/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xss4j;

import com.ibm.ws.wssecurity.xss4j.domutil.DOMUtil;
import com.ibm.ws.wssecurity.xss4j.dsig.Canonicalizer;
import com.ibm.ws.wssecurity.xss4j.dsig.SignatureEngineDSA;
import com.ibm.ws.wssecurity.xss4j.dsig.SignatureEngineHMAC;
import com.ibm.ws.wssecurity.xss4j.dsig.SignatureEngineRSA;
import com.ibm.ws.wssecurity.xss4j.dsig.Transform;
import com.ibm.ws.wssecurity.xss4j.dsig.util.Base64;
import com.ibm.ws.wssecurity.xss4j.enc.DOMSerializationEngine;
import com.ibm.ws.wssecurity.xss4j.enc.EncryptionEngineImpl;
import com.ibm.ws.wssecurity.xss4j.enc.KeyGenerationEngineImpl;
import com.ibm.ws.wssecurity.xss4j.enc.StructureException;
import com.ibm.ws.wssecurity.xss4j.enc.type.OAEPParams;
import com.ibm.ws.wssecurity.xss4j.enc.util.Util;
import com.ibm.wsspi.wssecurity.EncryptionEngine;
import com.ibm.wsspi.wssecurity.EngineFactory;
import com.ibm.wsspi.wssecurity.KeyGenerationEngine;
import com.ibm.wsspi.wssecurity.SignatureEngine;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.InvalidAlgorithmParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AlgorithmFactory
implements EngineFactory {
    private static boolean fipsEnabled = false;
    private static List providers = new ArrayList();
    private static AlgorithmFactory s_theInstance;
    protected static Stack sha1Pool;
    protected static Stack sha256Pool;
    protected static Stack sha512Pool;
    protected static Stack rsaPool;
    protected static Stack dsaPool;
    protected static Stack hmacPool;
    protected static HashMap eePoolMap;
    protected static Stack kge3desPool;
    protected static HashMap hwcSha1Map;
    protected static HashMap hwcSha256Map;
    protected static HashMap hwcSha512Map;
    protected static HashMap hwcRsaMap;
    protected static HashMap hwcDsaMap;
    protected static HashMap hwcHmacMap;
    protected static HashMap hwcEERsaMap;
    protected static HashMap hwcEE3desMap;
    protected static HashMap hwcEEAes128Map;
    protected static HashMap hwcEEAes192Map;
    protected static HashMap hwcEEAes256Map;
    protected static HashMap hwcEERsaOaepMap;
    protected static HashMap hwcEEkw3desMap;
    protected static HashMap hwcEEkwAes128Map;
    protected static HashMap hwcEEkwAes192Map;
    protected static HashMap hwcEEkwAes256Map;
    protected static HashMap hwcKge3desMap;
    private boolean debug = false;
    protected static DocumentBuilderFactory documentBuilderFactory;
    protected static Stack documentBuilderPool;
    private final String MD5 = "http://www.w3.org/2001/04/xmldsig-more#md5".intern();
    protected Provider provider;
    protected String providerName;
    protected Hashtable digestMethodTable;
    protected Hashtable transformTable;
    protected Hashtable canonicalizerTable;
    protected Set supportedSignature;
    protected Set supportedDigest;
    protected Set supportedDataEncryption;
    protected Set supportedKeyEncryption;
    protected final List childFactory;
    protected final Map childFactoryURIs;
    private boolean checkHMACOutputLength = true;
    private ThreadLocal _providerMap = new ThreadLocal();
    private ThreadLocal _allCryptoOffload = new ThreadLocal();
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$security$spec$AlgorithmParameterSpec;

    public void setCryptoOffloadProperty(String string) {
        this._allCryptoOffload.set(string);
    }

    public void setCheckHMACOutputLength(boolean bl) {
        this.checkHMACOutputLength = bl;
    }

    public boolean getCheckHMACOutputLength() {
        return this.checkHMACOutputLength;
    }

    private Map getProviderMap() {
        HashMap hashMap = (HashMap)this._providerMap.get();
        if (hashMap == null) {
            hashMap = new HashMap();
            this._providerMap.set(hashMap);
        }
        return hashMap;
    }

    public void clearLocalProviderMap() {
        this.getProviderMap().clear();
    }

    public void setLocalProvider(String string, Object object) {
        this.getProviderMap().put(string, object);
    }

    public Object getLocalProvider(String string) {
        return this.getProviderMap().get(string);
    }

    public Map getProviderMaps() {
        return this.getProviderMap();
    }

    public static AlgorithmFactory getInstance() {
        return s_theInstance;
    }

    protected AlgorithmFactory(String string) {
        if (!fipsEnabled) {
            providers.clear();
            providers.add(string == null ? null : Security.getProvider(string));
        }
        this.childFactory = new Vector();
        this.childFactoryURIs = new Hashtable();
        this.supportedDataEncryption = new HashSet();
        this.supportedKeyEncryption = new HashSet();
        this.supportedDataEncryption.add("http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
        this.supportedDataEncryption.add("http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        this.supportedDataEncryption.add("http://www.w3.org/2001/04/xmlenc#aes192-cbc");
        this.supportedDataEncryption.add("http://www.w3.org/2001/04/xmlenc#aes256-cbc");
        this.supportedKeyEncryption.add("http://www.w3.org/2001/04/xmlenc#rsa-1_5");
        this.supportedKeyEncryption.add("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p");
        this.supportedKeyEncryption.add("http://www.w3.org/2001/04/xmlenc#kw-tripledes");
        this.supportedKeyEncryption.add("http://www.w3.org/2001/04/xmlenc#kw-aes128");
        this.supportedKeyEncryption.add("http://www.w3.org/2001/04/xmlenc#kw-aes192");
        this.supportedKeyEncryption.add("http://www.w3.org/2001/04/xmlenc#kw-aes256");
        this.supportedSignature = new HashSet();
        this.supportedSignature.add("http://www.w3.org/2000/09/xmldsig#rsa-sha1");
        this.supportedSignature.add("http://www.w3.org/2000/09/xmldsig#dsa-sha1");
        this.supportedSignature.add("http://www.w3.org/2000/09/xmldsig#hmac-sha1");
        this.digestMethodTable = new Hashtable();
        this.digestMethodTable.put("http://www.w3.org/2000/09/xmldsig#sha1", "SHA");
        this.digestMethodTable.put(this.MD5, "md5");
        this.digestMethodTable.put("http://www.w3.org/2001/04/xmlenc#sha256", "SHA256");
        this.digestMethodTable.put("http://www.w3.org/2001/04/xmlenc#sha512", "SHA512");
        this.digestMethodTable.put("http://www.w3.org/2001/04/xmlenc#ripemd160", "RIPEMD160");
        this.supportedDigest = new HashSet();
        this.supportedDigest.add("http://www.w3.org/2000/09/xmldsig#sha1");
        this.supportedDigest.add(this.MD5);
        this.supportedDigest.add("http://www.w3.org/2001/04/xmlenc#sha256");
        this.supportedDigest.add("http://www.w3.org/2001/04/xmlenc#sha512");
        this.supportedDigest.add("http://www.w3.org/2001/04/xmlenc#ripemd160");
        this.transformTable = new Hashtable();
        this.transformTable.put("http://www.w3.org/TR/2000/WD-xml-c14n-20000601", "com.ibm.ws.wssecurity.xss4j.dsig.transform.W3CCanonicalizer2");
        this.transformTable.put("http://www.w3.org/TR/2000/WD-xml-c14n-20000613", "com.ibm.ws.wssecurity.xss4j.dsig.transform.W3CCanonicalizer2");
        this.transformTable.put("http://www.w3.org/TR/2000/WD-xml-c14n-20001011", "com.ibm.ws.wssecurity.xss4j.dsig.transform.W3CCanonicalizer2");
        this.transformTable.put("http://www.w3.org/TR/2000/CR-xml-c14n-20001026", "com.ibm.ws.wssecurity.xss4j.dsig.transform.W3CCanonicalizer2");
        this.transformTable.put("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", "com.ibm.ws.wssecurity.xss4j.dsig.transform.W3CCanonicalizer2");
        this.transformTable.put("http://www.w3.org/TR/2000/WD-xml-c14n-20001011#WithComments", "com.ibm.ws.wssecurity.xss4j.dsig.transform.W3CCanonicalizer2WC");
        this.transformTable.put("http://www.w3.org/TR/2000/CR-xml-c14n-20001026#WithComments", "com.ibm.ws.wssecurity.xss4j.dsig.transform.W3CCanonicalizer2WC");
        this.transformTable.put("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments", "com.ibm.ws.wssecurity.xss4j.dsig.transform.W3CCanonicalizer2WC");
        this.transformTable.put("http://www.w3.org/2001/10/xml-exc-c14n#", "com.ibm.ws.wssecurity.xss4j.dsig.transform.ExclusiveC11r");
        this.transformTable.put("http://www.w3.org/2001/10/xml-exc-c14n#WithComments", "com.ibm.ws.wssecurity.xss4j.dsig.transform.ExclusiveC11rWC");
        this.transformTable.put("http://www.w3.org/2000/09/xmldsig#base64", "com.ibm.ws.wssecurity.xss4j.dsig.transform.Base64Transformer");
        this.transformTable.put("http://www.w3.org/2000/09/xmldsig#enveloped-signature", "com.ibm.ws.wssecurity.xss4j.dsig.transform.Enveloped");
        this.transformTable.put("http://www.w3.org/TR/1999/REC-xslt-19991116", "com.ibm.ws.wssecurity.xss4j.dsig.transform.XSLTTransformer");
        this.transformTable.put("http://www.w3.org/TR/1999/REC-xpath-19991116", "com.ibm.ws.wssecurity.xss4j.dsig.transform.XPathTransformer");
        this.transformTable.put("http://www.w3.org/2002/06/xmldsig-filter2", "com.ibm.ws.wssecurity.xss4j.dsig.transform.XPath2Transformer");
        this.transformTable.put("http://www.w3.org/2001/04/decrypt#", "com.ibm.ws.wssecurity.xss4j.dsig.transform.XMLDecryptionTransformer");
        this.transformTable.put("http://www.w3.org/2002/07/decrypt#XML", "com.ibm.ws.wssecurity.xss4j.dsig.transform.XMLDecryptionTransformer2");
        this.transformTable.put("http://www.w3.org/2002/07/decrypt#Binary", "com.ibm.ws.wssecurity.xss4j.dsig.transform.BinaryDecryptionTransformer");
        this.canonicalizerTable = new Hashtable();
        this.canonicalizerTable.put("http://www.w3.org/TR/2000/WD-xml-c14n-20000601", "com.ibm.ws.wssecurity.xss4j.dsig.transform.W3CCanonicalizer2");
        this.canonicalizerTable.put("http://www.w3.org/TR/2000/WD-xml-c14n-20000613", "com.ibm.ws.wssecurity.xss4j.dsig.transform.W3CCanonicalizer2");
        this.canonicalizerTable.put("http://www.w3.org/TR/2000/WD-xml-c14n-20001011", "com.ibm.ws.wssecurity.xss4j.dsig.transform.W3CCanonicalizer2");
        this.canonicalizerTable.put("http://www.w3.org/TR/2000/CR-xml-c14n-20001026", "com.ibm.ws.wssecurity.xss4j.dsig.transform.W3CCanonicalizer2");
        this.canonicalizerTable.put("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", "com.ibm.ws.wssecurity.xss4j.dsig.transform.W3CCanonicalizer2");
        this.canonicalizerTable.put("http://www.w3.org/TR/2000/WD-xml-c14n-20001011#WithComments", "com.ibm.ws.wssecurity.xss4j.dsig.transform.W3CCanonicalizer2WC");
        this.canonicalizerTable.put("http://www.w3.org/TR/2000/CR-xml-c14n-20001026#WithComments", "com.ibm.ws.wssecurity.xss4j.dsig.transform.W3CCanonicalizer2WC");
        this.canonicalizerTable.put("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments", "com.ibm.ws.wssecurity.xss4j.dsig.transform.W3CCanonicalizer2WC");
        this.canonicalizerTable.put("http://www.w3.org/2001/10/xml-exc-c14n#", "com.ibm.ws.wssecurity.xss4j.dsig.transform.ExclusiveC11r");
        this.canonicalizerTable.put("http://www.w3.org/2001/10/xml-exc-c14n#WithComments", "com.ibm.ws.wssecurity.xss4j.dsig.transform.ExclusiveC11rWC");
    }

    public String getProvider() {
        return null;
    }

    public Set getSignatureAlgorithms() {
        return this.supportedSignature;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SignatureEngine getSignatureEngine(String string) throws NoSuchAlgorithmException {
        Iterator iterator;
        Object object;
        if (string == null) {
            throw new NullPointerException("No SignatureMethod for null.");
        }
        boolean bl = false;
        Provider provider = (Provider)this.getLocalProvider("com.ibm.ws.wssecurity.config.keystore.keyStoreRef");
        if (provider != null && ("http://www.w3.org/2000/09/xmldsig#rsa-sha1".equals(string) ? (object = (SignatureEngine)hwcRsaMap.get(provider.getName())) != null : ("http://www.w3.org/2000/09/xmldsig#dsa-sha1".equals(string) ? (object = (SignatureEngine)hwcDsaMap.get(provider.getName())) != null : "http://www.w3.org/2000/09/xmldsig#hmac-sha1".equals(string) && (object = (SignatureEngine)hwcHmacMap.get(provider.getName())) != null))) {
            return object;
        }
        object = (Provider)this.getLocalProvider("HWCONFIG");
        if (object != null && ("http://www.w3.org/2000/09/xmldsig#rsa-sha1".equals(string) ? (iterator = (SignatureEngine)hwcRsaMap.get(((Provider)object).getName())) != null : ("http://www.w3.org/2000/09/xmldsig#dsa-sha1".equals(string) ? (iterator = (SignatureEngine)hwcDsaMap.get(((Provider)object).getName())) != null : "http://www.w3.org/2000/09/xmldsig#hmac-sha1".equals(string) && (iterator = (SignatureEngine)hwcHmacMap.get(((Provider)object).getName())) != null))) {
            return iterator;
        }
        if (provider != null) {
            try {
                if (this.debug) {
                    System.out.println("HWC: AlgorithmFactory, getSignatureEngine, hw provider name: " + provider.getName() + "and uri is: " + string);
                }
                if (string.equals("http://www.w3.org/2000/09/xmldsig#hmac-sha1")) {
                    return new SignatureEngineHMAC(string, provider);
                }
                if (string.equals("http://www.w3.org/2000/09/xmldsig#rsa-sha1")) {
                    return new SignatureEngineRSA(string, provider);
                }
                if (string.equals("http://www.w3.org/2000/09/xmldsig#dsa-sha1")) {
                    return new SignatureEngineDSA(string, provider);
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                System.out.println("HARDWARE CRYPTO, In AlgFactory, caught Exception" + noSuchAlgorithmException.getMessage());
                noSuchAlgorithmException.printStackTrace();
            }
        }
        if (object != null) {
            try {
                if (this.debug) {
                    System.out.println("HWC: AlgorithmFactory, getSignatureEngine, hw provider name: " + ((Provider)object).getName() + "and uri is: " + string);
                }
                if (string.equals("http://www.w3.org/2000/09/xmldsig#hmac-sha1")) {
                    return new SignatureEngineHMAC(string, (Provider)object);
                }
                if (string.equals("http://www.w3.org/2000/09/xmldsig#rsa-sha1")) {
                    return new SignatureEngineRSA(string, (Provider)object);
                }
                if (string.equals("http://www.w3.org/2000/09/xmldsig#dsa-sha1")) {
                    return new SignatureEngineDSA(string, (Provider)object);
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                System.out.println("HARDWARE CRYPTO, In AlgFactory, caught Exception" + noSuchAlgorithmException.getMessage());
                noSuchAlgorithmException.printStackTrace();
            }
        }
        if ((provider != null || object != null) && this.debug) {
            System.out.println("HARDWARE CRYPTO: getSignatureEngine fails with hardware crypto provider. Continue to use JCE provider");
        }
        if ("http://www.w3.org/2000/09/xmldsig#rsa-sha1".equals(string)) {
            iterator = rsaPool;
            synchronized (iterator) {
                if (!rsaPool.empty()) {
                    if (this.debug) {
                        System.out.println("HARDWARE CRYPTO: Alg Factory. getting it from pool");
                    }
                    return (SignatureEngine)rsaPool.pop();
                }
            }
        }
        if ("http://www.w3.org/2000/09/xmldsig#dsa-sha1".equals(string)) {
            iterator = dsaPool;
            synchronized (iterator) {
                if (!dsaPool.empty()) {
                    return (SignatureEngine)dsaPool.pop();
                }
            }
        }
        if ("http://www.w3.org/2000/09/xmldsig#hmac-sha1".equals(string)) {
            iterator = hmacPool;
            synchronized (iterator) {
                if (!hmacPool.empty()) {
                    return (SignatureEngine)hmacPool.pop();
                }
            }
        }
        if (!fipsEnabled && this.childFactory != null && !this.childFactory.isEmpty()) {
            iterator = this.childFactory.iterator();
            while (iterator.hasNext()) {
                SignatureEngine signatureEngine;
                EngineFactory engineFactory = (EngineFactory)iterator.next();
                Object v = this.childFactoryURIs.get(engineFactory);
                if (v == null || !(v instanceof Set) || !((Set)v).contains(string) || !engineFactory.getSignatureAlgorithms().contains(string) || (signatureEngine = engineFactory.getSignatureEngine(string)) == null) continue;
                return signatureEngine;
            }
        }
        int n = 0;
        while (true) {
            if (n >= providers.size()) break;
            try {
                if (string.equals("http://www.w3.org/2000/09/xmldsig#hmac-sha1")) {
                    return new SignatureEngineHMAC(string, (Provider)providers.get(n));
                }
                if (string.equals("http://www.w3.org/2000/09/xmldsig#rsa-sha1")) {
                    if (this.debug) {
                        System.out.println("HARDWARE CRYPTO:Alg Factory getting it using software provider" + providers.get(n));
                    }
                    return new SignatureEngineRSA(string, (Provider)providers.get(n));
                }
                if (string.equals("http://www.w3.org/2000/09/xmldsig#dsa-sha1")) {
                    return new SignatureEngineDSA(string, (Provider)providers.get(n));
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
            ++n;
        }
        throw new NoSuchAlgorithmException("No SignatureEngine for " + string);
    }

    public boolean releaseSignatureEngine(SignatureEngine signatureEngine) {
        if (this.getProviderMaps().isEmpty()) {
            if ("http://www.w3.org/2000/09/xmldsig#rsa-sha1".equals(signatureEngine.getURI())) {
                rsaPool.push(signatureEngine);
                return true;
            }
            if ("http://www.w3.org/2000/09/xmldsig#dsa-sha1".equals(signatureEngine.getURI())) {
                dsaPool.push(signatureEngine);
                return true;
            }
            if ("http://www.w3.org/2000/09/xmldsig#hmac-sha1".equals(signatureEngine.getURI())) {
                hmacPool.push(signatureEngine);
                return true;
            }
            if (!fipsEnabled && this.childFactory != null && !this.childFactory.isEmpty()) {
                Iterator iterator = this.childFactory.iterator();
                while (iterator.hasNext()) {
                    EngineFactory engineFactory = (EngineFactory)iterator.next();
                    if (!engineFactory.releaseSignatureEngine(signatureEngine)) continue;
                    return true;
                }
            }
        } else {
            if (this.debug) {
                System.out.println("HWC: AlgorithmFactory, releaseSignatureEngine hw provider is in use");
            }
            if ("http://www.w3.org/2000/09/xmldsig#rsa-sha1".equals(signatureEngine.getURI())) {
                Provider provider = (Provider)this.getLocalProvider("com.ibm.ws.wssecurity.config.keystore.keyStoreRef");
                if (provider != null) {
                    hwcRsaMap.put(provider.getName(), signatureEngine);
                } else {
                    Provider provider2 = (Provider)this.getLocalProvider("HWCONFIG");
                    if (provider2 != null) {
                        hwcRsaMap.put(provider2.getName(), signatureEngine);
                    }
                }
                return true;
            }
            if ("http://www.w3.org/2000/09/xmldsig#dsa-sha1".equals(signatureEngine.getURI())) {
                Provider provider = (Provider)this.getLocalProvider("com.ibm.ws.wssecurity.config.keystore.keyStoreRef");
                if (provider != null) {
                    hwcDsaMap.put(provider.getName(), signatureEngine);
                } else {
                    Provider provider3 = (Provider)this.getLocalProvider("HWCONFIG");
                    if (provider3 != null) {
                        hwcDsaMap.put(provider3.getName(), signatureEngine);
                    }
                }
                return true;
            }
            if ("http://www.w3.org/2000/09/xmldsig#hmac-sha1".equals(signatureEngine.getURI())) {
                Provider provider = (Provider)this.getLocalProvider("com.ibm.ws.wssecurity.config.keystore.keyStoreRef");
                if (provider != null) {
                    hwcHmacMap.put(provider.getName(), signatureEngine);
                } else {
                    Provider provider4 = (Provider)this.getLocalProvider("HWCONFIG");
                    if (provider4 != null) {
                        hwcHmacMap.put(provider4.getName(), signatureEngine);
                    }
                }
                return true;
            }
        }
        return this.supportedSignature.contains(signatureEngine.getURI());
    }

    public Set getDigestAlgorithms() {
        return this.supportedDigest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageDigest getMessageDigest(String string, AlgorithmParameterSpec algorithmParameterSpec) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        MessageDigest messageDigest;
        Object object;
        Object object2;
        if (string == null) {
            throw new NullPointerException("Algorithm identifier is null.");
        }
        if (algorithmParameterSpec != null) {
            throw new InvalidAlgorithmParameterException("The algorithm " + string + " does not support AlgorihmParameterSpec.");
        }
        String string2 = (String)this.digestMethodTable.get(string);
        if (string2 == null) {
            throw new NoSuchAlgorithmException("No DigestMethod for " + string);
        }
        if (string.equals("http://www.w3.org/2000/09/xmldsig#sha1")) {
            object2 = sha1Pool;
            synchronized (object2) {
                if (!sha1Pool.empty()) {
                    MessageDigest messageDigest2 = (MessageDigest)sha1Pool.pop();
                    messageDigest2.reset();
                    return messageDigest2;
                }
            }
        } else if (string.equals("http://www.w3.org/2001/04/xmlenc#sha256")) {
            object2 = sha256Pool;
            synchronized (object2) {
                if (!sha256Pool.empty()) {
                    MessageDigest messageDigest3 = (MessageDigest)sha256Pool.pop();
                    messageDigest3.reset();
                    return messageDigest3;
                }
            }
        } else if (string.equals("http://www.w3.org/2001/04/xmlenc#sha512")) {
            object2 = sha512Pool;
            synchronized (object2) {
                if (!sha512Pool.empty()) {
                    MessageDigest messageDigest4 = (MessageDigest)sha512Pool.pop();
                    messageDigest4.reset();
                    return messageDigest4;
                }
            }
        } else if (!fipsEnabled && this.childFactory != null && !this.childFactory.isEmpty()) {
            object2 = this.childFactory.iterator();
            while (object2.hasNext()) {
                MessageDigest messageDigest5;
                object = (EngineFactory)object2.next();
                messageDigest = this.childFactoryURIs.get(object);
                if (messageDigest == null || !(messageDigest instanceof Set) || !((Set)((Object)messageDigest)).contains(string) || !object.getDigestAlgorithms().contains(string) || (messageDigest5 = object.getMessageDigest(string, algorithmParameterSpec)) == null) continue;
                return messageDigest5;
            }
        }
        int n = 0;
        while (true) {
            if (n >= providers.size()) break;
            object = (Provider)providers.get(n);
            try {
                messageDigest = object == null ? MessageDigest.getInstance(string2) : MessageDigest.getInstance(string2, (Provider)object);
                return messageDigest;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                ++n;
                continue;
            }
            break;
        }
        throw new NoSuchAlgorithmException("No MessageDigest for " + string2);
    }

    public boolean releaseMessageDigest(String string, MessageDigest messageDigest) {
        if ("http://www.w3.org/2000/09/xmldsig#sha1".equals(string)) {
            sha1Pool.push(messageDigest);
            return true;
        }
        if ("http://www.w3.org/2001/04/xmlenc#sha256".equals(string)) {
            sha256Pool.push(messageDigest);
            return true;
        }
        if ("http://www.w3.org/2001/04/xmlenc#sha512".equals(string)) {
            sha512Pool.push(messageDigest);
            return true;
        }
        if (!fipsEnabled && this.childFactory != null && !this.childFactory.isEmpty()) {
            Iterator iterator = this.childFactory.iterator();
            while (iterator.hasNext()) {
                EngineFactory engineFactory = (EngineFactory)iterator.next();
                if (!engineFactory.releaseMessageDigest(string, messageDigest)) continue;
                return true;
            }
        }
        return this.supportedDigest.contains(string);
    }

    public Transform getTransform(String string) throws NoSuchAlgorithmException {
        Object obj;
        if (string == null) {
            throw new NoSuchAlgorithmException("null parameter.");
        }
        String string2 = (String)this.transformTable.get(string);
        if (string2 == null) {
            throw new NoSuchAlgorithmException("Unknown algorithm URI: " + string);
        }
        try {
            obj = Class.forName(string2).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException.getMessage());
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException(instantiationException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException.getMessage());
        }
        return (Transform)obj;
    }

    public Canonicalizer getCanonicalizer(String string) {
        Object obj;
        if (string == null) {
            return null;
        }
        String string2 = (String)this.canonicalizerTable.get(string);
        if (string2 == null) {
            return null;
        }
        try {
            obj = Class.forName(string2).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (InstantiationException instantiationException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
        return (Canonicalizer)obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        Object object = documentBuilderPool;
        synchronized (object) {
            if (!documentBuilderPool.empty()) {
                return (DocumentBuilder)documentBuilderPool.pop();
            }
        }
        object = documentBuilderFactory;
        synchronized (object) {
            return documentBuilderFactory.newDocumentBuilder();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseDocumentBuilder(DocumentBuilder documentBuilder) {
        Stack stack = documentBuilderPool;
        synchronized (stack) {
            documentBuilderPool.push(documentBuilder);
        }
    }

    public Set getDataEncryptionAlgorithms() {
        return this.supportedDataEncryption;
    }

    public Set getKeyEncryptionAlgorithms() {
        return this.supportedKeyEncryption;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EncryptionEngine getEncryptionEngine(String string) throws NoSuchAlgorithmException {
        Object object;
        Object object2;
        if (string == null) {
            throw new NullPointerException("URI not specified");
        }
        boolean bl = true;
        boolean bl2 = false;
        ArrayList<Object> arrayList = new ArrayList<Object>(2);
        Provider provider = (Provider)this.getLocalProvider("com.ibm.ws.wssecurity.config.keystore.keyStoreRef");
        if (provider != null) {
            if ("http://www.w3.org/2001/04/xmlenc#rsa-1_5".equals(string) ? (object2 = (EncryptionEngine)hwcEERsaMap.get(provider.getName())) != null : ("http://www.w3.org/2001/04/xmlenc#tripledes-cbc".equals(string) ? (object2 = (EncryptionEngine)hwcEE3desMap.get(provider.getName())) != null : ("http://www.w3.org/2001/04/xmlenc#aes128-cbc".equals(string) ? (object2 = (EncryptionEngine)hwcEEAes128Map.get(provider.getName())) != null : ("http://www.w3.org/2001/04/xmlenc#aes192-cbc".equals(string) ? (object2 = (EncryptionEngine)hwcEEAes192Map.get(provider.getName())) != null : ("http://www.w3.org/2001/04/xmlenc#aes256-cbc".equals(string) ? (object2 = (EncryptionEngine)hwcEEAes256Map.get(provider.getName())) != null : ("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p".equals(string) ? (object2 = (EncryptionEngine)hwcEERsaOaepMap.get(provider.getName())) != null : ("http://www.w3.org/2001/04/xmlenc#kw-tripledes".equals(string) ? (object2 = (EncryptionEngine)hwcEEkw3desMap.get(provider.getName())) != null : ("http://www.w3.org/2001/04/xmlenc#kw-aes128".equals(string) ? (object2 = (EncryptionEngine)hwcEEkwAes128Map.get(provider.getName())) != null : ("http://www.w3.org/2001/04/xmlenc#kw-aes192".equals(string) ? (object2 = (EncryptionEngine)hwcEEkwAes192Map.get(provider.getName())) != null : "http://www.w3.org/2001/04/xmlenc#kw-aes256".equals(string) && (object2 = (EncryptionEngine)hwcEEkwAes256Map.get(provider.getName())) != null))))))))) {
                return object2;
            }
            arrayList.add(provider);
        }
        if ((object2 = (Provider)this.getLocalProvider("HWCONFIG")) != null) {
            if (this.debug) {
                System.out.println("HWC: AlgorithmFactory, getEncryptionEngine, uri and provider:" + string + ":" + ((Provider)this.getLocalProvider("HWCONFIG")).getName());
            }
            if ("http://www.w3.org/2001/04/xmlenc#rsa-1_5".equals(string) ? (object = (EncryptionEngine)hwcEERsaMap.get(((Provider)object2).getName())) != null : ("http://www.w3.org/2001/04/xmlenc#tripledes-cbc".equals(string) ? (object = (EncryptionEngine)hwcEE3desMap.get(((Provider)object2).getName())) != null : ("http://www.w3.org/2001/04/xmlenc#aes128-cbc".equals(string) ? (object = (EncryptionEngine)hwcEEAes128Map.get(((Provider)object2).getName())) != null : ("http://www.w3.org/2001/04/xmlenc#aes192-cbc".equals(string) ? (object = (EncryptionEngine)hwcEEAes192Map.get(((Provider)object2).getName())) != null : ("http://www.w3.org/2001/04/xmlenc#aes256-cbc".equals(string) ? (object = (EncryptionEngine)hwcEEAes256Map.get(((Provider)object2).getName())) != null : ("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p".equals(string) ? (object = (EncryptionEngine)hwcEERsaOaepMap.get(((Provider)object2).getName())) != null : ("http://www.w3.org/2001/04/xmlenc#kw-tripledes".equals(string) ? (object = (EncryptionEngine)hwcEEkw3desMap.get(((Provider)object2).getName())) != null : ("http://www.w3.org/2001/04/xmlenc#kw-aes128".equals(string) ? (object = (EncryptionEngine)hwcEEkwAes128Map.get(((Provider)object2).getName())) != null : ("http://www.w3.org/2001/04/xmlenc#kw-aes192".equals(string) ? (object = (EncryptionEngine)hwcEEkwAes192Map.get(((Provider)object2).getName())) != null : "http://www.w3.org/2001/04/xmlenc#kw-aes256".equals(string) && (object = (EncryptionEngine)hwcEEkwAes256Map.get(((Provider)object2).getName())) != null))))))))) {
                return object;
            }
            if (this.debug) {
                System.out.println("HWC: AlgorithmFactory, getEncryptionEngine, did not get any thing from the pool");
            }
            arrayList.add(object2);
        }
        if (provider != null) {
            try {
                if (this.debug) {
                    System.out.println("HWC: AlgorithmFactory, getEncryptionEngine, provider and uri: " + provider.getName() + ":" + string);
                }
                if (string.equals("http://www.w3.org/2001/04/xmlenc#tripledes-cbc")) {
                    return new EncryptionEngineImpl.TripleDESCBC(provider);
                }
                if (string.equals("http://www.w3.org/2001/04/xmlenc#aes128-cbc")) {
                    return new EncryptionEngineImpl.AES128CBC(provider);
                }
                if (string.equals("http://www.w3.org/2001/04/xmlenc#aes192-cbc")) {
                    return new EncryptionEngineImpl.AES192CBC(provider);
                }
                if (string.equals("http://www.w3.org/2001/04/xmlenc#aes256-cbc")) {
                    return new EncryptionEngineImpl.AES256CBC(provider);
                }
                if (string.equals("http://www.w3.org/2001/04/xmlenc#rsa-1_5")) {
                    return new EncryptionEngineImpl.RSA15(provider, this);
                }
                if (string.equals("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p")) {
                    return new EncryptionEngineImpl.RSAOAEP(provider, this);
                }
                if (string.equals("http://www.w3.org/2001/04/xmlenc#kw-tripledes")) {
                    return new EncryptionEngineImpl.HWC_KWTripleDES(provider, this);
                }
                if (string.equals("http://www.w3.org/2001/04/xmlenc#kw-aes128")) {
                    return new EncryptionEngineImpl.HWC_KWAES128(provider, this);
                }
                if (string.equals("http://www.w3.org/2001/04/xmlenc#kw-aes192")) {
                    return new EncryptionEngineImpl.HWC_KWAES192(provider, this);
                }
                if (string.equals("http://www.w3.org/2001/04/xmlenc#kw-aes256")) {
                    return new EncryptionEngineImpl.HWC_KWAES256(provider, this);
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                System.out.println("HARDWARE, Alg Factory, getEncryption Engine, caught Exception: " + noSuchAlgorithmException.getMessage());
                noSuchAlgorithmException.printStackTrace();
            }
        }
        if (object2 != null) {
            try {
                if (this.debug) {
                    System.out.println("HWC: AlgorithmFactory, getEncryptionEngine, provider and uri: " + ((Provider)object2).getName() + ":" + string);
                }
                if (string.equals("http://www.w3.org/2001/04/xmlenc#tripledes-cbc")) {
                    return new EncryptionEngineImpl.TripleDESCBC((Provider)object2);
                }
                if (string.equals("http://www.w3.org/2001/04/xmlenc#aes128-cbc")) {
                    return new EncryptionEngineImpl.AES128CBC((Provider)object2);
                }
                if (string.equals("http://www.w3.org/2001/04/xmlenc#aes192-cbc")) {
                    return new EncryptionEngineImpl.AES192CBC((Provider)object2);
                }
                if (string.equals("http://www.w3.org/2001/04/xmlenc#aes256-cbc")) {
                    return new EncryptionEngineImpl.AES256CBC((Provider)object2);
                }
                if (string.equals("http://www.w3.org/2001/04/xmlenc#rsa-1_5")) {
                    return new EncryptionEngineImpl.RSA15((Provider)object2, this);
                }
                if (string.equals("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p")) {
                    return new EncryptionEngineImpl.RSAOAEP((Provider)object2, this);
                }
                if (string.equals("http://www.w3.org/2001/04/xmlenc#kw-tripledes")) {
                    return new EncryptionEngineImpl.HWC_KWTripleDES((Provider)object2, this);
                }
                if (string.equals("http://www.w3.org/2001/04/xmlenc#kw-aes128")) {
                    return new EncryptionEngineImpl.HWC_KWAES128((Provider)object2, this);
                }
                if (string.equals("http://www.w3.org/2001/04/xmlenc#kw-aes192")) {
                    return new EncryptionEngineImpl.HWC_KWAES192((Provider)object2, this);
                }
                if (string.equals("http://www.w3.org/2001/04/xmlenc#kw-aes256")) {
                    return new EncryptionEngineImpl.HWC_KWAES256((Provider)object2, this);
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                System.out.println("HARDWARE, Alg Factory, getEncryption Engine, caught Exception: " + noSuchAlgorithmException.getMessage());
                noSuchAlgorithmException.printStackTrace();
            }
        }
        if ((provider != null || object2 != null) && this.debug) {
            System.out.println("HARDWARE CRYPTO: getEncryptionEngine fails with hardware crypto provider. Continue to use JCE provider");
        }
        if ((object = (Stack)eePoolMap.get(string)) != null) {
            Object object3 = object;
            synchronized (object3) {
                if (!((Vector)object).isEmpty()) {
                    return (EncryptionEngine)((Stack)object).pop();
                }
            }
        }
        int n = 0;
        while (true) {
            if (n >= providers.size()) break;
            try {
                if (string.equals("http://www.w3.org/2001/04/xmlenc#tripledes-cbc")) {
                    return new EncryptionEngineImpl.TripleDESCBC((Provider)providers.get(n));
                }
                if (string.equals("http://www.w3.org/2001/04/xmlenc#aes128-cbc")) {
                    return new EncryptionEngineImpl.AES128CBC((Provider)providers.get(n));
                }
                if (string.equals("http://www.w3.org/2001/04/xmlenc#aes192-cbc")) {
                    return new EncryptionEngineImpl.AES192CBC((Provider)providers.get(n));
                }
                if (string.equals("http://www.w3.org/2001/04/xmlenc#aes256-cbc")) {
                    return new EncryptionEngineImpl.AES256CBC((Provider)providers.get(n));
                }
                if (string.equals("http://www.w3.org/2001/04/xmlenc#rsa-1_5")) {
                    return new EncryptionEngineImpl.RSA15((Provider)providers.get(n), this);
                }
                if (string.equals("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p")) {
                    return new EncryptionEngineImpl.RSAOAEP((Provider)providers.get(n), this);
                }
                if (string.equals("http://www.w3.org/2001/04/xmlenc#kw-tripledes")) {
                    return new EncryptionEngineImpl.KWTripleDES((Provider)providers.get(n), this);
                }
                if (string.equals("http://www.w3.org/2001/04/xmlenc#kw-aes128")) {
                    return new EncryptionEngineImpl.KWAES128((Provider)providers.get(n), this);
                }
                if (string.equals("http://www.w3.org/2001/04/xmlenc#kw-aes192")) {
                    return new EncryptionEngineImpl.KWAES192((Provider)providers.get(n), this);
                }
                if (string.equals("http://www.w3.org/2001/04/xmlenc#kw-aes256")) {
                    return new EncryptionEngineImpl.KWAES256((Provider)providers.get(n), this);
                }
                bl = false;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                ++n;
                continue;
            }
            break;
        }
        if (bl) {
            throw new NoSuchAlgorithmException("No EncryptionEngine for " + string);
        }
        if (!fipsEnabled && this.childFactory != null && !this.childFactory.isEmpty()) {
            Iterator iterator = this.childFactory.iterator();
            while (iterator.hasNext()) {
                EncryptionEngine encryptionEngine;
                EngineFactory engineFactory = (EngineFactory)iterator.next();
                Object v = this.childFactoryURIs.get(engineFactory);
                if (v == null || !(v instanceof Set) || !((Set)v).contains(string) || !engineFactory.getDataEncryptionAlgorithms().contains(string) && !engineFactory.getKeyEncryptionAlgorithms().contains(string) || (encryptionEngine = engineFactory.getEncryptionEngine(string)) == null) continue;
                return encryptionEngine;
            }
        }
        throw new NoSuchAlgorithmException("Unknown algorithm: " + string);
    }

    public boolean releaseEncryptionEngine(EncryptionEngine encryptionEngine) {
        String string = encryptionEngine.getURI();
        if (this.getProviderMaps().isEmpty()) {
            if (this.supportedDataEncryption.contains(string) || this.supportedKeyEncryption.contains(string)) {
                Stack stack = (Stack)eePoolMap.get(string);
                stack.push(encryptionEngine);
                return true;
            }
            if (!fipsEnabled && this.childFactory != null && !this.childFactory.isEmpty()) {
                Iterator iterator = this.childFactory.iterator();
                while (iterator.hasNext()) {
                    EngineFactory engineFactory = (EngineFactory)iterator.next();
                    if (!engineFactory.releaseEncryptionEngine(encryptionEngine)) continue;
                    return true;
                }
            }
        } else {
            if (this.debug) {
                System.out.println("HWC: AlgorithmFactory, releaseEncryptionEngine, uri and provider:" + string + ":" + ((Provider)this.getLocalProvider("HWCONFIG")).getName());
            }
            if (this.supportedDataEncryption.contains(string) || this.supportedKeyEncryption.contains(string)) {
                if ("http://www.w3.org/2001/04/xmlenc#rsa-1_5".equals(string)) {
                    Provider provider = (Provider)this.getLocalProvider("com.ibm.ws.wssecurity.config.keystore.keyStoreRef");
                    if (provider != null) {
                        hwcEERsaMap.put(provider.getName(), encryptionEngine);
                    } else {
                        Provider provider2 = (Provider)this.getLocalProvider("HWCONFIG");
                        if (provider2 != null) {
                            hwcEERsaMap.put(provider2.getName(), encryptionEngine);
                        }
                    }
                    return true;
                }
                if ("http://www.w3.org/2001/04/xmlenc#tripledes-cbc".equals(string)) {
                    Provider provider = (Provider)this.getLocalProvider("com.ibm.ws.wssecurity.config.keystore.keyStoreRef");
                    if (provider != null) {
                        hwcEE3desMap.put(provider.getName(), encryptionEngine);
                        return true;
                    }
                    Provider provider3 = (Provider)this.getLocalProvider("HWCONFIG");
                    if (provider3 != null) {
                        hwcEE3desMap.put(provider3.getName(), encryptionEngine);
                        return true;
                    }
                } else {
                    if ("http://www.w3.org/2001/04/xmlenc#aes128-cbc".equals(string)) {
                        Provider provider = (Provider)this.getLocalProvider("com.ibm.ws.wssecurity.config.keystore.keyStoreRef");
                        if (provider != null) {
                            hwcEEAes128Map.put(provider.getName(), encryptionEngine);
                        } else {
                            Provider provider4 = (Provider)this.getLocalProvider("HWCONFIG");
                            if (provider4 != null) {
                                hwcEEAes128Map.put(provider4.getName(), encryptionEngine);
                            }
                        }
                        return true;
                    }
                    if ("http://www.w3.org/2001/04/xmlenc#aes192-cbc".equals(string)) {
                        Provider provider = (Provider)this.getLocalProvider("com.ibm.ws.wssecurity.config.keystore.keyStoreRef");
                        if (provider != null) {
                            hwcEEAes192Map.put(provider.getName(), encryptionEngine);
                        } else {
                            Provider provider5 = (Provider)this.getLocalProvider("HWCONFIG");
                            if (provider5 != null) {
                                hwcEEAes192Map.put(provider5.getName(), encryptionEngine);
                            }
                        }
                        return true;
                    }
                    if ("http://www.w3.org/2001/04/xmlenc#aes256-cbc".equals(string)) {
                        Provider provider = (Provider)this.getLocalProvider("com.ibm.ws.wssecurity.config.keystore.keyStoreRef");
                        if (provider != null) {
                            hwcEEAes256Map.put(provider.getName(), encryptionEngine);
                        } else {
                            Provider provider6 = (Provider)this.getLocalProvider("HWCONFIG");
                            if (provider6 != null) {
                                hwcEEAes256Map.put(provider6.getName(), encryptionEngine);
                            }
                        }
                        return true;
                    }
                    if ("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p".equals(string)) {
                        Provider provider = (Provider)this.getLocalProvider("com.ibm.ws.wssecurity.config.keystore.keyStoreRef");
                        if (provider != null) {
                            hwcEERsaOaepMap.put(provider.getName(), encryptionEngine);
                        } else {
                            Provider provider7 = (Provider)this.getLocalProvider("HWCONFIG");
                            if (provider7 != null) {
                                hwcEERsaOaepMap.put(provider7.getName(), encryptionEngine);
                            }
                        }
                        return true;
                    }
                    if ("http://www.w3.org/2001/04/xmlenc#kw-tripledes".equals(string)) {
                        Provider provider = (Provider)this.getLocalProvider("com.ibm.ws.wssecurity.config.keystore.keyStoreRef");
                        if (provider != null) {
                            hwcEEkw3desMap.put(provider.getName(), encryptionEngine);
                        } else {
                            Provider provider8 = (Provider)this.getLocalProvider("HWCONFIG");
                            if (provider8 != null) {
                                hwcEEkw3desMap.put(provider8.getName(), encryptionEngine);
                            }
                        }
                        return true;
                    }
                    if ("http://www.w3.org/2001/04/xmlenc#kw-aes128".equals(string)) {
                        Provider provider = (Provider)this.getLocalProvider("com.ibm.ws.wssecurity.config.keystore.keyStoreRef");
                        if (provider != null) {
                            hwcEEkwAes128Map.put(provider.getName(), encryptionEngine);
                        } else {
                            Provider provider9 = (Provider)this.getLocalProvider("HWCONFIG");
                            if (provider9 != null) {
                                hwcEEkwAes128Map.put(provider9.getName(), encryptionEngine);
                            }
                        }
                        return true;
                    }
                    if ("http://www.w3.org/2001/04/xmlenc#kw-aes192".equals(string)) {
                        Provider provider = (Provider)this.getLocalProvider("com.ibm.ws.wssecurity.config.keystore.keyStoreRef");
                        if (provider != null) {
                            hwcEEkwAes192Map.put(provider.getName(), encryptionEngine);
                        } else {
                            Provider provider10 = (Provider)this.getLocalProvider("HWCONFIG");
                            if (provider10 != null) {
                                hwcEEkwAes192Map.put(provider10.getName(), encryptionEngine);
                            }
                        }
                        return true;
                    }
                    if ("http://www.w3.org/2001/04/xmlenc#kw-aes256".equals(string)) {
                        Provider provider = (Provider)this.getLocalProvider("com.ibm.ws.wssecurity.config.keystore.keyStoreRef");
                        if (provider != null) {
                            hwcEEkwAes256Map.put(provider.getName(), encryptionEngine);
                        } else {
                            Provider provider11 = (Provider)this.getLocalProvider("HWCONFIG");
                            if (provider11 != null) {
                                hwcEEkwAes256Map.put(provider11.getName(), encryptionEngine);
                            }
                        }
                        return true;
                    }
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyGenerationEngine getKeyGenerationEngine(String string, String string2) throws NoSuchAlgorithmException {
        Object object;
        int n;
        if (string == null) {
            throw new NullPointerException("URI not specified");
        }
        boolean bl = true;
        boolean bl2 = false;
        ArrayList arrayList = new ArrayList(2);
        for (n = 0; n < arrayList.size(); ++n) {
            object = (Provider)arrayList.get(n);
            try {
                if (this.debug) {
                    System.out.println("HWC: AlgorithmFactory, getKeyGenerationEngine, provider and uri is: " + ((Provider)object).getName() + ":" + string);
                }
                if (string.equals("http://www.w3.org/2001/04/xmlenc#tripledes-cbc")) {
                    return new KeyGenerationEngineImpl.HWC_TripleDESCBC((Provider)object);
                }
                if (string.equals("http://www.w3.org/2001/04/xmlenc#aes128-cbc")) {
                    return new KeyGenerationEngineImpl.AES128CBC((Provider)object);
                }
                if (string.equals("http://www.w3.org/2001/04/xmlenc#aes192-cbc")) {
                    return new KeyGenerationEngineImpl.AES192CBC((Provider)object);
                }
                if (string.equals("http://www.w3.org/2001/04/xmlenc#aes256-cbc")) {
                    return new KeyGenerationEngineImpl.AES256CBC((Provider)object);
                }
                if (string.equals("http://www.w3.org/2001/04/xmlenc#kw-tripledes")) {
                    return new KeyGenerationEngineImpl.HWC_KWTripleDES((Provider)object);
                }
                if (string.equals("http://www.w3.org/2001/04/xmlenc#kw-aes128")) {
                    return new KeyGenerationEngineImpl.KWAES128((Provider)object);
                }
                if (string.equals("http://www.w3.org/2001/04/xmlenc#kw-aes192")) {
                    return new KeyGenerationEngineImpl.KWAES192((Provider)object);
                }
                if (string.equals("http://www.w3.org/2001/04/xmlenc#kw-aes256")) {
                    return new KeyGenerationEngineImpl.KWAES256((Provider)object);
                }
                break;
            }
            catch (Exception exception) {
                System.out.println("HARDWARE: Alg Factory, getKeyGenerationEngine, exception: " + exception.getMessage());
                exception.printStackTrace();
                continue;
            }
        }
        if (arrayList.size() != 0 && this.debug) {
            System.out.println("HARDWARE CRYPTO: getKeyGenerationEngine fails with hardware crypto provider. Continue to use JCE provider");
        }
        if (string.equals("http://www.w3.org/2001/04/xmlenc#tripledes-cbc")) {
            Stack stack = kge3desPool;
            synchronized (stack) {
                if (!kge3desPool.isEmpty()) {
                    return (KeyGenerationEngine)kge3desPool.pop();
                }
            }
        }
        n = 0;
        while (true) {
            if (n >= providers.size()) break;
            try {
                if (this.debug) {
                    System.out.println("HWC: AlgorithmFactory, getKeyGenerationEngine, uri is: " + string);
                }
                if (string.equals("http://www.w3.org/2001/04/xmlenc#tripledes-cbc")) {
                    return new KeyGenerationEngineImpl.TripleDESCBC((Provider)providers.get(n));
                }
                if (string.equals("http://www.w3.org/2001/04/xmlenc#aes128-cbc")) {
                    return new KeyGenerationEngineImpl.AES128CBC((Provider)providers.get(n));
                }
                if (string.equals("http://www.w3.org/2001/04/xmlenc#aes192-cbc")) {
                    return new KeyGenerationEngineImpl.AES192CBC((Provider)providers.get(n));
                }
                if (string.equals("http://www.w3.org/2001/04/xmlenc#aes256-cbc")) {
                    return new KeyGenerationEngineImpl.AES256CBC((Provider)providers.get(n));
                }
                if (string.equals("http://www.w3.org/2001/04/xmlenc#kw-tripledes")) {
                    return new KeyGenerationEngineImpl.KWTripleDES((Provider)providers.get(n));
                }
                if (string.equals("http://www.w3.org/2001/04/xmlenc#kw-aes128")) {
                    return new KeyGenerationEngineImpl.KWAES128((Provider)providers.get(n));
                }
                if (string.equals("http://www.w3.org/2001/04/xmlenc#kw-aes192")) {
                    return new KeyGenerationEngineImpl.KWAES192((Provider)providers.get(n));
                }
                if (string.equals("http://www.w3.org/2001/04/xmlenc#kw-aes256")) {
                    return new KeyGenerationEngineImpl.KWAES256((Provider)providers.get(n));
                }
                bl = false;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                ++n;
                continue;
            }
            break;
        }
        if (bl) {
            throw new NoSuchAlgorithmException("No EncryptionEngine for " + string);
        }
        if (!fipsEnabled && this.childFactory != null && !this.childFactory.isEmpty()) {
            Iterator iterator = this.childFactory.iterator();
            while (iterator.hasNext()) {
                KeyGenerationEngine keyGenerationEngine;
                object = (EngineFactory)iterator.next();
                Object v = this.childFactoryURIs.get(object);
                if (v == null || !(v instanceof Set) || !((Set)v).contains(string) || !object.getDataEncryptionAlgorithms().contains(string) && !object.getKeyEncryptionAlgorithms().contains(string) || (keyGenerationEngine = object.getKeyGenerationEngine(string, string2)) == null) continue;
                return keyGenerationEngine;
            }
        }
        throw new NoSuchAlgorithmException("Unknown algorithm: " + string);
    }

    public boolean releaseKeyGenerationEngine(KeyGenerationEngine keyGenerationEngine) {
        if (this.debug) {
            System.out.println("HWC: AlgorithmFactory, releaseKeyGenerationEngine, no hwprovider?");
        }
        if ("http://www.w3.org/2001/04/xmlenc#tripledes-cbc".equals(keyGenerationEngine.getURI())) {
            kge3desPool.push(keyGenerationEngine);
            return true;
        }
        if (!fipsEnabled && this.childFactory != null && !this.childFactory.isEmpty()) {
            Iterator iterator = this.childFactory.iterator();
            while (iterator.hasNext()) {
                EngineFactory engineFactory = (EngineFactory)iterator.next();
                if (!engineFactory.releaseKeyGenerationEngine(keyGenerationEngine)) continue;
                return true;
            }
        }
        return this.supportedDataEncryption.contains(keyGenerationEngine.getURI()) || this.supportedKeyEncryption.contains(keyGenerationEngine.getURI());
    }

    public DOMSerializationEngine getDOMSerializationEngine(String string) throws NoSuchAlgorithmException {
        DOMSerializationEngine.XMLContent xMLContent = null;
        if (string == null) {
            throw new NullPointerException("Type not specified");
        }
        if (string.equals("http://www.w3.org/2001/04/xmlenc#Element")) {
            xMLContent = new DOMSerializationEngine.XMLElement();
        } else if (string.equals("http://www.w3.org/2001/04/xmlenc#Content")) {
            xMLContent = new DOMSerializationEngine.XMLContent();
        } else {
            throw new NoSuchAlgorithmException("Unknown type: " + string);
        }
        return xMLContent;
    }

    public AlgorithmParameterSpec unmarshalParameter(String string, Element element) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        AlgorithmParameterSpec algorithmParameterSpec = null;
        if ("http://www.w3.org/2000/09/xmldsig#hmac-sha1".equals(string)) {
            Element element2 = DOMUtil.getFirstChildElementNamed(element, "http://www.w3.org/2000/09/xmldsig#", "HMACOutputLength");
            if (element2 != null) {
                int n = Integer.parseInt(DOMUtil.getStringValue(element2));
                algorithmParameterSpec = new SignatureEngineHMAC.HMACParameterSpec(n, this.getCheckHMACOutputLength());
            }
            return algorithmParameterSpec;
        }
        if ("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p".equals(string)) {
            OAEPParams oAEPParams;
            String string2 = null;
            Element element3 = DOMUtil.getFirstChildElementNamed(element, "http://www.w3.org/2000/09/xmldsig#", "DigestMethod");
            if (element3 != null) {
                string2 = element3.getAttribute("Algorithm");
            }
            byte[] byArray = null;
            Element element4 = DOMUtil.getFirstChildElementNamed(element, "OAEPparams");
            if (element4 != null && (oAEPParams = new OAEPParams(element4)) != null) {
                byArray = oAEPParams.getParameters();
            }
            algorithmParameterSpec = this.getOAEPParameterSpec(string2, byArray);
            return algorithmParameterSpec;
        }
        if (this.supportedSignature.contains(string) || this.supportedDigest.contains(string) || this.supportedDataEncryption.contains(string) || this.supportedKeyEncryption.contains(string)) {
            return algorithmParameterSpec;
        }
        if (!fipsEnabled && this.childFactory != null && !this.childFactory.isEmpty()) {
            Iterator iterator = this.childFactory.iterator();
            while (iterator.hasNext()) {
                EngineFactory engineFactory = (EngineFactory)iterator.next();
                Object v = this.childFactoryURIs.get(engineFactory);
                if (v == null || !(v instanceof Set) || !((Set)v).contains(string)) continue;
                algorithmParameterSpec = engineFactory.unmarshalParameter(string, element);
                return algorithmParameterSpec;
            }
        }
        throw new NoSuchAlgorithmException(string);
    }

    public void marshalParameter(String string, AlgorithmParameterSpec algorithmParameterSpec, Element element) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        if (algorithmParameterSpec == null) {
            return;
        }
        if ("http://www.w3.org/2000/09/xmldsig#hmac-sha1".equals(string)) {
            Document document = element.getOwnerDocument();
            String string2 = element.getPrefix();
            String string3 = string2 == null ? "HMACOutputLength" : string2 + ":HMACOutputLength";
            Element element2 = document.createElementNS("http://www.w3.org/2000/09/xmldsig#", string3);
            element.appendChild(element2);
            int n = ((SignatureEngineHMAC.HMACParameterSpec)algorithmParameterSpec).getOutputLength();
            if (n < 80) {
                throw new InvalidAlgorithmParameterException("Invalid HMACOutputLength value");
            }
            element2.appendChild(document.createTextNode(Integer.toString(n)));
        } else {
            if ("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p".equals(string)) {
                String string4 = this.getOaepDigestMethodURI(algorithmParameterSpec);
                Document document = element.getOwnerDocument();
                Element element3 = document.createElementNS("http://www.w3.org/2000/09/xmldsig#", "DigestMethod");
                element3.setAttribute("Algorithm", Util.normalize(string4));
                element.appendChild(element3);
                byte[] byArray = this.getOaepParams(algorithmParameterSpec);
                if (byArray != null && byArray.length > 0) {
                    OAEPParams oAEPParams = new OAEPParams();
                    oAEPParams.setParameters(byArray);
                    Element element4 = null;
                    try {
                        element4 = oAEPParams.createElement(document, false);
                    }
                    catch (StructureException structureException) {
                        InvalidAlgorithmParameterException invalidAlgorithmParameterException = new InvalidAlgorithmParameterException("Unable to create OAEPparams element");
                        invalidAlgorithmParameterException.initCause(structureException);
                        throw invalidAlgorithmParameterException;
                    }
                    if (element4 != null) {
                        element.appendChild(element4);
                    }
                }
                return;
            }
            if (this.supportedSignature.contains(string) || this.supportedDigest.contains(string) || this.supportedDataEncryption.contains(string) || this.supportedKeyEncryption.contains(string)) {
                throw new InvalidAlgorithmParameterException("The algorithm " + string + " does not support any AlgorithmParameterSpec.");
            }
            if (!fipsEnabled && this.childFactory != null && !this.childFactory.isEmpty()) {
                Iterator iterator = this.childFactory.iterator();
                while (iterator.hasNext()) {
                    EngineFactory engineFactory = (EngineFactory)iterator.next();
                    Object v = this.childFactoryURIs.get(engineFactory);
                    if (v == null || !(v instanceof Set) || !((Set)v).contains(string)) continue;
                    engineFactory.marshalParameter(string, algorithmParameterSpec, element);
                }
            }
        }
        throw new NoSuchAlgorithmException(string);
    }

    public AlgorithmParameterSpec convertParameter(String string, Map map) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        AlgorithmParameterSpec algorithmParameterSpec = null;
        if ("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p".equals(string)) {
            String string2 = (String)map.get("com.ibm.wsspi.wssecurity.enc.rsaoaep.DigestMethod");
            String string3 = (String)map.get("com.ibm.wsspi.wssecurity.enc.rsaoaep.OAEPparams");
            byte[] byArray = null;
            if (string3 != null && string3.length() > 0) {
                byArray = Base64.decode(string3);
            }
            algorithmParameterSpec = this.getOAEPParameterSpec(string2, byArray);
            return algorithmParameterSpec;
        }
        if (!(this.supportedSignature.contains(string) || this.supportedDigest.contains(string) || this.supportedDataEncryption.contains(string) || this.supportedKeyEncryption.contains(string) || fipsEnabled || this.childFactory == null || this.childFactory.isEmpty())) {
            Iterator iterator = this.childFactory.iterator();
            while (iterator.hasNext()) {
                EngineFactory engineFactory = (EngineFactory)iterator.next();
                Object v = this.childFactoryURIs.get(engineFactory);
                if (v == null || !(v instanceof Set) || !((Set)v).contains(string)) continue;
                algorithmParameterSpec = engineFactory.convertParameter(string, map);
                return algorithmParameterSpec;
            }
        }
        return null;
    }

    private AlgorithmParameterSpec getOAEPParameterSpec(String string, byte[] byArray) throws InvalidAlgorithmParameterException {
        AlgorithmParameterSpec algorithmParameterSpec = null;
        AlgorithmParameterSpec algorithmParameterSpec2 = null;
        String string2 = null;
        if (string == null || string.length() <= 0 || "http://www.w3.org/2000/09/xmldsig#sha1".equals(string)) {
            string2 = "SHA-1";
            algorithmParameterSpec2 = OAEPHelper.sha1MgfSpec;
        } else if ("http://www.w3.org/2001/04/xmlenc#sha256".equals(string)) {
            string2 = "SHA-256";
            algorithmParameterSpec2 = OAEPHelper.sha256MgfSpec;
        } else if ("http://www.w3.org/2001/04/xmlenc#sha512".equals(string)) {
            string2 = "SHA-512";
            algorithmParameterSpec2 = OAEPHelper.sha512MgfSpec;
        } else {
            throw new InvalidAlgorithmParameterException("Message digest algorithm " + string + " is not supported for use with the RSA-OAEP encryption algorithm.");
        }
        try {
            Constructor constructor;
            String string3 = "MGF1";
            Object object = null;
            if (byArray == null || byArray.length <= 0) {
                object = OAEPHelper.defaultPSource;
            } else {
                constructor = OAEPHelper.pSourceConstructor;
                if (constructor != null) {
                    object = constructor.newInstance(new Object[]{byArray});
                }
            }
            constructor = OAEPHelper.oaepParamSpecConstructor;
            if (algorithmParameterSpec2 == null || object == null || constructor == null) {
                InvalidAlgorithmParameterException invalidAlgorithmParameterException = new InvalidAlgorithmParameterException("Unable to construct OAEPParameterSpec");
                invalidAlgorithmParameterException.initCause(OAEPHelper.exc);
                throw invalidAlgorithmParameterException;
            }
            algorithmParameterSpec = (AlgorithmParameterSpec)constructor.newInstance(string2, string3, algorithmParameterSpec2, object);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InvalidAlgorithmParameterException(illegalAccessException.getMessage());
        }
        catch (InstantiationException instantiationException) {
            throw new InvalidAlgorithmParameterException(instantiationException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new InvalidAlgorithmParameterException(invocationTargetException.getMessage());
        }
        return algorithmParameterSpec;
    }

    private String getOaepDigestMethodURI(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        String string;
        block6: {
            string = "http://www.w3.org/2000/09/xmldsig#sha1";
            if (algorithmParameterSpec == null) {
                return string;
            }
            try {
                Method method2 = OAEPHelper.getDigestAlgorithm;
                if (method2 == null) break block6;
                Object object = method2.invoke((Object)algorithmParameterSpec, new Object[0]);
                String string2 = null;
                if (object == null || !(object instanceof String)) break block6;
                string2 = (String)object;
                if ("SHA-1".equals(string2) || "SHA1".equals(string2)) {
                    string = "http://www.w3.org/2000/09/xmldsig#sha1";
                    break block6;
                }
                if ("SHA-256".equals(string2) || "SHA256".equals(string2)) {
                    string = "http://www.w3.org/2001/04/xmlenc#sha256";
                    break block6;
                }
                if ("SHA-512".equals(string2) || "SHA512".equals(string2)) {
                    string = "http://www.w3.org/2001/04/xmlenc#sha512";
                    break block6;
                }
                throw new InvalidAlgorithmParameterException("Message digest algorithm " + string2 + " is not supported for use with the RSA-OAEP encryption algorithm.");
            }
            catch (Exception exception) {
                throw new InvalidAlgorithmParameterException(exception.getMessage());
            }
        }
        return string;
    }

    private byte[] getOaepParams(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        byte[] byArray = null;
        if (algorithmParameterSpec == null) {
            return byArray;
        }
        try {
            Object object;
            Object object2;
            Method method2 = OAEPHelper.getPSource;
            if (method2 != null && (object2 = method2.invoke((Object)algorithmParameterSpec, new Object[0])) != null && (method2 = OAEPHelper.getValue) != null && (object = method2.invoke(object2, new Object[0])) instanceof byte[]) {
                byArray = (byte[])object;
            }
        }
        catch (Exception exception) {
            throw new InvalidAlgorithmParameterException(exception.getMessage());
        }
        return byArray;
    }

    static {
        documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        try {
            documentBuilderFactory.setAttribute("http://apache.org/xml/features/validation/dynamic", Boolean.TRUE);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        documentBuilderPool = new Stack();
        sha1Pool = new Stack();
        sha256Pool = new Stack();
        sha512Pool = new Stack();
        rsaPool = new Stack();
        dsaPool = new Stack();
        hmacPool = new Stack();
        eePoolMap = new HashMap();
        eePoolMap.put("http://www.w3.org/2001/04/xmlenc#tripledes-cbc", new Stack());
        eePoolMap.put("http://www.w3.org/2001/04/xmlenc#aes128-cbc", new Stack());
        eePoolMap.put("http://www.w3.org/2001/04/xmlenc#aes192-cbc", new Stack());
        eePoolMap.put("http://www.w3.org/2001/04/xmlenc#aes256-cbc", new Stack());
        eePoolMap.put("http://www.w3.org/2001/04/xmlenc#rsa-1_5", new Stack());
        eePoolMap.put("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p", new Stack());
        eePoolMap.put("http://www.w3.org/2001/04/xmlenc#kw-tripledes", new Stack());
        eePoolMap.put("http://www.w3.org/2001/04/xmlenc#kw-aes128", new Stack());
        eePoolMap.put("http://www.w3.org/2001/04/xmlenc#kw-aes192", new Stack());
        eePoolMap.put("http://www.w3.org/2001/04/xmlenc#kw-aes256", new Stack());
        kge3desPool = new Stack();
        hwcRsaMap = new HashMap();
        hwcDsaMap = new HashMap();
        hwcHmacMap = new HashMap();
        hwcEERsaMap = new HashMap();
        hwcEE3desMap = new HashMap();
        hwcEEAes128Map = new HashMap();
        hwcEEAes192Map = new HashMap();
        hwcEEAes256Map = new HashMap();
        hwcEERsaOaepMap = new HashMap();
        hwcEEkw3desMap = new HashMap();
        hwcEEkwAes128Map = new HashMap();
        hwcEEkwAes192Map = new HashMap();
        hwcEEAes256Map = new HashMap();
        hwcKge3desMap = new HashMap();
        if ("true".equalsIgnoreCase(Security.getProperty("com.ibm.websphere.security.fips.enabled"))) {
            fipsEnabled = true;
            StringTokenizer stringTokenizer = new StringTokenizer(Security.getProperty("com.ibm.websphere.security.fips.jceProviders"), "|");
            while (stringTokenizer.hasMoreTokens()) {
                providers.add(Security.getProvider(stringTokenizer.nextToken()));
            }
        }
        s_theInstance = new AlgorithmFactory(null);
    }

    private static class OAEPHelper {
        static Object defaultPSource = null;
        static AlgorithmParameterSpec sha1MgfSpec = null;
        static AlgorithmParameterSpec sha256MgfSpec = null;
        static AlgorithmParameterSpec sha512MgfSpec = null;
        static Constructor oaepParamSpecConstructor = null;
        static Constructor pSourceConstructor = null;
        static Method getDigestAlgorithm = null;
        static Method getPSource = null;
        static Method getValue = null;
        static Throwable exc = null;

        private OAEPHelper() {
        }

        static {
            try {
                Class<?> clazz = Class.forName("java.security.spec.MGF1ParameterSpec");
                Object object = clazz.getField("SHA1").get(null);
                sha1MgfSpec = (AlgorithmParameterSpec)object;
                object = clazz.getField("SHA256").get(null);
                sha256MgfSpec = (AlgorithmParameterSpec)object;
                object = clazz.getField("SHA512").get(null);
                sha512MgfSpec = (AlgorithmParameterSpec)object;
                Class<?> clazz2 = Class.forName("javax.crypto.spec.PSource$PSpecified");
                defaultPSource = object = clazz2.getField("DEFAULT").get(null);
                pSourceConstructor = clazz2.getConstructor(array$B == null ? (array$B = AlgorithmFactory.class$("[B")) : array$B);
                Class<?> clazz3 = Class.forName("javax.crypto.spec.PSource");
                Class<?> clazz4 = Class.forName("javax.crypto.spec.OAEPParameterSpec");
                oaepParamSpecConstructor = clazz4.getConstructor(class$java$lang$String == null ? (class$java$lang$String = AlgorithmFactory.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = AlgorithmFactory.class$("java.lang.String")) : class$java$lang$String, class$java$security$spec$AlgorithmParameterSpec == null ? (class$java$security$spec$AlgorithmParameterSpec = AlgorithmFactory.class$("java.security.spec.AlgorithmParameterSpec")) : class$java$security$spec$AlgorithmParameterSpec, clazz3);
                getDigestAlgorithm = clazz4.getMethod("getDigestAlgorithm", new Class[0]);
                getPSource = clazz4.getMethod("getPSource", new Class[0]);
                getValue = clazz2.getMethod("getValue", new Class[0]);
            }
            catch (IllegalAccessException illegalAccessException) {
                exc = illegalAccessException;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                exc = noSuchFieldException;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                exc = noSuchMethodException;
            }
            catch (ClassNotFoundException classNotFoundException) {
                exc = classNotFoundException;
            }
            catch (Throwable throwable) {
                exc = throwable;
            }
        }
    }
}

