/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xss4j.domutil;

import java.io.IOException;
import java.io.Writer;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

public final class C14nUtil {
    private static final int TEXT_TAB_SIZE = 64;
    private static final String[] textTab = new String[]{null, null, null, null, null, null, null, null, null, null, null, null, null, "&#xD;", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "&amp;", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "&lt;", null, "&gt;", null};
    private static final int ATTR_TAB_SIZE = 64;
    private static final String[] attrTab = new String[]{null, null, null, null, null, null, null, null, null, "&#x9;", "&#xA;", null, null, "&#xD;", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "&quot;", null, null, null, "&amp;", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "&lt;", null, null, null};
    private static final int[] fixTable = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8192, -2048, -2048, -2048, -2048};

    static final void serializeText(String string, Writer writer) throws IOException {
        int n = string.length();
        int n2 = -1;
        for (int i = 0; i < n; ++i) {
            String string2;
            char c = string.charAt(i);
            String string3 = string2 = c < '@' ? textTab[c] : null;
            if (string2 != null) {
                if (n2 >= 0) {
                    writer.write(string, n2, i - n2);
                    n2 = -1;
                }
                writer.write(string2);
                continue;
            }
            if (n2 >= 0) continue;
            n2 = i;
        }
        if (n2 >= 0) {
            writer.write(string, n2, n - n2);
        }
    }

    static final void serializePI(Node node, Writer writer) throws IOException {
        Node node2;
        boolean bl = false;
        boolean bl2 = false;
        if (node.getParentNode().getNodeType() == 9) {
            node2 = node;
            while ((node2 = node2.getPreviousSibling()) != null && node2.getNodeType() != 1) {
            }
            if (node2 == null) {
                bl = true;
            } else {
                bl2 = true;
            }
        }
        node2 = (ProcessingInstruction)node;
        if (bl2) {
            writer.write("\n");
        }
        writer.write("<?");
        writer.write(node2.getTarget());
        if (node2.getData() != null && node2.getData().length() > 0) {
            writer.write(" ");
            String string = node2.getData();
            int n = 0;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) != '\r') continue;
                if (i > n) {
                    writer.write(string, n, i - n);
                }
                writer.write("&#xD;");
                n = i + 1;
            }
            if (n < string.length()) {
                writer.write(string, n, string.length() - n);
            }
        }
        writer.write("?>");
        if (bl) {
            writer.write("\n");
        }
    }

    static final void serializeComment(Node node, Writer writer) throws IOException {
        boolean bl = false;
        boolean bl2 = false;
        if (node.getParentNode().getNodeType() == 9) {
            Node node2 = node;
            while ((node2 = node2.getPreviousSibling()) != null && node2.getNodeType() != 1) {
            }
            if (node2 == null) {
                bl = true;
            } else {
                bl2 = true;
            }
        }
        if (bl2) {
            writer.write("\n");
        }
        writer.write("<!--");
        writer.write(node.getNodeValue());
        writer.write("-->");
        if (bl) {
            writer.write("\n");
        }
    }

    static final void serializeAttribute(Node node, Writer writer, boolean bl) throws IOException {
        C14nUtil.serializeAttribute(node.getNodeName(), node.getNodeValue(), writer, bl);
    }

    static final void serializeAttribute(String string, String string2, Writer writer, boolean bl) throws IOException {
        int n = string2.length();
        int n2 = -1;
        boolean bl2 = false;
        writer.write(" ");
        writer.write(string);
        writer.write("=\"");
        for (int i = 0; i < n; ++i) {
            String string3;
            char c = string2.charAt(i);
            String string4 = string3 = c < '@' ? attrTab[c] : null;
            if (string3 != null) {
                if (n2 >= 0) {
                    writer.write(string2, n2, i - n2);
                    n2 = -1;
                }
                writer.write(string3);
                continue;
            }
            if (n2 < 0) {
                n2 = i;
            }
            if (!bl) continue;
            if (c == ':') {
                bl2 = true;
                continue;
            }
            if (c != '/' || bl2) continue;
            throw new RuntimeException("Found a relative URI: " + string + "='" + string2 + "'");
        }
        if (n2 >= 0) {
            writer.write(string2, n2, n - n2);
        }
        if (string2.length() > 0 && bl && !bl2) {
            throw new RuntimeException("Found a relative URI: " + string + "='" + string2 + "'");
        }
        writer.write("\"");
    }

    public static void heapSort(int[] nArray, String[] stringArray, int n) {
        int n2;
        for (n2 = n / 2; n2 >= 0; --n2) {
            C14nUtil.fall(nArray, stringArray, n, n2);
        }
        for (n2 = n - 1; n2 > 0; --n2) {
            int n3 = nArray[0];
            nArray[0] = nArray[n2];
            nArray[n2] = n3;
            C14nUtil.fall(nArray, stringArray, n2, 0);
        }
    }

    private static void fall(int[] nArray, String[] stringArray, int n, int n2) {
        int n3 = 2 * n2 + 1;
        if (n3 < n) {
            if (n3 + 1 < n && 0 > stringArray[nArray[n3]].compareTo(stringArray[nArray[n3 + 1]])) {
                n3 = 2 * n2 + 2;
            }
            if (0 > C14nUtil.compareInUCS(stringArray[nArray[n2]], stringArray[nArray[n3]])) {
                int n4 = nArray[n2];
                nArray[n2] = nArray[n3];
                nArray[n3] = n4;
                C14nUtil.fall(nArray, stringArray, n, n3);
            }
        }
    }

    public static final int lengthInUCS(String string) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if ('\ud800' <= c && c < '\udc00') {
                ++i;
            }
            ++n;
        }
        return n;
    }

    public static final int compareInUCS(String string, String string2) {
        int n;
        int n2 = string.length();
        int n3 = n2 < (n = string2.length()) ? n2 : n;
        int n4 = 0;
        int n5 = 0;
        while (n3-- != 0) {
            int n6 = string.charAt(n4++);
            n6 += fixTable[n6 >> 11];
            int n7 = string2.charAt(n5++);
            if (n6 == (n7 += fixTable[n7 >> 11])) continue;
            return n6 - n7;
        }
        return n2 - n;
    }
}

