/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xss4j.domutil;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Stack;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.apache.xerces.dom.DocumentImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

public class DOMBuilder
implements ContentHandler,
LexicalHandler {
    public static final String XMLNS_NSURI = "http://www.w3.org/2000/xmlns/";
    private Node contextNode = null;
    private Stack contextStack = new Stack();
    private Document factory;
    private boolean inCdata = false;
    private Vector prefixes = null;
    private StringBuffer buffer = null;
    static Stack s_parserPool = new Stack();
    static SAXParserFactory s_factory = null;

    public DOMBuilder(Document document) {
        this.reset(document);
    }

    public void reset(Document document) {
        this.factory = document;
        this.contextStack.setSize(0);
        this.contextNode = null;
        this.inCdata = false;
        this.prefixes = null;
        if (this.buffer != null) {
            this.buffer.setLength(0);
        }
    }

    public Node getNode() {
        this.flushText();
        return this.contextNode;
    }

    protected void output(Node node) {
        if (this.contextNode == null) {
            this.contextNode = node;
        } else {
            this.contextNode.appendChild(node);
        }
    }

    protected void pushContext(Node node) {
        this.contextStack.push(this.contextNode);
        this.contextNode = node;
    }

    protected Node popContext() {
        Node node = this.contextNode;
        this.contextNode = (Node)this.contextStack.pop();
        return node;
    }

    protected void flushText() {
        if (this.buffer == null || this.buffer.length() == 0) {
            return;
        }
        String string = new String(this.buffer);
        Text text = this.inCdata ? this.factory.createCDATASection(string) : this.factory.createTextNode(string);
        this.output(text);
        this.buffer.setLength(0);
    }

    public void startCDATA() throws SAXException {
    }

    public void endCDATA() throws SAXException {
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.buffer == null) {
            this.buffer = new StringBuffer();
        }
        this.buffer.append(cArray, n, n2);
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        this.characters(cArray, n, n2);
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        this.flushText();
        ProcessingInstruction processingInstruction = this.factory.createProcessingInstruction(string, string2);
        this.output(processingInstruction);
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        this.flushText();
        String string = new String(cArray, n, n2);
        Comment comment = this.factory.createComment(string);
        this.output(comment);
    }

    public void startDocument() throws SAXException {
        this.pushContext(this.factory);
    }

    public void endDocument() throws SAXException {
        this.output(this.popContext());
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        if (this.prefixes == null) {
            this.prefixes = new Vector();
        }
        String string3 = "xmlns";
        if (string.length() > 0) {
            string3 = "xmlns:" + string;
        }
        Attr attr = this.factory.createAttributeNS(XMLNS_NSURI, string3);
        attr.setNodeValue(string2);
        this.prefixes.addElement(attr);
    }

    public void startElement(String string, String string2, String string3, Attributes attributes2) throws SAXException {
        Attr attr;
        int n;
        this.flushText();
        Element element = this.factory.createElementNS(string, string3);
        for (n = 0; n < attributes2.getLength(); ++n) {
            String string4 = attributes2.getURI(n);
            String string5 = attributes2.getQName(n);
            if (string5.startsWith("xmlns:") || string5.equals("xmlns")) {
                string4 = XMLNS_NSURI;
            }
            attr = this.factory.createAttributeNS(string4, string5);
            attr.setNodeValue(attributes2.getValue(n));
            element.setAttributeNode(attr);
        }
        if (this.prefixes != null && this.prefixes.size() > 0) {
            for (n = 0; n < this.prefixes.size(); ++n) {
                attr = (Attr)this.prefixes.elementAt(n);
                element.setAttributeNode(attr);
            }
            this.prefixes.removeAllElements();
        }
        this.pushContext(element);
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        this.flushText();
        this.output(this.popContext());
    }

    public void endPrefixMapping(String string) throws SAXException {
    }

    public void startEntity(String string) throws SAXException {
    }

    public void endEntity(String string) throws SAXException {
    }

    public void startDTD(String string, String string2, String string3) throws SAXException {
    }

    public void endDTD() throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void skippedEntity(String string) throws SAXException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XMLReader getXMLReader() throws ParserConfigurationException, SAXException {
        Stack stack = s_parserPool;
        synchronized (stack) {
            if (!s_parserPool.isEmpty()) {
                return (XMLReader)s_parserPool.pop();
            }
        }
        return s_factory.newSAXParser().getXMLReader();
    }

    public static void releaseXMLReader(XMLReader xMLReader) {
        s_parserPool.push(xMLReader);
    }

    public Document parse(InputSource inputSource) throws IOException, SAXException, ParserConfigurationException {
        XMLReader xMLReader = DOMBuilder.getXMLReader();
        xMLReader.setContentHandler(this);
        xMLReader.setProperty("http://xml.org/sax/properties/lexical-handler", this);
        xMLReader.parse(inputSource);
        DOMBuilder.releaseXMLReader(xMLReader);
        return this.factory;
    }

    public static Document parse(InputStream inputStream) throws IOException, SAXException, ParserConfigurationException {
        DOMBuilder dOMBuilder = new DOMBuilder((Document)new DocumentImpl());
        return dOMBuilder.parse(new InputSource(inputStream));
    }

    public static Document parse(byte[] byArray) throws IOException, SAXException, ParserConfigurationException {
        DocumentImpl documentImpl = new DocumentImpl();
        DOMBuilder dOMBuilder = new DOMBuilder(null);
        dOMBuilder.reset((Document)documentImpl);
        return dOMBuilder.parse(new InputSource(new ByteArrayInputStream(byArray)));
    }

    static {
        try {
            Class<?> clazz = Class.forName("jaxp.SAXParserFactoryImpl");
            s_factory = (SAXParserFactory)clazz.newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (s_factory == null) {
            s_factory = SAXParserFactory.newInstance();
        }
        s_factory.setNamespaceAware(true);
    }
}

