/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xss4j.domutil;

import com.ibm.ws.wssecurity.xss4j.domutil.IndentConfig;
import java.io.IOException;
import java.io.Writer;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DOMUtil {
    public static final String S_XMLNS = "xmlns";
    public static final String S_XMLNAMESPACEURI = "http://www.w3.org/XML/1998/namespace";
    private static final String[] INDENT_STRINGS = new String[]{"\n", "\n ", "\n  ", "\n   ", "\n    ", "\n     ", "\n      ", "\n       ", "\n        ", "\n         ", "\n          "};
    public static IndentConfig DEFAULT_INDENT = new IndentConfig(){

        public boolean doIndentation() {
            return false;
        }

        public int getUnit() {
            return 2;
        }
    };

    private DOMUtil() {
    }

    public static String getStringValue(Node node) {
        switch (node.getNodeType()) {
            case 1: 
            case 5: 
            case 9: {
                Node node2 = node.getFirstChild();
                if (node2 == null) {
                    return "";
                }
                if (node2 == node.getLastChild() && (node2.getNodeType() == 3 || node2.getNodeType() == 4)) {
                    return node2.getNodeValue();
                }
                StringBuffer stringBuffer = new StringBuffer();
                DOMUtil.getStringValue0(node, stringBuffer);
                return new String(stringBuffer);
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                return node.getNodeValue();
            }
        }
        throw new RuntimeException("Internal Error: Unexpected node type: " + node.getNodeType());
    }

    private static void getStringValue0(Node node, StringBuffer stringBuffer) {
        switch (node.getNodeType()) {
            case 1: 
            case 5: {
                for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                    DOMUtil.getStringValue0(node2, stringBuffer);
                }
                break;
            }
            case 3: 
            case 4: {
                stringBuffer.append(node.getNodeValue());
                break;
            }
        }
    }

    public static final Element createTextElement(Document document, String string, String string2) {
        Element element = document.createElement(string);
        element.appendChild(document.createTextNode(string2));
        return element;
    }

    public static final Element createTextElementNS(Document document, String string, String string2, String string3) {
        Element element = document.createElementNS(string, string2);
        element.appendChild(document.createTextNode(string3));
        return element;
    }

    public static final void appendText(Element element, String string) {
        element.appendChild(element.getOwnerDocument().createTextNode(string));
    }

    public static final void removeAllChildren(Element element) {
        while (element.hasChildNodes()) {
            element.removeChild(element.getFirstChild());
        }
    }

    public static String getNamespaceForPrefix(String string, Node node) {
        if (string.equals("xml")) {
            return S_XMLNAMESPACEURI;
        }
        if (string.equals(S_XMLNS)) {
            return string;
        }
        String string2 = string.length() == 0 ? S_XMLNS : "xmlns:" + string;
        Node node2 = node;
        do {
            short s;
            Attr attr;
            Attr attr2 = attr = node2.getAttributes().getLength() == 0 ? null : ((Element)node2).getAttributeNode(string2);
            if (attr != null) {
                return attr.getNodeValue();
            }
            do {
                if ((node2 = node2.getParentNode()) != null) continue;
                return string2 == S_XMLNS ? "" : null;
            } while ((s = node2.getNodeType()) == 5);
            if (s == 1) continue;
            return string2 == S_XMLNS ? "" : null;
        } while (node2 != null);
        return null;
    }

    public static String getNamespace(Element element) {
        String string = element.getNodeName();
        int n = string.indexOf(58);
        String string2 = n <= 0 ? "" : string.substring(0, n);
        String string3 = DOMUtil.getNamespaceForPrefix(string2, element);
        if (string3 == null || string3.length() == 0) {
            string3 = null;
        }
        return string3;
    }

    public static Node getPreviousSibling2(Node node) {
        Node node2 = node.getPreviousSibling();
        if (node2 == null) {
            Node node3 = node.getParentNode();
            if (node3 == null) {
                return null;
            }
            if (node3.getNodeType() == 5) {
                node2 = DOMUtil.getPreviousSibling2(node3);
            }
        } else {
            while (node2.getNodeType() == 5) {
                Node node4 = node2.getLastChild();
                if (node4 == null) {
                    node2 = DOMUtil.getPreviousSibling2(node2);
                    break;
                }
                node2 = node4;
            }
        }
        return node2;
    }

    public static Node getNextSibling2(Node node) {
        Node node2 = node.getNextSibling();
        if (node2 == null) {
            Node node3 = node.getParentNode();
            if (node3 == null) {
                return null;
            }
            if (node3.getNodeType() == 5) {
                node2 = DOMUtil.getNextSibling2(node3);
            }
        } else {
            while (node2.getNodeType() == 5) {
                Node node4 = node2.getFirstChild();
                if (node4 == null) {
                    node2 = DOMUtil.getNextSibling2(node2);
                    break;
                }
                node2 = node4;
            }
        }
        return node2;
    }

    public static Node getFirstChild2(Node node) {
        Node node2 = node.getFirstChild();
        while (node2 != null && node2.getNodeType() == 5) {
            Node node3 = node2.getFirstChild();
            if (node3 == null) {
                node2 = DOMUtil.getNextSibling2(node2);
                break;
            }
            node2 = node3;
        }
        return node2;
    }

    public static Node getLastChild2(Node node) {
        Node node2 = node.getLastChild();
        while (node2 != null && node2.getNodeType() == 5) {
            Node node3 = node2.getLastChild();
            if (node3 == null) {
                node2 = DOMUtil.getPreviousSibling2(node2);
                break;
            }
            node2 = node3;
        }
        return node2;
    }

    public static Element getNextElement(Node node) {
        Node node2 = node;
        while ((node2 = DOMUtil.getNextSibling2(node2)) != null && node2.getNodeType() != 1) {
        }
        return (Element)node2;
    }

    public static Element getFirstChildElement(Node node) {
        Node node2 = DOMUtil.getFirstChild2(node);
        while (node2 != null && node2.getNodeType() != 1) {
            node2 = DOMUtil.getNextSibling2(node2);
        }
        return (Element)node2;
    }

    public static Element getFirstChildElementNamed(Node node, String string) {
        Node node2 = node.getFirstChild();
        while (!(node2 == null || node2.getNodeType() == 1 && node2.getNodeName().equals(string))) {
            node2 = DOMUtil.getNextSibling2(node2);
        }
        return (Element)node2;
    }

    public static Element getFirstChildElementNamed(Node node, String string, String string2) {
        Node node2 = node.getFirstChild();
        while (node2 != null) {
            if (node2.getNodeType() == 1) {
                Element element = (Element)node2;
                String string3 = DOMUtil.getNamespace(element);
                if ((string2.equals("*") || element.getLocalName().equals(string2)) && (string == null && string3 == null || string != null && string.equals("*") || string != null && string.equals(string3))) break;
            }
            node2 = DOMUtil.getNextSibling2(node2);
        }
        return (Element)node2;
    }

    public static boolean checkAllSpaces(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c <= ' ' && 0 <= " \t\r\n".indexOf(c)) continue;
            return false;
        }
        return true;
    }

    public static void writeEscapedAttribute(Writer writer, String string) throws IOException {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if ('<' == c) {
                writer.write("&lt;");
                continue;
            }
            if ('&' == c) {
                writer.write("&amp;");
                continue;
            }
            if ('\t' == c) {
                writer.write("&#x9;");
                continue;
            }
            if ('\n' == c) {
                writer.write("&#xA;");
                continue;
            }
            if ('\r' == c) {
                writer.write("&#xD;");
                continue;
            }
            if ('\"' == c) {
                writer.write("&quot;");
                continue;
            }
            writer.write(c);
        }
    }

    public static void writeEscapedCharData(Writer writer, String string) throws IOException {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if ('<' == c) {
                writer.write("&lt;");
                continue;
            }
            if ('&' == c) {
                writer.write("&amp;");
                continue;
            }
            if ('>' == c) {
                writer.write("&gt;");
                continue;
            }
            if ('\r' == c) {
                writer.write("&#xD;");
                continue;
            }
            writer.write(c);
        }
    }

    public static String escapeAttribute(String string) {
        StringBuffer stringBuffer = null;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if ("<&\t\n\r\"".indexOf(c) >= 0) {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer(string.length() * 2);
                    stringBuffer.append(string.substring(0, i));
                }
                if ('<' == c) {
                    stringBuffer.append("&lt;");
                    continue;
                }
                if ('&' == c) {
                    stringBuffer.append("&amp;");
                    continue;
                }
                if ('\t' == c) {
                    stringBuffer.append("&#x9;");
                    continue;
                }
                if ('\n' == c) {
                    stringBuffer.append("&#xA;");
                    continue;
                }
                if ('\r' == c) {
                    stringBuffer.append("&#xD;");
                    continue;
                }
                if ('\"' != c) continue;
                stringBuffer.append("&quot;");
                continue;
            }
            if (stringBuffer == null) continue;
            stringBuffer.append(c);
        }
        return stringBuffer == null ? string : new String(stringBuffer);
    }

    public static String escapeCharData(String string) {
        StringBuffer stringBuffer = null;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if ("<&>\r".indexOf(c) >= 0) {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer(string.length() * 2);
                    stringBuffer.append(string.substring(0, i));
                }
                if ('<' == c) {
                    stringBuffer.append("&lt;");
                    continue;
                }
                if ('&' == c) {
                    stringBuffer.append("&amp;");
                    continue;
                }
                if ('>' == c) {
                    stringBuffer.append("&gt;");
                    continue;
                }
                if ('\r' != c) continue;
                stringBuffer.append("&#xD;");
                continue;
            }
            if (stringBuffer == null) continue;
            stringBuffer.append(c);
        }
        return stringBuffer == null ? string : new String(stringBuffer);
    }

    public static void replacePrefix(Element element, String string, String string2) {
        if (string == null && element.getNamespaceURI() == null || string != null && string.equals(element.getNamespaceURI())) {
            element.setPrefix(string2);
        }
        Node node = DOMUtil.getFirstChild2(element);
        while (node != null) {
            if (node.getNodeType() == 1) {
                DOMUtil.replacePrefix((Element)node, string, string2);
            }
            node = DOMUtil.getNextSibling2(node);
        }
    }

    private static String getIndentText(IndentConfig indentConfig, int n) {
        String string;
        if (!indentConfig.doIndentation()) {
            return null;
        }
        int n2 = indentConfig.getUnit() * n;
        if (n2 < INDENT_STRINGS.length) {
            string = INDENT_STRINGS[n2];
        } else {
            StringBuffer stringBuffer = new StringBuffer(1 + n2);
            stringBuffer.append(INDENT_STRINGS[INDENT_STRINGS.length - 1]);
            for (int i = INDENT_STRINGS.length - 1; i < n2; ++i) {
                stringBuffer.append(' ');
            }
            string = new String(stringBuffer);
        }
        return string;
    }

    public static String getSpaces(IndentConfig indentConfig, int n) {
        if (indentConfig == null) {
            indentConfig = DEFAULT_INDENT;
        }
        int n2 = indentConfig.getUnit() * n;
        StringBuffer stringBuffer = new StringBuffer(n2);
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append(' ');
        }
        return new String(stringBuffer);
    }

    private static Node getIndentNode(Document document, IndentConfig indentConfig, int n) {
        return document.createTextNode(DOMUtil.getIndentText(indentConfig, n));
    }

    public static void addIndent(Element element, IndentConfig indentConfig, int n) {
        if (indentConfig == null) {
            indentConfig = DEFAULT_INDENT;
        }
        if (!indentConfig.doIndentation()) {
            return;
        }
        element.appendChild(DOMUtil.getIndentNode(element.getOwnerDocument(), indentConfig, n));
    }

    public static void addIndentBefore(Element element, Node node, IndentConfig indentConfig, int n) {
        if (indentConfig == null) {
            indentConfig = DEFAULT_INDENT;
        }
        if (!indentConfig.doIndentation()) {
            return;
        }
        element.insertBefore(DOMUtil.getIndentNode(element.getOwnerDocument(), indentConfig, n), node);
    }
}

