/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xss4j.domutil;

import com.ibm.ws.wssecurity.xss4j.domutil.C14nUtil;
import com.ibm.ws.wssecurity.xss4j.domutil.DOMUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.security.MessageDigest;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class Digest {
    static final boolean DEBUG = false;
    static final String tab = "0123456789ABCDEF";

    private Digest() {
    }

    public static byte[] getDigest(MessageDigest messageDigest, Node node) {
        if (node == null) {
            throw new IllegalArgumentException("The parameter is null.");
        }
        messageDigest.reset();
        byte[] byArray = null;
        short s = node.getNodeType();
        switch (s) {
            case 9: {
                Node node2;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                Digest.writeInt(byteArrayOutputStream, s);
                int n = 0;
                for (node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                    if (node2.getNodeType() == 1) {
                        ++n;
                        continue;
                    }
                    if (node2.getNodeType() != 7 || node2.getNodeName().equals("xml")) continue;
                    ++n;
                }
                Digest.writeInt(byteArrayOutputStream, n);
                try {
                    for (node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                        if (node2.getNodeType() == 1) {
                            byteArrayOutputStream.write(Digest.getDigest(messageDigest, node2));
                            continue;
                        }
                        if (node2.getNodeType() != 7 || node2.getNodeName().equals("xml")) continue;
                        byteArrayOutputStream.write(Digest.getDigest(messageDigest, node2));
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                messageDigest.reset();
                messageDigest.update(byteArrayOutputStream.toByteArray());
                byArray = messageDigest.digest();
                break;
            }
            case 1: {
                Node node3;
                Object object;
                Serializable serializable;
                int n;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                Digest.writeInt(byteArrayOutputStream, 1);
                String string = Digest.createExpandedName(node, node);
                for (int i = 0; i < string.length(); ++i) {
                    n = string.charAt(i);
                    byteArrayOutputStream.write(n >> 8);
                    byteArrayOutputStream.write(n & 0xFF);
                }
                byteArrayOutputStream.write(0);
                byteArrayOutputStream.write(0);
                NamedNodeMap namedNodeMap = node.getAttributes();
                n = namedNodeMap.getLength();
                if (n == 0) {
                    Digest.writeInt(byteArrayOutputStream, 0);
                } else {
                    int n2;
                    int n3 = 0;
                    serializable = new Hashtable(n);
                    object = new String[n];
                    for (n2 = 0; n2 < n; ++n2) {
                        node3 = namedNodeMap.item(n2);
                        String string2 = node3.getNodeName();
                        if (string2.equals("xmlns") || string2.startsWith("xmlns:")) continue;
                        String string3 = Digest.createExpandedName(node3, node);
                        ((Hashtable)serializable).put(string3, string2);
                        object[n3++] = string3;
                    }
                    Digest.writeInt(byteArrayOutputStream, n3);
                    Digest.heapSort((String[])object, n3);
                    try {
                        for (n2 = 0; n2 < n3; ++n2) {
                            node3 = ((Element)node).getAttributeNode((String)((Hashtable)serializable).get(object[n2]));
                            byteArrayOutputStream.write(Digest.getDigest(messageDigest, (Attr)node3, (Element)node));
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                Vector<byte[]> vector = new Vector<byte[]>();
                serializable = new StringBuffer();
                object = DOMUtil.getFirstChild2(node);
                while (object != null) {
                    byte[] byArray2 = null;
                    if (object instanceof Text) {
                        ((StringBuffer)serializable).append(object.getNodeValue());
                        while ((node3 = DOMUtil.getNextSibling2((Node)object)) != null && (node3 instanceof Text || node3.getNodeType() == 8)) {
                            object = node3;
                            if (node3.getNodeType() == 8) continue;
                            ((StringBuffer)serializable).append(object.getNodeValue());
                        }
                        if (0 < ((StringBuffer)serializable).length()) {
                            byArray2 = Digest.getTextDigest(messageDigest, (StringBuffer)serializable);
                            ((StringBuffer)serializable).setLength(0);
                        }
                    } else if (object.getNodeType() != 8) {
                        byArray2 = Digest.getDigest(messageDigest, (Node)object);
                    }
                    if (byArray2 != null) {
                        vector.addElement(byArray2);
                    }
                    object = DOMUtil.getNextSibling2((Node)object);
                }
                Digest.writeInt(byteArrayOutputStream, vector.size());
                try {
                    for (int i = 0; i < vector.size(); ++i) {
                        byteArrayOutputStream.write((byte[])vector.elementAt(i));
                    }
                    byteArrayOutputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                messageDigest.reset();
                messageDigest.update(byteArrayOutputStream.toByteArray());
                byArray = messageDigest.digest();
                break;
            }
            case 7: {
                Digest.digestInt(messageDigest, s);
                Digest.digestString(messageDigest, node.getNodeName());
                messageDigest.update((byte)0);
                messageDigest.update((byte)0);
                Digest.digestString(messageDigest, node.getNodeValue());
                byArray = messageDigest.digest();
                break;
            }
            case 3: 
            case 4: {
                Digest.digestInt(messageDigest, 3);
                Digest.digestString(messageDigest, node.getNodeValue());
                byArray = messageDigest.digest();
            }
        }
        return byArray;
    }

    public static byte[] getDigest(MessageDigest messageDigest, Attr attr, Element element) {
        String string = attr.getNodeName();
        if (string.equals("xmlns") || string.startsWith("xmlns:")) {
            return null;
        }
        messageDigest.reset();
        Digest.digestInt(messageDigest, 2);
        Digest.digestString(messageDigest, Digest.createExpandedName(attr, element));
        messageDigest.update((byte)0);
        messageDigest.update((byte)0);
        Digest.digestString(messageDigest, attr.getValue());
        return messageDigest.digest();
    }

    private static byte[] getTextDigest(MessageDigest messageDigest, String string) {
        messageDigest.reset();
        Digest.digestInt(messageDigest, 3);
        Digest.digestString(messageDigest, string);
        return messageDigest.digest();
    }

    private static byte[] getTextDigest(MessageDigest messageDigest, StringBuffer stringBuffer) {
        messageDigest.reset();
        Digest.digestInt(messageDigest, 3);
        Digest.digestString(messageDigest, stringBuffer);
        return messageDigest.digest();
    }

    private static void writeInt(ByteArrayOutputStream byteArrayOutputStream, int n) {
        byteArrayOutputStream.write(n >> 24 & 0xFF);
        byteArrayOutputStream.write(n >> 16 & 0xFF);
        byteArrayOutputStream.write(n >> 8 & 0xFF);
        byteArrayOutputStream.write(n & 0xFF);
    }

    public static String createExpandedName(Node node, Node node2) {
        String string;
        if (node.getNodeType() == 1) {
            String string2 = node.getNodeName();
            int n = string2.indexOf(58);
            String string3 = n <= 0 ? "" : string2.substring(0, n);
            String string4 = DOMUtil.getNamespaceForPrefix(string3, node2);
            string = string4 == null || string4.length() == 0 ? string2 : string4 + ":" + string2.substring(n + 1);
        } else if (node.getNodeType() == 2) {
            String string5 = node.getNodeName();
            int n = string5.indexOf(58);
            string = n <= 0 ? string5 : DOMUtil.getNamespaceForPrefix(string5.substring(0, n), node2) + ":" + string5.substring(n + 1);
        } else {
            throw new IllegalArgumentException("Requires Element or Attr node.");
        }
        return string;
    }

    private static void digestInt(MessageDigest messageDigest, int n) {
        messageDigest.update((byte)(n >> 24 & 0xFF));
        messageDigest.update((byte)(n >> 16 & 0xFF));
        messageDigest.update((byte)(n >> 8 & 0xFF));
        messageDigest.update((byte)(n & 0xFF));
    }

    private static void digestString(MessageDigest messageDigest, String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            messageDigest.update((byte)(c >> 8));
            messageDigest.update((byte)(c & 0xFF));
        }
    }

    private static void digestString(MessageDigest messageDigest, StringBuffer stringBuffer) {
        for (int i = 0; i < stringBuffer.length(); ++i) {
            char c = stringBuffer.charAt(i);
            messageDigest.update((byte)(c >> 8));
            messageDigest.update((byte)(c & 0xFF));
        }
    }

    private static void heapSort(String[] stringArray, int n) {
        int n2;
        for (n2 = n / 2; n2 >= 0; --n2) {
            Digest.fall(stringArray, n, n2);
        }
        for (n2 = n - 1; n2 > 0; --n2) {
            String string = stringArray[0];
            stringArray[0] = stringArray[n2];
            stringArray[n2] = string;
            Digest.fall(stringArray, n2, 0);
        }
    }

    private static void fall(String[] stringArray, int n, int n2) {
        int n3 = 2 * n2 + 1;
        if (n3 < n) {
            if (n3 + 1 < n && 0 > C14nUtil.compareInUCS(stringArray[n3], stringArray[n3 + 1])) {
                n3 = 2 * n2 + 2;
            }
            if (0 > C14nUtil.compareInUCS(stringArray[n2], stringArray[n3])) {
                String string = stringArray[n2];
                stringArray[n2] = stringArray[n3];
                stringArray[n3] = string;
                Digest.fall(stringArray, n, n3);
            }
        }
    }

    public static void printByteArray(byte[] byArray) throws IOException {
    }

    public static void printByteArray(Writer writer, byte[] byArray) throws IOException {
        if (null == byArray) {
            writer.write("NULL");
        } else {
            for (int i = 0; i < byArray.length; ++i) {
                Digest.printByte(writer, byArray[i]);
            }
        }
        writer.write("\n");
    }

    private static void printByte(Writer writer, byte by) throws IOException {
        writer.write(tab.charAt(by >> 4 & 0xF));
        writer.write(tab.charAt(by & 0xF));
    }
}

