/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xss4j.domutil;

import com.ibm.ws.wssecurity.xss4j.domutil.NOOPVisitor;
import java.io.IOException;
import java.io.Writer;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.Notation;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class PrintNodeTreeVisitor
extends NOOPVisitor {
    protected Writer writer = null;
    protected int indent = 0;
    protected int dx = 2;

    public PrintNodeTreeVisitor(Writer writer) {
        this.writer = writer;
    }

    public void visitElementPre(Element element) throws Exception {
        this.indent();
        this.writer.write("[Element] " + element.getNodeName() + "\n");
        this.indent += this.dx;
    }

    public void visitElementPost(Element element) throws Exception {
        this.indent -= this.dx;
    }

    public void visitTextPre(Text text) throws Exception {
        this.indent();
        this.writer.write("[Text] \"");
        this.printText(text.getNodeValue());
        this.writer.write("\"\n");
    }

    public void visitCDATASectionPre(CDATASection cDATASection) throws Exception {
        this.indent();
        this.writer.write("[CDATASection] \"" + cDATASection.getNodeValue() + "\"\n");
    }

    public void visitEntityReferencePre(EntityReference entityReference) throws Exception {
        this.indent();
        this.writer.write("[EntityReference] &" + entityReference.getNodeName() + ";\n");
    }

    public void visitEntityPre(Entity entity) throws Exception {
        this.indent();
        this.writer.write("[Entity] " + entity.getNodeName() + "\n");
    }

    public void visitProcessingInstructionPre(ProcessingInstruction processingInstruction) throws Exception {
        this.indent();
        this.writer.write("[ProcessingInstruction] " + processingInstruction.getNodeName() + " \"");
        this.printText(processingInstruction.getNodeValue());
        this.writer.write("\"\n");
    }

    public void visitCommentPre(Comment comment) throws Exception {
        this.indent();
        this.writer.write("[Comment] \"" + comment.getNodeValue() + "\"\n");
    }

    public void visitDocumentPre(Document document) throws Exception {
        this.indent();
        this.writer.write("[Document]\n");
        this.indent += this.dx;
    }

    public void visitDocumentPost(Document document) throws Exception {
        this.indent -= this.dx;
        this.writer.flush();
    }

    public void visitDocumentTypePre(DocumentType documentType) throws Exception {
        this.indent();
        this.writer.write("[DocumentType] " + documentType.getNodeValue() + "\n");
    }

    public void visitDocumentFragmentPre(DocumentFragment documentFragment) throws Exception {
        this.indent();
        this.writer.write("[DocumentFragment]\n");
    }

    public void visitNotationPre(Notation notation) throws Exception {
        this.indent();
        this.writer.write("[Notation]\n");
    }

    public void visitUnknownPre(Node node) throws Exception {
        this.indent();
        this.writer.write("[???Unknown]\n");
    }

    protected void indent() throws IOException {
        for (int i = 0; i < this.indent; ++i) {
            this.writer.write(" ");
        }
    }

    protected void printText(String string) throws IOException {
        block5: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\r': {
                    this.writer.write("&#x0d;");
                    continue block5;
                }
                case '\n': {
                    this.writer.write("&#x0a;");
                    continue block5;
                }
                case '\"': {
                    this.writer.write("&#x22;");
                    continue block5;
                }
                default: {
                    this.writer.write(c);
                }
            }
        }
    }
}

