/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xss4j.domutil;

import com.ibm.ws.wssecurity.xss4j.domutil.C14nUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class Serializer {
    private static final int ATTR_TAB_SIZE = 64;
    private static final String[] attrTab = new String[]{null, null, null, null, null, null, null, null, null, "&#x9;", "&#xA;", null, null, "&#xD;", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "&quot;", null, null, null, "&amp;", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "&lt;", null, null, null};

    static final void serializeAttribute(Node node, Writer writer) throws IOException {
        Serializer.serializeAttribute(node.getNodeName(), node.getNodeValue(), writer);
    }

    static final void serializeAttribute(String string, String string2, Writer writer) throws IOException {
        int n = string2.length();
        int n2 = -1;
        writer.write(" ");
        writer.write(string);
        writer.write("=\"");
        for (int i = 0; i < n; ++i) {
            String string3;
            char c = string2.charAt(i);
            String string4 = string3 = c < '@' ? attrTab[c] : null;
            if (string3 != null) {
                if (n2 >= 0) {
                    writer.write(string2, n2, i - n2);
                    n2 = -1;
                }
                writer.write(string3);
                continue;
            }
            if (n2 >= 0) continue;
            n2 = i;
        }
        if (n2 >= 0) {
            writer.write(string2, n2, n - n2);
        }
        writer.write("\"");
    }

    public static void serialize(Node node, Writer writer) throws IOException {
        switch (node.getNodeType()) {
            case 1: {
                String string = node.getNodeName();
                writer.write("<");
                writer.write(string);
                NamedNodeMap namedNodeMap = node.getAttributes();
                if (namedNodeMap != null) {
                    int n = namedNodeMap.getLength();
                    for (int i = 0; i < n; ++i) {
                        Serializer.serializeAttribute(namedNodeMap.item(i), writer);
                    }
                }
                writer.write(">");
                for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                    Serializer.serialize(node2, writer);
                }
                writer.write("</");
                writer.write(string);
                writer.write(">");
                break;
            }
            case 5: 
            case 9: {
                for (Node node3 = node.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
                    Serializer.serialize(node3, writer);
                }
                break;
            }
            case 3: 
            case 4: {
                C14nUtil.serializeText(node.getNodeValue(), writer);
                break;
            }
            case 8: {
                C14nUtil.serializeComment(node, writer);
                break;
            }
            case 2: {
                Serializer.serializeAttribute(node, writer);
                break;
            }
        }
    }

    public static byte[] serialize(Node node) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(byteArrayOutputStream);
        Serializer.serialize(node, outputStreamWriter);
        ((Writer)outputStreamWriter).close();
        return byteArrayOutputStream.toByteArray();
    }
}

