/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xss4j.domutil;

import com.ibm.ws.wssecurity.xss4j.domutil.NOOPVisitor;
import com.ibm.ws.wssecurity.xss4j.domutil.TreeTraversal;
import java.io.IOException;
import java.io.Writer;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class ToXMLVisitor
extends NOOPVisitor {
    protected Writer writer = null;
    protected String encoding = null;
    protected boolean isPrintNonSpecifiedAttributes = true;

    public ToXMLVisitor(Writer writer, String string) {
        this.writer = writer;
        this.encoding = string;
    }

    public ToXMLVisitor(Writer writer) {
        this(writer, null);
    }

    public void setPrintNonSpecifiedAttributes(boolean bl) {
        this.isPrintNonSpecifiedAttributes = bl;
    }

    public boolean getPrintNonSpecifiedAttributes() {
        return this.isPrintNonSpecifiedAttributes;
    }

    public void visitDocumentPre(Document document) throws Exception {
        this.writer.write("<?xml version=\"1.0\"?>");
    }

    public void visitDocumentPost(Document document) throws Exception {
        this.writer.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitElementPre(Element element) throws Exception {
        NamedNodeMap namedNodeMap;
        this.writer.write("<");
        this.writer.write(element.getTagName());
        NamedNodeMap namedNodeMap2 = namedNodeMap = element.getAttributes();
        synchronized (namedNodeMap2) {
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Attr attr = (Attr)namedNodeMap.item(i);
                if (!this.isPrintNonSpecifiedAttributes && !attr.getSpecified()) continue;
                this.visitAttributePre(attr);
            }
        }
        if (element.hasChildNodes()) {
            this.writer.write(">");
        } else {
            this.writer.write("/>");
        }
    }

    public void visitElementPost(Element element) throws Exception {
        if (element.hasChildNodes()) {
            this.writer.write("</");
            this.writer.write(element.getTagName());
            this.writer.write(">");
        }
    }

    public void visitAttributePre(Attr attr) throws Exception {
        this.writer.write(" ");
        this.writer.write(attr.getName());
        this.writer.write("=\"");
        for (Node node = attr.getFirstChild(); node != null; node = node.getNextSibling()) {
            short s = node.getNodeType();
            if (s == 3) {
                this.escapedWrite(this.writer, node.getNodeValue(), "<&\"", this.encoding);
                continue;
            }
            if (s != 5) continue;
            this.writer.write("&");
            this.writer.write(node.getNodeName());
            this.writer.write(";");
        }
        this.writer.write("\"");
    }

    public void visitProcessingInstructionPre(ProcessingInstruction processingInstruction) throws Exception {
        this.writer.write("<?");
        this.writer.write(processingInstruction.getNodeName());
        if (processingInstruction.getData().length() > 0) {
            this.writer.write(" ");
            this.writer.write(processingInstruction.getData());
        }
        this.writer.write("?>");
    }

    public void visitCommentPre(Comment comment) throws Exception {
        this.writer.write("<!--");
        this.writer.write(comment.getData());
        this.writer.write("-->");
    }

    public void visitTextPre(Text text) throws Exception {
        this.escapedWrite(this.writer, text.getData(), "<&", this.encoding);
    }

    public void visitCDATASectionPre(CDATASection cDATASection) throws Exception {
        this.writer.write("<![CDATA[");
        this.writer.write(cDATASection.getData());
        this.writer.write("]]>");
    }

    public void visitDocumentTypePre(DocumentType documentType) throws Exception {
        this.writer.write("<!DOCTYPE ");
        this.writer.write(documentType.getName());
        this.writer.write(">");
    }

    public void visitEntityReference(EntityReference entityReference) throws Exception {
        this.writer.write("&");
        this.writer.write(entityReference.getNodeName());
        this.writer.write(";");
        throw new TreeTraversal.ToNextSiblingTraversalException();
    }

    public void escapedWrite(Writer writer, String string, String string2) throws IOException {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if ('<' == c) {
                writer.write("&lt;");
                continue;
            }
            if ('>' == c) {
                writer.write("&gt;");
                continue;
            }
            if ('&' == c) {
                writer.write("&amp;");
                continue;
            }
            if ('\ud800' <= c && c < '\udc00') {
                int n;
                if (i + 1 >= string.length()) {
                    throw new RuntimeException("Invalid UTF-16 surrogate detected: " + Integer.toHexString(c) + " ?");
                }
                if (56320 > (n = string.charAt(++i)) || n >= 57344) {
                    throw new RuntimeException("Invalid UTF-16 surrogate detected: " + Integer.toHexString(c) + " " + Integer.toHexString(n));
                }
                n = (c - 55296 << 10) + n - 56320 + 65536;
                writer.write("&#x");
                writer.write(Integer.toHexString(n));
                writer.write(";");
                continue;
            }
            writer.write(c);
        }
    }

    public void escapedWrite(Writer writer, String string, String string2, String string3) throws IOException {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            int n = string2.indexOf(c);
            if (n >= 0) {
                writer.write("&#");
                writer.write(Integer.toString(c));
                writer.write(";");
                continue;
            }
            if ('\ud800' <= c && c < '\udc00') {
                int n2;
                if (i + 1 >= string.length()) {
                    throw new RuntimeException("Invalid UTF-16 surrogate detected: " + Integer.toHexString(c) + " ?");
                }
                if (56320 > (n2 = string.charAt(++i)) || n2 >= 57344) {
                    throw new RuntimeException("Invalid UTF-16 surrogate detected: " + Integer.toHexString(c) + " " + Integer.toHexString(n2));
                }
                n2 = (c - 55296 << 10) + n2 - 56320 + 65536;
                writer.write("&#x");
                writer.write(Integer.toHexString(n2));
                writer.write(";");
                continue;
            }
            writer.write(c);
        }
    }
}

