/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xss4j.domutil;

import com.ibm.ws.wssecurity.xss4j.domutil.UDDISchemaCentricCanonicalizer;
import com.ibm.ws.wssecurity.xss4j.dsig.Canonicalizer;
import com.ibm.ws.wssecurity.xss4j.dsig.Transform;
import com.ibm.ws.wssecurity.xss4j.dsig.TransformContext;
import com.ibm.ws.wssecurity.xss4j.dsig.TransformException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.w3c.dom.Node;

public final class UDDISchemaCentricC11r
extends Transform
implements Canonicalizer {
    public static final String JAVA_COPYRIGHT = "Licensed Materials - Property of IBM 5724-I63, 5724-H88, 5655-N02, 5733-W70          (C) COPYRIGHT International Business Machines Corp. 2005  All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String NS = "urn:uddi-org:schemaCentricC14N:2002-07-10";

    public String getURI() {
        return NS;
    }

    public void transform(TransformContext transformContext) throws TransformException {
        UDDISchemaCentricCanonicalizer uDDISchemaCentricCanonicalizer = new UDDISchemaCentricCanonicalizer();
        switch (transformContext.getType()) {
            case 0: 
            case 1: {
                byte[] byArray = uDDISchemaCentricCanonicalizer.serializeAll(transformContext.getDocument());
                transformContext.setContent(byArray, "UTF-8");
                break;
            }
            case 3: {
                byte[] byArray = uDDISchemaCentricCanonicalizer.serializeSubset(transformContext.getNode());
                transformContext.setContent(byArray, "UTF-8");
                break;
            }
            case 2: {
                byte[] byArray = uDDISchemaCentricCanonicalizer.serializeSubset(transformContext.getNodeset());
                transformContext.setContent(byArray, "UTF-8");
                break;
            }
            default: {
                throw new RuntimeException("Internal Error: Unknown type: " + transformContext.getType());
            }
        }
    }

    public void canonicalize(Node node, OutputStream outputStream) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
        UDDISchemaCentricCanonicalizer uDDISchemaCentricCanonicalizer = new UDDISchemaCentricCanonicalizer();
        uDDISchemaCentricCanonicalizer.serializeSubset(node, outputStreamWriter);
        ((Writer)outputStreamWriter).flush();
    }
}

