/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xss4j.domutil;

import com.ibm.ws.wssecurity.xss4j.domutil.InternalAttrNSImpl;
import com.ibm.ws.wssecurity.xss4j.domutil.XPathCanonicalizer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.apache.xerces.dom.AttrNSImpl;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UDDISchemaCentricCanonicalizer {
    public static final String JAVA_COPYRIGHT = "Licensed Materials - Property of IBM 5724-I63, 5724-H88, 5655-N02, 5733-W70          (C) COPYRIGHT International Business Machines Corp. 2005  All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final boolean DEBUG = false;
    int nsCount = 0;
    Hashtable nsMap = null;

    UDDISchemaCentricCanonicalizer() {
    }

    void serializeSubset(Node node, Writer writer) throws IOException {
        this.nsCount = 0;
        this.nsMap = new Hashtable();
        StringWriter stringWriter = new StringWriter();
        this.serializeSubset(XPathCanonicalizer.toNodeset(node, null, true), writer, stringWriter);
    }

    byte[] serializeAll(Document document) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF-8");
            this.serializeAll(document, outputStreamWriter);
            ((Writer)outputStreamWriter).close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException("Internal Error: " + iOException);
        }
    }

    byte[] serializeSubset(Node node) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF-8");
            this.serializeSubset(node, outputStreamWriter);
            ((Writer)outputStreamWriter).close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException("Internal Error: " + iOException);
        }
    }

    byte[] serializeSubset(NodeList nodeList) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF-8");
            this.nsCount = 0;
            this.nsMap = new Hashtable();
            StringWriter stringWriter = new StringWriter();
            this.serializeSubset(nodeList, outputStreamWriter, stringWriter);
            ((Writer)outputStreamWriter).close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException("Internal Error: " + iOException);
        }
    }

    private void serializeAll(Document document, Writer writer) throws IOException {
        this.nsCount = 0;
        this.nsMap = new Hashtable();
        StringWriter stringWriter = new StringWriter();
        this.serializeSubset(XPathCanonicalizer.toNodeset(document, null, true), writer, stringWriter);
    }

    private void serializeSubset(NodeList nodeList, Writer writer, Writer writer2) throws IOException {
        Vector<Object> vector = new Vector<Object>(nodeList.getLength());
        Node node = null;
        Hashtable<String, Attr> hashtable = new Hashtable<String, Attr>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() == 1) {
                node = nodeList.item(i);
            }
            if (node2.getNodeType() != 2) {
                if (hashtable.size() > 0) {
                    vector.addElement(new XPathCanonicalizer.Attributes(node, hashtable));
                    hashtable = new Hashtable();
                }
                vector.addElement(node2);
                this.setNamespacePrefix(node2);
                continue;
            }
            if (node.getNodeType() != 1) continue;
            Attr attr = (Attr)node2;
            if (attr instanceof AttrNSImpl) {
                this.casefoldUDDIKey(attr);
            }
            attr = !attr.getNodeName().startsWith("xmlns") ? this.SetAttributeNamespacePrefix(attr) : this.SetNamespaceAttributeNamespacePrefix(attr);
            if (hashtable.containsKey("xmlns") && ((Attr)hashtable.get("xmlns")).getNodeValue().length() == 0) continue;
            hashtable.put(attr.getNodeName(), attr);
        }
        Stack stack = new Stack();
        for (int i = 0; i < vector.size(); ++i) {
            this.serializeSubset(stack, vector, i, writer, writer2);
        }
    }

    private void setNamespacePrefix(Node node) {
        if (node.getNamespaceURI() != null) {
            String string = "";
            if (this.nsMap.containsKey(node.getNamespaceURI())) {
                string = (String)this.nsMap.get(node.getNamespaceURI());
            } else {
                StringBuffer stringBuffer = new StringBuffer("n");
                stringBuffer.append(this.nsCount);
                string = stringBuffer.toString();
                ++this.nsCount;
                this.nsMap.put(node.getNamespaceURI(), string);
            }
            node.setPrefix(string);
        }
    }

    private void casefoldUDDIKey(Attr attr) {
        try {
            AttrNSImpl attrNSImpl = (AttrNSImpl)attr;
            String string = attrNSImpl.getTypeName();
            String string2 = attrNSImpl.getTypeNamespace();
            if (string2 != null && string != null && string2.equals("urn:uddi-org:api_v3") && string.endsWith("Key")) {
                String string3 = attr.getNodeValue().toLowerCase();
                attr.setNodeValue(string3);
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    private Attr SetAttributeNamespacePrefix(Attr attr) {
        Object object = attr;
        String string = attr.getNodeName();
        if (attr.getNamespaceURI() != null && !string.startsWith("xml:")) {
            String string2 = (String)this.nsMap.get(attr.getNamespaceURI());
            if (string2 == null) {
                StringBuffer stringBuffer = new StringBuffer("ns");
                stringBuffer.append(this.nsCount);
                string2 = stringBuffer.toString();
                ++this.nsCount;
                this.nsMap.put(attr.getNamespaceURI(), string2);
            }
            int n = string.indexOf(":") + 1;
            String string3 = string2 + ":" + string.substring(n);
            InternalAttrNSImpl internalAttrNSImpl = new InternalAttrNSImpl((CoreDocumentImpl)attr.getOwnerDocument(), attr.getNamespaceURI(), string3);
            internalAttrNSImpl.setNodeValue(attr.getNodeValue());
            object = internalAttrNSImpl;
        }
        return object;
    }

    private Attr SetNamespaceAttributeNamespacePrefix(Attr attr) {
        Object object = attr;
        String string = attr.getNodeValue();
        if (!string.equals("http://www.w3.org/XML/1998/namespace")) {
            String string2 = attr.getNodeName();
            int n = string2.indexOf(":") + 1;
            String string3 = (String)this.nsMap.get(attr.getNodeValue());
            String string4 = "xmlns:" + string3;
            InternalAttrNSImpl internalAttrNSImpl = new InternalAttrNSImpl((CoreDocumentImpl)attr.getOwnerDocument(), attr.getNamespaceURI(), string4);
            internalAttrNSImpl.setNodeValue(attr.getNodeValue());
            object = internalAttrNSImpl;
        }
        return object;
    }

    private void serializeSubset(Stack stack, Vector vector, int n, Writer writer, Writer writer2) throws IOException {
        Object object;
        Object e2 = vector.elementAt(n);
        if (e2 == null) {
            return;
        }
        if (e2 instanceof XPathCanonicalizer.Attributes) {
            vector.setElementAt(null, n);
            ((XPathCanonicalizer.Attributes)e2).serialize(null, null, null, writer);
            if (writer2 != null) {
                ((XPathCanonicalizer.Attributes)e2).serialize(null, null, null, writer2);
            }
            return;
        }
        Node node = (Node)e2;
        short s = node.getNodeType();
        if (s == 9) {
            return;
        }
        if (s != 1) {
            String string;
            if (s == 3 && (string = node.getNodeValue()).trim().equals("")) {
                return;
            }
            XPathCanonicalizer.serializeNode(null, node, null, false, true, writer);
            if (writer2 != null) {
                XPathCanonicalizer.serializeNode(null, node, null, false, true, writer2);
            }
            return;
        }
        writer.write("<");
        writer.write(node.getNodeName());
        if (writer2 != null) {
            writer2.write("<");
            writer2.write(node.getNodeName());
        }
        XPathCanonicalizer.Attributes attributes2 = stack.empty() ? null : (XPathCanonicalizer.Attributes)stack.peek();
        XPathCanonicalizer.Attributes attributes3 = null;
        int n2 = n + 1;
        if (n2 >= vector.size() || vector.elementAt(n2) instanceof Node) {
            object = node.getParentNode();
            if (object.getNodeType() != 9 && attributes2 != null && attributes2.contains("xmlns")) {
                writer.write(" xmlns=\"\"");
                if (writer2 != null) {
                    writer2.write(" xmlns=\"\"");
                }
            }
        } else {
            attributes3 = (XPathCanonicalizer.Attributes)vector.elementAt(n2);
            if (!attributes3.contains("xmlns") && (object = node.getParentNode()).getNodeType() != 9 && attributes2 != null && attributes2.contains("xmlns")) {
                writer.write(" xmlns=\"\"");
                if (writer2 != null) {
                    writer2.write(" xmlns=\"\"");
                }
            }
            if ((object = node.getPrefix()) == null) {
                object = "";
            }
            attributes3.serialize(stack, null, (String)object, writer);
            if (writer2 != null) {
                attributes3.serialize(stack, null, (String)object, writer2);
            }
            vector.setElementAt(null, n2);
        }
        writer.write(">");
        if (writer2 != null) {
            writer2.write(">");
        }
        stack.push(attributes3);
        while (n2 < vector.size()) {
            if (vector.elementAt(n2) == null) {
                ++n2;
                continue;
            }
            if (!XPathCanonicalizer.isAncestor(vector.elementAt(n2), node)) break;
            this.serializeSubset(stack, vector, n2, writer, writer2);
            vector.setElementAt(null, n2++);
        }
        stack.pop();
        writer.write("</");
        writer.write(node.getNodeName());
        writer.write(">");
        if (writer2 != null) {
            writer2.write("</");
            writer2.write(node.getNodeName());
            writer2.write(">");
        }
    }
}

