/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xss4j.domutil;

import com.ibm.ws.wssecurity.xss4j.domutil.AttrProxy;
import com.ibm.ws.wssecurity.xss4j.domutil.C14nUtil;
import com.ibm.ws.wssecurity.xss4j.domutil.DOMUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.NodeIterator;

public class XPathCanonicalizer {
    static final boolean DEBUG = false;
    private static final String XML_NAMESPACE = "http://www.w3.org/XML/1998/namespace";
    private static final String XMLNS_NS = "http://www.w3.org/2000/xmlns/";

    public static byte[] serializeAll(Document document, boolean bl) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF-8");
            XPathCanonicalizer.serializeNode(null, document, null, bl, false, outputStreamWriter);
            ((Writer)outputStreamWriter).close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Internal Error: " + iOException);
        }
    }

    public static void serializeAll(Document document, boolean bl, Writer writer) throws IOException {
        XPathCanonicalizer.serializeNode(null, document, null, bl, false, writer);
    }

    public static byte[] serializeSubset(Node node, boolean bl) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF-8");
            XPathCanonicalizer.serializeNode(node, node, null, bl, true, outputStreamWriter);
            ((Writer)outputStreamWriter).close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Internal Error: " + iOException);
        }
    }

    public static void serializeSubset(Node node, boolean bl, Writer writer) throws IOException {
        XPathCanonicalizer.serializeNode(node, node, null, bl, true, writer);
    }

    public static NodeList toNodeset(Node node, Node node2, boolean bl) {
        NodeListImpl nodeListImpl = new NodeListImpl();
        XPathCanonicalizer.toNodeset_addNode(nodeListImpl, node, node2, bl);
        return nodeListImpl;
    }

    private static void toNodeset_addNode(NodeListImpl nodeListImpl, Node node, Node node2, boolean bl) {
        if (node == node2) {
            return;
        }
        switch (node.getNodeType()) {
            case 1: {
                nodeListImpl.add(node);
                Hashtable hashtable = XPathCanonicalizer.collectNamespaceNodesInAncestors(node, true);
                Object object = hashtable.elements();
                while (object.hasMoreElements()) {
                    Attr attr = (Attr)object.nextElement();
                    if (attr.getNodeName().equals("xmlns") && attr.getNodeValue().length() == 0) continue;
                    nodeListImpl.add(attr);
                }
                object = node.getAttributes();
                for (int i = 0; i < object.getLength(); ++i) {
                    Node node3 = object.item(i);
                    if (node3.getNodeName().equals("xmlns") || node3.getNodeName().startsWith("xmlns:")) continue;
                    nodeListImpl.add(node3);
                }
                for (Node node4 = node.getFirstChild(); node4 != null; node4 = node4.getNextSibling()) {
                    XPathCanonicalizer.toNodeset_addNode(nodeListImpl, node4, node2, bl);
                }
                break;
            }
            case 5: {
                for (Node node5 = node.getFirstChild(); node5 != null; node5 = node5.getNextSibling()) {
                    XPathCanonicalizer.toNodeset_addNode(nodeListImpl, node5, node2, bl);
                }
                break;
            }
            case 8: {
                if (!bl) break;
                nodeListImpl.add(node);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                nodeListImpl.add(node);
                break;
            }
            case 9: {
                for (Node node6 = node.getFirstChild(); node6 != null; node6 = node6.getNextSibling()) {
                    XPathCanonicalizer.toNodeset_addNode(nodeListImpl, node6, node2, bl);
                }
                break;
            }
            case 10: {
                break;
            }
            case 6: 
            case 11: 
            case 12: {
                throw new RuntimeException("Internal Error: Invalid node type: " + node.getNodeType());
            }
        }
    }

    public static byte[] serializeSubset(NodeIterator nodeIterator, boolean bl) {
        Node node;
        NodeListImpl nodeListImpl = new NodeListImpl();
        while ((node = nodeIterator.nextNode()) != null) {
            nodeListImpl.add(node);
        }
        return XPathCanonicalizer.serializeSubset(nodeListImpl, bl);
    }

    public static void serializeSubset(NodeIterator nodeIterator, boolean bl, Writer writer) throws IOException {
        Node node;
        NodeListImpl nodeListImpl = new NodeListImpl();
        while ((node = nodeIterator.nextNode()) != null) {
            nodeListImpl.add(node);
        }
        XPathCanonicalizer.serializeSubset(nodeListImpl, bl, writer);
    }

    public static byte[] serializeSubset(NodeList nodeList, boolean bl) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF-8");
            XPathCanonicalizer.serializeSubset(nodeList, bl, (Writer)outputStreamWriter);
            ((Writer)outputStreamWriter).close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Internal Error: " + iOException);
        }
    }

    private static boolean inNodeList(Node node, NodeList nodeList) {
        if (node == null) {
            return false;
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i) != node) continue;
            return true;
        }
        return false;
    }

    public static void serializeSubset(NodeList nodeList, boolean bl, Writer writer) throws IOException {
        Vector<Object> vector = new Vector<Object>(nodeList.getLength());
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node;
            Object object;
            Hashtable<String, Node> hashtable;
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 2) {
                vector.addElement(node2);
                if (node2.getNodeType() != 1) continue;
                hashtable = null;
                if (!XPathCanonicalizer.inNodeList(node2.getParentNode(), nodeList)) {
                    hashtable = XPathCanonicalizer.collectXMLPrefixAttributesInAncestors(node2);
                }
                if (i + 1 < nodeList.getLength() && (object = nodeList.item(i + 1)).getNodeType() == 2 && ((Attr)object).getOwnerElement() == node2) {
                    if (hashtable == null) {
                        hashtable = new Hashtable<String, Node>();
                    }
                    ++i;
                    while (i < nodeList.getLength() && (node = nodeList.item(i)).getNodeType() == 2 && node2 == ((Attr)node).getOwnerElement()) {
                        hashtable.put(node.getNodeName(), node);
                        ++i;
                    }
                    if (hashtable.containsKey("xmlns") && ((Attr)hashtable.get("xmlns")).getNodeValue().length() == 0) {
                        hashtable.remove("xmlns");
                    }
                    --i;
                    vector.addElement(new Attributes(node2, hashtable));
                    continue;
                }
                if (hashtable == null) continue;
                vector.addElement(new Attributes(node2, hashtable));
                continue;
            }
            hashtable = ((Attr)node2).getOwnerElement();
            object = new Hashtable<String, Node>();
            while (i < nodeList.getLength() && (node = nodeList.item(i)).getNodeType() == 2 && hashtable == ((Attr)node).getOwnerElement()) {
                ((Hashtable)object).put(node.getNodeName(), node);
                ++i;
            }
            vector.addElement(new Attributes((Node)((Object)hashtable), (Hashtable)object));
            --i;
        }
        Stack stack = new Stack();
        for (int i = 0; i < vector.size(); ++i) {
            XPathCanonicalizer.serializeSubset(stack, vector, i, bl, writer);
        }
    }

    private static void serializeSubset(Stack stack, Vector vector, int n, boolean bl, Writer writer) throws IOException {
        Node node;
        Object e2 = vector.elementAt(n);
        if (e2 == null) {
            return;
        }
        if (e2 instanceof Attributes) {
            Attributes attributes2 = stack.empty() ? null : (Attributes)stack.peek();
            ((Attributes)e2).serialize(attributes2, writer);
            vector.setElementAt(null, n);
            return;
        }
        Node node2 = (Node)e2;
        short s = node2.getNodeType();
        if (s == 9) {
            return;
        }
        if (s != 1) {
            XPathCanonicalizer.serializeNode(null, node2, null, bl, true, writer);
            return;
        }
        writer.write("<");
        writer.write(node2.getNodeName());
        Attributes attributes3 = stack.empty() ? null : (Attributes)stack.peek();
        Attributes attributes4 = null;
        int n2 = n + 1;
        if (n2 >= vector.size() || vector.elementAt(n2) instanceof Node) {
            node = node2.getParentNode();
            if (node.getNodeType() != 9 && attributes3 != null && attributes3.contains("xmlns")) {
                writer.write(" xmlns=\"\"");
            }
        } else {
            attributes4 = (Attributes)vector.elementAt(n2);
            if (!attributes4.contains("xmlns") && (node = node2.getParentNode()).getNodeType() != 9 && attributes3 != null && attributes3.contains("xmlns")) {
                writer.write(" xmlns=\"\"");
            }
            attributes4.serialize(attributes3, writer);
            vector.setElementAt(null, n2);
        }
        writer.write(">");
        stack.push(attributes4);
        while (n2 < vector.size()) {
            if (vector.elementAt(n2) == null) {
                ++n2;
                continue;
            }
            if (!XPathCanonicalizer.isAncestor(vector.elementAt(n2), node2)) break;
            XPathCanonicalizer.serializeSubset(stack, vector, n2, bl, writer);
            vector.setElementAt(null, n2++);
        }
        stack.pop();
        writer.write("</");
        writer.write(node2.getNodeName());
        writer.write(">");
    }

    static boolean isAncestor(Object object, Node node) {
        Node node2 = object instanceof Attributes ? ((Attributes)object).parent : (Node)object;
        while (node2 != node) {
            if ((node2 = node2.getNodeType() == 2 ? ((Attr)node2).getOwnerElement() : node2.getParentNode()) != null) continue;
            return false;
        }
        return true;
    }

    static void serializeNode(Node node, Node node2, Node node3, boolean bl, boolean bl2, Writer writer) throws IOException {
        XPathCanonicalizer.serializeNode(node, null, node2, node3, bl, bl2, writer);
    }

    private static void serializeNode(Node node, Stack stack, Node node2, Node node3, boolean bl, boolean bl2, Writer writer) throws IOException {
        if (node3 == node2) {
            return;
        }
        switch (node2.getNodeType()) {
            case 1: {
                if (stack == null) {
                    stack = new Stack();
                }
                writer.write("<");
                writer.write(node2.getNodeName());
                XPathCanonicalizer.serializeAttributes(node, stack, (Element)node2, bl2, writer);
                writer.write(">");
                for (Node node4 = node2.getFirstChild(); node4 != null; node4 = node4.getNextSibling()) {
                    XPathCanonicalizer.serializeNode(node, stack, node4, node3, bl, bl2, writer);
                }
                stack.pop();
                writer.write("</");
                writer.write(node2.getNodeName());
                writer.write(">");
                break;
            }
            case 3: 
            case 4: {
                C14nUtil.serializeText(node2.getNodeValue(), writer);
                break;
            }
            case 5: 
            case 9: {
                for (Node node5 = node2.getFirstChild(); node5 != null; node5 = node5.getNextSibling()) {
                    XPathCanonicalizer.serializeNode(node, stack, node5, node3, bl, bl2, writer);
                }
                break;
            }
            case 7: {
                C14nUtil.serializePI(node2, writer);
                break;
            }
            case 8: {
                if (!bl) break;
                C14nUtil.serializeComment(node2, writer);
                break;
            }
            case 10: {
                break;
            }
            case 2: {
                String string = node2.getNodeName();
                C14nUtil.serializeAttribute(node2, writer, string.equals("xmlns") || string.startsWith("xmlns:"));
                break;
            }
            case 6: 
            case 11: 
            case 12: {
                throw new RuntimeException("Internal Error: Invalid Node Type: " + node2.getNodeType());
            }
        }
    }

    private static boolean isTopElement(Node node, Element element) {
        if (node == element) {
            return true;
        }
        Node node2 = element.getParentNode();
        if (node2 != null) {
            switch (node2.getNodeType()) {
                case 9: {
                    return true;
                }
                case 1: {
                    return false;
                }
                case 5: {
                    node2 = node2.getParentNode();
                }
            }
            throw new RuntimeException("Internal Error: Unexpected node type: " + node2.getNodeType());
        }
        return true;
    }

    private static void serializeAttributes(Node node, Stack stack, Element element, boolean bl, Writer writer) throws IOException {
        Object object;
        String[] stringArray;
        Hashtable hashtable;
        Hashtable hashtable2 = XPathCanonicalizer.collectNamespaceNodesInAncestors(element, false);
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            hashtable2.put(namedNodeMap.item(i).getNodeName(), namedNodeMap.item(i));
        }
        if (bl && (hashtable = XPathCanonicalizer.collectXMLPrefixAttributesInAncestors(element)) != null) {
            stringArray = hashtable.elements();
            while (stringArray.hasMoreElements()) {
                object = (Attr)stringArray.nextElement();
                hashtable2.put(object.getNodeName(), object);
            }
        }
        Hashtable hashtable3 = stack.isEmpty() ? null : (Hashtable)stack.peek();
        stack.push(hashtable2);
        n = hashtable2.size();
        stringArray = new String[n];
        object = new int[n];
        Attr[] attrArray = new Attr[n];
        int n2 = 0;
        Enumeration enumeration = hashtable2.elements();
        while (enumeration.hasMoreElements()) {
            Attr attr = (Attr)enumeration.nextElement();
            object[n2] = n2;
            attrArray[n2] = attr;
            stringArray[n2] = XPathCanonicalizer.createSortedString(attr, element);
            ++n2;
        }
        C14nUtil.heapSort((int[])object, stringArray, n);
        for (int i = 0; i < n; ++i) {
            Attr attr;
            Attr attr2 = attrArray[object[i]];
            String string = attr2.getNodeName();
            boolean bl2 = false;
            if (string.equals("xmlns:xml")) continue;
            if (string.equals("xmlns") && attr2.getNodeValue().length() == 0) {
                if (XPathCanonicalizer.isTopElement(node, element)) continue;
                boolean bl3 = false;
                for (int j = stack.size() - 1; j >= 0; --j) {
                    Hashtable hashtable4 = (Hashtable)stack.elementAt(j);
                    Attr attr3 = (Attr)hashtable4.get("xmlns");
                    if (attr3 == null || attr3.getNodeValue().length() <= 0) continue;
                    bl3 = true;
                    break;
                }
                if (!bl3) continue;
            }
            if (string.equals("xmlns") || string.startsWith("xmlns:")) {
                Attr attr4;
                bl2 = true;
                if (hashtable3 != null && (attr4 = (Attr)hashtable3.get(string)) != null && attr4.getNodeValue().equals(attr2.getNodeValue())) {
                    continue;
                }
            } else if (string.startsWith("xml:") && hashtable3 != null && (attr = (Attr)hashtable3.get(string)) != null && attr.getNodeValue().equals(attr2.getNodeValue())) continue;
            C14nUtil.serializeAttribute(attr2, writer, bl2);
        }
    }

    public static Hashtable collectNamespaceNodesInAncestors(Node node, boolean bl) {
        Object object;
        Node node2 = node;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        Document document = node.getOwnerDocument();
        if (node2.getNodeType() == 1 && ((Element)node2).getAttributeNode("xmlns:xml") == null) {
            if (bl) {
                hashtable.put("xmlns:xml", (Object)new AttrProxy(node, document, XMLNS_NS, "xmlns:xml", XML_NAMESPACE));
            } else {
                object = document.createAttributeNS(XMLNS_NS, "xmlns:xml");
                object.setNodeValue(XML_NAMESPACE);
                hashtable.put("xmlns:xml", object);
            }
        }
        do {
            if ((object = node2.getAttributes()) == null) continue;
            int n = object.getLength();
            for (int i = 0; i < n; ++i) {
                Object object2;
                Attr attr = (Attr)object.item(i);
                String string = attr.getNodeName();
                if (!string.equals("xmlns") && !string.startsWith("xmlns:") || hashtable.containsKey(string)) continue;
                if (node2 == node) {
                    hashtable.put(string, attr);
                    continue;
                }
                if (bl) {
                    object2 = new AttrProxy(node, document, XMLNS_NS, string, attr.getNodeValue());
                    hashtable.put(string, object2);
                    continue;
                }
                object2 = document.createAttributeNS(XMLNS_NS, string);
                object2.setNodeValue(attr.getNodeValue());
                hashtable.put(string, object2);
            }
        } while ((node2 = node2.getParentNode()) != null);
        return hashtable;
    }

    public static void copyNamespaceNodesInAncestors(Element element) {
        Node node = element;
        while ((node = node.getParentNode()) != null) {
            NamedNodeMap namedNodeMap = node.getAttributes();
            if (namedNodeMap == null) continue;
            int n = namedNodeMap.getLength();
            for (int i = 0; i < n; ++i) {
                Attr attr = (Attr)namedNodeMap.item(i);
                String string = attr.getNodeName();
                if (!string.equals("xmlns") && !string.startsWith("xmlns:") || element.hasAttribute(string)) continue;
                element.setAttributeNS(XMLNS_NS, string, attr.getNodeValue());
            }
        }
    }

    public static void copyNamespaceNodesInAncestorsRecursively(Node node) {
        if (node.getNodeType() == 1) {
            XPathCanonicalizer.copyNamespaceNodesInAncestors((Element)node);
        }
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            switch (node2.getNodeType()) {
                case 1: 
                case 5: {
                    XPathCanonicalizer.copyNamespaceNodesInAncestorsRecursively(node2);
                }
            }
        }
    }

    public static Hashtable collectXMLPrefixAttributesInAncestors(Node node) {
        Object object;
        int n;
        Object object2;
        Hashtable<String, Object> hashtable = null;
        for (object2 = node.getParentNode(); object2 != null; object2 = object2.getParentNode()) {
            NamedNodeMap namedNodeMap = object2.getAttributes();
            if (namedNodeMap == null) continue;
            n = namedNodeMap.getLength();
            for (int i = 0; i < n; ++i) {
                object = (Attr)namedNodeMap.item(i);
                String string = object.getNodeName();
                if (!string.startsWith("xml:") || hashtable != null && hashtable.containsKey(string)) continue;
                if (hashtable == null) {
                    hashtable = new Hashtable<String, Object>();
                }
                hashtable.put(string, object);
            }
        }
        if (hashtable != null && (object2 = node.getAttributes()) != null) {
            int n2 = object2.getLength();
            for (n = 0; n < n2; ++n) {
                Attr attr = (Attr)object2.item(n);
                object = attr.getNodeName();
                if (!((String)object).startsWith("xml:") || !hashtable.containsKey(object)) continue;
                hashtable.remove(object);
            }
        }
        return hashtable;
    }

    private static String createSortedString(Attr attr, Node node) {
        String string;
        if (attr.getNodeType() == 2) {
            String string2 = attr.getNodeName();
            if (string2.equals("xmlns")) {
                return "\u0000";
            }
            int n = string2.indexOf(58);
            if (n <= 0) {
                return "\u0001" + string2;
            }
            String string3 = string2.substring(0, n);
            if (string3.equals("xmlns")) {
                return "\u0000" + string2.substring(n + 1);
            }
            String string4 = DOMUtil.getNamespaceForPrefix(string3, node);
            string = string4 == null || string4.length() == 0 ? "\u0001" + string2 : string4 + "\u0001" + string2.substring(n + 1);
        } else {
            throw new IllegalArgumentException("Requires an Attr node.");
        }
        return string;
    }

    public static class NodeListImpl
    implements NodeList {
        Vector vector = null;

        public NodeListImpl() {
        }

        public NodeListImpl(int n) {
            this.vector = new Vector(n);
        }

        public void add(Node node) {
            if (this.vector == null) {
                this.vector = new Vector();
            }
            this.vector.addElement(node);
        }

        public Node item(int n) {
            return this.vector == null || n < 0 || this.vector.size() <= n ? null : (Node)this.vector.elementAt(n);
        }

        public int getLength() {
            return this.vector == null ? 0 : this.vector.size();
        }
    }

    static class Attributes {
        Node parent;
        Hashtable attributes;
        Hashtable rendered;

        Attributes(Node node, Hashtable hashtable) {
            this.parent = node;
            this.attributes = hashtable;
            if (this.attributes == null) {
                this.attributes = new Hashtable();
            }
            this.rendered = null;
        }

        boolean contains(String string) {
            return this.attributes.containsKey(string);
        }

        private boolean rendered(String string) {
            if (this.rendered == null) {
                return false;
            }
            return this.rendered.containsKey(string);
        }

        private void setRendered(String string, Attr attr) {
            if (this.rendered == null) {
                this.rendered = new Hashtable();
            }
            this.rendered.put(string, attr);
        }

        void serialize(Attributes attributes2, Writer writer) throws IOException {
            Attr attr;
            int n;
            int n2 = this.attributes.size();
            String[] stringArray = new String[n2];
            int[] nArray = new int[n2];
            Attr[] attrArray = new Attr[n2];
            Enumeration enumeration = this.attributes.elements();
            for (n = 0; n < n2; ++n) {
                attr = (Attr)enumeration.nextElement();
                nArray[n] = n;
                attrArray[n] = attr;
                stringArray[n] = XPathCanonicalizer.createSortedString(attr, this.parent);
            }
            C14nUtil.heapSort(nArray, stringArray, n2);
            for (n = 0; n < n2; ++n) {
                attr = attrArray[nArray[n]];
                String string = attr.getNodeName();
                boolean bl = false;
                if (string.equals("xmlns:xml")) continue;
                if (string.equals("xmlns") || string.startsWith("xmlns:")) {
                    bl = true;
                    if (attributes2 != null && attributes2.contains(string) && attributes2.get(string).getNodeValue().equals(attr.getNodeValue())) {
                        continue;
                    }
                } else if (string.startsWith("xml:")) {
                    // empty if block
                }
                C14nUtil.serializeAttribute(attr, writer, bl);
            }
        }

        Enumeration enumeration() {
            return this.attributes.elements();
        }

        Attr get(String string) {
            return (Attr)this.attributes.get(string);
        }

        private void remove(String string) {
            Object v = this.attributes.remove(string);
            if (v == null) {
                // empty if block
            }
        }

        private boolean usePrefix(String string) {
            if (string.length() == 0) {
                return false;
            }
            Enumeration enumeration = this.enumeration();
            while (enumeration.hasMoreElements()) {
                Attr attr = (Attr)enumeration.nextElement();
                String string2 = attr.getPrefix();
                if (string2 == null || !string2.equals(string)) continue;
                return true;
            }
            return false;
        }

        private static boolean renderedInAncestors(Stack stack, String string, String string2) {
            if (stack == null || stack.isEmpty()) {
                return false;
            }
            for (int i = stack.size() - 1; i >= 0; --i) {
                Attributes attributes2 = (Attributes)stack.elementAt(i);
                if (!attributes2.rendered(string) || !attributes2.get(string).getNodeValue().equals(string2)) continue;
                return true;
            }
            return false;
        }

        private boolean utilizedInNearest(Stack stack, Attr attr) {
            if (stack == null || stack.isEmpty()) {
                return false;
            }
            String string = attr.getName().equals("xmlns") ? "" : attr.getLocalName();
            for (int i = stack.size() - 1; i >= 0; --i) {
                Attributes attributes2 = (Attributes)stack.elementAt(i);
                if (attributes2.parent == null) continue;
                String string2 = attributes2.parent.getPrefix();
                if (string2 == null) {
                    string2 = "";
                }
                if (!string.equals(string2) && !attributes2.usePrefix(string)) continue;
                return attributes2.contains(attr.getNodeName()) && attributes2.get(attr.getNodeName()).getNodeValue().equals(attr.getNodeValue());
            }
            return false;
        }

        void serialize(Stack stack, Hashtable hashtable, String string, Writer writer) throws IOException {
            Attr attr;
            int n;
            int n2 = this.attributes.size();
            String[] stringArray = new String[n2];
            int[] nArray = new int[n2];
            Attr[] attrArray = new Attr[n2];
            Enumeration enumeration = this.attributes.elements();
            for (n = 0; n < n2; ++n) {
                attr = (Attr)enumeration.nextElement();
                nArray[n] = n;
                attrArray[n] = attr;
                stringArray[n] = XPathCanonicalizer.createSortedString(attr, this.parent);
            }
            C14nUtil.heapSort(nArray, stringArray, n2);
            for (n = 0; n < n2; ++n) {
                attr = attrArray[nArray[n]];
                String string2 = attr.getNodeName();
                boolean bl = false;
                if (string2.equals("xmlns:xml")) continue;
                if (string2.equals("xmlns") || string2.startsWith("xmlns:")) {
                    String string3 = string2.equals("xmlns") ? "" : string2.substring(6);
                    bl = true;
                    if (hashtable != null && hashtable.get(string3) != null) {
                        Attributes attributes2 = null;
                        if (stack != null && !stack.isEmpty()) {
                            attributes2 = (Attributes)stack.elementAt(stack.size() - 1);
                        }
                        if (attributes2 != null && attributes2.contains(string2) && attributes2.get(string2).getNodeValue().equals(attr.getNodeValue())) {
                            continue;
                        }
                    } else if (string == null || Attributes.renderedInAncestors(stack, string2, attr.getNodeValue()) && this.utilizedInNearest(stack, attr) || string != null && !string.equals(string3) && !this.usePrefix(string3)) continue;
                    this.setRendered(string2, attr);
                }
                C14nUtil.serializeAttribute(attr, writer, bl);
            }
        }

        public String toString() {
            return "Attributes[#=" + this.attributes.size() + "]";
        }
    }
}

