/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xss4j.dsig;

import com.ibm.ws.wssecurity.xss4j.dsig.KeyInfo;
import com.ibm.ws.wssecurity.xss4j.dsig.SignatureStructureException;
import com.ibm.ws.wssecurity.xss4j.dsig.XSignatureException;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertStore;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXParameters;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.w3c.dom.Element;

public class CertUtil {
    static final boolean DEBUG = false;
    public static final int CHAINS_ANY = 100;
    public static final int CHAINS_ALL = 101;

    public static Key verify(Element element, int n, PKIXParameters pKIXParameters) throws XSignatureException {
        return CertUtil.verifyAndGetCert(element, n, pKIXParameters).getPublicKey();
    }

    public static X509Certificate verifyAndGetCert(Element element, int n, PKIXParameters pKIXParameters) throws XSignatureException {
        Key key;
        KeyInfo.X509Data[] x509DataArray;
        Object object;
        X509Certificate x509Certificate = null;
        byte[] byArray = null;
        try {
            object = CertUtil.getKeyInfo(element);
            x509DataArray = ((KeyInfo)object).getX509Data();
            if (x509DataArray == null || x509DataArray.length == 0) {
                throw new SignatureStructureException("No X509Data elements.");
            }
            key = ((KeyInfo)object).getKeyValue();
            if (key != null) {
                byArray = key.getEncoded();
            }
        }
        catch (SignatureStructureException signatureStructureException) {
            throw new XSignatureException(signatureStructureException);
        }
        try {
            object = CertificateFactory.getInstance("X.509", "IBMCertPath");
            CertPathValidator certPathValidator = CertPathValidator.getInstance("PKIX");
            CertPathValidatorException certPathValidatorException = null;
            for (int i = 0; i < x509DataArray.length; ++i) {
                List list = CertUtil.orderCertificates(x509DataArray[i].getCertificates());
                if (list.size() == 0) {
                    if (n == 100) continue;
                    throw new CertPathValidatorException("Incomplete certificate chain.");
                }
                x509Certificate = (X509Certificate)list.get(0);
                PublicKey publicKey = x509Certificate.getPublicKey();
                if (byArray == null) {
                    key = publicKey;
                    byArray = publicKey.getEncoded();
                } else if (!MessageDigest.isEqual(byArray, publicKey.getEncoded())) {
                    throw new CertPathValidatorException("A certificate has different key.");
                }
                CertPath certPath = ((CertificateFactory)object).generateCertPath(list);
                if (n == 101) {
                    certPathValidator.validate(certPath, pKIXParameters);
                    continue;
                }
                try {
                    certPathValidator.validate(certPath, pKIXParameters);
                    return x509Certificate;
                }
                catch (CertPathValidatorException certPathValidatorException2) {
                    certPathValidatorException = certPathValidatorException2;
                }
            }
            if (n == 101) {
                return x509Certificate;
            }
            if (certPathValidatorException == null) {
                throw new CertPathValidatorException("No valid certificate chain.");
            }
            throw new CertPathValidatorException("No valid certificate chain: Last exception: " + certPathValidatorException);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new XSignatureException(generalSecurityException);
        }
    }

    public static X509DataUtil[] getX509Data(Element element) throws XSignatureException {
        try {
            KeyInfo keyInfo = CertUtil.getKeyInfo(element);
            KeyInfo.X509Data[] x509DataArray = keyInfo.getX509Data();
            if (x509DataArray == null || x509DataArray.length == 0) {
                throw new SignatureStructureException("No X509Data elements.");
            }
            Key key = keyInfo.getKeyValue();
            X509DataUtil[] x509DataUtilArray = new X509DataUtil[x509DataArray.length];
            for (int i = 0; i < x509DataArray.length; ++i) {
                x509DataUtilArray[i] = new X509DataUtil(x509DataArray[i], key);
            }
            return x509DataUtilArray;
        }
        catch (SignatureStructureException signatureStructureException) {
            throw new XSignatureException(signatureStructureException);
        }
    }

    public static List orderCertificates(X509Certificate[] x509CertificateArray) throws CertPathValidatorException {
        Object object;
        int n;
        boolean bl;
        LinkedList<Object> linkedList = new LinkedList<Object>();
        if (x509CertificateArray == null || x509CertificateArray.length == 0) {
            return linkedList;
        }
        if (x509CertificateArray.length == 1) {
            linkedList.add(x509CertificateArray[0]);
            return linkedList;
        }
        X509Certificate[] x509CertificateArray2 = new X509Certificate[x509CertificateArray.length];
        System.arraycopy(x509CertificateArray, 0, x509CertificateArray2, 0, x509CertificateArray.length);
        for (int i = 0; i < x509CertificateArray2.length; ++i) {
            Principal principal = x509CertificateArray2[i].getSubjectDN();
            bl = false;
            for (n = 0; n < x509CertificateArray.length; ++n) {
                if (n == i || !((Object)principal).equals(object = x509CertificateArray2[n].getIssuerDN())) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            linkedList.add(x509CertificateArray2[i]);
            x509CertificateArray2[i] = null;
            break;
        }
        if (linkedList.size() == 0) {
            return linkedList;
        }
        Principal principal = ((X509Certificate)linkedList.get(0)).getIssuerDN();
        int n2 = x509CertificateArray2.length - 1;
        while (n2 > 0) {
            bl = false;
            for (n = 0; n < x509CertificateArray2.length; ++n) {
                object = x509CertificateArray2[n];
                if (object == null || !((Object)((X509Certificate)object).getSubjectDN()).equals(principal)) continue;
                bl = true;
                linkedList.add(object);
                x509CertificateArray2[n] = null;
                --n2;
                principal = ((X509Certificate)object).getIssuerDN();
                break;
            }
            if (bl) continue;
            throw new CertPathValidatorException("The chain is incomplete: No certificate of an issuer `" + principal + "'");
        }
        return linkedList;
    }

    private static KeyInfo getKeyInfo(Element element) throws SignatureStructureException, XSignatureException {
        Element element2 = KeyInfo.searchForKeyInfo(element);
        if (element2 == null) {
            throw new SignatureStructureException("No KeyInfo element.");
        }
        return new KeyInfo(element2);
    }

    public static class X509DataUtil {
        KeyInfo.X509Data x5data;
        CertStore docStore = null;
        Key publicKey;

        public X509DataUtil(KeyInfo.X509Data x509Data, Key key) {
            this.x5data = x509Data;
            this.publicKey = key;
        }

        private CertStore createCertStore() throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
            Vector<X509Certificate> vector = new Vector<X509Certificate>();
            X509Certificate[] x509CertificateArray = this.x5data.getCertificates();
            if (x509CertificateArray != null) {
                for (int i = 0; i < x509CertificateArray.length; ++i) {
                    vector.addElement(x509CertificateArray[i]);
                }
            }
            return CertStore.getInstance("Collection", new CollectionCertStoreParameters(vector));
        }

        public Key validate(PKIXBuilderParameters pKIXBuilderParameters) throws XSignatureException {
            return this.validateAndGetCert(pKIXBuilderParameters).getPublicKey();
        }

        public X509Certificate validateAndGetCert(PKIXBuilderParameters pKIXBuilderParameters) throws XSignatureException {
            CertPath certPath;
            Object object;
            List<CertStore> list = pKIXBuilderParameters.getCertStores();
            ArrayList<CertStore> arrayList = new ArrayList<CertStore>((list == null ? 0 : list.size()) + 1);
            for (int i = 0; i < list.size(); ++i) {
                arrayList.add(list.get(i));
            }
            try {
                arrayList.add(this.createCertStore());
                pKIXBuilderParameters.setCertStores(arrayList);
                object = CertPathBuilder.getInstance("PKIX");
                CertPathValidator certPathValidator = CertPathValidator.getInstance("PKIX");
                certPath = ((CertPathBuilder)object).build(pKIXBuilderParameters).getCertPath();
                certPathValidator.validate(certPath, pKIXBuilderParameters);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                pKIXBuilderParameters.setCertStores(list);
                throw new XSignatureException(invalidAlgorithmParameterException);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                pKIXBuilderParameters.setCertStores(list);
                throw new XSignatureException(noSuchAlgorithmException);
            }
            catch (CertPathBuilderException certPathBuilderException) {
                pKIXBuilderParameters.setCertStores(list);
                throw new XSignatureException(certPathBuilderException);
            }
            catch (CertPathValidatorException certPathValidatorException) {
                pKIXBuilderParameters.setCertStores(list);
                throw new XSignatureException(certPathValidatorException);
            }
            object = certPath.getCertificates();
            return object.isEmpty() ? null : (X509Certificate)object.get(0);
        }

        public X509CertSelector createSelector() throws IOException {
            X509Certificate[] x509CertificateArray;
            Object[] objectArray;
            Object[] objectArray2;
            X509CertSelector x509CertSelector = new X509CertSelector();
            String[] stringArray = this.x5data.getIssuerNames();
            if (stringArray != null && stringArray.length > 0) {
                objectArray2 = this.x5data.getSerialNumbers();
                x509CertSelector.setIssuer(stringArray[0]);
                x509CertSelector.setSerialNumber((BigInteger)objectArray2[0]);
            }
            if ((objectArray2 = this.x5data.getSubjectNames()) != null && objectArray2.length > 0) {
                x509CertSelector.setSubject((String)objectArray2[0]);
            } else {
                objectArray = this.x5data.getCertificates();
                if (objectArray != null && objectArray.length > 0) {
                    x509CertSelector.setSubject(((X509Certificate)objectArray[0]).getSubjectDN().getName());
                }
            }
            objectArray = this.x5data.getSKIs();
            if (objectArray != null && objectArray.length > 0) {
                x509CertSelector.setSubjectKeyIdentifier((byte[])objectArray[0]);
            }
            if ((x509CertificateArray = this.x5data.getCertificates()) != null && x509CertificateArray.length == 1) {
                x509CertSelector.setCertificate(x509CertificateArray[0]);
            }
            if (this.publicKey != null) {
                x509CertSelector.setSubjectPublicKey(this.publicKey.getEncoded());
            }
            return x509CertSelector;
        }
    }
}

