/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xss4j.dsig;

import com.ibm.ws.wssecurity.xss4j.domutil.DOMUtil;
import com.ibm.ws.wssecurity.xss4j.dsig.ReferenceProcessor;
import com.ibm.ws.wssecurity.xss4j.dsig.ReferenceValidity;
import com.ibm.ws.wssecurity.xss4j.dsig.SignatureContext;
import com.ibm.ws.wssecurity.xss4j.dsig.SignatureStructureException;
import com.ibm.ws.wssecurity.xss4j.dsig.TransformException;
import com.ibm.ws.wssecurity.xss4j.dsig.Validity;
import com.ibm.ws.wssecurity.xss4j.dsig.ValidityDOM;
import com.ibm.ws.wssecurity.xss4j.dsig.XSignature;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class ManifestProcessor {
    private ManifestProcessor() {
    }

    static Element digest(SignatureContext signatureContext) throws SignatureStructureException, TransformException, IOException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, NoSuchProviderException {
        int n = 0;
        Element element = DOMUtil.getFirstChildElement(signatureContext.getOwnerElement());
        while (element != null) {
            if (!XSignature.isDsigElement(element, "Reference")) {
                throw new SignatureStructureException("A Reference element is expected: " + element.getNodeName());
            }
            ReferenceProcessor.substDigest(signatureContext, element, n++);
            element = DOMUtil.getNextElement(element);
        }
        return signatureContext.getOwnerElement();
    }

    static Validity verify(SignatureContext signatureContext) {
        ValidityDOM validityDOM = new ValidityDOM();
        int n = 0;
        try {
            block6: for (Node node = signatureContext.getOwnerElement().getFirstChild(); node != null; node = node.getNextSibling()) {
                switch (node.getNodeType()) {
                    case 3: 
                    case 7: 
                    case 8: {
                        continue block6;
                    }
                    case 1: {
                        Element element = (Element)node;
                        if (XSignature.isDsigElement(element, "Reference")) {
                            ReferenceValidity referenceValidity = ReferenceProcessor.verify(signatureContext, element, n++);
                            validityDOM.addReferenceValidity(referenceValidity);
                            continue block6;
                        }
                    }
                    default: {
                        throw new SignatureStructureException("Invalid node in the Manifest element:" + node.getNodeName());
                    }
                }
            }
        }
        catch (SignatureStructureException signatureStructureException) {
            validityDOM.setSignedInfoMessage(signatureStructureException.getMessage());
        }
        validityDOM.setSignedInfoValidity(true);
        validityDOM.setSignedInfoMessage("N/A");
        validityDOM.setCoreValidity();
        return validityDOM;
    }
}

