/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xss4j.dsig;

import com.ibm.ws.wssecurity.xss4j.domutil.DOMUtil;
import com.ibm.ws.wssecurity.xss4j.domutil.IndentConfig;
import com.ibm.ws.wssecurity.xss4j.dsig.KeyInfoGenerator;
import com.ibm.ws.wssecurity.xss4j.dsig.ReferenceProcessor;
import com.ibm.ws.wssecurity.xss4j.dsig.SignatureContext;
import com.ibm.ws.wssecurity.xss4j.dsig.SignatureStructureException;
import com.ibm.ws.wssecurity.xss4j.dsig.TransformException;
import com.ibm.ws.wssecurity.xss4j.dsig.XSignature;
import com.ibm.ws.wssecurity.xss4j.dsig.util.Base64;
import com.ibm.ws.wssecurity.xss4j.dsig.util.SimpleKey;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class ProcessKey {
    static final boolean DEBUG = false;

    private ProcessKey() {
    }

    private static String encodeBigInteger(BigInteger bigInteger) {
        byte[] byArray = bigInteger.toByteArray();
        int n = 0;
        while (byArray[n] == 0) {
            ++n;
        }
        return Base64.encode(byArray, n, byArray.length - n);
    }

    private static boolean matchClass(Class clazz, String string) {
        if (clazz.getName().equals(string)) {
            return true;
        }
        Class clazz2 = clazz.getSuperclass();
        if (clazz2 != null && ProcessKey.matchClass(clazz2, string)) {
            return true;
        }
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            if (!ProcessKey.matchClass(classArray[i], string)) continue;
            return true;
        }
        return false;
    }

    private static boolean instanceOf(Object object, String string) {
        return ProcessKey.matchClass(object.getClass(), string);
    }

    static Element createKeyValue(Document document, IndentConfig indentConfig, Key key) {
        Element element = document.createElementNS("http://www.w3.org/2000/09/xmldsig#", "KeyValue");
        if (ProcessKey.instanceOf(key, "java.security.interfaces.DSAPublicKey")) {
            DOMUtil.addIndent(element, indentConfig, 3);
            DSAPublicKey dSAPublicKey = (DSAPublicKey)key;
            DSAParams dSAParams = dSAPublicKey.getParams();
            Element element2 = document.createElementNS("http://www.w3.org/2000/09/xmldsig#", "DSAKeyValue");
            DOMUtil.addIndent(element2, indentConfig, 4);
            String string = ProcessKey.encodeBigInteger(dSAParams.getP());
            if (indentConfig.doIndentation()) {
                string = Base64.format(string, indentConfig.getUnit() * 5, "\n", DOMUtil.getSpaces(indentConfig, 4));
            }
            element2.appendChild(DOMUtil.createTextElementNS(document, "http://www.w3.org/2000/09/xmldsig#", "P", string));
            DOMUtil.addIndent(element2, indentConfig, 4);
            string = ProcessKey.encodeBigInteger(dSAParams.getQ());
            element2.appendChild(DOMUtil.createTextElementNS(document, "http://www.w3.org/2000/09/xmldsig#", "Q", string));
            DOMUtil.addIndent(element2, indentConfig, 4);
            string = ProcessKey.encodeBigInteger(dSAParams.getG());
            if (indentConfig.doIndentation()) {
                string = Base64.format(string, indentConfig.getUnit() * 5, "\n", DOMUtil.getSpaces(indentConfig, 4));
            }
            element2.appendChild(DOMUtil.createTextElementNS(document, "http://www.w3.org/2000/09/xmldsig#", "G", string));
            DOMUtil.addIndent(element2, indentConfig, 4);
            string = ProcessKey.encodeBigInteger(dSAPublicKey.getY());
            if (indentConfig.doIndentation()) {
                string = Base64.format(string, indentConfig.getUnit() * 5, "\n", DOMUtil.getSpaces(indentConfig, 4));
            }
            element2.appendChild(DOMUtil.createTextElementNS(document, "http://www.w3.org/2000/09/xmldsig#", "Y", string));
            DOMUtil.addIndent(element2, indentConfig, 3);
            element.appendChild(element2);
            DOMUtil.addIndent(element, indentConfig, 2);
        } else if (ProcessKey.instanceOf(key, "java.security.interfaces.RSAPublicKey")) {
            RSA.createKeyValue(document, indentConfig, key, element);
        } else {
            element.appendChild(document.createTextNode(Base64.encode(key.getEncoded())));
        }
        return element;
    }

    static void printKey(Key key) {
        PrintStream printStream = System.err;
        if (key instanceof DSAPublicKey) {
            DSAPublicKey dSAPublicKey = (DSAPublicKey)key;
            DSAParams dSAParams = dSAPublicKey.getParams();
            printStream.println("P: " + dSAParams.getP());
            printStream.println("Q: " + dSAParams.getQ());
            printStream.println("G: " + dSAParams.getG());
            printStream.println("Y: " + dSAPublicKey.getY());
            printStream.println("P: " + ProcessKey.encodeBigInteger(dSAParams.getP()));
            printStream.println("Q: " + ProcessKey.encodeBigInteger(dSAParams.getQ()));
            printStream.println("G: " + ProcessKey.encodeBigInteger(dSAParams.getG()));
            printStream.println("Y: " + ProcessKey.encodeBigInteger(dSAPublicKey.getY()));
            printStream.print("P: ");
            ProcessKey.printByteArray(printStream, dSAParams.getP());
            printStream.print("Q: ");
            ProcessKey.printByteArray(printStream, dSAParams.getQ());
            printStream.print("G: ");
            ProcessKey.printByteArray(printStream, dSAParams.getG());
            printStream.print("Y: ");
            ProcessKey.printByteArray(printStream, dSAPublicKey.getY());
        } else if (ProcessKey.instanceOf(key, "java.security.interfaces.RSAPublicKey")) {
            RSA.print(printStream, key);
        } else {
            printStream.println("Neither DSAPublicky nor RsAPublicKey");
        }
    }

    private static void printByteArray(PrintStream printStream, BigInteger bigInteger) {
        printStream.println(Base64.toHexString(bigInteger.toByteArray()));
    }

    static Key createKey(Element element) throws SignatureStructureException, NoSuchAlgorithmException, InvalidKeySpecException {
        Object object = DOMUtil.getFirstChild2(element);
        while (object != null) {
            if (object.getNodeType() == 1) {
                Element element2 = (Element)object;
                if (!XSignature.isDsigElement(element2)) {
                    throw new SignatureStructureException("Unknown element: " + element2.getNodeName());
                }
                if (XSignature.isDsigElement(element2, "DSAKeyValue")) {
                    return ProcessKey.createDSAKey(element2);
                }
                if (XSignature.isDsigElement(element2, "RSAKeyValue")) {
                    return ProcessKey.createRSAKey(element2);
                }
                throw new SignatureStructureException("Unknown element: " + element2.getNodeName());
            }
            object = DOMUtil.getNextSibling2((Node)object);
        }
        object = DOMUtil.getStringValue(element);
        return new SimpleKey(Base64.decode((String)object));
    }

    static Key createDSAKey(Element element) throws SignatureStructureException, NoSuchAlgorithmException, InvalidKeySpecException {
        BigInteger bigInteger = null;
        BigInteger bigInteger2 = null;
        BigInteger bigInteger3 = null;
        BigInteger bigInteger4 = null;
        Object object = DOMUtil.getFirstChild2(element);
        while (object != null) {
            if (object.getNodeType() == 1) {
                Element element2 = (Element)object;
                if (XSignature.isDsigElement(element2, "P")) {
                    bigInteger = new BigInteger(1, Base64.decode(DOMUtil.getStringValue(element2)));
                } else if (XSignature.isDsigElement(element2, "Q")) {
                    bigInteger2 = new BigInteger(1, Base64.decode(DOMUtil.getStringValue(element2)));
                } else if (XSignature.isDsigElement(element2, "G")) {
                    bigInteger3 = new BigInteger(1, Base64.decode(DOMUtil.getStringValue(element2)));
                } else if (XSignature.isDsigElement(element2, "Y")) {
                    bigInteger4 = new BigInteger(1, Base64.decode(DOMUtil.getStringValue(element2)));
                } else if (!(XSignature.isDsigElement(element2, "J") || XSignature.isDsigElement(element2, "Seed") || XSignature.isDsigElement(element2, "PgenCounter"))) {
                    throw new SignatureStructureException("Unknown element: " + element2.getNodeName());
                }
            }
            object = DOMUtil.getNextSibling2((Node)object);
        }
        if (bigInteger == null) {
            throw new SignatureStructureException("No P element in the DSAKeyValue element.");
        }
        if (bigInteger2 == null) {
            throw new SignatureStructureException("No Q element in the DSAKeyValue element.");
        }
        if (bigInteger3 == null) {
            throw new SignatureStructureException("No G element in the DSAKeyValue element.");
        }
        if (bigInteger4 == null) {
            throw new SignatureStructureException("No Y element in the DSAKeyValue element.");
        }
        object = KeyFactory.getInstance("DSA");
        return ((KeyFactory)object).generatePublic(new DSAPublicKeySpec(bigInteger4, bigInteger, bigInteger2, bigInteger3));
    }

    static Key createRSAKey(Element element) throws SignatureStructureException, NoSuchAlgorithmException, InvalidKeySpecException {
        BigInteger bigInteger = null;
        BigInteger bigInteger2 = null;
        Object object = DOMUtil.getFirstChild2(element);
        while (object != null) {
            if (object.getNodeType() == 1) {
                Element element2 = (Element)object;
                if (XSignature.isDsigElement(element2, "Modulus")) {
                    byte[] byArray = Base64.decode(DOMUtil.getStringValue(element2));
                    bigInteger = new BigInteger(1, byArray);
                } else if (XSignature.isDsigElement(element2, "Exponent")) {
                    bigInteger2 = new BigInteger(1, Base64.decode(DOMUtil.getStringValue(element2)));
                } else {
                    throw new SignatureStructureException("Unknown element: " + element2.getNodeName());
                }
            }
            object = DOMUtil.getNextSibling2((Node)object);
        }
        if (bigInteger == null) {
            throw new SignatureStructureException("No Modulus element in the RSAKeyValue element.");
        }
        if (bigInteger2 == null) {
            throw new SignatureStructureException("No Exponent element in the RSAKeyValue element.");
        }
        object = KeyFactory.getInstance("RSA");
        return ((KeyFactory)object).generatePublic(new RSAPublicKeySpec(bigInteger, bigInteger2));
    }

    static void setKeyInfo(Element element, KeyInfoGenerator keyInfoGenerator) throws SignatureStructureException {
        Element element2 = XSignature.getFirstChild(element, "SignatureValue");
        if (element2 == null) {
            throw new SignatureStructureException("The Signature element has no SignatureValue element.");
        }
        Node node = element2.getNextSibling();
        Document document = element.getOwnerDocument();
        Element element3 = keyInfoGenerator.getKeyInfoElement(document);
        if (!element.getTagName().equals("Signature")) {
            element3.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://www.w3.org/2000/09/xmldsig#");
        }
        element.insertBefore(document.createTextNode("\n  "), node);
        element.insertBefore(element3, node);
    }

    static Key processKeyInfo(SignatureContext signatureContext, Element element) throws CertificateException, NoSuchAlgorithmException, SignatureStructureException, InvalidKeySpecException, IOException, TransformException {
        Key key = null;
        Key key2 = null;
        int n = 0;
        Map map = null;
        map = signatureContext.getContext();
        Node node = DOMUtil.getFirstChild2(element);
        while (node != null) {
            if (node.getNodeType() == 1) {
                Object object;
                ByteArrayInputStream byteArrayInputStream;
                Object object2;
                Object object3;
                Element element2 = (Element)node;
                if (XSignature.isDsigElement(element2, "KeyValue")) {
                    key = ProcessKey.createKey(element2);
                } else if (XSignature.isDsigElement(element2, "RetrievalMethod")) {
                    object3 = ReferenceProcessor.getTransformedOctets(signatureContext, element2.getOwnerDocument(), element2, -1);
                    object2 = CertificateFactory.getInstance("X.509");
                    byteArrayInputStream = new ByteArrayInputStream((byte[])object3);
                    object = (X509Certificate)((CertificateFactory)object2).generateCertificate(byteArrayInputStream);
                    if (key == null) {
                        key = ((Certificate)object).getPublicKey();
                    }
                    if (key != null && map != null) {
                        map.put(key, object);
                    }
                } else if (XSignature.isDsigElement(element2, "X509Data")) {
                    object3 = DOMUtil.getFirstChild2(element2);
                    while (object3 != null) {
                        if (object3.getNodeType() == 1 && XSignature.isDsigElement((Element)(object2 = (Element)object3)) && XSignature.isDsigElement((Element)object2, "X509Certificate")) {
                            ++n;
                            object = Base64.decode(DOMUtil.getStringValue((Node)object2));
                            byteArrayInputStream = new ByteArrayInputStream((byte[])object);
                            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
                            if (key2 == null) {
                                key2 = x509Certificate.getPublicKey();
                            }
                            if (key2 != null && map != null) {
                                map.put(key2, x509Certificate);
                            }
                        }
                        object3 = DOMUtil.getNextSibling2((Node)object3);
                    }
                }
            }
            node = DOMUtil.getNextSibling2(node);
        }
        if (n > 1) {
            key2 = null;
        }
        return key != null ? key : key2;
    }

    private static class RSA {
        private RSA() {
        }

        static void createKeyValue(Document document, IndentConfig indentConfig, Key key, Element element) {
            DOMUtil.addIndent(element, indentConfig, 3);
            RSAPublicKey rSAPublicKey = (RSAPublicKey)key;
            Element element2 = document.createElementNS("http://www.w3.org/2000/09/xmldsig#", "RSAKeyValue");
            DOMUtil.addIndent(element2, indentConfig, 4);
            String string = ProcessKey.encodeBigInteger(rSAPublicKey.getModulus());
            if (indentConfig.doIndentation()) {
                string = Base64.format(string, indentConfig.getUnit() * 5, "\n", DOMUtil.getSpaces(indentConfig, 4));
            }
            element2.appendChild(DOMUtil.createTextElementNS(document, "http://www.w3.org/2000/09/xmldsig#", "Modulus", string));
            DOMUtil.addIndent(element2, indentConfig, 4);
            string = ProcessKey.encodeBigInteger(rSAPublicKey.getPublicExponent());
            element2.appendChild(DOMUtil.createTextElementNS(document, "http://www.w3.org/2000/09/xmldsig#", "Exponent", string));
            DOMUtil.addIndent(element2, indentConfig, 3);
            element.appendChild(element2);
            DOMUtil.addIndent(element, indentConfig, 2);
        }

        static void print(PrintStream printStream, Key key) {
            RSAPublicKey rSAPublicKey = (RSAPublicKey)key;
            printStream.println("Modulus: " + rSAPublicKey.getModulus());
            printStream.println("Exponent: " + rSAPublicKey.getPublicExponent());
            printStream.println("Modulus: " + ProcessKey.encodeBigInteger(rSAPublicKey.getModulus()));
            printStream.println("Exponent: " + ProcessKey.encodeBigInteger(rSAPublicKey.getPublicExponent()));
        }
    }
}

