/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xss4j.dsig;

import com.ibm.ws.wssecurity.xss4j.domutil.DOMUtil;
import com.ibm.ws.wssecurity.xss4j.domutil.IndentConfig;
import com.ibm.ws.wssecurity.xss4j.dsig.TemplateGenerator;
import java.util.Vector;
import org.w3c.dom.Element;

public class Reference {
    String uri;
    String id;
    String type;
    TemplateGenerator gen;
    Element objectElement;
    Vector transforms;
    String digester;

    protected Reference(TemplateGenerator templateGenerator, String string, Element element) {
        this.gen = templateGenerator;
        this.uri = string;
        this.objectElement = element;
    }

    public void setId(String string) {
        this.id = string;
    }

    public void setType(String string) {
        this.type = string;
    }

    public void addTransform(Element element) {
        if (this.transforms == null) {
            this.transforms = new Vector();
        }
        this.transforms.addElement(element);
    }

    public void addTransform(String string) {
        Element element = this.gen.createElementNS("Transform");
        element.setAttributeNS(null, "Algorithm", string);
        this.addTransform(element);
    }

    public void addXPathTransform(String string) {
        Element element = this.gen.createElementNS("Transform");
        element.setAttributeNS(null, "Algorithm", "http://www.w3.org/TR/1999/REC-xpath-19991116");
        Element element2 = this.gen.createElementNS("XPath");
        DOMUtil.appendText(element2, string);
        element.appendChild(element2);
        this.addTransform(element);
    }

    public void setDigestMethod(String string) {
        this.digester = string;
    }

    protected String getDigestMethod() {
        return this.digester;
    }

    public Element getReferenceElement() {
        return this.getReferenceElement(null);
    }

    public Element getReferenceElement(IndentConfig indentConfig) {
        Element element;
        Element element2 = this.gen.createElementNS("Reference");
        element2.setAttributeNS(null, "URI", this.uri);
        if (this.id != null) {
            element2.setAttributeNS(null, "Id", this.id);
        }
        if (this.type != null) {
            element2.setAttributeNS(null, "Type", this.type);
        }
        DOMUtil.addIndent(element2, indentConfig, 3);
        if (this.transforms != null) {
            element = this.gen.createElementNS("Transforms");
            for (int i = 0; i < this.transforms.size(); ++i) {
                Element element3 = (Element)this.transforms.elementAt(i);
                DOMUtil.addIndent(element, indentConfig, 4);
                element.appendChild(element3);
            }
            DOMUtil.addIndent(element, indentConfig, 3);
            element2.appendChild(element);
            DOMUtil.addIndent(element2, indentConfig, 3);
        }
        element = this.gen.createElementNS("DigestMethod");
        element.setAttributeNS(null, "Algorithm", this.digester);
        element2.appendChild(element);
        DOMUtil.addIndent(element2, indentConfig, 3);
        element2.appendChild(this.gen.createElementNS("DigestValue"));
        DOMUtil.addIndent(element2, indentConfig, 2);
        return element2;
    }

    protected Element getObjectElement() {
        return this.objectElement;
    }

    protected boolean isEnvelopedObject() {
        return this.objectElement != null;
    }
}

