/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xss4j.dsig;

import com.ibm.ws.wssecurity.xss4j.AlgorithmFactory;
import com.ibm.ws.wssecurity.xss4j.domutil.DOMUtil;
import com.ibm.ws.wssecurity.xss4j.domutil.XPathCanonicalizer;
import com.ibm.ws.wssecurity.xss4j.dsig.IDResolver;
import com.ibm.ws.wssecurity.xss4j.dsig.ReferenceValidity;
import com.ibm.ws.wssecurity.xss4j.dsig.SignatureContext;
import com.ibm.ws.wssecurity.xss4j.dsig.SignatureStructureException;
import com.ibm.ws.wssecurity.xss4j.dsig.Transform;
import com.ibm.ws.wssecurity.xss4j.dsig.TransformContext;
import com.ibm.ws.wssecurity.xss4j.dsig.TransformException;
import com.ibm.ws.wssecurity.xss4j.dsig.URITransportSetter;
import com.ibm.ws.wssecurity.xss4j.dsig.XSignature;
import com.ibm.ws.wssecurity.xss4j.dsig.util.Base64;
import com.ibm.ws.wssecurity.xss4j.dsig.util.XPathUtil;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class ReferenceProcessor {
    private static final boolean DEBUG = false;
    public static long digestTime;

    private ReferenceProcessor() {
    }

    static byte[] getTransformedOctets(SignatureContext signatureContext, Document document, Element element, int n) throws IOException, SignatureStructureException, TransformException, NoSuchAlgorithmException {
        Object object;
        String string = null;
        TransformContext transformContext = null;
        Vector vector = null;
        Element element2 = XSignature.getFirstChild(element, "Transforms");
        Attr attr = element.getAttributeNode("Type");
        String string2 = attr == null ? null : attr.getNodeValue();
        Attr attr2 = element.getAttributeNode("URI");
        if (attr2 == null) {
            object = signatureContext.getNullURIHandler();
            if (object == null) {
                throw new TransformException("A Reference element has no URI attribute, but NullURIHandler is not registered.");
            }
            transformContext = object.getContent();
            if (transformContext.getType() == 3) {
                Node node = transformContext.getNode();
                if (node.getOwnerDocument() != null && node.getOwnerDocument() == document || node == document) {
                    vector = ReferenceProcessor.fixTree(node, element2);
                } else {
                    ReferenceProcessor.fixTree(node, element2);
                }
            }
        } else {
            String string3;
            string = attr2.getNodeValue();
            if (string == null) {
                string = "";
            }
            int n2 = -1;
            if (string.length() > 0 && (n2 = string.indexOf(35)) < 0 && element2 == null) {
                byte[] byArray = URITransportSetter.getContent(string, signatureContext.getEntityResolver(), null);
                if (signatureContext.getResourceShower() != null) {
                    signatureContext.getResourceShower().showSignedResource(signatureContext.getOwnerElement(), n, string, string2, byArray, null);
                }
                return byArray;
            }
            String string4 = null;
            if (n2 >= 0) {
                string3 = string.substring(0, n2);
                string4 = string.substring(n2 + 1);
            } else {
                string3 = string;
            }
            if (string3.length() > 0 && string4 == null) {
                transformContext = new TransformContext(signatureContext, string3);
            } else {
                Document document2 = null;
                if (string3.length() == 0) {
                    document2 = document;
                    vector = ReferenceProcessor.fixTree(document, element2);
                } else if (string4 != null) {
                    try {
                        InputSource inputSource = null;
                        if (signatureContext.getEntityResolver() != null) {
                            inputSource = signatureContext.getEntityResolver().resolveEntity(null, string3);
                        }
                        document2 = inputSource == null ? signatureContext.parse(new InputSource(string3)) : signatureContext.parse(inputSource);
                    }
                    catch (SAXException sAXException) {
                        throw TransformException.create(sAXException);
                    }
                    catch (ParserConfigurationException parserConfigurationException) {
                        throw TransformException.create(parserConfigurationException);
                    }
                }
                transformContext = string4 != null ? ReferenceProcessor.idToInput(signatureContext, string3, document2, string4) : new TransformContext(signatureContext, document2);
            }
        }
        ReferenceProcessor.transform(element, transformContext, signatureContext.getAlgorithmFactory());
        if (signatureContext.getResourceShower() != null) {
            signatureContext.getResourceShower().showSignedResource(signatureContext.getOwnerElement(), n, string, string2, transformContext.getOctets(), transformContext.getEncoding());
        }
        object = transformContext.getOctets();
        if (vector != null) {
            XPathUtil.cleanTree(vector);
        }
        return object;
    }

    private static String getIdFromXPointer(String string) {
        if (!string.endsWith(")")) {
            return null;
        }
        if (!(string = string.substring("xpointer(".length(), string.length() - 1).trim()).startsWith("id(") || !string.endsWith(")")) {
            return null;
        }
        if ((string = string.substring("id(".length(), string.length() - 1).trim()).length() < 3) {
            return null;
        }
        char c = string.charAt(0);
        char c2 = string.charAt(string.length() - 1);
        if ((c == '\"' || c == '\'') && c == c2) {
            return string.substring(1, string.length() - 1);
        }
        return null;
    }

    private static TransformContext idToInput(SignatureContext signatureContext, String string, Document document, String string2) throws IllegalArgumentException {
        TransformContext transformContext;
        IDResolver iDResolver = signatureContext.getIDResolver0();
        if (string2.startsWith("xpointer(")) {
            if (string2.equals("xpointer(/)")) {
                NodeList nodeList = XPathCanonicalizer.toNodeset(document, null, true);
                transformContext = new TransformContext(signatureContext, nodeList);
            } else {
                String string3 = ReferenceProcessor.getIdFromXPointer(string2);
                if (string3 == null) {
                    throw new IllegalArgumentException("No support for xpointer '" + string2 + "'");
                }
                string2 = string3;
                if (iDResolver == null) {
                    throw new IllegalArgumentException("No IDResolver is registered.");
                }
                Element element = iDResolver.resolveID(document, string2);
                if (element == null) {
                    throw new IllegalArgumentException("Can't resolve ID: '" + string2 + "' in '" + string + "'");
                }
                NodeList nodeList = XPathCanonicalizer.toNodeset(element, null, true);
                transformContext = new TransformContext(signatureContext, nodeList);
            }
        } else {
            if (iDResolver == null) {
                throw new IllegalArgumentException("No IDResolver is registered.");
            }
            Element element = iDResolver.resolveID(document, string2);
            if (element == null) {
                throw new IllegalArgumentException("Can't resolve ID: '" + string2 + "' in '" + string + "'");
            }
            transformContext = new TransformContext(signatureContext, element);
        }
        return transformContext;
    }

    private static Vector fixTree(Node node, Element element) {
        if (element == null) {
            return null;
        }
        Element element2 = XSignature.getFirstChild(element, "Transform");
        if (element2 == null) {
            return null;
        }
        String string = element2.getAttribute("Algorithm");
        if ("http://www.w3.org/TR/2001/REC-xml-c14n-20010315".equals(string) || "http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments".equals(string) || "http://www.w3.org/2001/10/xml-exc-c14n#".equals(string) || "http://www.w3.org/2001/10/xml-exc-c14n#WithComments".equals(string)) {
            Node node2;
            for (node2 = element2.getNextSibling(); node2 != null && node2.getNodeType() != 1; node2 = node2.getNextSibling()) {
            }
            if (node2 == null) {
                return null;
            }
        }
        return XPathUtil.fixTree(node);
    }

    private static byte[] transform(Element element, TransformContext transformContext, AlgorithmFactory algorithmFactory) throws SignatureStructureException, TransformException, NoSuchAlgorithmException {
        Element element2 = XSignature.getFirstChild(element, "Transforms");
        if (element2 == null) {
            return transformContext.getOctets();
        }
        Node node = DOMUtil.getFirstChild2(element2);
        while (node != null) {
            Element element3;
            if (node.getNodeType() == 1 && XSignature.isDsigElement(element3 = (Element)node, "Transform")) {
                String string = element3.getAttribute("Algorithm");
                if (string == null || string.length() == 0) {
                    throw new SignatureStructureException("No Algorithm in a Transform element.");
                }
                Transform transform = algorithmFactory.getTransform(string);
                if (transform == null) {
                    throw new TransformException("No such algorithm: " + string);
                }
                transform.setParameter(DOMUtil.getFirstChildElement(element3));
                transform.transform(transformContext);
            }
            node = DOMUtil.getNextSibling2(node);
        }
        return transformContext.getOctets();
    }

    static byte[] calculateDigestValue(Element element, byte[] byArray, AlgorithmFactory algorithmFactory) throws SignatureStructureException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, NoSuchProviderException {
        Element element2 = XSignature.getFirstChild(element, "DigestMethod");
        if (element2 == null) {
            throw new SignatureStructureException("No DigestMethod element.");
        }
        String string = element2.getAttribute("Algorithm");
        if (string == null || string.length() == 0) {
            throw new SignatureStructureException("No Algorithm attribute, or empty Algorithm attribute.");
        }
        AlgorithmParameterSpec algorithmParameterSpec = algorithmFactory.unmarshalParameter(string, element2);
        MessageDigest messageDigest = algorithmFactory.getMessageDigest(string, algorithmParameterSpec);
        long l = System.currentTimeMillis();
        messageDigest.reset();
        messageDigest.update(byArray);
        byte[] byArray2 = messageDigest.digest();
        algorithmFactory.releaseMessageDigest(string, messageDigest);
        digestTime += System.currentTimeMillis() - l;
        return byArray2;
    }

    private static byte[] digest(SignatureContext signatureContext, Element element, int n) throws SignatureStructureException, NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException, TransformException, IOException {
        Document document = element.getOwnerDocument();
        byte[] byArray = ReferenceProcessor.getTransformedOctets(signatureContext, document, element, n);
        return ReferenceProcessor.calculateDigestValue(element, byArray, signatureContext.getAlgorithmFactory());
    }

    static void substDigest(SignatureContext signatureContext, Element element, int n) throws SignatureStructureException, NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException, TransformException, IOException {
        byte[] byArray = ReferenceProcessor.digest(signatureContext, element, n);
        Element element2 = XSignature.getFirstChild(element, "DigestValue");
        if (element2 == null) {
            throw new SignatureStructureException("No DigestValue element.");
        }
        DOMUtil.removeAllChildren(element2);
        Document document = element.getOwnerDocument();
        element2.appendChild(document.createTextNode(Base64.encode(byArray)));
    }

    static ReferenceValidity verify(SignatureContext signatureContext, Element element, int n) {
        ReferenceValidity referenceValidity;
        block3: {
            Attr attr = element.getAttributeNode("URI");
            Attr attr2 = element.getAttributeNode("Type");
            referenceValidity = new ReferenceValidity(attr == null ? null : attr.getNodeValue(), attr2 == null ? null : attr2.getNodeValue());
            byte[] byArray = null;
            try {
                byArray = ReferenceProcessor.digest(signatureContext, element, n);
                Element element2 = XSignature.getFirstChild(element, "DigestValue");
                if (element2 == null) {
                    throw new SignatureStructureException("No DigestValue element.");
                }
                byte[] byArray2 = Base64.decode(DOMUtil.getStringValue(element2));
                referenceValidity.valid = MessageDigest.isEqual(byArray, byArray2);
                referenceValidity.message = referenceValidity.valid ? "Ok." : "Digest value mismatch: calculated: " + Base64.encode(byArray);
            }
            catch (Exception exception) {
                referenceValidity.valid = false;
                referenceValidity.message = exception.getMessage();
                if (referenceValidity.message != null) break block3;
                referenceValidity.message = exception.getClass().getName();
            }
        }
        return referenceValidity;
    }
}

