/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xss4j.dsig;

import com.ibm.ws.wssecurity.xss4j.AlgorithmFactory;
import com.ibm.ws.wssecurity.xss4j.domutil.DOMUtil;
import com.ibm.ws.wssecurity.xss4j.dsig.IDResolver;
import com.ibm.ws.wssecurity.xss4j.dsig.KeyInfo;
import com.ibm.ws.wssecurity.xss4j.dsig.KeyInfoGenerator;
import com.ibm.ws.wssecurity.xss4j.dsig.ManifestProcessor;
import com.ibm.ws.wssecurity.xss4j.dsig.NullURIHandler;
import com.ibm.ws.wssecurity.xss4j.dsig.ProcessKey;
import com.ibm.ws.wssecurity.xss4j.dsig.ReferenceProcessor;
import com.ibm.ws.wssecurity.xss4j.dsig.ResourceShower;
import com.ibm.ws.wssecurity.xss4j.dsig.SignatureStructureException;
import com.ibm.ws.wssecurity.xss4j.dsig.TransformException;
import com.ibm.ws.wssecurity.xss4j.dsig.Validity;
import com.ibm.ws.wssecurity.xss4j.dsig.XSignature;
import com.ibm.ws.wssecurity.xss4j.dsig.XSignatureException;
import com.ibm.ws.wssecurity.xss4j.dsig.util.HWKeyCache;
import com.ibm.ws.wssecurity.xss4j.dsig.util.XPathUtil;
import com.ibm.ws.wssecurity.xss4j.enc.EncryptedKeyRetriever;
import com.ibm.ws.wssecurity.xss4j.enc.KeyInfoResolver;
import com.ibm.ws.wssecurity.xss4j.enc.type.EncryptedKey;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.Key;
import java.security.Provider;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SignatureContext
implements ErrorHandler {
    private EncryptedKeyRetriever encryptedKeyRetriever = null;
    private KeyInfoResolver keyInfoResolver = null;
    EntityResolver entityResolver = null;
    IDResolver idResolver = null;
    AlgorithmFactory aFactory = null;
    ResourceShower shower = null;
    NullURIHandler nullHandler = null;
    boolean useInternalIDResolver = true;
    IDResolver wrappedIDResolver = null;
    boolean verifyManifest = false;
    Element signature;
    Element owner;
    private Map _context;
    private String _hwKeyStoreName;
    private String _hwConfigName;
    private String sigAlgorithm = null;
    private Boolean _offload = Boolean.TRUE;
    private Provider hwAccelerationProvider = null;
    private Provider hwKeyStoreProvider = null;

    public SignatureContext() {
        this.aFactory = AlgorithmFactory.getInstance();
    }

    public Provider getHWAccelerationProvider() {
        return this.hwAccelerationProvider;
    }

    public Provider getHWKeyStoreProvider() {
        return this.hwKeyStoreProvider;
    }

    public void setContext(Map map) {
        this._context = map;
    }

    public Map getContext() {
        return this._context;
    }

    public void setHWAccelerationProvider(Provider provider) {
        if (this.shouldChangeProvider()) {
            this.hwAccelerationProvider = provider;
        }
    }

    public void setHWKeyStoreProvider(Provider provider) {
        this.hwKeyStoreProvider = provider;
    }

    public boolean isHWAccelerationProvider() {
        return this.hwAccelerationProvider != null;
    }

    public boolean isHWKeyStoreProvider() {
        return this.hwKeyStoreProvider != null;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public void setSigAlgorithm(String string) {
        this.sigAlgorithm = string;
    }

    public String getSigAlgorithm() {
        return this.sigAlgorithm;
    }

    public void setHWKeyStoreName(String string) {
        this._hwKeyStoreName = string;
    }

    public String getHWKeyStoreName() {
        return this._hwKeyStoreName;
    }

    public void setHWConfigName(String string) {
        this._hwConfigName = string;
    }

    public void setOffload(Boolean bl) {
        this._offload = bl;
    }

    public String getHWConfigName() {
        return this._hwConfigName;
    }

    public boolean shouldChangeProvider() {
        return this._hwConfigName != null && this._hwConfigName.length() > 0 && HWKeyCache.isHWSigAlgorithm(this.sigAlgorithm) && this._offload != false;
    }

    public boolean useHWKeyStore() {
        return this._hwKeyStoreName != null && this._hwKeyStoreName.length() > 0;
    }

    public IDResolver getIDResolver() {
        return this.idResolver;
    }

    public void setIDResolver(IDResolver iDResolver) {
        this.idResolver = iDResolver;
    }

    void setWrappedIDResolver(IDResolver iDResolver) {
        this.wrappedIDResolver = iDResolver;
    }

    IDResolver getIDResolver0() {
        return this.wrappedIDResolver != null ? this.wrappedIDResolver : this.idResolver;
    }

    public EncryptedKeyRetriever getEncryptedKeyRetriever() {
        return this.encryptedKeyRetriever;
    }

    public void setEncryptedKeyRetriever(EncryptedKeyRetriever encryptedKeyRetriever) {
        this.encryptedKeyRetriever = encryptedKeyRetriever;
    }

    public KeyInfoResolver getKeyInfoResolver() {
        return this.keyInfoResolver;
    }

    public void setKeyInfoResolver(KeyInfoResolver keyInfoResolver) {
        this.keyInfoResolver = keyInfoResolver;
    }

    public AlgorithmFactory getAlgorithmFactory() {
        return this.aFactory;
    }

    public void setAlgorithmFactory(AlgorithmFactory algorithmFactory) {
        this.aFactory = algorithmFactory;
    }

    public ResourceShower getResourceShower() {
        return this.shower;
    }

    public void setResourceShower(ResourceShower resourceShower) {
        this.shower = resourceShower;
    }

    public NullURIHandler getNullURIHandler() {
        return this.nullHandler;
    }

    public void setNullURIHandler(NullURIHandler nullURIHandler) {
        this.nullHandler = nullURIHandler;
    }

    public boolean getUseInternalIDResolver() {
        return this.useInternalIDResolver;
    }

    public void setUseInternalIDResolver(boolean bl) {
        this.useInternalIDResolver = bl;
    }

    Element getSignatureElement() {
        return this.signature;
    }

    Element setSignatureElement(Element element) {
        Element element2 = this.signature;
        this.signature = element;
        return element2;
    }

    Element getOwnerElement() {
        return this.owner;
    }

    Element setOwnerElement(Element element) {
        Element element2 = this.owner;
        this.owner = element;
        return element2;
    }

    public Element sign(Element element, Key key) throws XSignatureException {
        Object object;
        this.signature = element;
        this.owner = element;
        if (this.isHWAccelerationProvider()) {
            object = HWKeyCache.getInstance();
            this.aFactory.setLocalProvider("HWCONFIG", this.getHWAccelerationProvider());
            try {
                key = ((HWKeyCache)object).translate(key);
            }
            catch (Exception exception) {
                throw new XSignatureException(exception);
            }
        }
        if (this.isHWKeyStoreProvider()) {
            this.aFactory.setLocalProvider("com.ibm.ws.wssecurity.config.keystore.keyStoreRef", this.getHWKeyStoreProvider());
        }
        try {
            object = XSignature.internalSign(this, key);
            return object;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("HARDWARE: Signature signing with HW crypto provider failed, Continue using software provider");
            try {
                Element element2 = XSignature.internalSign(this, key);
                return element2;
            }
            catch (Exception exception2) {
                exception2.printStackTrace();
                throw new XSignatureException(exception2);
            }
        }
        finally {
            if (this.isHWAccelerationProvider() || this.isHWKeyStoreProvider()) {
                this.aFactory.clearLocalProviderMap();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Validity verify(Element element, Key key) {
        this.signature = element;
        this.owner = element;
        Validity validity = null;
        if (this.isHWAccelerationProvider()) {
            this.aFactory.setLocalProvider("HWCONFIG", this.getHWAccelerationProvider());
        }
        if (this.isHWKeyStoreProvider()) {
            this.aFactory.setLocalProvider("com.ibm.ws.wssecurity.config.keystore.keyStoreRef", this.getHWKeyStoreProvider());
        }
        try {
            validity = XSignature.internalVerify(this, key);
        }
        catch (Exception exception) {
            if (!this.isHWKeyStoreProvider() && this.isHWAccelerationProvider()) {
                this.aFactory.clearLocalProviderMap();
                System.out.println("HARDWARE: signature verification with HW crypto provider failed, Continue using software provider");
                validity = XSignature.internalVerify(this, key);
            }
        }
        finally {
            if (this.isHWAccelerationProvider() || this.isHWKeyStoreProvider()) {
                this.aFactory.clearLocalProviderMap();
            }
        }
        return validity;
    }

    public Element digestManifest(Element element) throws XSignatureException {
        this.signature = null;
        this.owner = element;
        if (this.isHWAccelerationProvider()) {
            this.aFactory.setLocalProvider("HWCONFIG", this.getHWAccelerationProvider());
        }
        if (this.isHWKeyStoreProvider()) {
            this.aFactory.setLocalProvider("com.ibm.ws.wssecurity.config.keystore.keyStoreRef", this.getHWKeyStoreProvider());
        }
        try {
            Element element2 = ManifestProcessor.digest(this);
            return element2;
        }
        catch (Exception exception) {
            System.out.println("HARDWARE: Digest with HW crypto provider failed, Continue using software provider");
            try {
                Element element3 = ManifestProcessor.digest(this);
                return element3;
            }
            catch (Exception exception2) {
                throw new XSignatureException(exception2);
            }
        }
        finally {
            if (this.isHWAccelerationProvider() || this.isHWKeyStoreProvider()) {
                this.aFactory.clearLocalProviderMap();
            }
        }
    }

    public Validity verifyManifest(Element element) throws Exception {
        this.signature = null;
        this.owner = element;
        if (this.isHWAccelerationProvider()) {
            this.aFactory.setLocalProvider("HWCONFIG", this.getHWAccelerationProvider());
        }
        if (this.isHWKeyStoreProvider()) {
            this.aFactory.setLocalProvider("com.ibm.ws.wssecurity.config.keystore.keyStoreRef", this.getHWKeyStoreProvider());
        }
        try {
            Validity validity = ManifestProcessor.verify(this);
            return validity;
        }
        catch (Exception exception) {
            System.out.println("HARDWARE: Verify with HW crypto provider failed, Continue using software provider");
            Validity validity = ManifestProcessor.verify(this);
            return validity;
        }
        finally {
            if (this.isHWAccelerationProvider() || this.isHWKeyStoreProvider()) {
                this.aFactory.clearLocalProviderMap();
            }
        }
    }

    public static void setKeyInfo(Element element, KeyInfoGenerator keyInfoGenerator) throws SignatureStructureException {
        ProcessKey.setKeyInfo(element, keyInfoGenerator);
    }

    protected Document parse(InputSource inputSource) throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilder documentBuilder = this.getAlgorithmFactory().getDocumentBuilder();
        if (this.entityResolver != null) {
            documentBuilder.setEntityResolver(this.entityResolver);
        }
        documentBuilder.setErrorHandler(this);
        Document document = documentBuilder.parse(inputSource);
        this.getAlgorithmFactory().releaseDocumentBuilder(documentBuilder);
        XPathUtil.fixTree(document);
        return document;
    }

    private Document parse(byte[] byArray) throws IOException, TransformException {
        try {
            return this.parse(new InputSource(new ByteArrayInputStream(byArray)));
        }
        catch (SAXException sAXException) {
            throw TransformException.create(sAXException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw TransformException.create(parserConfigurationException);
        }
    }

    private Element parseWithConfirmingRoot(byte[] byArray, String string) throws SignatureStructureException, IOException, TransformException {
        Document document = this.parse(byArray);
        Element element = document.getDocumentElement();
        if (!XSignature.isDsigElement(element, string)) {
            throw new SignatureStructureException("Type mismatch: Type=" + string + ", root=" + element.getNodeName());
        }
        return element;
    }

    public Object retrieve(Element element) throws XSignatureException {
        try {
            byte[] byArray;
            this.signature = null;
            this.owner = element;
            Object object = byArray = ReferenceProcessor.getTransformedOctets(this, element.getOwnerDocument(), element, -1);
            Attr attr = element.getAttributeNode("Type");
            if (attr == null) {
                return object;
            }
            String string = attr.getNodeValue();
            if (string.equals("http://www.w3.org/2000/09/xmldsig#X509Data")) {
                Element element2 = this.parseWithConfirmingRoot(byArray, "X509Data");
                object = new KeyInfo.X509Data(element2);
            } else if (string.equals("http://www.w3.org/2000/09/xmldsig#PGPData")) {
                Element element3 = this.parseWithConfirmingRoot(byArray, "PGPData");
                object = new KeyInfo.PGPData(element3);
            } else if (string.equals("http://www.w3.org/2000/09/xmldsig#SPKIData")) {
                Element element4 = this.parseWithConfirmingRoot(byArray, "SPKIData");
                object = new KeyInfo.SPKIData(element4);
            } else if (string.equals("http://www.w3.org/2000/09/xmldsig#MgmtData")) {
                Element element5 = this.parseWithConfirmingRoot(byArray, "MgmgtData");
                object = DOMUtil.getStringValue(element5);
            } else if (string.equals("http://www.w3.org/2000/09/xmldsig#rawX509Certificate")) {
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
                object = x509Certificate;
            } else if (string.equals("http://www.w3.org/2000/09/xmldsig#DSAKeyValue")) {
                Element element6 = this.parseWithConfirmingRoot(byArray, "DSAKeyValue");
                object = ProcessKey.createDSAKey(element6);
            } else if (string.equals("http://www.w3.org/2000/09/xmldsig#RSAKeyValue")) {
                Element element7 = this.parseWithConfirmingRoot(byArray, "RSAKeyValue");
                object = ProcessKey.createRSAKey(element7);
            } else if (string.equals("http://www.w3.org/2001/04/xmlenc#EncryptedKey")) {
                DocumentBuilder documentBuilder = this.getAlgorithmFactory().getDocumentBuilder();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                Element element8 = documentBuilder.parse(byteArrayInputStream).getDocumentElement();
                this.getAlgorithmFactory().releaseDocumentBuilder(documentBuilder);
                object = new EncryptedKey(element8);
            }
            return object;
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException.getException();
            if (exception != null) {
                throw new XSignatureException(exception);
            }
            throw new XSignatureException(sAXException);
        }
        catch (Exception exception) {
            throw new XSignatureException(exception);
        }
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    public boolean isDebug() {
        return false;
    }
}

