/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xss4j.dsig;

import com.ibm.wsspi.wssecurity.SignatureEngine;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;

public class SignatureEngineHMAC
implements SignatureEngine {
    private MessageDigest digest;
    private int outputLength;
    private String uri;
    private byte[] key_opad;
    private static final int B = 64;
    static final byte[] MASK_BITS = new byte[]{-1, -2, -4, -8, -16, -32, -64, -128};

    public SignatureEngineHMAC(String string, Provider provider) throws NoSuchAlgorithmException {
        this.digest = provider == null ? MessageDigest.getInstance("SHA") : MessageDigest.getInstance("SHA", provider);
        this.outputLength = -1;
        this.uri = string;
    }

    public void setParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        if (algorithmParameterSpec == null) {
            this.outputLength = -1;
            return;
        }
        if (!(algorithmParameterSpec instanceof HMACParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Invalid paremeter class: " + algorithmParameterSpec.getClass().getName());
        }
        HMACParameterSpec hMACParameterSpec = (HMACParameterSpec)algorithmParameterSpec;
        if (hMACParameterSpec.getOutputLength() <= 0) {
            throw new InvalidAlgorithmParameterException("Output length is less than 1: " + hMACParameterSpec.getOutputLength());
        }
        this.outputLength = hMACParameterSpec.getOutputLength();
    }

    public String getURI() {
        return this.uri;
    }

    public void initSign(Key key) throws InvalidKeyException {
        this.init(key);
    }

    public void initVerify(Key key) throws InvalidKeyException {
        this.init(key);
    }

    public void update(byte[] byArray) throws SignatureException {
        this.digest.update(byArray);
    }

    public void update(byte[] byArray, int n, int n2) throws SignatureException {
        this.digest.update(byArray, n, n2);
    }

    public byte[] sign() throws SignatureException {
        byte[] byArray = this.digest.digest();
        this.digest.reset();
        this.digest.update(this.key_opad);
        this.digest.update(byArray);
        return this.mask(this.digest.digest());
    }

    public boolean verify(byte[] byArray) throws SignatureException {
        return MessageDigest.isEqual(this.mask(byArray), this.sign());
    }

    private void init(Key key) {
        byte[] byArray = key.getEncoded();
        byte[] byArray2 = new byte[64];
        if (byArray.length > 64) {
            this.digest.reset();
            byArray = this.digest.digest(byArray);
        }
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        for (int i = byArray.length; i < 64; ++i) {
            byArray2[i] = 0;
        }
        byte[] byArray3 = new byte[64];
        this.key_opad = new byte[64];
        for (int i = 0; i < 64; ++i) {
            byArray3[i] = (byte)(byArray2[i] ^ 0x36);
            this.key_opad[i] = (byte)(byArray2[i] ^ 0x5C);
        }
        this.digest.reset();
        this.digest.update(byArray3);
    }

    private byte[] mask(byte[] byArray) {
        if (this.outputLength < 0) {
            return byArray;
        }
        int n = (this.outputLength + 7) / 8;
        int n2 = n * 8 - this.outputLength;
        if (n > byArray.length) {
            return byArray;
        }
        if (n == byArray.length && n2 == 0) {
            return byArray;
        }
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        if (n2 == 0) {
            return byArray2;
        }
        int n3 = n - 1;
        byArray2[n3] = (byte)(byArray2[n3] & MASK_BITS[n2]);
        return byArray2;
    }

    public static class HMACParameterSpec
    implements AlgorithmParameterSpec {
        private int outputLength;

        public HMACParameterSpec(int n) {
            this.outputLength = n;
        }

        public HMACParameterSpec(int n, boolean bl) throws InvalidAlgorithmParameterException {
            if (bl && n < 80) {
                throw new InvalidAlgorithmParameterException("Invalid HMACOutputLength value");
            }
            this.outputLength = n;
        }

        public int getOutputLength() {
            return this.outputLength;
        }
    }
}

