/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xss4j.dsig;

import com.ibm.ws.wssecurity.xss4j.AlgorithmFactory;
import com.ibm.ws.wssecurity.xss4j.domutil.DOMUtil;
import com.ibm.ws.wssecurity.xss4j.domutil.IndentConfig;
import com.ibm.ws.wssecurity.xss4j.dsig.KeyInfoGenerator;
import com.ibm.ws.wssecurity.xss4j.dsig.Reference;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TemplateGenerator
implements IndentConfig {
    Vector objects;
    String defaultDigestAlgorithm;
    String c11r;
    String signatureMethod;
    AlgorithmParameterSpec signatureSpec;
    KeyInfoGenerator keyGen;
    Document factory;
    Element signedInfoElement;
    Element manifestElement;
    Element signatureElement;
    String prefix = null;
    boolean doIndent = false;
    int indentUnit = 2;

    public TemplateGenerator() {
    }

    public TemplateGenerator(Document document, String string, String string2, String string3) {
        this();
        this.setDocument(document);
        this.setDefaultDigestMethod(string);
        this.setCanonicalizer(string2);
        this.setSignatureMethod(string3);
    }

    public TemplateGenerator(Document document, String string, String string2, String string3, KeyInfoGenerator keyInfoGenerator) {
        this();
        this.setDocument(document);
        this.setDefaultDigestMethod(string);
        this.setCanonicalizer(string2);
        this.setSignatureMethod(string3);
        this.setKeyInfoGenerator(keyInfoGenerator);
    }

    public void setDefaultDigestMethod(String string) {
        this.defaultDigestAlgorithm = string;
    }

    public Reference createReference(String string) {
        Reference reference = new Reference(this, string, null);
        reference.setDigestMethod(this.defaultDigestAlgorithm);
        return reference;
    }

    public Reference createReference(Element element) {
        String string = element.getAttribute("Id");
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("This Object element has no Id attribute.");
        }
        Reference reference = new Reference(this, "#" + string, element);
        reference.setDigestMethod(this.defaultDigestAlgorithm);
        return reference;
    }

    public Reference createReference(Element element, String string) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("This Object element has no Id attribute.");
        }
        Reference reference = new Reference(this, "#" + string, element);
        reference.setDigestMethod(this.defaultDigestAlgorithm);
        return reference;
    }

    public Element wrapWithObject(Node node, String string) {
        Element element = this.createElementNS("dsig:Object");
        TemplateGenerator.fixupNamespace(element);
        element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "");
        element.setAttributeNS(null, "Id", string);
        if (this.factory != node.getOwnerDocument()) {
            if (node.getNodeType() == 9) {
                for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                    if (node2.getNodeType() == 10) continue;
                    element.appendChild(this.factory.importNode(node2, true));
                }
            } else {
                element.appendChild(this.factory.importNode(node, true));
            }
        } else {
            element.appendChild(node);
        }
        return element;
    }

    public void addReference(Reference reference) {
        if (reference == null) {
            throw new NullPointerException();
        }
        if (this.objects == null) {
            this.objects = new Vector();
        }
        this.objects.addElement(reference);
    }

    public void removeAllReferences() {
        if (this.objects != null) {
            this.objects.removeAllElements();
        }
    }

    public void setCanonicalizer(String string) {
        this.c11r = string;
    }

    public void setSignatureMethod(String string) {
        this.signatureMethod = string;
    }

    public void setSignatureMethodParameter(AlgorithmParameterSpec algorithmParameterSpec) {
        this.signatureSpec = algorithmParameterSpec;
    }

    public void setKeyInfoGenerator(KeyInfoGenerator keyInfoGenerator) {
        this.keyGen = keyInfoGenerator;
    }

    public void setDocument(Document document) {
        this.factory = document;
    }

    public Document getDocument() {
        return this.factory;
    }

    public void setPrefix(String string) {
        this.prefix = string;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setIndentation(boolean bl) {
        this.doIndent = bl;
    }

    public boolean doIndentation() {
        return this.doIndent;
    }

    public void setUnit(int n) {
        this.indentUnit = n;
    }

    public int getUnit() {
        return this.indentUnit;
    }

    public synchronized Element getSignedInfoElement() {
        try {
            return this.getSignedInfoElement(null);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("Internal Error: " + noSuchAlgorithmException.getMessage());
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new RuntimeException("Internal Error: " + noSuchProviderException.getMessage());
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new RuntimeException("Internal Error: " + invalidAlgorithmParameterException.getMessage());
        }
    }

    public synchronized Element getSignedInfoElement(AlgorithmFactory algorithmFactory) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException {
        if (this.signedInfoElement != null) {
            return this.signedInfoElement;
        }
        this.signatureElement = this.createElementNS("Signature");
        TemplateGenerator.fixupNamespace(this.signatureElement);
        DOMUtil.addIndent(this.signatureElement, this, 1);
        this.signedInfoElement = this.createElementNS("SignedInfo");
        this.signatureElement.appendChild(this.signedInfoElement);
        Element element = this.signedInfoElement;
        DOMUtil.addIndent(element, this, 2);
        if (this.c11r == null) {
            throw new RuntimeException("You must specify a CanonicalizationMethod in this implementation.");
        }
        Element element2 = this.createElementNS("CanonicalizationMethod");
        element2.setAttributeNS(null, "Algorithm", this.c11r);
        element.appendChild(element2);
        DOMUtil.addIndent(element, this, 2);
        if (this.signatureMethod == null) {
            throw new RuntimeException("You must specify a SignatureMethod.");
        }
        Element element3 = this.createElementNS("SignatureMethod");
        element3.setAttributeNS(null, "Algorithm", this.signatureMethod);
        element.appendChild(element3);
        if (algorithmFactory != null && this.signatureSpec != null) {
            algorithmFactory.marshalParameter(this.signatureMethod, this.signatureSpec, element3);
        }
        DOMUtil.addIndent(element, this, 2);
        if (this.objects == null || this.objects.size() == 0) {
            throw new RuntimeException("No resources are registered.");
        }
        for (int i = 0; i < this.objects.size(); ++i) {
            Reference reference = (Reference)this.objects.elementAt(i);
            Element element4 = reference.getReferenceElement(this);
            element.appendChild(element4);
            DOMUtil.addIndent(element, this, i == this.objects.size() - 1 ? 1 : 2);
        }
        return element;
    }

    public synchronized Element getManifestElement() {
        if (this.manifestElement != null) {
            return this.manifestElement;
        }
        this.manifestElement = this.createElementNS("Manifest");
        TemplateGenerator.fixupNamespace(this.manifestElement);
        DOMUtil.addIndent(this.manifestElement, this, 2);
        if (this.objects == null || this.objects.size() == 0) {
            throw new RuntimeException("No resources are registered.");
        }
        for (int i = 0; i < this.objects.size(); ++i) {
            Reference reference = (Reference)this.objects.elementAt(i);
            Element element = reference.getReferenceElement(this);
            this.manifestElement.appendChild(element);
            DOMUtil.addIndent(this.manifestElement, this, i == this.objects.size() - 1 ? 1 : 2);
        }
        return this.manifestElement;
    }

    public synchronized Element getSignatureElement() {
        try {
            return this.getSignatureElement(null);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("Internal Error: " + noSuchAlgorithmException.getMessage());
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new RuntimeException("Internal Error: " + noSuchProviderException.getMessage());
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new RuntimeException("Internal Error: " + invalidAlgorithmParameterException.getMessage());
        }
    }

    public synchronized Element getSignatureElement(AlgorithmFactory algorithmFactory) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException {
        if (this.signatureElement != null) {
            return this.signatureElement;
        }
        this.getSignedInfoElement(algorithmFactory);
        Element element = this.signatureElement;
        DOMUtil.addIndent(element, this, 1);
        element.appendChild(this.createElementNS("SignatureValue"));
        if (this.keyGen != null) {
            DOMUtil.addIndent(element, this, 1);
            element.appendChild(this.keyGen.getKeyInfoElement(this.factory));
        }
        Vector<Element> vector = new Vector<Element>(this.objects.size());
        for (int i = 0; i < this.objects.size(); ++i) {
            Element element2;
            Reference reference = (Reference)this.objects.elementAt(i);
            if (!reference.isEnvelopedObject() || TemplateGenerator.contains(vector, element2 = reference.getObjectElement())) continue;
            vector.addElement(element2);
            DOMUtil.addIndent(element, this, 1);
            element.appendChild(element2);
        }
        DOMUtil.addIndent(element, this, 0);
        return element;
    }

    private static boolean contains(Vector vector, Object object) {
        for (int i = 0; i < vector.size(); ++i) {
            if (vector.elementAt(i) != object) continue;
            return true;
        }
        return false;
    }

    final Element createElementNS(String string) {
        int n = string.indexOf(58);
        if (n >= 0 || this.prefix == null || this.prefix.length() == 0) {
            return this.factory.createElementNS("http://www.w3.org/2000/09/xmldsig#", string);
        }
        return this.factory.createElementNS("http://www.w3.org/2000/09/xmldsig#", this.prefix + ":" + string);
    }

    private static void fixupNamespace(Element element) {
        String string = element.getPrefix();
        if (string == null) {
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", element.getNamespaceURI());
        } else {
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + string, element.getNamespaceURI());
        }
    }
}

