/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xss4j.dsig;

import com.ibm.ws.wssecurity.xss4j.domutil.XPathCanonicalizer;
import com.ibm.ws.wssecurity.xss4j.dsig.IDResolver;
import com.ibm.ws.wssecurity.xss4j.dsig.SignatureContext;
import com.ibm.ws.wssecurity.xss4j.dsig.TransformException;
import com.ibm.ws.wssecurity.xss4j.dsig.URITransportSetter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class TransformContext
implements URITransportSetter.Receiver {
    private SignatureContext scontext;
    private byte[] content;
    private String encoding;
    private Node node;
    private NodeList nodeset;
    private String uri;
    private int type;
    public static final int TYPE_BINARY = 0;
    public static final int TYPE_URI = 1;
    public static final int TYPE_NODESET = 2;
    public static final int TYPE_NODE = 3;

    private TransformContext(SignatureContext signatureContext) {
        this.scontext = signatureContext;
        this.clearData();
    }

    private void clearData() {
        this.content = null;
        this.encoding = null;
        this.node = null;
        this.nodeset = null;
        this.uri = null;
    }

    TransformContext(SignatureContext signatureContext, byte[] byArray, String string) {
        this(signatureContext);
        this.content = byArray;
        this.encoding = string;
        this.type = 0;
    }

    public TransformContext(SignatureContext signatureContext, Node node) {
        this(signatureContext);
        this.node = node;
        this.type = 3;
    }

    TransformContext(SignatureContext signatureContext, String string) {
        this(signatureContext);
        this.uri = string;
        this.type = 1;
    }

    TransformContext(SignatureContext signatureContext, NodeList nodeList) {
        this(signatureContext);
        this.nodeset = nodeList;
        this.type = 2;
    }

    public int getType() {
        return this.type;
    }

    public boolean isOctetsOrURI() {
        return this.type == 0 || this.type == 1;
    }

    public void setContent(byte[] byArray, String string) {
        this.clearData();
        this.content = byArray;
        this.encoding = string;
        this.type = 0;
    }

    public void setContent(NodeList nodeList) {
        this.clearData();
        this.nodeset = nodeList;
        this.type = 2;
    }

    public byte[] getOctets() throws TransformException {
        switch (this.type) {
            case 3: {
                this.content = XPathCanonicalizer.serializeSubset(this.node, false);
                this.encoding = "UTF-8";
                this.node = null;
                this.type = 0;
                break;
            }
            case 2: {
                this.content = XPathCanonicalizer.serializeSubset(this.nodeset, false);
                this.encoding = "UTF-8";
                this.nodeset = null;
                this.type = 0;
                break;
            }
            case 1: {
                try {
                    URITransportSetter.getContent(this.uri, this.getEntityResolver(), this);
                    break;
                }
                catch (IOException iOException) {
                    throw TransformException.create(iOException);
                }
            }
        }
        return this.content;
    }

    public String getEncoding() throws TransformException {
        this.getOctets();
        return this.encoding;
    }

    public Node getNode() throws TransformException {
        if (this.type != 3) {
            throw new RuntimeException("Internal Error: Type mismatch: requested=TYPE_NODE, type=" + this.type);
        }
        return this.node;
    }

    public NodeList getNodeset() throws TransformException {
        switch (this.type) {
            case 0: 
            case 1: {
                return XPathCanonicalizer.toNodeset(this.getDocument(), null, true);
            }
            case 3: {
                Node node = this.getNode();
                if (node.getNodeType() == 9) {
                    return XPathCanonicalizer.toNodeset(node, null, true);
                }
                return XPathCanonicalizer.toNodeset(node, null, false);
            }
            case 2: {
                return this.nodeset;
            }
        }
        throw new RuntimeException("Internal Error: Unknown type: type=" + this.type);
    }

    public Document getDocument() throws TransformException {
        Document document;
        try {
            InputSource inputSource = null;
            if (this.type == 1) {
                if (this.getEntityResolver() != null) {
                    try {
                        inputSource = this.getEntityResolver().resolveEntity(null, this.uri);
                    }
                    catch (SAXException sAXException) {
                        // empty catch block
                    }
                }
                if (inputSource == null) {
                    inputSource = new InputSource(this.uri);
                }
            } else {
                inputSource = new InputSource(new ByteArrayInputStream(this.getOctets()));
                if (this.getEncoding() != null) {
                    inputSource.setEncoding(this.getEncoding());
                }
            }
            document = this.scontext.parse(inputSource);
        }
        catch (IOException iOException) {
            throw TransformException.create(iOException);
        }
        catch (SAXException sAXException) {
            throw TransformException.create(sAXException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw TransformException.create(parserConfigurationException);
        }
        return document;
    }

    public SignatureContext getSignatureContext() {
        return this.scontext;
    }

    public EntityResolver getEntityResolver() {
        return this.scontext.getEntityResolver();
    }

    public IDResolver getIDResolver() {
        return this.scontext.getIDResolver();
    }

    public Element getSignatureElement() {
        return this.scontext.getSignatureElement();
    }

    public boolean isDebug() {
        return this.scontext.isDebug();
    }
}

