/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xss4j.dsig;

import com.ibm.ws.wssecurity.xss4j.AlgorithmFactory;
import com.ibm.ws.wssecurity.xss4j.domutil.DOMUtil;
import com.ibm.ws.wssecurity.xss4j.dsig.Canonicalizer;
import com.ibm.ws.wssecurity.xss4j.dsig.IDResolver;
import com.ibm.ws.wssecurity.xss4j.dsig.ProcessKey;
import com.ibm.ws.wssecurity.xss4j.dsig.ReferenceProcessor;
import com.ibm.ws.wssecurity.xss4j.dsig.ReferenceValidity;
import com.ibm.ws.wssecurity.xss4j.dsig.SignatureContext;
import com.ibm.ws.wssecurity.xss4j.dsig.SignatureStructureException;
import com.ibm.ws.wssecurity.xss4j.dsig.TransformException;
import com.ibm.ws.wssecurity.xss4j.dsig.Validity;
import com.ibm.ws.wssecurity.xss4j.dsig.ValidityDOM;
import com.ibm.ws.wssecurity.xss4j.dsig.util.Base64;
import com.ibm.ws.wssecurity.xss4j.dsig.util.HWKeyCache;
import com.ibm.wsspi.wssecurity.SignatureEngine;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.util.Hashtable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XSignature {
    static final boolean DEBUG = false;
    public static final String XMLDSIG_NAMESPACE = "http://www.w3.org/2000/09/xmldsig#";
    static final String XMLNS_NS = "http://www.w3.org/2000/xmlns/";
    public static final String TYPE_MANIFEST = "http://www.w3.org/2000/09/xmldsig#Manifest";
    public static final String TYPE_OBJECT = "http://www.w3.org/2000/09/xmldsig#Object";
    public static final String SHA1 = "http://www.w3.org/2000/09/xmldsig#sha1";
    public static long signTime = 0L;
    public static long canonicalizeTime = 0L;

    private XSignature() {
    }

    static final Element getFirstChild(Node node, String string) {
        return DOMUtil.getFirstChildElementNamed(node, XMLDSIG_NAMESPACE, string);
    }

    static final boolean isDsigElement(Element element) {
        String string = element.getNamespaceURI();
        if (string == null) {
            return false;
        }
        return string.equals(XMLDSIG_NAMESPACE);
    }

    static final boolean isDsigElement(Element element, String string) {
        String string2 = element.getNamespaceURI();
        if (string2 == null) {
            return false;
        }
        return string2.equals(XMLDSIG_NAMESPACE) && element.getLocalName().equals(string);
    }

    static byte[] getSignedInfoOctets(SignatureContext signatureContext, Element element) throws SignatureStructureException, NoSuchAlgorithmException, IOException {
        Element element2 = XSignature.getFirstChild(element, "CanonicalizationMethod");
        if (element2 == null) {
            throw new SignatureStructureException("No CanonicalizationMethod element.  This implementation always requires a CanonicalizationMethod.");
        }
        String string = element2.getAttribute("Algorithm");
        if (string == null || string.length() == 0) {
            throw new SignatureStructureException("No Algorithm attribute in the CanonicalizationMethod element.");
        }
        AlgorithmFactory algorithmFactory = signatureContext.getAlgorithmFactory();
        Canonicalizer canonicalizer = algorithmFactory.getCanonicalizer(string);
        if (canonicalizer == null) {
            throw new NoSuchAlgorithmException("No canonicalization algorithm: " + string);
        }
        canonicalizer.setParameter(DOMUtil.getFirstChildElement(element2));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        long l = System.currentTimeMillis();
        canonicalizer.canonicalize(element, byteArrayOutputStream);
        canonicalizeTime += System.currentTimeMillis() - l;
        byteArrayOutputStream.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        if (signatureContext.getResourceShower() != null) {
            signatureContext.getResourceShower().showSignedResource(signatureContext.getOwnerElement(), -1, "_SignedInfo_", null, byArray, null);
        }
        return byArray;
    }

    static SignatureEngine getSignatureEngine(Element element, AlgorithmFactory algorithmFactory) throws SignatureStructureException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, NoSuchProviderException {
        Element element2 = XSignature.getFirstChild(element, "SignatureMethod");
        if (element2 == null) {
            throw new SignatureStructureException("No SignatureMethod element.");
        }
        String string = element2.getAttribute("Algorithm");
        if (string == null || string.length() == 0) {
            throw new SignatureStructureException("No Algorithm attribute in the SignatureMethod element.");
        }
        AlgorithmParameterSpec algorithmParameterSpec = algorithmFactory.unmarshalParameter(string, element2);
        SignatureEngine signatureEngine = algorithmFactory.getSignatureEngine(string);
        signatureEngine.setParameter(algorithmParameterSpec);
        return signatureEngine;
    }

    public static void resetDigestTime() {
        ReferenceProcessor.digestTime = 0L;
    }

    public static long getDigestTime() {
        return ReferenceProcessor.digestTime;
    }

    static void calculateSignatureValue(Element element, SignatureEngine signatureEngine, Key key, byte[] byArray) throws SignatureStructureException, InvalidKeyException, SignatureException {
        long l = System.currentTimeMillis();
        signatureEngine.initSign(key);
        signatureEngine.update(byArray);
        byte[] byArray2 = signatureEngine.sign();
        signTime += System.currentTimeMillis() - l;
        Element element2 = XSignature.getFirstChild(element, "SignatureValue");
        if (element2 == null) {
            throw new SignatureStructureException("No SignatureValue element.");
        }
        DOMUtil.removeAllChildren(element2);
        String string = Base64.encode(byArray2);
        Node node = element2.getPreviousSibling();
        if (node != null && node.getNodeType() == 3) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = (node.getNodeValue().length() - 1) * 2;
            stringBuffer.append(Base64.format(string, n, "\n", ""));
            for (int i = 0; i < n / 2; ++i) {
                stringBuffer.append(" ");
            }
            string = new String(stringBuffer);
        }
        DOMUtil.appendText(element2, string);
    }

    static boolean verifySignatureValue(Element element, SignatureEngine signatureEngine, Key key, byte[] byArray) throws SignatureStructureException, InvalidKeyException, SignatureException {
        Element element2 = XSignature.getFirstChild(element, "SignatureValue");
        if (element2 == null) {
            throw new SignatureStructureException("No SignatureValue element.");
        }
        byte[] byArray2 = Base64.decode(DOMUtil.getStringValue(element2));
        signatureEngine.initVerify(key);
        signatureEngine.update(byArray);
        boolean bl = signatureEngine.verify(byArray2);
        return bl;
    }

    static Element internalSign(SignatureContext signatureContext, Key key) throws SignatureStructureException, NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException, InvalidKeyException, SignatureException, TransformException, IOException {
        Object object;
        Node node;
        Element element = signatureContext.getSignatureElement();
        IDResolverWrapper iDResolverWrapper = null;
        if (signatureContext.getUseInternalIDResolver()) {
            iDResolverWrapper = new IDResolverWrapper(element.getOwnerDocument(), signatureContext.getIDResolver());
            node = DOMUtil.getFirstChild2(element);
            while (node != null) {
                Element element2;
                if (node.getNodeType() == 1 && XSignature.isDsigElement(element2 = (Element)node) && XSignature.isDsigElement(element2, "Object") && (object = element2.getAttribute("Id")) != null && ((String)object).length() != 0) {
                    iDResolverWrapper.registerID((String)object, element2);
                }
                node = DOMUtil.getNextSibling2(node);
            }
            signatureContext.setWrappedIDResolver(iDResolverWrapper);
        }
        if ((node = DOMUtil.getFirstChildElement(element)) == null) {
            throw new SignatureStructureException("No SignedInfo element.");
        }
        int n = 0;
        object = XSignature.getFirstChild(node, "Reference");
        while (object != null) {
            if (!XSignature.isDsigElement((Element)object, "Reference")) {
                throw new SignatureStructureException("A Reference element is expected: " + object.getNodeName());
            }
            ReferenceProcessor.substDigest(signatureContext, (Element)object, n++);
            object = DOMUtil.getNextElement((Node)object);
        }
        object = XSignature.getSignedInfoOctets(signatureContext, (Element)node);
        if (key != null) {
            AlgorithmFactory algorithmFactory = signatureContext.getAlgorithmFactory();
            SignatureEngine signatureEngine = XSignature.getSignatureEngine((Element)node, algorithmFactory);
            try {
                XSignature.calculateSignatureValue(element, signatureEngine, key, (byte[])object);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                HWKeyCache.setCapacityReached();
                XSignature.calculateSignatureValue(element, signatureEngine, key, (byte[])object);
            }
            algorithmFactory.releaseSignatureEngine(signatureEngine);
        }
        return element;
    }

    static Validity internalVerify(SignatureContext signatureContext, Key object) {
        Element element = signatureContext.getSignatureElement();
        IDResolverWrapper iDResolverWrapper = null;
        if (signatureContext.getUseInternalIDResolver()) {
            iDResolverWrapper = new IDResolverWrapper(element.getOwnerDocument(), signatureContext.getIDResolver());
        }
        ValidityDOM validityDOM = new ValidityDOM();
        try {
            Object object2;
            Object object3 = DOMUtil.getFirstChild2(element);
            while (object3 != null) {
                if (object3.getNodeType() == 1 && XSignature.isDsigElement((Element)(object2 = (Element)object3))) {
                    String string;
                    if (XSignature.isDsigElement((Element)object2, "KeyInfo")) {
                        if (object == null) {
                            object = ProcessKey.processKeyInfo(signatureContext, (Element)object2);
                        }
                    } else if (XSignature.isDsigElement((Element)object2, "Object") && iDResolverWrapper != null && (string = object2.getAttribute("Id")) != null && string.length() != 0) {
                        iDResolverWrapper.registerID(string, (Element)object2);
                    }
                }
                object3 = DOMUtil.getNextSibling2((Node)object3);
            }
            if (object == null) {
                throw new SignatureStructureException("No KeyInfo element.");
            }
            if (signatureContext.isHWAccelerationProvider() && (object2 = (PublicKey)((HWKeyCache)(object3 = HWKeyCache.getInstance())).translate((Key)object)) != null) {
                object = object2;
            }
            signatureContext.setWrappedIDResolver(iDResolverWrapper);
            XSignature.verify2(signatureContext, validityDOM, (Key)object);
        }
        catch (SignatureStructureException signatureStructureException) {
            validityDOM.setSignedInfoMessage(signatureStructureException.getMessage());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            validityDOM.setSignedInfoMessage(noSuchAlgorithmException.getMessage());
        }
        catch (CertificateException certificateException) {
            validityDOM.setSignedInfoMessage(certificateException.getMessage());
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            validityDOM.setSignedInfoMessage(invalidKeySpecException.getMessage());
        }
        catch (IOException iOException) {
            validityDOM.setSignedInfoMessage(iOException.getMessage());
        }
        catch (TransformException transformException) {
            validityDOM.setSignedInfoMessage(transformException.getMessage());
        }
        catch (Exception exception) {
            validityDOM.setSignedInfoMessage(exception.getMessage());
        }
        validityDOM.setCoreValidity();
        return validityDOM;
    }

    private static void verify2(SignatureContext signatureContext, Verifier verifier, Key key) {
        boolean bl = false;
        try {
            Object object;
            Element element = signatureContext.getSignatureElement();
            Element element2 = DOMUtil.getFirstChildElement(element);
            if (element2 == null) {
                throw new SignatureStructureException("No SignedInfo element.");
            }
            int n = 0;
            Object object2 = XSignature.getFirstChild(element2, "Reference");
            while (object2 != null) {
                if (!XSignature.isDsigElement((Element)object2, "Reference")) {
                    throw new SignatureStructureException("A Reference element is expected: " + object2.getNodeName());
                }
                object = ReferenceProcessor.verify(signatureContext, (Element)object2, n++);
                verifier.addReferenceValidity((ReferenceValidity)object);
                object2 = DOMUtil.getNextElement((Node)object2);
            }
            object2 = signatureContext.getAlgorithmFactory();
            object = XSignature.getSignedInfoOctets(signatureContext, element2);
            SignatureEngine signatureEngine = XSignature.getSignatureEngine(element2, (AlgorithmFactory)object2);
            try {
                bl = XSignature.verifySignatureValue(element, signatureEngine, key, object);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                if (signatureContext.isHWAccelerationProvider()) {
                    HWKeyCache.setCapacityReached();
                    object = XSignature.getSignedInfoOctets(signatureContext, element2);
                    bl = XSignature.verifySignatureValue(element, signatureEngine, key, object);
                }
                throw outOfMemoryError;
            }
            ((AlgorithmFactory)object2).releaseSignatureEngine(signatureEngine);
            if (!bl) {
                verifier.setSignedInfoMessage("SignatureValue mismatched.");
            }
        }
        catch (Exception exception) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            exception.printStackTrace(printWriter);
            printWriter.close();
            verifier.setSignedInfoMessage(stringWriter.toString());
        }
        verifier.setSignedInfoValidity(bl);
    }

    static class IDResolverWrapper
    implements IDResolver {
        IDResolver next;
        Hashtable hash;
        Document doc;

        IDResolverWrapper(Document document, IDResolver iDResolver) {
            this.doc = document;
            this.next = iDResolver;
            this.hash = null;
        }

        void registerID(String string, Element element) {
            if (this.hash == null) {
                this.hash = new Hashtable();
            }
            this.hash.put(string, element);
        }

        public Element resolveID(Document document, String string) {
            Element element = null;
            if (document == this.doc && this.hash != null && (element = (Element)this.hash.get(string)) != null) {
                return element;
            }
            if (this.next == null) {
                return null;
            }
            return this.next.resolveID(document, string);
        }
    }

    static interface Verifier {
        public void addReferenceValidity(ReferenceValidity var1);

        public void setSignedInfoMessage(String var1);

        public void setSignedInfoValidity(boolean var1);
    }
}

