/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xss4j.dsig.transform;

import com.ibm.ws.wssecurity.xss4j.domutil.XPathCanonicalizer;
import com.ibm.ws.wssecurity.xss4j.dsig.SignatureContext;
import com.ibm.ws.wssecurity.xss4j.dsig.TransformContext;
import com.ibm.ws.wssecurity.xss4j.dsig.TransformException;
import com.ibm.ws.wssecurity.xss4j.dsig.XSignatureException;
import com.ibm.ws.wssecurity.xss4j.dsig.transform.DecryptionTransformer;
import com.ibm.ws.wssecurity.xss4j.enc.DecryptionContext;
import com.ibm.ws.wssecurity.xss4j.enc.KeyInfoResolvingException;
import com.ibm.ws.wssecurity.xss4j.enc.StructureException;
import com.ibm.ws.wssecurity.xss4j.enc.util.Util;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BinaryDecryptionTransformer
extends DecryptionTransformer {
    private static final boolean DEBUG = false;

    private void decryptBinary(SignatureContext signatureContext, NodeList nodeList, OutputStream outputStream) throws BadPaddingException, IOException, IllegalBlockSizeException, InvalidAlgorithmParameterException, InvalidKeyException, KeyInfoResolvingException, NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException, StructureException, XSignatureException {
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (!this.isEncryptedData(node)) continue;
            this.decryptEncryptedData(signatureContext, (Element)node, outputStream);
        }
    }

    private void decryptEncryptedData(SignatureContext signatureContext, Element element, OutputStream outputStream) throws BadPaddingException, IOException, IllegalBlockSizeException, InvalidAlgorithmParameterException, InvalidKeyException, KeyInfoResolvingException, NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException, StructureException, XSignatureException {
        DecryptionContext decryptionContext = this.createDecryptionContext(signatureContext);
        decryptionContext.setEncryptedType(element, null, null, null);
        decryptionContext.decrypt();
        Util.getBytes((InputStream)decryptionContext.getData(), outputStream);
    }

    public String getURI() {
        return "http://www.w3.org/2002/07/decrypt#Binary";
    }

    public void transform(TransformContext transformContext) throws TransformException {
        NodeList nodeList = null;
        switch (transformContext.getType()) {
            case 0: 
            case 1: {
                nodeList = XPathCanonicalizer.toNodeset(transformContext.getDocument(), null, true);
                break;
            }
            case 3: {
                nodeList = XPathCanonicalizer.toNodeset(transformContext.getNode(), null, true);
                break;
            }
            case 2: {
                nodeList = transformContext.getNodeset();
            }
        }
        byte[] byArray = null;
        if (nodeList != null) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                this.decryptBinary(transformContext.getSignatureContext(), nodeList, byteArrayOutputStream);
                byteArrayOutputStream.close();
                byArray = byteArrayOutputStream.toByteArray();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                Exception exception2;
                Exception exception3;
                if (exception instanceof XSignatureException && (exception3 = ((XSignatureException)exception).getException()) != null) {
                    exception2 = exception3;
                }
                throw new TransformException(exception2.getMessage());
            }
        }
        transformContext.setContent(byArray, null);
    }
}

