/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xss4j.dsig.transform;

import com.ibm.ws.wssecurity.xss4j.domutil.ExclusiveCanonicalizer;
import com.ibm.ws.wssecurity.xss4j.dsig.Canonicalizer;
import com.ibm.ws.wssecurity.xss4j.dsig.Transform;
import com.ibm.ws.wssecurity.xss4j.dsig.TransformContext;
import com.ibm.ws.wssecurity.xss4j.dsig.TransformException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Hashtable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ExclusiveC11r
extends Transform
implements Canonicalizer {
    boolean wc = false;
    Hashtable prefixList = null;
    public static final String NS = "http://www.w3.org/2001/10/xml-exc-c14n#";

    public void setParameter(Node node) {
        if (node == null) {
            this.prefixList = null;
            return;
        }
        if (node.getNodeType() != 1) {
            throw new IllegalArgumentException("The parameter must be an element.");
        }
        Element element = (Element)node;
        if (element.getNamespaceURI() == null || !element.getNamespaceURI().equals(NS)) {
            throw new IllegalArgumentException("The parameter must belong to the 'http://www.w3.org/2001/10/xml-exc-c14n#' namespace.");
        }
        if (!element.getLocalName().equals("InclusiveNamespaces")) {
            throw new IllegalArgumentException("The parameter element must be 'InclusiveNamespaces'.");
        }
        String string = element.getAttribute("PrefixList");
        this.prefixList = ExclusiveCanonicalizer.parsePrefixList(string);
    }

    public String getURI() {
        return NS;
    }

    public String getType() {
        return null;
    }

    public String getCharset() {
        return null;
    }

    public void transform(TransformContext transformContext) throws TransformException {
        switch (transformContext.getType()) {
            case 0: 
            case 1: {
                byte[] byArray = ExclusiveCanonicalizer.serializeAll(this.prefixList, transformContext.getDocument(), this.wc);
                transformContext.setContent(byArray, "UTF-8");
                break;
            }
            case 3: {
                byte[] byArray = ExclusiveCanonicalizer.serializeSubset(this.prefixList, transformContext.getNode(), this.wc);
                transformContext.setContent(byArray, "UTF-8");
                break;
            }
            case 2: {
                byte[] byArray = ExclusiveCanonicalizer.serializeSubset(this.prefixList, transformContext.getNodeset(), this.wc);
                transformContext.setContent(byArray, "UTF-8");
                break;
            }
            default: {
                throw new RuntimeException("Internal Error: Unknown type: " + transformContext.getType());
            }
        }
    }

    public void canonicalize(Node node, OutputStream outputStream) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
        ExclusiveCanonicalizer.serializeSubset(this.prefixList, node, this.wc, (Writer)outputStreamWriter);
        ((Writer)outputStreamWriter).flush();
    }
}

