/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xss4j.dsig.transform;

import com.ibm.ws.wssecurity.xss4j.domutil.XPathCanonicalizer;
import com.ibm.ws.wssecurity.xss4j.dsig.Canonicalizer;
import com.ibm.ws.wssecurity.xss4j.dsig.Transform;
import com.ibm.ws.wssecurity.xss4j.dsig.TransformContext;
import com.ibm.ws.wssecurity.xss4j.dsig.TransformException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.w3c.dom.Node;

public class W3CCanonicalizer2
extends Transform
implements Canonicalizer {
    public String getURI() {
        return "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
    }

    public String getType() {
        return null;
    }

    public String getCharset() {
        return null;
    }

    public void transform(TransformContext transformContext) throws TransformException {
        switch (transformContext.getType()) {
            case 0: 
            case 1: {
                byte[] byArray = XPathCanonicalizer.serializeAll(transformContext.getDocument(), false);
                transformContext.setContent(byArray, "UTF-8");
                break;
            }
            case 3: {
                byte[] byArray = XPathCanonicalizer.serializeSubset(transformContext.getNode(), false);
                transformContext.setContent(byArray, "UTF-8");
                break;
            }
            case 2: {
                byte[] byArray = XPathCanonicalizer.serializeSubset(transformContext.getNodeset(), false);
                transformContext.setContent(byArray, "UTF-8");
                break;
            }
            default: {
                throw new RuntimeException("Internal Error: Unknown type: " + transformContext.getType());
            }
        }
    }

    public void canonicalize(Node node, OutputStream outputStream) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
        XPathCanonicalizer.serializeSubset(node, false, (Writer)outputStreamWriter);
        ((Writer)outputStreamWriter).flush();
    }
}

