/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xss4j.dsig.transform;

import com.ibm.ws.wssecurity.xss4j.domutil.XPathCanonicalizer;
import com.ibm.ws.wssecurity.xss4j.dsig.SignatureContext;
import com.ibm.ws.wssecurity.xss4j.dsig.TransformContext;
import com.ibm.ws.wssecurity.xss4j.dsig.TransformException;
import com.ibm.ws.wssecurity.xss4j.dsig.XSignatureException;
import com.ibm.ws.wssecurity.xss4j.dsig.transform.DecryptionTransformer;
import com.ibm.ws.wssecurity.xss4j.enc.DecryptionContext;
import com.ibm.ws.wssecurity.xss4j.enc.KeyInfoResolvingException;
import com.ibm.ws.wssecurity.xss4j.enc.StructureException;
import com.ibm.ws.wssecurity.xss4j.enc.util.DOMUtil;
import com.ibm.ws.wssecurity.xss4j.enc.util.Util;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.HashSet;
import java.util.Set;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLDecryptionTransformer
extends DecryptionTransformer {
    private static final boolean DEBUG = false;
    private boolean fReplace;
    private boolean fContinue;
    private Set fFailedEncryptedData = new HashSet();

    public void setReplaceEncryptedData(boolean bl) {
        this.fReplace = bl;
    }

    public void setContinueProcessing(boolean bl) {
        this.fContinue = bl;
    }

    private boolean containsEncryptedData(NodeList nodeList) throws StructureException {
        return this.getIndexOfEncryptedData(nodeList) >= 0;
    }

    private NodeList cloneNodeSet(NodeList nodeList, TransformContext transformContext) throws TransformException {
        byte[] byArray = XPathCanonicalizer.serializeSubset(nodeList, true);
        byArray = DecryptionContext.wrapData(byArray, nodeList.item(0));
        Element element = this.parseOctets(byArray, transformContext).getDocumentElement();
        return this.convertToNodeSet(element);
    }

    private NodeList decryptIncludedNodes(NodeList nodeList, TransformContext transformContext) throws Exception {
        while (true) {
            if (!this.isSingleRooted(nodeList)) {
                throw new TransformException("Not single-rooted node-set");
            }
            int n = this.getIndexOfEncryptedData(nodeList);
            if (n < 0) break;
            try {
                nodeList = this.decrypt(nodeList, n, transformContext);
            }
            catch (Exception exception) {
                if (!this.fContinue) {
                    throw exception;
                }
                Exception exception2 = this.getInnerException(exception);
                this.fFailedEncryptedData.add(nodeList.item(n));
            }
        }
        return nodeList;
    }

    private boolean isSingleRooted(NodeList nodeList) {
        boolean bl = true;
        if (nodeList.getLength() > 0) {
            Node node = nodeList.item(0);
            int n = nodeList.getLength();
            for (int i = 1; i < n; ++i) {
                if (DOMUtil.isDescendantNode(nodeList.item(i), node)) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    private int getIndexOfEncryptedData(NodeList nodeList) throws StructureException {
        int n = -1;
        int n2 = nodeList.getLength();
        for (int i = 0; i < n2; ++i) {
            if (!this.isEncryptedData(nodeList.item(i))) continue;
            n = i;
            break;
        }
        return n;
    }

    boolean isEncryptedData(Node node) throws StructureException {
        return super.isEncryptedData(node) && !this.fFailedEncryptedData.contains(node);
    }

    private NodeList decrypt(NodeList nodeList, int n, TransformContext transformContext) throws BadPaddingException, IOException, IllegalBlockSizeException, InvalidAlgorithmParameterException, InvalidKeyException, KeyInfoResolvingException, NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException, ParserConfigurationException, SAXException, StructureException, TransformException, XSignatureException {
        int n2 = this.getIndexOfNextNode(nodeList, n);
        NodeList nodeList2 = this.getSubNodeSet(nodeList, n, n2);
        nodeList2 = this.decryptEncryptedData(nodeList2, n == 0, transformContext);
        return this.replaceSubNodeSet(nodeList, n, n2, nodeList2);
    }

    private int getIndexOfNextNode(NodeList nodeList, int n) {
        int n2;
        Node node = nodeList.item(n);
        int n3 = nodeList.getLength();
        for (n2 = n + 1; n2 < n3 && DOMUtil.isDescendantNode(nodeList.item(n2), node); ++n2) {
        }
        return n2;
    }

    private NodeList getSubNodeSet(NodeList nodeList, int n, int n2) {
        DOMUtil.NodeListImpl nodeListImpl = new DOMUtil.NodeListImpl();
        for (int i = n; i < n2; ++i) {
            nodeListImpl.add(nodeList.item(i));
        }
        return nodeListImpl;
    }

    private NodeList decryptEncryptedData(NodeList nodeList, boolean bl, TransformContext transformContext) throws BadPaddingException, IOException, IllegalBlockSizeException, InvalidAlgorithmParameterException, InvalidKeyException, KeyInfoResolvingException, NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException, ParserConfigurationException, SAXException, StructureException, TransformException, XSignatureException {
        byte[] byArray = XPathCanonicalizer.serializeSubset(nodeList, false);
        byArray = this.decryptEncryptedData(transformContext.getSignatureContext(), byArray, bl);
        byArray = DecryptionContext.wrapData(byArray, nodeList.item(0));
        Element element = this.parseOctets(byArray, transformContext).getDocumentElement();
        element = (Element)nodeList.item(0).getOwnerDocument().importNode(element, true);
        return this.convertToNodeSet(element);
    }

    private byte[] decryptEncryptedData(SignatureContext signatureContext, byte[] byArray, boolean bl) throws BadPaddingException, IOException, IllegalBlockSizeException, InvalidAlgorithmParameterException, InvalidKeyException, KeyInfoResolvingException, NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException, ParserConfigurationException, SAXException, StructureException, XSignatureException {
        DecryptionContext decryptionContext = this.createDecryptionContext(signatureContext);
        decryptionContext.setEncryptedType(new ByteArrayInputStream(byArray), null, null, null);
        decryptionContext.decrypt();
        String string = decryptionContext.getType();
        if (string == null) {
            throw new StructureException("Type attribute not specified");
        }
        if (!string.equals("http://www.w3.org/2001/04/xmlenc#Element")) {
            if (string.equals("http://www.w3.org/2001/04/xmlenc#Content")) {
                if (bl) {
                    throw new StructureException("Wrong type: " + string);
                }
            } else {
                throw new StructureException("Unknown type: " + string);
            }
        }
        return Util.getBytes((InputStream)decryptionContext.getData());
    }

    private Document parseOctets(byte[] byArray, TransformContext transformContext) throws TransformException {
        transformContext.setContent(byArray, "UTF-8");
        return transformContext.getDocument();
    }

    private NodeList convertToNodeSet(Node node) {
        DOMUtil.NodeListImpl nodeListImpl = new DOMUtil.NodeListImpl();
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            NodeList nodeList = XPathCanonicalizer.toNodeset(node2, null, true);
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                nodeListImpl.add(nodeList.item(i));
            }
        }
        return nodeListImpl;
    }

    private NodeList replaceSubNodeSet(NodeList nodeList, int n, int n2, NodeList nodeList2) {
        int n3;
        DOMUtil.NodeListImpl nodeListImpl = new DOMUtil.NodeListImpl();
        for (n3 = 0; n3 < n; ++n3) {
            nodeListImpl.add(nodeList.item(n3));
        }
        int n4 = nodeList2.getLength();
        for (n3 = 0; n3 < n4; ++n3) {
            nodeListImpl.add(nodeList2.item(n3));
        }
        n4 = nodeList.getLength();
        for (n3 = n2; n3 < n4; ++n3) {
            nodeListImpl.add(nodeList.item(n3));
        }
        Node node = nodeList.item(n);
        Node node2 = node.getParentNode();
        if (node2 != null) {
            Node node3 = nodeList2.item(0);
            Node node4 = node3.getNextSibling();
            node2.replaceChild(node3, node);
            node = node3.getNextSibling();
            node3 = node4;
            while (node3 != null) {
                node4 = node3.getNextSibling();
                node2.insertBefore(node3, node);
                node3 = node4;
            }
        }
        return nodeListImpl;
    }

    private Exception getInnerException(Exception exception) {
        Exception exception2;
        if (exception instanceof SAXException) {
            Exception exception3 = ((SAXException)exception).getException();
            if (exception3 != null) {
                exception = exception3;
            }
        } else if (exception instanceof XSignatureException && (exception2 = ((XSignatureException)exception).getException()) != null) {
            exception = exception2;
        }
        return exception;
    }

    public String getURI() {
        return "http://www.w3.org/2001/04/decrypt#";
    }

    public void transform(TransformContext transformContext) throws TransformException {
        NodeList nodeList = null;
        switch (transformContext.getType()) {
            case 0: 
            case 1: {
                nodeList = XPathCanonicalizer.toNodeset(transformContext.getDocument(), null, true);
                break;
            }
            case 3: {
                nodeList = XPathCanonicalizer.toNodeset(transformContext.getNode(), null, true);
                break;
            }
            case 2: {
                nodeList = transformContext.getNodeset();
            }
        }
        if (nodeList != null) {
            if (!this.isSingleRooted(nodeList)) {
                throw new TransformException("Not single-rooted node-set");
            }
            try {
                if (this.containsEncryptedData(nodeList)) {
                    if (!this.fReplace) {
                        nodeList = this.cloneNodeSet(nodeList, transformContext);
                    }
                    nodeList = this.decryptIncludedNodes(nodeList, transformContext);
                }
            }
            catch (TransformException transformException) {
                throw transformException;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                Exception exception2 = this.getInnerException(exception);
                throw new TransformException(exception2.getMessage());
            }
        }
        transformContext.setContent(nodeList);
    }
}

