/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xss4j.dsig.transform;

import com.ibm.ws.wssecurity.xss4j.domutil.XPathCanonicalizer;
import com.ibm.ws.wssecurity.xss4j.dsig.SignatureContext;
import com.ibm.ws.wssecurity.xss4j.dsig.TransformContext;
import com.ibm.ws.wssecurity.xss4j.dsig.TransformException;
import com.ibm.ws.wssecurity.xss4j.dsig.XSignatureException;
import com.ibm.ws.wssecurity.xss4j.dsig.transform.Canonicalizer;
import com.ibm.ws.wssecurity.xss4j.dsig.transform.DecryptionTransformer;
import com.ibm.ws.wssecurity.xss4j.enc.DecryptionContext;
import com.ibm.ws.wssecurity.xss4j.enc.KeyInfoResolvingException;
import com.ibm.ws.wssecurity.xss4j.enc.StructureException;
import com.ibm.ws.wssecurity.xss4j.enc.util.DOMUtil;
import com.ibm.ws.wssecurity.xss4j.enc.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLDecryptionTransformer2
extends DecryptionTransformer {
    private static final boolean DEBUG = false;

    private NodeList decryptXML(NodeList nodeList, TransformContext transformContext) throws BadPaddingException, IOException, IllegalBlockSizeException, InvalidAlgorithmParameterException, InvalidKeyException, KeyInfoResolvingException, NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException, StructureException, TransformException, XSignatureException {
        Map map = this.decryptNodeSet(nodeList, transformContext);
        byte[] byArray = Canonicalizer.serializeSubset(nodeList, false, map);
        Document document = this.parseOctets(byArray, transformContext);
        return XPathCanonicalizer.toNodeset(document, null, true);
    }

    private Map decryptNodeSet(NodeList nodeList, TransformContext transformContext) throws BadPaddingException, IOException, IllegalBlockSizeException, InvalidAlgorithmParameterException, InvalidKeyException, KeyInfoResolvingException, NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException, StructureException, TransformException, XSignatureException {
        HashMap<Node, NodeList> hashMap = new HashMap<Node, NodeList>();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (!this.isEncryptedData(node)) continue;
            NodeList nodeList2 = this.decryptEncryptedData((Element)node, transformContext);
            hashMap.put(node, nodeList2);
            Map map = this.decryptNodeSet(nodeList2, transformContext);
            hashMap.putAll(map);
        }
        return hashMap;
    }

    private NodeList decryptEncryptedData(Element element, TransformContext transformContext) throws BadPaddingException, IOException, IllegalBlockSizeException, InvalidAlgorithmParameterException, InvalidKeyException, KeyInfoResolvingException, NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException, StructureException, TransformException, XSignatureException {
        byte[] byArray = this.decryptEncryptedData(transformContext.getSignatureContext(), element);
        byArray = DecryptionContext.wrapData(byArray, element);
        Document document = this.parseOctets(byArray, transformContext);
        Element element2 = document.getDocumentElement();
        return this.convertToNodeSet(element2);
    }

    private byte[] decryptEncryptedData(SignatureContext signatureContext, Element element) throws BadPaddingException, IOException, IllegalBlockSizeException, InvalidAlgorithmParameterException, InvalidKeyException, KeyInfoResolvingException, NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException, StructureException, XSignatureException {
        DecryptionContext decryptionContext = this.createDecryptionContext(signatureContext);
        decryptionContext.setEncryptedType(element, null, null, null);
        decryptionContext.decrypt();
        String string = decryptionContext.getType();
        if (string == null) {
            throw new StructureException("Type attribute not specified");
        }
        if (!string.equals("http://www.w3.org/2001/04/xmlenc#Element") && !string.equals("http://www.w3.org/2001/04/xmlenc#Content")) {
            throw new StructureException("Unknown type: " + string);
        }
        return Util.getBytes((InputStream)decryptionContext.getData());
    }

    private Document parseOctets(byte[] byArray, TransformContext transformContext) throws TransformException {
        transformContext.setContent(byArray, "UTF-8");
        return transformContext.getDocument();
    }

    private NodeList convertToNodeSet(Node node) {
        DOMUtil.NodeListImpl nodeListImpl = new DOMUtil.NodeListImpl();
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            NodeList nodeList = XPathCanonicalizer.toNodeset(node2, null, true);
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                nodeListImpl.add(nodeList.item(i));
            }
        }
        return nodeListImpl;
    }

    public String getURI() {
        return "http://www.w3.org/2002/07/decrypt#XML";
    }

    public void transform(TransformContext transformContext) throws TransformException {
        NodeList nodeList = null;
        switch (transformContext.getType()) {
            case 0: 
            case 1: {
                nodeList = XPathCanonicalizer.toNodeset(transformContext.getDocument(), null, true);
                break;
            }
            case 3: {
                nodeList = XPathCanonicalizer.toNodeset(transformContext.getNode(), null, true);
                break;
            }
            case 2: {
                nodeList = transformContext.getNodeset();
            }
        }
        if (nodeList != null) {
            try {
                nodeList = this.decryptXML(nodeList, transformContext);
            }
            catch (TransformException transformException) {
                throw transformException;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                Exception exception2;
                Exception exception3;
                if (exception instanceof XSignatureException && (exception3 = ((XSignatureException)exception).getException()) != null) {
                    exception2 = exception3;
                }
                throw new TransformException(exception2.getMessage());
            }
        }
        transformContext.setContent(nodeList);
    }
}

