/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xss4j.dsig.transform;

import com.ibm.ws.wssecurity.xss4j.domutil.DOMUtil;
import com.ibm.ws.wssecurity.xss4j.domutil.IndentConfig;
import com.ibm.ws.wssecurity.xss4j.domutil.XPathCanonicalizer;
import com.ibm.ws.wssecurity.xss4j.dsig.Transform;
import com.ibm.ws.wssecurity.xss4j.dsig.TransformContext;
import com.ibm.ws.wssecurity.xss4j.dsig.TransformException;
import com.ibm.ws.wssecurity.xss4j.dsig.transform.Enveloped;
import com.ibm.ws.wssecurity.xss4j.dsig.transform.XPathTransformer;
import com.ibm.ws.wssecurity.xss4j.dsig.util.XPathUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.PrefixResolverDefault;
import org.apache.xpath.XPath;
import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.NodeIterator;

public class XPath2Transformer
extends Transform {
    private static final int FILTER_INVALID = -1;
    private static final int FILTER_UNION = 1;
    private static final int FILTER_SUBTRACT = 2;
    private static final int FILTER_INTERSECT = 3;
    private List xpathNodes;

    public String getURI() {
        return "http://www.w3.org/2002/06/xmldsig-filter2";
    }

    public void setParameter(Node node) {
        Vector<Node> vector = new Vector<Node>();
        while (node != null) {
            vector.addElement(node);
            node = DOMUtil.getNextElement(node);
        }
        this.xpathNodes = vector;
    }

    public void transform(TransformContext transformContext) throws TransformException {
        NodeList nodeList = transformContext.getNodeset();
        int n = nodeList.getLength();
        if (n <= 0) {
            return;
        }
        Node node = nodeList.item(0);
        Document document = node instanceof Document ? (Document)node : node.getOwnerDocument();
        int n2 = this.xpathNodes.size();
        List[] listArray = new List[n2 + 1];
        int[] nArray = new int[n2 + 1];
        listArray[0] = Collections.singletonList(document);
        nArray[0] = 1;
        Iterator iterator = this.xpathNodes.iterator();
        int n3 = 1;
        while (iterator.hasNext()) {
            Node node2 = (Node)iterator.next();
            listArray[n3] = XPath2Transformer.eval(node2, document, transformContext);
            nArray[n3] = XPath2Transformer.getFilter(node2);
            if (nArray[n3] == -1) {
                throw new TransformException("XPath element has no valid Filter attribute.");
            }
            ++n3;
        }
        XPathCanonicalizer.NodeListImpl nodeListImpl = new XPathCanonicalizer.NodeListImpl();
        block1: for (int i = 0; i < n; ++i) {
            node = nodeList.item(i);
            for (int j = 0; j < nArray.length; ++j) {
                if (nArray[j] != 1 || !XPath2Transformer.contain(listArray[j], node)) continue;
                boolean bl = true;
                for (int k = j + 1; k < nArray.length; ++k) {
                    if (nArray[k] == 1) continue;
                    if (nArray[k] == 3) {
                        if (XPath2Transformer.contain(listArray[k], node)) continue;
                        bl = false;
                        break;
                    }
                    if (nArray[k] != 2 || !XPath2Transformer.contain(listArray[k], node)) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                nodeListImpl.add(node);
                continue block1;
            }
        }
        transformContext.setContent(nodeListImpl);
    }

    private static int getFilter(Node node) {
        String string = ((Element)node).getAttribute("Filter");
        if ("union".equals(string)) {
            return 1;
        }
        if ("subtract".equals(string)) {
            return 2;
        }
        if ("intersect".equals(string)) {
            return 3;
        }
        return -1;
    }

    private static boolean contain(List list, Node node) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Node node2 = (Node)iterator.next();
            if (node2 != node && !Enveloped.isAncestorOrSelf(node, node2)) continue;
            return true;
        }
        return false;
    }

    private static List eval(Node node, Document document, TransformContext transformContext) throws TransformException {
        Node node2;
        NodeIterator nodeIterator;
        XPathUtil.XPathContextWithIR xPathContextWithIR = new XPathUtil.XPathContextWithIR(node, transformContext.getIDResolver());
        PrefixResolverDefault prefixResolverDefault = new PrefixResolverDefault(node);
        String string = DOMUtil.getStringValue(node);
        try {
            XPath xPath = XPathTransformer.createXPath(string, prefixResolverDefault, 0);
            XObject xObject = xPath.execute((XPathContext)xPathContextWithIR, (Node)document, (PrefixResolver)prefixResolverDefault);
            if (xObject.getType() != 4) {
                throw new TransformException("The result of xpath evaluation for '" + string + "' is not a nodeset: " + xObject.getTypeString());
            }
            nodeIterator = xObject.nodeset();
        }
        catch (TransformerException transformerException) {
            throw new TransformException("Error occured in an XPath evaluation: " + transformerException.getMessage());
        }
        ArrayList<Node> arrayList = new ArrayList<Node>();
        while ((node2 = nodeIterator.nextNode()) != null) {
            arrayList.add(node2);
        }
        return arrayList;
    }

    public Element createTransformElement(Document document, IndentConfig indentConfig) {
        throw new RuntimeException("Not supported.");
    }
}

