/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xss4j.dsig.transform;

import com.ibm.ws.wssecurity.xss4j.AlgorithmFactory;
import com.ibm.ws.wssecurity.xss4j.domutil.DOMUtil;
import com.ibm.ws.wssecurity.xss4j.domutil.IndentConfig;
import com.ibm.ws.wssecurity.xss4j.domutil.XPathCanonicalizer;
import com.ibm.ws.wssecurity.xss4j.dsig.Transform;
import com.ibm.ws.wssecurity.xss4j.dsig.TransformContext;
import com.ibm.ws.wssecurity.xss4j.dsig.TransformException;
import java.io.ByteArrayOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XSLTTransformer
extends Transform {
    private static final boolean DEBUG = false;
    public static final String URI = "http://www.w3.org/TR/1999/REC-xslt-19991116";
    Document styledoc = null;

    public void setParameter(Node node) {
        Document document;
        Object object;
        if (node == null) {
            return;
        }
        Node node2 = node.getParentNode();
        if (node2 != null && node2.getNodeType() == 9) {
            this.styledoc = (Document)node2;
            return;
        }
        if (node.getNodeType() == 1 && node.getNamespaceURI().equals("http://www.w3.org/2000/09/xmldsig#") && node.getLocalName().equals("XSLT")) {
            node = DOMUtil.getFirstChildElement(node);
        }
        if (node == null) {
            return;
        }
        AlgorithmFactory algorithmFactory = AlgorithmFactory.getInstance();
        try {
            object = algorithmFactory.getDocumentBuilder();
            document = ((DocumentBuilder)object).newDocument();
            algorithmFactory.releaseDocumentBuilder((DocumentBuilder)object);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new RuntimeException(parserConfigurationException.getMessage());
        }
        object = (Element)document.importNode(node, true);
        Hashtable hashtable = XPathCanonicalizer.collectNamespaceNodesInAncestors(node, false);
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            Attr attr = (Attr)enumeration.nextElement();
            if (attr.getNodeName().equals("xmlns:xml")) continue;
            object.setAttributeNS(attr.getNamespaceURI(), attr.getNodeName(), attr.getNodeValue());
        }
        document.appendChild((Node)object);
        this.styledoc = document;
    }

    private static void print(Node node) {
    }

    public void setParameter(Document document) {
        this.styledoc = document;
    }

    public String getURI() {
        return URI;
    }

    public void transform(TransformContext transformContext) throws TransformException {
        if (this.styledoc == null) {
            throw new TransformException("No prameter element.");
        }
        try {
            Document document = transformContext.getDocument();
            XPathCanonicalizer.copyNamespaceNodesInAncestorsRecursively(document);
            XPathCanonicalizer.copyNamespaceNodesInAncestorsRecursively(this.styledoc);
            XSLTTransformer.print(this.styledoc);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer(new DOMSource(this.styledoc));
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            transformer.transform(new DOMSource(document), new StreamResult(byteArrayOutputStream));
            transformContext.setContent(byteArrayOutputStream.toByteArray(), null);
        }
        catch (TransformerException transformerException) {
            throw TransformException.create(transformerException);
        }
    }

    public Element createTransformElement(Document document, IndentConfig indentConfig) {
        Element element = super.createTransformElement(document, indentConfig);
        DOMUtil.addIndent(element, indentConfig, 0);
        element.appendChild(document.importNode(this.styledoc.getDocumentElement(), true));
        DOMUtil.addIndent(element, indentConfig, 4);
        return element;
    }
}

