/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xss4j.dsig.util;

import com.ibm.ws.wssecurity.xss4j.dsig.IDResolver;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AdHocIDResolver
implements IDResolver {
    Vector docs = new Vector();
    Vector hashes = new Vector();

    public AdHocIDResolver(Document document) {
        this.registerDocument(document);
    }

    private Hashtable searchFor(Document document) {
        for (int i = 0; i < this.docs.size(); ++i) {
            Object e2 = this.docs.elementAt(i);
            if (e2 != document) continue;
            return (Hashtable)this.hashes.elementAt(i);
        }
        return null;
    }

    private Hashtable registerDocument(Document document) {
        this.docs.addElement(document);
        Hashtable hashtable = new Hashtable();
        this.hashes.addElement(hashtable);
        AdHocIDResolver.traverseNode(hashtable, document.getDocumentElement());
        return hashtable;
    }

    private static void traverseNode(Hashtable hashtable, Node node) {
        Object object;
        if (node.getNodeType() == 1) {
            object = node.getAttributes();
            for (int i = 0; i < object.getLength(); ++i) {
                Attr attr = (Attr)object.item(i);
                if (!"id".equalsIgnoreCase(attr.getLocalName())) continue;
                hashtable.put(attr.getNodeValue(), node);
            }
        }
        for (object = node.getFirstChild(); object != null; object = object.getNextSibling()) {
            AdHocIDResolver.traverseNode(hashtable, (Node)object);
        }
    }

    public Element resolveID(Document document, String string) {
        Element element = document.getElementById(string);
        if (element != null) {
            return element;
        }
        Hashtable hashtable = this.searchFor(document);
        if (hashtable == null) {
            hashtable = this.registerDocument(document);
        }
        element = (Element)hashtable.get(string);
        return element;
    }
}

