/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xss4j.enc;

import com.ibm.ws.wssecurity.xss4j.domutil.Serializer;
import com.ibm.ws.wssecurity.xss4j.enc.util.DOMUtil;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class DOMSerializationEngine {
    public abstract String getType();

    public abstract void setOutputStream(OutputStream var1);

    public abstract void serialize(NodeList var1) throws IOException;

    private static Throwable unwrapException(TransformerException transformerException) {
        Throwable throwable = transformerException.getException();
        if (throwable == null) {
            throwable = transformerException;
        }
        return throwable;
    }

    public static class XMLElement
    extends XMLContent {
        public String getType() {
            return "http://www.w3.org/2001/04/xmlenc#Element";
        }

        public void serialize(NodeList nodeList) throws IOException {
            if (nodeList != null) {
                Element element = DOMUtil.getFirstElement(nodeList);
                DOMUtil.NodeListImpl nodeListImpl = new DOMUtil.NodeListImpl();
                if (element != null) {
                    nodeListImpl.add(element);
                }
                nodeList = nodeListImpl;
            }
            super.serialize(nodeList);
        }
    }

    public static class XMLContent
    extends DOMSerializationEngine {
        private Writer fOut;

        public String getType() {
            return "http://www.w3.org/2001/04/xmlenc#Content";
        }

        public void setOutputStream(OutputStream outputStream) {
            try {
                this.fOut = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException("Internal Error: " + unsupportedEncodingException.toString());
            }
        }

        public void serialize(NodeList nodeList) throws IOException {
            if (nodeList != null) {
                int n = nodeList.getLength();
                for (int i = 0; i < n; ++i) {
                    Serializer.serialize(nodeList.item(i), this.fOut);
                }
                this.fOut.flush();
            }
        }
    }
}

