/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xss4j.enc;

import com.ibm.ws.wssecurity.xss4j.AlgorithmFactory;
import com.ibm.ws.wssecurity.xss4j.domutil.AdoptingDOMBuilder;
import com.ibm.ws.wssecurity.xss4j.domutil.DOMBuilder;
import com.ibm.ws.wssecurity.xss4j.dsig.IDResolver;
import com.ibm.ws.wssecurity.xss4j.dsig.SignatureContext;
import com.ibm.ws.wssecurity.xss4j.dsig.XSignatureException;
import com.ibm.ws.wssecurity.xss4j.dsig.util.FastBAOutputStream;
import com.ibm.ws.wssecurity.xss4j.dsig.util.HWKeyCache;
import com.ibm.ws.wssecurity.xss4j.enc.EncryptedKeyRetriever;
import com.ibm.ws.wssecurity.xss4j.enc.EncryptedTypeContainer;
import com.ibm.ws.wssecurity.xss4j.enc.EncryptionInputStream;
import com.ibm.ws.wssecurity.xss4j.enc.KeyInfoResolver;
import com.ibm.ws.wssecurity.xss4j.enc.KeyInfoResolvingException;
import com.ibm.ws.wssecurity.xss4j.enc.ResourceInputStream;
import com.ibm.ws.wssecurity.xss4j.enc.ResourceShower;
import com.ibm.ws.wssecurity.xss4j.enc.StructureException;
import com.ibm.ws.wssecurity.xss4j.enc.XMLWriter;
import com.ibm.ws.wssecurity.xss4j.enc.type.CipherData;
import com.ibm.ws.wssecurity.xss4j.enc.type.CipherReference;
import com.ibm.ws.wssecurity.xss4j.enc.type.CipherValue;
import com.ibm.ws.wssecurity.xss4j.enc.type.DsTransforms;
import com.ibm.ws.wssecurity.xss4j.enc.type.EncryptedData;
import com.ibm.ws.wssecurity.xss4j.enc.type.EncryptedKey;
import com.ibm.ws.wssecurity.xss4j.enc.type.EncryptedType;
import com.ibm.ws.wssecurity.xss4j.enc.type.EncryptionMethod;
import com.ibm.ws.wssecurity.xss4j.enc.type.KeyInfo;
import com.ibm.ws.wssecurity.xss4j.enc.type.Transform;
import com.ibm.ws.wssecurity.xss4j.enc.type.Transforms;
import com.ibm.ws.wssecurity.xss4j.enc.type.TransformsType;
import com.ibm.ws.wssecurity.xss4j.enc.type.Type;
import com.ibm.ws.wssecurity.xss4j.enc.util.DOMUtil;
import com.ibm.ws.wssecurity.xss4j.enc.util.Util;
import com.ibm.wsspi.wssecurity.EncryptionEngine;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Iterator;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

public class DecryptionContext {
    private static final boolean DEBUG = false;
    private static final Class[] adoptNodeArgs = new Class[]{Node.class};
    private EncryptedTypeContainer fEncryptedTypeContainer;
    private EncryptionMethod fEncryptionMethod;
    private Key fKey;
    private AlgorithmFactory fAlgorithmFactory;
    private KeyInfoResolver fKeyInfoResolver;
    private IDResolver fIdResolver;
    private EntityResolver fEntityResolver;
    private EncryptedKeyRetriever fEncryptedKeyRetriever;
    private HWKeyCache fHWKeyCache;
    private Object fData;
    private String fType;
    private String fMimeType;
    private String fEncoding;
    private ResourceShower shower;
    private String encAlgorithm = null;
    private Provider hwAccelerationProvider = null;
    private Provider hwKeyStoreProvider = null;
    private String _hwConfigName = null;
    private String _hwKeyStoreName = null;
    private String allCryptoOffload = null;
    private Boolean _offload = Boolean.TRUE;
    private boolean debug = false;

    public DecryptionContext() {
        this.fAlgorithmFactory = AlgorithmFactory.getInstance();
        this.fHWKeyCache = HWKeyCache.getInstance();
    }

    public Provider getHWAccelerationProvider() {
        return this.hwAccelerationProvider;
    }

    public Provider getHWKeyStoreProvider() {
        return this.hwKeyStoreProvider;
    }

    public void setEncAlgorithm(String string) {
        this.encAlgorithm = string;
    }

    public void setHWKeyStoreName(String string) {
        this._hwKeyStoreName = string;
    }

    public String getHWKeyStoreName() {
        return this._hwKeyStoreName;
    }

    public void setHWConfigName(String string) {
        this._hwConfigName = string;
    }

    public String getHWConfigName() {
        return this._hwConfigName;
    }

    public void setOffload(Boolean bl) {
        this._offload = bl;
    }

    public boolean shouldChangeProvider() {
        return this._hwConfigName != null && this._hwConfigName.length() > 0 && HWKeyCache.isHWEncAlgorithm(this.encAlgorithm) && this._offload != false;
    }

    public boolean useHWKeyStore() {
        return this._hwKeyStoreName != null && this._hwKeyStoreName.length() > 0;
    }

    public void setHWAccelerationProvider(Provider provider, Integer n) {
        if (this.shouldChangeProvider()) {
            this.hwAccelerationProvider = provider;
            this.fHWKeyCache.setProvider(provider, n);
        }
    }

    public void setHWKeyStoreProvider(Provider provider) {
        this.hwKeyStoreProvider = provider;
    }

    public boolean isHWAccelerationProvider() {
        return this.hwAccelerationProvider != null;
    }

    public boolean isHWKeyStoreProvider() {
        return this.hwKeyStoreProvider != null;
    }

    public void setCryptoOffloadProperty(String string) {
        this.allCryptoOffload = string;
    }

    public void clearLocalProviderMap() {
        this.fAlgorithmFactory.clearLocalProviderMap();
    }

    public void setEncryptedType(InputStream inputStream, String string, Element element, Element element2) throws IOException, ParserConfigurationException, SAXException {
        Element element3 = null;
        if (inputStream != null) {
            DocumentBuilder documentBuilder = this.fAlgorithmFactory.getDocumentBuilder();
            element3 = documentBuilder.parse(inputStream).getDocumentElement();
            this.fAlgorithmFactory.releaseDocumentBuilder(documentBuilder);
        }
        this.setEncryptedType(element3, string, element, element2);
    }

    public void setEncryptedType(Element element, String string, Element element2, Element element3) {
        this.fEncryptedTypeContainer = new EncryptedTypeContainer(element, string, element2, element3);
    }

    void setEncryptedType(EncryptedType encryptedType, String string, EncryptionMethod encryptionMethod, KeyInfo keyInfo) {
        this.fEncryptedTypeContainer = new EncryptedTypeContainer(encryptedType, string, encryptionMethod, keyInfo);
    }

    public void setEncryptionMethod(Element element) {
        EncryptionMethod encryptionMethod = null;
        if (element != null) {
            encryptionMethod = new EncryptionMethod(element);
        }
        this.setEncryptionMethod(encryptionMethod);
    }

    void setEncryptionMethod(EncryptionMethod encryptionMethod) {
        this.fEncryptionMethod = encryptionMethod;
    }

    public void updateHWCache() throws Exception {
        this.fKey = this.fHWKeyCache.translate(this.fKey);
    }

    public void setHWKey(Key key) throws Exception {
        this.fKey = this.fHWKeyCache.translate(key);
    }

    public void setKey(Key key) {
        this.fKey = key;
    }

    public void setAlgorithmFactory(AlgorithmFactory algorithmFactory) {
        if (algorithmFactory == null) {
            throw new NullPointerException("AlgorithmFacotry is null.");
        }
        this.fAlgorithmFactory = algorithmFactory;
    }

    public void setKeyInfoResolver(KeyInfoResolver keyInfoResolver) {
        this.fKeyInfoResolver = keyInfoResolver;
    }

    public void setIdResolver(IDResolver iDResolver) {
        this.fIdResolver = iDResolver;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.fEntityResolver = entityResolver;
    }

    public void setEncryptedKeyRetriever(EncryptedKeyRetriever encryptedKeyRetriever) {
        this.fEncryptedKeyRetriever = encryptedKeyRetriever;
    }

    public Object getData() {
        return this.fData;
    }

    public NodeList getDataAsNodeList() throws IOException, ParserConfigurationException, SAXException, StructureException {
        if (this.fData != null) {
            if (this.fType == null) {
                throw new StructureException("Type attribute not specified");
            }
            if (this.fType.equals("http://www.w3.org/2001/04/xmlenc#Element") || this.fType.equals("http://www.w3.org/2001/04/xmlenc#Content")) {
                if (this.fData instanceof InputStream) {
                    Element element = this.fEncryptedTypeContainer.getET().getBase();
                    byte[] byArray = Util.getBytes((InputStream)this.fData);
                    this.fData = DOMUtil.getChildNodes(this.parseData(byArray, element));
                } else if (!(this.fData instanceof NodeList)) {
                    throw new RuntimeException("Instance of unknown class: " + this.fData.getClass().getName());
                }
            } else {
                throw new StructureException("Unknown type: " + this.fType);
            }
        }
        return (NodeList)this.fData;
    }

    public String getType() {
        return this.fType;
    }

    public String getMimeType() {
        return this.fMimeType;
    }

    public String getEncoding() {
        return this.fEncoding;
    }

    public Key getKey() {
        return this.fKey;
    }

    public void decrypt() throws BadPaddingException, IOException, IllegalBlockSizeException, InvalidAlgorithmParameterException, InvalidKeyException, KeyInfoResolvingException, NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException, StructureException, XSignatureException {
        if (this.fEncryptedTypeContainer == null) {
            throw new NullPointerException("Neither encrypted data nor key specified");
        }
        EncryptedType encryptedType = this.fEncryptedTypeContainer.getET();
        if (encryptedType == null) {
            throw new NullPointerException("Neither EncryptedData nor EncryptedKey element specified");
        }
        if (encryptedType instanceof EncryptedData) {
            if (this.debug) {
                System.out.println("HWC: decrypt, data");
            }
            EncryptionEngine encryptionEngine = this.getEncryptionEngine(2);
            InputStream inputStream = this.getInputStream();
            this.fData = new EncryptionInputStream(inputStream, encryptionEngine, this.fAlgorithmFactory);
            if (this.debug) {
                System.out.println("HWC: decrypt data, after EncryptionInputStream");
            }
            if (this.shower != null) {
                this.fData = this.getResourceInputStream((InputStream)this.fData);
            }
        } else if (encryptedType instanceof EncryptedKey) {
            if (this.debug) {
                System.out.println("HWC: decrypt, key");
            }
            EncryptionEngine encryptionEngine = this.getEncryptionEngine(4);
            byte[] byArray = Util.getBytes(this.getInputStream());
            if (this.fEncryptionMethod == null) {
                throw new NullPointerException("EncryptionMethod element not specified");
            }
            String string = this.fEncryptionMethod.getAlgorithm();
            if (string == null) {
                throw new StructureException("Algorithm attribute not specified");
            }
            String string2 = this.fEncryptedTypeContainer.getType();
            try {
                this.fData = encryptionEngine.unwrap(byArray, string, string2);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                if (this.isHWAccelerationProvider()) {
                    HWKeyCache.setCapacityReached();
                    string2 = this.fEncryptedTypeContainer.getType();
                    this.fData = encryptionEngine.unwrap(byArray, string, string2);
                }
                throw outOfMemoryError;
            }
            this.fAlgorithmFactory.releaseEncryptionEngine(encryptionEngine);
            if (this.debug) {
                System.out.println("HWC: decrypt, key unwrap is done");
            }
            if (this.shower != null) {
                this.showResource((Key)this.fData);
            }
        }
        this.fType = this.fEncryptedTypeContainer.getType();
        this.fMimeType = encryptedType.getMimeType();
        this.fEncoding = encryptedType.getEncoding();
    }

    private EncryptionEngine getEncryptionEngine(int n) throws InvalidAlgorithmParameterException, InvalidKeyException, KeyInfoResolvingException, NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException, StructureException {
        EncryptionMethod encryptionMethod = this.fEncryptedTypeContainer.getEM();
        if (encryptionMethod == null) {
            throw new StructureException("EncryptionMethod element not specified");
        }
        String string = encryptionMethod.getAlgorithm();
        if (string == null) {
            throw new StructureException("Algorithm attribute not specified");
        }
        Key key = this._getKey();
        if (key == null) {
            throw new NullPointerException("Key not specified or obtained");
        }
        if (this.isHWAccelerationProvider()) {
            if ("true".equals(this.allCryptoOffload)) {
                this.fAlgorithmFactory.setLocalProvider("HWCONFIG", this.getHWAccelerationProvider());
            } else if (!(string.equals("http://www.w3.org/2001/04/xmlenc#tripledes-cbc") || string.equals("http://www.w3.org/2001/04/xmlenc#aes128-cbc") || string.equals("http://www.w3.org/2001/04/xmlenc#aes192-cbc") || string.equals("http://www.w3.org/2001/04/xmlenc#aes256-cbc"))) {
                this.fAlgorithmFactory.setLocalProvider("HWCONFIG", this.getHWAccelerationProvider());
            } else {
                this.fAlgorithmFactory.getProviderMaps().remove("HWCONFIG");
            }
        }
        if (this.isHWKeyStoreProvider()) {
            if ("true".equals(this.allCryptoOffload)) {
                this.fAlgorithmFactory.setLocalProvider("com.ibm.ws.wssecurity.config.keystore.keyStoreRef", this.getHWKeyStoreProvider());
            } else if (!(string.equals("http://www.w3.org/2001/04/xmlenc#tripledes-cbc") || string.equals("http://www.w3.org/2001/04/xmlenc#aes128-cbc") || string.equals("http://www.w3.org/2001/04/xmlenc#aes192-cbc") || string.equals("http://www.w3.org/2001/04/xmlenc#aes256-cbc"))) {
                this.fAlgorithmFactory.setLocalProvider("com.ibm.ws.wssecurity.config.keystore.keyStoreRef", this.getHWKeyStoreProvider());
            } else {
                this.fAlgorithmFactory.getProviderMaps().remove("HWCONFIG");
            }
        }
        EncryptionEngine encryptionEngine = this.fAlgorithmFactory.getEncryptionEngine(string);
        AlgorithmParameterSpec algorithmParameterSpec = encryptionMethod.getParameterSpec(this.fAlgorithmFactory);
        encryptionEngine.init(n, key, algorithmParameterSpec);
        return encryptionEngine;
    }

    private Key _getKey() throws KeyInfoResolvingException {
        Object object;
        if (this.fKey == null && (object = this.fEncryptedTypeContainer.getKI()) != null && this.fKeyInfoResolver != null) {
            this.fKey = this.fKeyInfoResolver.resolve((KeyInfo)object, this.fEncryptedTypeContainer.getEM());
        }
        if (this.fKey == null && (object = this.fEncryptedTypeContainer.getET().getId()) != null && this.fEncryptedKeyRetriever != null && this.fKeyInfoResolver != null) {
            KeyInfo keyInfo = new KeyInfo();
            Iterator iterator = this.fEncryptedKeyRetriever.retrieve((String)object).iterator();
            while (iterator.hasNext()) {
                keyInfo.addEncryptedKey((EncryptedKey)iterator.next());
            }
            this.fKey = this.fKeyInfoResolver.resolve(keyInfo, this.fEncryptedTypeContainer.getEM());
        }
        return this.fKey;
    }

    private InputStream getInputStream() throws StructureException, XSignatureException {
        CipherData cipherData = this.fEncryptedTypeContainer.getET().getCipherData();
        if (cipherData == null) {
            throw new StructureException("CipherData element not specified");
        }
        Type type = cipherData.getCipherData();
        byte[] byArray = null;
        if (type == null) {
            throw new StructureException("Neither CipherValue nor CipherReference element specified");
        }
        if (type instanceof CipherValue) {
            byArray = ((CipherValue)type).getValue();
            if (byArray == null) {
                throw new StructureException("Cipher value not specified");
            }
        } else if (type instanceof CipherReference) {
            Object object;
            CipherReference cipherReference = (CipherReference)type;
            String string = cipherReference.getURI();
            if (string == null) {
                throw new StructureException("URI attribute not specified");
            }
            Element element = cipherReference.getBase();
            Transforms transforms = cipherReference.getTransforms();
            if (transforms != null) {
                object = new DsTransforms();
                Object object2 = transforms.getTransforms().iterator();
                while (object2.hasNext()) {
                    ((TransformsType)object).addTransform((Transform)object2.next());
                }
                object2 = ((DsTransforms)object).createElement(element.getOwnerDocument(), true);
                element = (Element)element.cloneNode(false);
                element.appendChild((Node)object2);
            }
            object = new SignatureContext();
            ((SignatureContext)object).setAlgorithmFactory(this.fAlgorithmFactory);
            ((SignatureContext)object).setIDResolver(this.fIdResolver);
            ((SignatureContext)object).setEntityResolver(this.fEntityResolver);
            byArray = (byte[])((SignatureContext)object).retrieve(element);
        }
        return new ByteArrayInputStream(byArray);
    }

    public void replace() throws IOException, ParserConfigurationException, SAXException, StructureException {
        NodeList nodeList = this.getDataAsNodeList();
        if (nodeList == null) {
            throw new NullPointerException("Data not obtained");
        }
        this.fData = DOMUtil.replaceNode((Node)this.fEncryptedTypeContainer.getET().getBase(), nodeList);
    }

    private static NamedNodeMap getEntities(Node node) {
        Object var1_1 = null;
        if (node == null) {
            return null;
        }
        DocumentType documentType = node.getOwnerDocument().getDoctype();
        if (documentType == null) {
            return null;
        }
        return documentType.getEntities();
    }

    private static void serializeEntities(Node node, XMLWriter xMLWriter) throws IOException {
        NamedNodeMap namedNodeMap = DecryptionContext.getEntities(node);
        if (namedNodeMap == null || namedNodeMap.getLength() <= 0) {
            return;
        }
        xMLWriter.printText("<!DOCTYPE dummy [");
        for (int i = namedNodeMap.getLength() - 1; i >= 0; --i) {
            Entity entity = (Entity)namedNodeMap.item(i);
            if (entity.getNotationName() != null) continue;
            xMLWriter.printText("<!ENTITY " + entity.getNodeName() + " ");
            if (entity.getSystemId() != null) {
                String string = entity.getPublicId();
                if (string != null) {
                    xMLWriter.printText("PUBLIC ");
                    xMLWriter.printDoctypeURL(string);
                    xMLWriter.printText(' ');
                } else {
                    xMLWriter.printText("SYSTEM ");
                }
                xMLWriter.printDoctypeURL(entity.getSystemId());
            } else {
                xMLWriter.printText('\"');
                xMLWriter.printText(DOMUtil.cloneChildNodes(entity), false);
                xMLWriter.printText('\"');
            }
            xMLWriter.printText('>');
        }
        xMLWriter.printText("]>");
    }

    private static void serializeNamespaceDecls(Node node, XMLWriter xMLWriter) throws IOException {
        Map map = DOMUtil.getNamespaceDeclAttrNodes(node);
        if (map == null || map.size() <= 0) {
            return;
        }
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            Attr attr = (Attr)iterator.next();
            if (attr.getName().equals("xmlns:xml")) continue;
            xMLWriter.printText(" ");
            xMLWriter.printText(attr.getName());
            xMLWriter.printText("=\"");
            String string = attr.getValue();
            if (string == null) {
                string = "";
            }
            xMLWriter.printEscaped(string);
            xMLWriter.printText('\"');
        }
    }

    public static byte[] wrapData(byte[] byArray, Node node) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            XMLWriter xMLWriter = new XMLWriter(byteArrayOutputStream);
            DecryptionContext.serializeEntities(node, xMLWriter);
            xMLWriter.printText("<dummy");
            DecryptionContext.serializeNamespaceDecls(node, xMLWriter);
            xMLWriter.printText('>');
            xMLWriter.flush();
            if (byArray != null) {
                byteArrayOutputStream.write(byArray);
            }
            xMLWriter.printText("</dummy>");
            xMLWriter.flush();
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byteArrayOutputStream.toByteArray();
    }

    private Element parseData(byte[] byArray, Node node) throws IOException, ParserConfigurationException, SAXException {
        FastBAOutputStream fastBAOutputStream = byArray != null ? new FastBAOutputStream(byArray.length * 2 + 1) : new FastBAOutputStream();
        XMLWriter xMLWriter = new XMLWriter(fastBAOutputStream);
        DecryptionContext.serializeEntities(node, xMLWriter);
        xMLWriter.printText("<dummy");
        DecryptionContext.serializeNamespaceDecls(node, xMLWriter);
        xMLWriter.printText('>');
        xMLWriter.flush();
        if (byArray != null) {
            fastBAOutputStream.write(byArray);
        }
        xMLWriter.printText("</dummy>");
        xMLWriter.flush();
        fastBAOutputStream.close();
        InputStream inputStream = fastBAOutputStream.createInputStream();
        if (node != null) {
            Document document = node.getOwnerDocument();
            if (node.getNodeType() == 9) {
                document = (Document)node;
            }
            AdoptingDOMBuilder adoptingDOMBuilder = new AdoptingDOMBuilder(document);
            adoptingDOMBuilder.reset(document);
            return adoptingDOMBuilder.parseElement(inputStream);
        }
        return DOMBuilder.parse(inputStream).getDocumentElement();
    }

    public void setResourceShower(ResourceShower resourceShower) {
        this.shower = resourceShower;
    }

    private ResourceInputStream getResourceInputStream(InputStream inputStream) {
        return new ResourceInputStream(inputStream, this.shower, this.fData, this.fEncryptedTypeContainer.getEncryptedType());
    }

    private void showResource(Key key) {
        this.shower.showEncryptedResource(key.getEncoded(), this.fData, this.fEncryptedTypeContainer.getEncryptedType());
    }
}

