/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xss4j.enc;

import com.ibm.ws.wssecurity.xss4j.AlgorithmFactory;
import com.ibm.ws.wssecurity.xss4j.dsig.util.HWKeyCache;
import com.ibm.ws.wssecurity.xss4j.enc.DOMSerializationEngine;
import com.ibm.ws.wssecurity.xss4j.enc.EncryptedTypeContainer;
import com.ibm.ws.wssecurity.xss4j.enc.EncryptionOutputStream;
import com.ibm.ws.wssecurity.xss4j.enc.KeyInfoResolver;
import com.ibm.ws.wssecurity.xss4j.enc.KeyInfoResolvingException;
import com.ibm.ws.wssecurity.xss4j.enc.ResourceOutputStream;
import com.ibm.ws.wssecurity.xss4j.enc.ResourceShower;
import com.ibm.ws.wssecurity.xss4j.enc.StructureException;
import com.ibm.ws.wssecurity.xss4j.enc.type.CipherData;
import com.ibm.ws.wssecurity.xss4j.enc.type.CipherValue;
import com.ibm.ws.wssecurity.xss4j.enc.type.EncryptedType;
import com.ibm.ws.wssecurity.xss4j.enc.type.EncryptionMethod;
import com.ibm.ws.wssecurity.xss4j.enc.type.KeyInfo;
import com.ibm.ws.wssecurity.xss4j.enc.type.Type;
import com.ibm.ws.wssecurity.xss4j.enc.util.DOMUtil;
import com.ibm.ws.wssecurity.xss4j.enc.util.Util;
import com.ibm.wsspi.wssecurity.EncryptionEngine;
import com.ibm.wsspi.wssecurity.KeyGenerationEngine;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EncryptionContext {
    private static final boolean DEBUG = false;
    private Object fData;
    private EncryptedTypeContainer fEncryptedTypeContainer;
    private Key fKey;
    private X509Certificate fCertificate;
    private OutputStream fOut;
    private AlgorithmFactory fAlgorithmFactory;
    private KeyInfoResolver fKeyInfoResolver;
    private HWKeyCache fHWKeyCache;
    private Element fEncryptedType;
    private ResourceShower shower;
    private Provider hwAccelerationProvider = null;
    private Provider hwKeyStoreProvider = null;
    private String _hwConfigName = null;
    private String _hwKeyStoreName = null;
    private String allCryptoOffload = null;
    private String encAlgorithm = null;
    private Boolean _offload = Boolean.TRUE;
    private boolean debug = false;

    public EncryptionContext() {
        this.fAlgorithmFactory = AlgorithmFactory.getInstance();
        this.fHWKeyCache = HWKeyCache.getInstance();
    }

    public void setEncAlgorithm(String string) {
        this.encAlgorithm = string;
    }

    public void setHWKeyStoreName(String string) {
        this._hwKeyStoreName = string;
    }

    public void setOffload(Boolean bl) {
        this._offload = bl;
    }

    public String getHWKeyStoreName() {
        return this._hwKeyStoreName;
    }

    public void setHWConfigName(String string) {
        this._hwConfigName = string;
    }

    public String getHWConfigName() {
        return this._hwConfigName;
    }

    public boolean shouldChangeProvider() {
        return this._hwConfigName != null && this._hwConfigName.length() > 0 && HWKeyCache.isHWEncAlgorithm(this.encAlgorithm) && this._offload != false;
    }

    public boolean useHWKeyStore() {
        return this._hwKeyStoreName != null && this._hwKeyStoreName.length() > 0;
    }

    public Provider getHWAccelerationProvider() {
        return this.hwAccelerationProvider;
    }

    public Provider getHWKeyStoreProvider() {
        return this.hwKeyStoreProvider;
    }

    public void setHWAccelerationProvider(Provider provider, Integer n) {
        if (this.shouldChangeProvider()) {
            this.hwAccelerationProvider = provider;
            this.fHWKeyCache.setProvider(provider, n);
        }
    }

    public void setHWKeyStoreProvider(Provider provider) {
        this.hwKeyStoreProvider = provider;
    }

    public boolean isHWAccelerationProvider() {
        return this.hwAccelerationProvider != null;
    }

    public boolean isHWKeyStoreProvider() {
        return this.hwKeyStoreProvider != null;
    }

    public void clearLocalProviderMap() {
        this.fAlgorithmFactory.clearLocalProviderMap();
    }

    public void setCryptoOffloadProperty(String string) {
        this.allCryptoOffload = string;
    }

    public void setData(InputStream inputStream) {
        this.fData = inputStream;
    }

    public void setData(Element element) {
        this.fData = element;
    }

    public void setData(Key key) {
        this.fData = key;
    }

    public void setEncryptedType(Element element, String string, Element element2, Element element3) {
        this.fEncryptedTypeContainer = new EncryptedTypeContainer(element, string, element2, element3);
    }

    void setEncryptedType(EncryptedType encryptedType, String string, EncryptionMethod encryptionMethod, KeyInfo keyInfo) {
        this.fEncryptedTypeContainer = new EncryptedTypeContainer(encryptedType, string, encryptionMethod, keyInfo);
    }

    public boolean setHWKeyFromCache(PublicKey publicKey) throws Exception {
        this.fKey = this.fHWKeyCache.translate(publicKey);
        return this.fKey != null;
    }

    public void setKey(Key key) {
        this.fKey = key;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.fOut = outputStream;
    }

    public void setAlgorithmFactory(AlgorithmFactory algorithmFactory) {
        if (algorithmFactory == null) {
            throw new NullPointerException("AlgorithmFactory is null.");
        }
        this.fAlgorithmFactory = algorithmFactory;
    }

    public void setKeyInfoResolver(KeyInfoResolver keyInfoResolver) {
        this.fKeyInfoResolver = keyInfoResolver;
    }

    public InputStream getEncryptedType() {
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.fEncryptedType != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.serialize(this.fEncryptedType));
        }
        return byteArrayInputStream;
    }

    private byte[] serialize(Element element) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DOMSerializationEngine.XMLElement xMLElement = new DOMSerializationEngine.XMLElement();
        ((DOMSerializationEngine)xMLElement).setOutputStream(byteArrayOutputStream);
        try {
            ((DOMSerializationEngine)xMLElement).serialize(new DOMUtil.NodeListImpl(element));
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byteArrayOutputStream.toByteArray();
    }

    public Element getEncryptedTypeAsElement() {
        return this.fEncryptedType;
    }

    public Key getKey() {
        return this.fKey;
    }

    public void encrypt() throws BadPaddingException, IOException, IllegalBlockSizeException, InvalidAlgorithmParameterException, InvalidKeyException, KeyInfoResolvingException, NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException, StructureException {
        Object object;
        OutputStream outputStream = null;
        if (this.fData == null) {
            throw new NullPointerException("Data not specified");
        }
        if (this.fData instanceof InputStream) {
            if (this.debug) {
                System.out.println("HWC: AlgorithmFactory, EncryptionContext, encrypt, fData is instance of InputStream");
            }
            outputStream = this.getEncryptionOutputStream();
            if (this.shower != null) {
                outputStream = this.getResourceOutputStream(outputStream);
            }
            Util.getBytes((InputStream)this.fData, outputStream);
            if (this.shower != null) {
                outputStream = this.showResource((ResourceOutputStream)outputStream);
            }
        } else if (this.fData instanceof Element) {
            if (this.debug) {
                System.out.println("HWC: EncryptionContext, encrypt, fData is instance of Element");
            }
            outputStream = this.getEncryptionOutputStream();
            if (this.shower != null) {
                outputStream = this.getResourceOutputStream(outputStream);
            }
            this.serialize((Element)this.fData, outputStream);
            if (this.shower != null) {
                outputStream = this.showResource((ResourceOutputStream)outputStream);
            }
        } else if (this.fData instanceof Key) {
            if (this.debug) {
                System.out.println("HWC: AlgorithmFactory, EncryptionContext, encrypt, fData is instance of Key");
            }
            object = this.getEncryptionEngine(3);
            outputStream = this.getOutputStream();
            try {
                outputStream.write(object.wrap((Key)this.fData));
            }
            catch (OutOfMemoryError outOfMemoryError) {
                if (this.isHWAccelerationProvider()) {
                    HWKeyCache.setCapacityReached();
                    outputStream = this.getOutputStream();
                    outputStream.write(object.wrap((Key)this.fData));
                }
                throw outOfMemoryError;
            }
            outputStream.flush();
            this.fAlgorithmFactory.releaseEncryptionEngine((EncryptionEngine)object);
            if (this.shower != null) {
                this.showResource((Key)this.fData);
            }
        }
        this.doFinal(outputStream);
        if (this.debug) {
            System.out.println("HWC: EncryptionContext, encrypt, after clearLocalProviderMap");
            object = (Provider)this.fAlgorithmFactory.getLocalProvider("HWCONFIG");
            if (object != null) {
                System.out.println("HWC: EncryptionContext, encrypt, alg factory's hw provider: " + ((Provider)object).getName());
            } else {
                System.out.println("HWC: EncryptionContext, encrypt, alg factory's hw provider is cleared");
            }
        }
    }

    public EncryptionOutputStream getEncryptionOutputStream() throws IOException, InvalidAlgorithmParameterException, InvalidKeyException, KeyInfoResolvingException, NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException, StructureException {
        EncryptionEngine encryptionEngine = this.getEncryptionEngine(1);
        OutputStream outputStream = this.getOutputStream();
        EncryptionOutputStream encryptionOutputStream = new EncryptionOutputStream(outputStream, encryptionEngine, this.fAlgorithmFactory);
        return encryptionOutputStream;
    }

    private EncryptionEngine getEncryptionEngine(int n) throws InvalidAlgorithmParameterException, InvalidKeyException, KeyInfoResolvingException, NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException, StructureException {
        if (this.fEncryptedTypeContainer == null) {
            throw new NullPointerException("Neither EncryptedData nor EncryptedKey element specified");
        }
        EncryptionMethod encryptionMethod = this.fEncryptedTypeContainer.getEM();
        if (encryptionMethod == null) {
            throw new StructureException("EncryptionMethod element not specified");
        }
        String string = encryptionMethod.getAlgorithm();
        if (string == null) {
            throw new StructureException("Algorithm attribute not specified");
        }
        Key key = this._getKey();
        if (key == null) {
            throw new NullPointerException("Key not specified or obtained");
        }
        if (this.isHWAccelerationProvider()) {
            if ("true".equals(this.allCryptoOffload)) {
                this.fAlgorithmFactory.setLocalProvider("HWCONFIG", this.getHWAccelerationProvider());
            } else if (!(string.equals("http://www.w3.org/2001/04/xmlenc#tripledes-cbc") || string.equals("http://www.w3.org/2001/04/xmlenc#aes128-cbc") || string.equals("http://www.w3.org/2001/04/xmlenc#aes192-cbc") || string.equals("http://www.w3.org/2001/04/xmlenc#aes256-cbc"))) {
                this.fAlgorithmFactory.setLocalProvider("HWCONFIG", this.getHWAccelerationProvider());
            } else {
                this.fAlgorithmFactory.getProviderMaps().remove("HWCONFIG");
            }
            if (this.debug) {
                System.out.println("HWC: Hardware provider instance is : " + this.getHWAccelerationProvider().getName());
            }
        }
        if (this.isHWKeyStoreProvider()) {
            if ("true".equals(this.allCryptoOffload)) {
                this.fAlgorithmFactory.setLocalProvider("com.ibm.ws.wssecurity.config.keystore.keyStoreRef", this.getHWKeyStoreProvider());
            } else if (!(string.equals("http://www.w3.org/2001/04/xmlenc#tripledes-cbc") || string.equals("http://www.w3.org/2001/04/xmlenc#aes128-cbc") || string.equals("http://www.w3.org/2001/04/xmlenc#aes192-cbc") || string.equals("http://www.w3.org/2001/04/xmlenc#aes256-cbc"))) {
                this.fAlgorithmFactory.setLocalProvider("com.ibm.ws.wssecurity.config.keystore.keyStoreRef", this.getHWKeyStoreProvider());
            } else {
                this.fAlgorithmFactory.getProviderMaps().remove("HWCONFIG");
            }
        }
        EncryptionEngine encryptionEngine = this.fAlgorithmFactory.getEncryptionEngine(string);
        AlgorithmParameterSpec algorithmParameterSpec = encryptionMethod.getParameterSpec(this.fAlgorithmFactory);
        encryptionEngine.init(n, key, algorithmParameterSpec);
        return encryptionEngine;
    }

    private Key _getKey() throws KeyInfoResolvingException {
        KeyInfo keyInfo;
        if (this.fKey == null && (keyInfo = this.fEncryptedTypeContainer.getKI()) != null && this.fKeyInfoResolver != null) {
            this.fKey = this.fKeyInfoResolver.resolve(keyInfo, this.fEncryptedTypeContainer.getEM());
        }
        return this.fKey;
    }

    private OutputStream getOutputStream() throws StructureException {
        OutputStream outputStream = null;
        if (this.hasCipherValue()) {
            outputStream = new ByteArrayOutputStream();
        } else if (this.fOut != null) {
            outputStream = this.fOut;
        } else {
            throw new NullPointerException("Neither CipherValue element nor output stream specified");
        }
        return outputStream;
    }

    private boolean hasCipherValue() throws StructureException {
        EncryptedType encryptedType = this.fEncryptedTypeContainer.getET();
        if (encryptedType == null) {
            throw new NullPointerException("Neither EncryptedData nor EncryptedKey element specified");
        }
        return this.getCipherValue(encryptedType) != null;
    }

    private CipherValue getCipherValue(EncryptedType encryptedType) throws StructureException {
        CipherData cipherData = encryptedType.getCipherData();
        if (cipherData == null) {
            throw new StructureException("CipherData element not specified");
        }
        Type type = cipherData.getCipherData();
        if (type == null) {
            throw new StructureException("Neither CipherValue nor CipherReference element specified");
        }
        CipherValue cipherValue = null;
        if (type instanceof CipherValue) {
            cipherValue = (CipherValue)type;
        }
        return cipherValue;
    }

    private void serialize(Element element, OutputStream outputStream) throws IOException, NoSuchAlgorithmException, StructureException {
        String string = this.fEncryptedTypeContainer.getType();
        if (string == null) {
            throw new StructureException("Type attribute not specified");
        }
        NodeList nodeList = null;
        if (string.equals("http://www.w3.org/2001/04/xmlenc#Element")) {
            nodeList = new DOMUtil.NodeListImpl(element);
        } else if (string.equals("http://www.w3.org/2001/04/xmlenc#Content")) {
            nodeList = DOMUtil.getChildNodes(element);
        } else {
            throw new StructureException("Unknown type: " + string);
        }
        DOMSerializationEngine dOMSerializationEngine = this.fAlgorithmFactory.getDOMSerializationEngine(string);
        dOMSerializationEngine.setOutputStream(outputStream);
        dOMSerializationEngine.serialize(nodeList);
    }

    public void doFinal(OutputStream outputStream) throws IOException, StructureException {
        if (outputStream instanceof EncryptionOutputStream) {
            EncryptionOutputStream encryptionOutputStream = (EncryptionOutputStream)outputStream;
            encryptionOutputStream.doFinal();
            encryptionOutputStream.flush();
            outputStream = encryptionOutputStream.getOutputStream();
        }
        this.fEncryptedType = this.getEncryptedType(outputStream);
    }

    private Element getEncryptedType(OutputStream outputStream) throws StructureException {
        if (this.fEncryptedTypeContainer == null) {
            throw new NullPointerException("Neither EncryptedData nor EncryptedKey element specified");
        }
        EncryptedType encryptedType = this.fEncryptedTypeContainer.getET();
        if (encryptedType == null) {
            throw new NullPointerException("Neither EncryptedData nor EncryptedKey element specified");
        }
        CipherValue cipherValue = this.getCipherValue(encryptedType);
        if (cipherValue != null) {
            ByteArrayOutputStream byteArrayOutputStream = (ByteArrayOutputStream)outputStream;
            try {
                byteArrayOutputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.setCipherValue(cipherValue, byteArrayOutputStream.toByteArray());
        }
        return encryptedType.getBase();
    }

    private void setCipherValue(CipherValue cipherValue, byte[] byArray) throws StructureException {
        Element element = cipherValue.getBase();
        cipherValue = new CipherValue();
        cipherValue.setValue(byArray);
        Element element2 = cipherValue.createElement(element.getOwnerDocument(), false);
        DOMUtil.removeChildNodes(element);
        DOMUtil.moveChildNodes(element2, element);
    }

    public Key generateKey() throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException, StructureException {
        KeyGenerationEngine keyGenerationEngine = this.getKeyGenerationEngine();
        this.fKey = keyGenerationEngine.generateKey();
        this.fAlgorithmFactory.releaseKeyGenerationEngine(keyGenerationEngine);
        if (this.debug) {
            System.out.println("HWC: EncryptionContext generateKey, about to call clearLocalProviderMap");
        }
        if (this.debug) {
            System.out.println("HWC: EncryptionContext, generateKey, after clearLocalProviderMap");
            Provider provider = (Provider)this.fAlgorithmFactory.getLocalProvider("HWCONFIG");
            if (provider != null) {
                System.out.println("HWC: EncryptionContext, generateKey, alg factory's hw provider: " + provider.getName());
            } else {
                System.out.println("HWC: EncryptionContext, generateKey, alg factory's hw provider is cleared");
            }
        }
        return this.fKey;
    }

    private KeyGenerationEngine getKeyGenerationEngine() throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException, StructureException {
        if (this.fEncryptedTypeContainer == null) {
            throw new NullPointerException("Neither EncryptedData nor EncryptedKey element specified");
        }
        EncryptionMethod encryptionMethod = this.fEncryptedTypeContainer.getEM();
        if (encryptionMethod == null) {
            throw new StructureException("EncryptionMethod element not specified");
        }
        String string = encryptionMethod.getAlgorithm();
        if (string == null) {
            throw new StructureException("Algorithm attribute not specified");
        }
        if (this.isHWAccelerationProvider()) {
            this.fAlgorithmFactory.setLocalProvider("HWCONFIG", this.getHWAccelerationProvider());
            if (this.debug) {
                System.out.println("HWC: EncryptionContext, getKeyGenerationEngine, hwprovider: " + this.getHWAccelerationProvider().getName());
            }
        }
        if (this.isHWKeyStoreProvider()) {
            this.fAlgorithmFactory.setLocalProvider("com.ibm.ws.wssecurity.config.keystore.keyStoreRef", this.getHWKeyStoreProvider());
        }
        if (this.debug) {
            System.out.println("HWC: EncryptionContext, getKeyGenerationEngine, about to call AlgorithmFactory's and uri is : " + string);
        }
        KeyGenerationEngine keyGenerationEngine = this.fAlgorithmFactory.getKeyGenerationEngine(string, this.fEncryptedTypeContainer.getType());
        AlgorithmParameterSpec algorithmParameterSpec = encryptionMethod.getParameterSpec(this.fAlgorithmFactory);
        keyGenerationEngine.init(algorithmParameterSpec);
        return keyGenerationEngine;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void replace() throws StructureException {
        String string;
        if (this.fEncryptedType == null) {
            throw new NullPointerException("Neither EncryptedData nor EncryptedKey element obtained");
        }
        if (!(this.fData instanceof Element)) throw new RuntimeException("Instance of unknown class: " + this.fData.getClass().getName());
        Element element = (Element)this.fData;
        Document document = element.getOwnerDocument();
        Element element2 = this.fEncryptedType;
        if (element2.getOwnerDocument() != document) {
            element2 = (Element)document.importNode(element2, true);
        }
        if ((string = this.fEncryptedTypeContainer.getType()).equals("http://www.w3.org/2001/04/xmlenc#Element")) {
            element2 = (Element)DOMUtil.replaceNode((Node)element, element2);
        } else {
            if (!string.equals("http://www.w3.org/2001/04/xmlenc#Content")) throw new StructureException("Unknown type: " + string);
            element2 = (Element)DOMUtil.replaceNodes(DOMUtil.getChildNodes(element), element2);
        }
        this.fEncryptedType = element2;
    }

    public void setResourceShower(ResourceShower resourceShower) {
        this.shower = resourceShower;
    }

    private ResourceOutputStream getResourceOutputStream(OutputStream outputStream) {
        return new ResourceOutputStream(outputStream, this.shower, this.fData, this.fEncryptedTypeContainer.getEncryptedType());
    }

    private OutputStream showResource(ResourceOutputStream resourceOutputStream) {
        resourceOutputStream.showResource();
        return resourceOutputStream.getOutputStream();
    }

    private void showResource(Key key) {
        this.shower.showEncryptedResource(key.getEncoded(), this.fData, this.fEncryptedTypeContainer.getEncryptedType());
    }
}

