/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xss4j.enc;

import com.ibm.wsspi.wssecurity.EncryptionEngine;
import com.ibm.wsspi.wssecurity.EngineFactory;
import com.ibm.wsspi.wssecurity.KeyGenerationEngine;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;

public abstract class EncryptionEngineImpl
implements EncryptionEngine {
    private static SecureRandom fSecureRandom = new SecureRandom();

    static SecureRandom getRandom() {
        return fSecureRandom;
    }

    public byte[] update(byte[] byArray) {
        return this.update(byArray, 0, byArray != null ? byArray.length : 0);
    }

    public byte[] doFinal() throws BadPaddingException, IllegalBlockSizeException {
        return this.doFinal(null);
    }

    public byte[] doFinal(byte[] byArray) throws BadPaddingException, IllegalBlockSizeException {
        return this.doFinal(byArray, 0, byArray != null ? byArray.length : 0);
    }

    public static class RSAOAEP
    extends RSA {
        private static final String TRANS = "RSA/ /OAEPPADDINGSHA-1";
        private static final String TRANS256 = "RSA/ /OAEPPADDINGSHA-256";
        private static final String TRANS512 = "RSA/ /OAEPPADDINGSHA-512";

        public RSAOAEP(Provider provider, EngineFactory engineFactory) throws NoSuchAlgorithmException {
            super(TRANS, provider, engineFactory, true);
        }

        public String getURI() {
            return "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p";
        }

        protected static Cipher getOaepCipher(AlgorithmParameterSpec algorithmParameterSpec, Provider provider) {
            Method method2;
            Cipher cipher = null;
            String string = TRANS;
            Class clazz = OAEPHelper.OAEPParameterSpecClass;
            if (algorithmParameterSpec != null && clazz != null && clazz.isInstance(algorithmParameterSpec) && (method2 = OAEPHelper.getDigestAlgorithm) != null) {
                try {
                    Object object = method2.invoke((Object)algorithmParameterSpec, new Object[0]);
                    String string2 = null;
                    if (object != null && object instanceof String) {
                        string2 = (String)object;
                        if ("SHA-1".equals(string2) || "SHA1".equals(string2)) {
                            string = TRANS;
                        } else if ("SHA-256".equals(string2) || "SHA256".equals(string2)) {
                            string = TRANS256;
                        } else if ("SHA-512".equals(string2) || "SHA512".equals(string2)) {
                            string = TRANS512;
                        }
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
            try {
                cipher = provider == null ? Cipher.getInstance(string) : Cipher.getInstance(string, provider);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            }
            catch (NoSuchPaddingException noSuchPaddingException) {
                // empty catch block
            }
            return cipher;
        }

        private static class OAEPHelper {
            static Class OAEPParameterSpecClass = null;
            static Method getDigestAlgorithm = null;

            private OAEPHelper() {
            }

            static {
                try {
                    OAEPParameterSpecClass = Class.forName("javax.crypto.spec.OAEPParameterSpec");
                    getDigestAlgorithm = OAEPParameterSpecClass.getMethod("getDigestAlgorithm", new Class[0]);
                }
                catch (SecurityException securityException) {
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
    }

    public static class RSA15
    extends RSA {
        private static final String TRANS = "RSA";

        public RSA15(Provider provider, EngineFactory engineFactory) throws NoSuchAlgorithmException {
            super(TRANS, provider, engineFactory);
        }

        public String getURI() {
            return "http://www.w3.org/2001/04/xmlenc#rsa-1_5";
        }
    }

    public static abstract class RSA
    extends EncryptionEngineImpl {
        private EngineFactory fEngineFactory;
        private int fOpMode;
        private Cipher fCipher;
        private Provider fProvider = null;
        private boolean fIsOaep = false;

        protected RSA(String string, Provider provider, EngineFactory engineFactory) throws NoSuchAlgorithmException {
            this.fEngineFactory = engineFactory;
            this.fProvider = provider;
            try {
                this.fCipher = provider != null ? Cipher.getInstance(string, provider) : Cipher.getInstance(string);
            }
            catch (NoSuchPaddingException noSuchPaddingException) {
                throw new NoSuchAlgorithmException(noSuchPaddingException.toString());
            }
        }

        protected RSA(String string, Provider provider, EngineFactory engineFactory, boolean bl) throws NoSuchAlgorithmException {
            this(string, provider, engineFactory);
            this.fIsOaep = bl;
        }

        public void init(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException, InvalidKeyException {
            Cipher cipher;
            this.fOpMode = n;
            switch (n) {
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    n = 1;
                    break;
                }
                case 4: {
                    n = 2;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown operation mode: " + n);
                }
            }
            if (this.fIsOaep && algorithmParameterSpec != null && (cipher = RSAOAEP.getOaepCipher(algorithmParameterSpec, this.fProvider)) != null) {
                this.fCipher = cipher;
            }
            if (key == null) {
                throw new NullPointerException("Key not specified");
            }
            if (algorithmParameterSpec != null) {
                this.fCipher.init(n, key, algorithmParameterSpec, RSA.getRandom());
            } else {
                this.fCipher.init(n, key, RSA.getRandom());
            }
        }

        public byte[] update(byte[] byArray, int n, int n2) {
            byte[] byArray2 = null;
            switch (this.fOpMode) {
                case 1: 
                case 2: {
                    if (byArray == null) {
                        throw new NullPointerException("Data not specified");
                    }
                    byArray2 = this.fCipher.update(byArray, n, n2);
                    break;
                }
                default: {
                    throw new IllegalStateException("EncryptionEngine not initialized");
                }
            }
            return byArray2;
        }

        public byte[] doFinal(byte[] byArray, int n, int n2) throws BadPaddingException, IllegalBlockSizeException {
            byte[] byArray2 = null;
            switch (this.fOpMode) {
                case 1: 
                case 2: {
                    if (byArray != null) {
                        byArray2 = this.fCipher.doFinal(byArray, n, n2);
                        break;
                    }
                    byArray2 = this.fCipher.doFinal();
                    break;
                }
                default: {
                    throw new IllegalStateException("EncryptionEngine not initialized");
                }
            }
            return byArray2;
        }

        public byte[] wrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
            byte[] byArray = null;
            switch (this.fOpMode) {
                case 3: {
                    if (key == null) {
                        throw new NullPointerException("Data not specified");
                    }
                    byte[] byArray2 = key.getEncoded();
                    if (byArray2 == null || byArray2.length == 0) {
                        throw new InvalidKeyException("Encoded data not obtained or too short");
                    }
                    try {
                        byArray = this.fCipher.doFinal(byArray2);
                        break;
                    }
                    catch (BadPaddingException badPaddingException) {
                        throw new RuntimeException(badPaddingException);
                    }
                }
                default: {
                    throw new IllegalStateException("EncryptionEngine not initialized");
                }
            }
            return byArray;
        }

        public Key unwrap(byte[] byArray, String string, String string2) throws InvalidKeyException, NoSuchAlgorithmException {
            Key key = null;
            switch (this.fOpMode) {
                case 4: {
                    if (byArray == null) {
                        throw new NullPointerException("Data not specified");
                    }
                    if (byArray.length == 0) {
                        throw new InvalidKeyException("Data too short");
                    }
                    byte[] byArray2 = null;
                    try {
                        byArray2 = this.fCipher.doFinal(byArray);
                    }
                    catch (BadPaddingException badPaddingException) {
                        throw new RuntimeException(badPaddingException);
                    }
                    catch (IllegalBlockSizeException illegalBlockSizeException) {
                        throw new RuntimeException(illegalBlockSizeException);
                    }
                    KeyGenerationEngine keyGenerationEngine = this.fEngineFactory.getKeyGenerationEngine(string, string2);
                    if (keyGenerationEngine == null) {
                        throw new NullPointerException("KeyGenerationEngine not obtained: " + string + ", " + string2);
                    }
                    key = keyGenerationEngine.generateKey(byArray2);
                    this.fEngineFactory.releaseKeyGenerationEngine(keyGenerationEngine);
                    break;
                }
                default: {
                    throw new IllegalStateException("EncryptionEngine not initialized");
                }
            }
            return key;
        }
    }

    public static class KWAES256
    extends KWAES {
        private static final int KEY_LENGTH = 32;

        public KWAES256(Provider provider, EngineFactory engineFactory) throws NoSuchAlgorithmException {
            super(provider, engineFactory);
        }

        public String getURI() {
            return "http://www.w3.org/2001/04/xmlenc#kw-aes256";
        }

        public void init(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException, InvalidKeyException {
            if (key == null) {
                throw new NullPointerException("Key not specified");
            }
            byte[] byArray = key.getEncoded();
            if (byArray == null) {
                throw new InvalidKeyException("Encoded key not obtained");
            }
            if (byArray.length != 32) {
                throw new InvalidKeyException("Wrong length: " + byArray.length);
            }
            super.init(n, key, algorithmParameterSpec);
        }
    }

    public static class KWAES192
    extends KWAES {
        private static final int KEY_LENGTH = 24;

        public KWAES192(Provider provider, EngineFactory engineFactory) throws NoSuchAlgorithmException {
            super(provider, engineFactory);
        }

        public String getURI() {
            return "http://www.w3.org/2001/04/xmlenc#kw-aes192";
        }

        public void init(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException, InvalidKeyException {
            if (key == null) {
                throw new NullPointerException("Key not specified");
            }
            byte[] byArray = key.getEncoded();
            if (byArray == null) {
                throw new InvalidKeyException("Encoded key not obtained");
            }
            if (byArray.length != 24) {
                throw new InvalidKeyException("Wrong length: " + byArray.length);
            }
            super.init(n, key, algorithmParameterSpec);
        }
    }

    public static class KWAES128
    extends KWAES {
        private static final int KEY_LENGTH = 16;

        public KWAES128(Provider provider, EngineFactory engineFactory) throws NoSuchAlgorithmException {
            super(provider, engineFactory);
        }

        public String getURI() {
            return "http://www.w3.org/2001/04/xmlenc#kw-aes128";
        }

        public void init(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException, InvalidKeyException {
            if (key == null) {
                throw new NullPointerException("Key not specified");
            }
            byte[] byArray = key.getEncoded();
            if (byArray == null) {
                throw new InvalidKeyException("Encoded key not obtained");
            }
            if (byArray.length != 16) {
                throw new InvalidKeyException("Wrong length: " + byArray.length);
            }
            super.init(n, key, algorithmParameterSpec);
        }
    }

    public static abstract class KWAES
    extends EncryptionEngineImpl {
        private static final String TRANS = "AES/ECB/NoPadding";
        private static final int BLOCK_SIZE = 8;
        private static final byte[] PADS = new byte[]{-90, -90, -90, -90, -90, -90, -90, -90};
        private EngineFactory fEngineFactory;
        private int fOpMode;
        private Cipher fCipher;

        protected KWAES(Provider provider, EngineFactory engineFactory) throws NoSuchAlgorithmException {
            this.fEngineFactory = engineFactory;
            try {
                this.fCipher = provider != null ? Cipher.getInstance(TRANS, provider) : Cipher.getInstance(TRANS);
            }
            catch (NoSuchPaddingException noSuchPaddingException) {
                throw new NoSuchAlgorithmException(noSuchPaddingException.toString());
            }
        }

        private void encryptBlocks(byte[] byArray, int n) throws BadPaddingException, IllegalBlockSizeException {
            for (int i = 0; i <= 5; ++i) {
                for (int j = 1; j <= n; ++j) {
                    int n2 = j + i * n;
                    this.processBlock(byArray, j);
                    this.xorBlock(byArray, n2);
                }
            }
        }

        private void decryptBlocks(byte[] byArray, int n) throws BadPaddingException, IllegalBlockSizeException {
            for (int i = 5; i >= 0; --i) {
                for (int j = n; j >= 1; --j) {
                    int n2 = j + i * n;
                    this.xorBlock(byArray, n2);
                    this.processBlock(byArray, j);
                }
            }
        }

        private void processBlock(byte[] byArray, int n) throws BadPaddingException, IllegalBlockSizeException {
            byte[] byArray2 = new byte[16];
            System.arraycopy(byArray, 0, byArray2, 0, 8);
            System.arraycopy(byArray, 8 * n, byArray2, 8, 8);
            byArray2 = this.fCipher.doFinal(byArray2);
            System.arraycopy(byArray2, 0, byArray, 0, 8);
            System.arraycopy(byArray2, 8, byArray, 8 * n, 8);
        }

        private void xorBlock(byte[] byArray, int n) {
            byte[] byArray2 = BigInteger.valueOf(n).toByteArray();
            for (int i = 0; i < 8; ++i) {
                int n2 = i - 8 + byArray2.length;
                int n3 = 0;
                if (n2 >= 0) {
                    n3 = byArray2[n2];
                }
                byArray[i] = (byte)(n3 ^= byArray[i]);
            }
        }

        private boolean arePadsChanged(byte[] byArray) {
            boolean bl = false;
            for (int i = 0; !bl && i < PADS.length; ++i) {
                if (byArray[i] == PADS[i]) continue;
                bl = true;
            }
            return bl;
        }

        public void init(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException, InvalidKeyException {
            this.fOpMode = n;
            switch (n) {
                case 1: 
                case 2: {
                    throw new IllegalArgumentException("Unsupported operation mode: " + n);
                }
                case 3: {
                    this.fCipher.init(1, key, KWAES.getRandom());
                    break;
                }
                case 4: {
                    this.fCipher.init(2, key, KWAES.getRandom());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown operation mode: " + n);
                }
            }
        }

        public byte[] update(byte[] byArray, int n, int n2) {
            throw new UnsupportedOperationException("Unsupported method: EncryptionEngineImpl$KWAES.update(byte[], int, int)");
        }

        public byte[] doFinal(byte[] byArray, int n, int n2) throws BadPaddingException, IllegalBlockSizeException {
            throw new UnsupportedOperationException("Unsupported method: EncryptionEngineImpl$KWAES.doFinal(byte[], int, int)");
        }

        public byte[] wrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
            byte[] byArray = null;
            switch (this.fOpMode) {
                case 3: {
                    if (key == null) {
                        throw new NullPointerException("Data not specified");
                    }
                    byte[] byArray2 = key.getEncoded();
                    if (byArray2 == null || byArray2.length == 0) {
                        throw new InvalidKeyException("Encoded data not obtained or too short");
                    }
                    if (byArray2.length % 8 > 0) {
                        throw new InvalidKeyException("Encoded data not multiple of 8 bytes");
                    }
                    byArray = new byte[PADS.length + byArray2.length];
                    System.arraycopy(PADS, 0, byArray, 0, PADS.length);
                    System.arraycopy(byArray2, 0, byArray, PADS.length, byArray2.length);
                    int n = byArray2.length / 8;
                    try {
                        if (n > 1) {
                            this.encryptBlocks(byArray, n);
                            break;
                        }
                        this.processBlock(byArray, 1);
                        break;
                    }
                    catch (BadPaddingException badPaddingException) {
                        throw new RuntimeException(badPaddingException);
                    }
                }
                default: {
                    throw new IllegalStateException("EncryptionEngine not initialized");
                }
            }
            return byArray;
        }

        public Key unwrap(byte[] byArray, String string, String string2) throws InvalidKeyException, NoSuchAlgorithmException {
            Key key = null;
            switch (this.fOpMode) {
                case 4: {
                    if (byArray == null) {
                        throw new NullPointerException("Data not specified");
                    }
                    if (byArray.length < 16) {
                        throw new InvalidKeyException("Data too short");
                    }
                    if (byArray.length % 8 > 0) {
                        throw new InvalidKeyException("Data not multiple of 8 bytes");
                    }
                    byte[] byArray2 = (byte[])byArray.clone();
                    int n = byArray2.length / 8 - 1;
                    try {
                        if (n > 1) {
                            this.decryptBlocks(byArray2, n);
                        } else {
                            this.processBlock(byArray2, 1);
                        }
                        if (this.arePadsChanged(byArray2)) {
                            throw new BadPaddingException("Wrong pads");
                        }
                    }
                    catch (BadPaddingException badPaddingException) {
                        throw new RuntimeException(badPaddingException);
                    }
                    catch (IllegalBlockSizeException illegalBlockSizeException) {
                        throw new RuntimeException(illegalBlockSizeException);
                    }
                    byte[] byArray3 = new byte[byArray2.length - 8];
                    System.arraycopy(byArray2, 8, byArray3, 0, byArray3.length);
                    KeyGenerationEngine keyGenerationEngine = this.fEngineFactory.getKeyGenerationEngine(string, string2);
                    if (keyGenerationEngine == null) {
                        throw new NullPointerException("KeyGenerationEngine not obtained: " + string + ", " + string2);
                    }
                    key = keyGenerationEngine.generateKey(byArray3);
                    this.fEngineFactory.releaseKeyGenerationEngine(keyGenerationEngine);
                    break;
                }
                default: {
                    throw new IllegalStateException("EncryptionEngine not initialized");
                }
            }
            return key;
        }
    }

    public static class AES256CBC
    extends AESCBC {
        private static final int KEY_LENGTH = 32;

        public AES256CBC(Provider provider) throws NoSuchAlgorithmException {
            super(provider);
        }

        public String getURI() {
            return "http://www.w3.org/2001/04/xmlenc#aes256-cbc";
        }

        public void init(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException, InvalidKeyException {
            if (key == null) {
                throw new NullPointerException("Key not specified");
            }
            byte[] byArray = key.getEncoded();
            if (byArray == null) {
                throw new InvalidKeyException("Encoded key not obtained");
            }
            if (byArray.length != 32) {
                throw new InvalidKeyException("Wrong length: " + byArray.length);
            }
            super.init(n, key, algorithmParameterSpec);
        }
    }

    public static class AES192CBC
    extends AESCBC {
        private static final int KEY_LENGTH = 24;

        public AES192CBC(Provider provider) throws NoSuchAlgorithmException {
            super(provider);
        }

        public String getURI() {
            return "http://www.w3.org/2001/04/xmlenc#aes192-cbc";
        }

        public void init(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException, InvalidKeyException {
            if (key == null) {
                throw new NullPointerException("Key not specified");
            }
            byte[] byArray = key.getEncoded();
            if (byArray == null) {
                throw new InvalidKeyException("Encoded key not obtained");
            }
            if (byArray.length != 24) {
                throw new InvalidKeyException("Wrong length: " + byArray.length);
            }
            super.init(n, key, algorithmParameterSpec);
        }
    }

    public static class AES128CBC
    extends AESCBC {
        private static final int KEY_LENGTH = 16;

        public AES128CBC(Provider provider) throws NoSuchAlgorithmException {
            super(provider);
        }

        public String getURI() {
            return "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
        }

        public void init(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException, InvalidKeyException {
            if (key == null) {
                throw new NullPointerException("Key not specified");
            }
            byte[] byArray = key.getEncoded();
            if (byArray == null) {
                throw new InvalidKeyException("Encoded key not obtained");
            }
            if (byArray.length != 16) {
                throw new InvalidKeyException("Wrong length: " + byArray.length);
            }
            super.init(n, key, algorithmParameterSpec);
        }
    }

    public static abstract class AESCBC
    extends EncryptionEngineImpl {
        private static final String TRANS = "AES/CBC/NoPadding";
        private static final int BLOCK_SIZE = 16;
        private int fOpMode;
        private Key fKey;
        private Cipher fCipher;
        private boolean fFirstOutput;
        private int fLength;
        private byte[] fIv;
        private int fIndex;
        private boolean fInitialized;
        private byte[] fBuffer;
        private int fIndex2;

        protected AESCBC(Provider provider) throws NoSuchAlgorithmException {
            try {
                this.fCipher = provider != null ? Cipher.getInstance(TRANS, provider) : Cipher.getInstance(TRANS);
            }
            catch (NoSuchPaddingException noSuchPaddingException) {
                throw new NoSuchAlgorithmException(noSuchPaddingException.toString());
            }
            this.fIndex = -1;
            this.fIndex2 = -1;
        }

        private byte[] addIv(byte[] byArray) {
            byte[] byArray2 = null;
            if (byArray != null && byArray.length > 0) {
                byte[] byArray3 = this.fCipher.getIV();
                byArray2 = new byte[byArray3.length + byArray.length];
                System.arraycopy(byArray3, 0, byArray2, 0, byArray3.length);
                System.arraycopy(byArray, 0, byArray2, byArray3.length, byArray.length);
            } else {
                byArray2 = this.fCipher.getIV();
            }
            return byArray2;
        }

        private byte[] removeIv(byte[] byArray, int n, int n2) {
            int n3 = 16 - this.fIndex;
            byte[] byArray2 = null;
            if (n3 > n2) {
                System.arraycopy(byArray, n, this.fIv, this.fIndex, n2);
                this.fIndex += n2;
                byArray2 = new byte[]{};
            } else {
                System.arraycopy(byArray, n, this.fIv, this.fIndex, n3);
                try {
                    this.fCipher.init(this.fOpMode, this.fKey, new IvParameterSpec(this.fIv), AESCBC.getRandom());
                }
                catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                    throw new RuntimeException(invalidAlgorithmParameterException);
                }
                catch (InvalidKeyException invalidKeyException) {
                    throw new RuntimeException(invalidKeyException);
                }
                this.fIndex = -1;
                this.fInitialized = true;
                byArray2 = new byte[n2 - n3];
                System.arraycopy(byArray, n + n3, byArray2, 0, byArray2.length);
            }
            return byArray2;
        }

        private byte[] addPads(byte[] byArray, int n, int n2) {
            int n3 = 16 - this.fLength % 16;
            int n4 = 0;
            if (byArray != null) {
                n4 += n2;
            }
            byte[] byArray2 = new byte[n4 += n3];
            if (byArray != null) {
                System.arraycopy(byArray, n, byArray2, 0, n2);
            }
            for (int i = n4 - n3; i < n4; ++i) {
                byArray2[i] = (byte)n3;
            }
            return byArray2;
        }

        private byte[] bufferData(byte[] byArray) {
            byte[] byArray2 = null;
            if (byArray != null && byArray.length > 0) {
                if (16 - this.fIndex2 >= byArray.length) {
                    System.arraycopy(byArray, 0, this.fBuffer, this.fIndex2, byArray.length);
                    this.fIndex2 += byArray.length;
                } else {
                    byte[] byArray3 = new byte[this.fIndex2 + byArray.length];
                    System.arraycopy(this.fBuffer, 0, byArray3, 0, this.fIndex2);
                    System.arraycopy(byArray, 0, byArray3, this.fIndex2, byArray.length);
                    byArray2 = new byte[byArray3.length - 16];
                    System.arraycopy(byArray3, 0, byArray2, 0, byArray2.length);
                    System.arraycopy(byArray3, byArray2.length, this.fBuffer, 0, 16);
                    this.fIndex2 = 16;
                }
            }
            return byArray2;
        }

        private byte[] removePads(byte[] byArray) throws BadPaddingException {
            int n = 0;
            if (byArray != null) {
                n += byArray.length;
            }
            byte[] byArray2 = new byte[this.fIndex2 + n];
            System.arraycopy(this.fBuffer, 0, byArray2, 0, this.fIndex2);
            if (byArray != null) {
                System.arraycopy(byArray, 0, byArray2, this.fIndex2, byArray.length);
            }
            this.fIndex2 = -1;
            if (byArray2.length == 0) {
                throw new BadPaddingException("No pads");
            }
            int n2 = byArray2[byArray2.length - 1] & 0xFF;
            if (n2 <= 0 || n2 > 16) {
                throw new BadPaddingException("Wrong pad: " + n2);
            }
            if (n2 > byArray2.length) {
                throw new BadPaddingException("Fewer pads");
            }
            byte[] byArray3 = null;
            if (n2 < byArray2.length) {
                byArray3 = new byte[byArray2.length - n2];
                System.arraycopy(byArray2, 0, byArray3, 0, byArray3.length);
            }
            return byArray3;
        }

        public void init(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException, InvalidKeyException {
            this.fOpMode = n;
            this.fKey = key;
            switch (n) {
                case 1: {
                    if (algorithmParameterSpec != null) {
                        this.fCipher.init(n, key, algorithmParameterSpec, AESCBC.getRandom());
                    } else {
                        this.fCipher.init(n, key, AESCBC.getRandom());
                    }
                    this.fFirstOutput = true;
                    this.fLength = 0;
                    break;
                }
                case 2: {
                    this.fIv = new byte[16];
                    this.fIndex = 0;
                    this.fInitialized = false;
                    this.fBuffer = new byte[16];
                    this.fIndex2 = 0;
                    break;
                }
                case 3: 
                case 4: {
                    throw new IllegalArgumentException("Unsupported operation mode: " + n);
                }
                default: {
                    throw new IllegalArgumentException("Unknown operation mode: " + n);
                }
            }
        }

        public byte[] update(byte[] byArray, int n, int n2) {
            byte[] byArray2 = null;
            switch (this.fOpMode) {
                case 1: {
                    if (byArray == null) {
                        throw new NullPointerException("Data not specified");
                    }
                    byArray2 = this.fCipher.update(byArray, n, n2);
                    if (this.fFirstOutput) {
                        byArray2 = this.addIv(byArray2);
                        this.fFirstOutput = false;
                    }
                    this.fLength += n2;
                    break;
                }
                case 2: {
                    if (byArray == null) {
                        throw new NullPointerException("Data not specified");
                    }
                    if (!this.fInitialized) {
                        byArray = this.removeIv(byArray, n, n2);
                        n = 0;
                        n2 = byArray.length;
                    }
                    if (!this.fInitialized) break;
                    byArray2 = this.fCipher.update(byArray, n, n2);
                    byArray2 = this.bufferData(byArray2);
                    break;
                }
                default: {
                    throw new IllegalStateException("EncryptionEngine not initialized");
                }
            }
            return byArray2;
        }

        public byte[] doFinal(byte[] byArray, int n, int n2) throws BadPaddingException, IllegalBlockSizeException {
            byte[] byArray2 = null;
            switch (this.fOpMode) {
                case 1: {
                    if (byArray != null) {
                        this.fLength += n2;
                    }
                    byArray = this.addPads(byArray, n, n2);
                    byArray2 = this.fCipher.doFinal(byArray);
                    if (this.fFirstOutput) {
                        byArray2 = this.addIv(byArray2);
                    }
                    this.fFirstOutput = true;
                    this.fLength = 0;
                    break;
                }
                case 2: {
                    if (byArray != null) {
                        if (!this.fInitialized) {
                            byArray = this.removeIv(byArray, n, n2);
                        }
                        byArray2 = this.fCipher.doFinal(byArray, n, n2);
                    } else {
                        byArray2 = this.fCipher.doFinal();
                    }
                    byArray2 = this.removePads(byArray2);
                    this.fIndex = 0;
                    this.fInitialized = false;
                    this.fIndex2 = 0;
                    break;
                }
                default: {
                    throw new IllegalStateException("EncryptionEngine not initialized");
                }
            }
            return byArray2;
        }

        public byte[] wrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
            throw new UnsupportedOperationException("Unsupported method: EncryptionEngineImpl$AESCBC.wrap(Key)");
        }

        public Key unwrap(byte[] byArray, String string, String string2) throws InvalidKeyException, NoSuchAlgorithmException {
            throw new UnsupportedOperationException("Unsupported method: EncryptionEngineImpl$AESCBC.unwrap(byte[], String, String)");
        }
    }

    public static class KWTripleDES
    extends EncryptionEngineImpl {
        private static final String TRANS = "DESede/CBC/NoPadding";
        private static final byte[] IV = new byte[]{74, -35, -94, 44, 121, -24, 33, 5};
        private EngineFactory fEngineFactory;
        private int fOpMode;
        private Key fKey;
        private Cipher fCipher0;
        private Cipher fCipher1;

        public KWTripleDES(Provider provider, EngineFactory engineFactory) throws NoSuchAlgorithmException {
            this.fEngineFactory = engineFactory;
            try {
                if (provider != null) {
                    this.fCipher0 = Cipher.getInstance(TRANS, provider);
                    this.fCipher1 = Cipher.getInstance(TRANS, provider);
                } else {
                    this.fCipher0 = Cipher.getInstance(TRANS);
                    this.fCipher1 = Cipher.getInstance(TRANS);
                }
            }
            catch (NoSuchPaddingException noSuchPaddingException) {
                throw new RuntimeException(noSuchPaddingException);
            }
        }

        private byte[] addChecksum(byte[] byArray) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException {
            MessageDigest messageDigest = this.fEngineFactory.getMessageDigest("http://www.w3.org/2000/09/xmldsig#sha1", null);
            byte[] byArray2 = messageDigest.digest(byArray);
            this.fEngineFactory.releaseMessageDigest("http://www.w3.org/2000/09/xmldsig#sha1", messageDigest);
            byte[] byArray3 = new byte[byArray.length + 8];
            System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
            System.arraycopy(byArray2, 0, byArray3, byArray.length, 8);
            return byArray3;
        }

        private byte[] addIv(byte[] byArray) {
            byte[] byArray2 = this.fCipher0.getIV();
            byte[] byArray3 = new byte[byArray.length + 8];
            System.arraycopy(byArray2, 0, byArray3, 0, 8);
            System.arraycopy(byArray, 0, byArray3, 8, byArray.length);
            return byArray3;
        }

        private byte[] reverse(byte[] byArray) {
            byte[] byArray2 = new byte[byArray.length];
            for (int i = 0; i < byArray.length; ++i) {
                byArray2[byArray2.length - i - 1] = byArray[i];
            }
            return byArray2;
        }

        private byte[] removeIv(byte[] byArray) {
            byte[] byArray2 = new byte[8];
            byte[] byArray3 = new byte[byArray.length - 8];
            System.arraycopy(byArray, 0, byArray2, 0, 8);
            System.arraycopy(byArray, 8, byArray3, 0, byArray3.length);
            try {
                this.fCipher0.init(2, this.fKey, new IvParameterSpec(byArray2), KWTripleDES.getRandom());
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new RuntimeException(invalidAlgorithmParameterException);
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new RuntimeException(invalidKeyException);
            }
            return byArray3;
        }

        private byte[] removeChecksum(byte[] byArray) throws InvalidAlgorithmParameterException, InvalidKeyException, NoSuchAlgorithmException {
            byte[] byArray2 = new byte[byArray.length - 8];
            byte[] byArray3 = new byte[8];
            System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
            System.arraycopy(byArray, byArray2.length, byArray3, 0, 8);
            MessageDigest messageDigest = this.fEngineFactory.getMessageDigest("http://www.w3.org/2000/09/xmldsig#sha1", null);
            byte[] byArray4 = messageDigest.digest(byArray2);
            this.fEngineFactory.releaseMessageDigest("http://www.w3.org/2000/09/xmldsig#sha1", messageDigest);
            for (int i = 0; i < 8; ++i) {
                if (byArray3[i] == byArray4[i]) continue;
                throw new InvalidKeyException("Wrong checksum");
            }
            return byArray2;
        }

        public String getURI() {
            return "http://www.w3.org/2001/04/xmlenc#kw-tripledes";
        }

        public void init(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException, InvalidKeyException {
            this.fOpMode = n;
            this.fKey = key;
            switch (n) {
                case 1: 
                case 2: {
                    throw new IllegalArgumentException("Unsupported operation mode: " + n);
                }
                case 3: {
                    if (key == null) {
                        throw new NullPointerException("Key not specified");
                    }
                    this.fCipher0.init(1, key, KWTripleDES.getRandom());
                    this.fCipher1.init(1, key, new IvParameterSpec(IV), KWTripleDES.getRandom());
                    break;
                }
                case 4: {
                    if (key == null) {
                        throw new NullPointerException("Key not specified");
                    }
                    this.fCipher1.init(2, key, new IvParameterSpec(IV), KWTripleDES.getRandom());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown operation mode: " + n);
                }
            }
        }

        public byte[] update(byte[] byArray, int n, int n2) {
            throw new UnsupportedOperationException("Unsupported method: EncryptionEngineImpl$KWTripleDES.update(byte[], int, int)");
        }

        public byte[] doFinal(byte[] byArray, int n, int n2) throws BadPaddingException, IllegalBlockSizeException {
            throw new UnsupportedOperationException("Unsupported method: EncryptionEngineImpl$KWTripleDES.doFinal(byte[], int, int)");
        }

        public byte[] wrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
            byte[] byArray = null;
            switch (this.fOpMode) {
                case 3: {
                    if (key == null) {
                        throw new NullPointerException("Data not specified");
                    }
                    byte[] byArray2 = key.getEncoded();
                    if (byArray2 == null || byArray2.length == 0) {
                        throw new InvalidKeyException("Encoded data not obtained or too short");
                    }
                    try {
                        byArray2 = this.addChecksum(byArray2);
                        byArray2 = this.fCipher0.doFinal(byArray2);
                        byArray2 = this.addIv(byArray2);
                        byArray2 = this.reverse(byArray2);
                        byArray = this.fCipher1.doFinal(byArray2);
                        break;
                    }
                    catch (BadPaddingException badPaddingException) {
                        throw new RuntimeException(badPaddingException);
                    }
                    catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                        throw new RuntimeException(invalidAlgorithmParameterException);
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        throw new RuntimeException(noSuchAlgorithmException);
                    }
                }
                default: {
                    throw new IllegalStateException("EncryptionEngine not initialized");
                }
            }
            return byArray;
        }

        public Key unwrap(byte[] byArray, String string, String string2) throws InvalidKeyException, NoSuchAlgorithmException {
            Key key = null;
            switch (this.fOpMode) {
                case 4: {
                    if (byArray == null) {
                        throw new NullPointerException("Data not specified");
                    }
                    KeyGenerationEngine keyGenerationEngine = this.fEngineFactory.getKeyGenerationEngine(string, string2);
                    if (keyGenerationEngine == null) {
                        throw new NullPointerException("KeyGenerationEngine not obtained: " + string + ", " + string2);
                    }
                    if (byArray.length != keyGenerationEngine.getKeySize() + 16) {
                        this.fEngineFactory.releaseKeyGenerationEngine(keyGenerationEngine);
                        throw new InvalidKeyException("Wrong length: " + byArray.length);
                    }
                    byte[] byArray2 = null;
                    try {
                        byArray2 = this.fCipher1.doFinal(byArray);
                        byArray2 = this.reverse(byArray2);
                        byArray2 = this.removeIv(byArray2);
                        byArray2 = this.fCipher0.doFinal(byArray2);
                        byArray2 = this.removeChecksum(byArray2);
                    }
                    catch (BadPaddingException badPaddingException) {
                        throw new RuntimeException(badPaddingException);
                    }
                    catch (IllegalBlockSizeException illegalBlockSizeException) {
                        throw new RuntimeException(illegalBlockSizeException);
                    }
                    catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                        throw new RuntimeException(invalidAlgorithmParameterException);
                    }
                    key = keyGenerationEngine.generateKey(byArray2);
                    this.fEngineFactory.releaseKeyGenerationEngine(keyGenerationEngine);
                    break;
                }
                default: {
                    throw new IllegalStateException("EncryptionEngine not initialized");
                }
            }
            return key;
        }
    }

    public static class TripleDESCBC
    extends EncryptionEngineImpl {
        private static final String TRANS = "DESede/CBC/NoPadding";
        private static final int BLOCK_SIZE = 8;
        private int fOpMode;
        private Key fKey;
        private Cipher fCipher;
        private boolean fFirstOutput;
        private int fLength;
        private byte[] fIv;
        private int fIndex;
        private boolean fInitialized;
        private byte[] fBuffer;
        private int fIndex2;

        public TripleDESCBC(Provider provider) throws NoSuchAlgorithmException {
            try {
                this.fCipher = provider != null ? Cipher.getInstance(TRANS, provider) : Cipher.getInstance(TRANS);
            }
            catch (NoSuchPaddingException noSuchPaddingException) {
                throw new RuntimeException(noSuchPaddingException);
            }
            this.fIndex = -1;
            this.fIndex2 = -1;
        }

        private byte[] addIv(byte[] byArray) {
            byte[] byArray2 = null;
            if (byArray != null && byArray.length > 0) {
                byte[] byArray3 = this.fCipher.getIV();
                byArray2 = new byte[byArray3.length + byArray.length];
                System.arraycopy(byArray3, 0, byArray2, 0, byArray3.length);
                System.arraycopy(byArray, 0, byArray2, byArray3.length, byArray.length);
            } else {
                byArray2 = this.fCipher.getIV();
            }
            return byArray2;
        }

        private byte[] removeIv(byte[] byArray, int n, int n2) {
            int n3 = 8 - this.fIndex;
            byte[] byArray2 = null;
            if (n3 > n2) {
                System.arraycopy(byArray, n, this.fIv, this.fIndex, n2);
                this.fIndex += n2;
                byArray2 = new byte[]{};
            } else {
                System.arraycopy(byArray, n, this.fIv, this.fIndex, n3);
                if (this.fKey == null) {
                    throw new NullPointerException("Key not specified");
                }
                try {
                    this.fCipher.init(this.fOpMode, this.fKey, new IvParameterSpec(this.fIv), TripleDESCBC.getRandom());
                }
                catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                    throw new RuntimeException(invalidAlgorithmParameterException);
                }
                catch (InvalidKeyException invalidKeyException) {
                    throw new RuntimeException(invalidKeyException);
                }
                this.fIndex = -1;
                this.fInitialized = true;
                byArray2 = new byte[n2 - n3];
                System.arraycopy(byArray, n + n3, byArray2, 0, byArray2.length);
            }
            return byArray2;
        }

        private byte[] addPads(byte[] byArray, int n, int n2) {
            int n3 = 8 - this.fLength % 8;
            int n4 = 0;
            if (byArray != null) {
                n4 += n2;
            }
            byte[] byArray2 = new byte[n4 += n3];
            if (byArray != null) {
                System.arraycopy(byArray, n, byArray2, 0, n2);
            }
            for (int i = n4 - n3; i < n4; ++i) {
                byArray2[i] = (byte)n3;
            }
            return byArray2;
        }

        private byte[] bufferData(byte[] byArray) {
            byte[] byArray2 = null;
            if (byArray != null && byArray.length > 0) {
                if (8 - this.fIndex2 >= byArray.length) {
                    System.arraycopy(byArray, 0, this.fBuffer, this.fIndex2, byArray.length);
                    this.fIndex2 += byArray.length;
                } else {
                    byte[] byArray3 = new byte[this.fIndex2 + byArray.length];
                    System.arraycopy(this.fBuffer, 0, byArray3, 0, this.fIndex2);
                    System.arraycopy(byArray, 0, byArray3, this.fIndex2, byArray.length);
                    byArray2 = new byte[byArray3.length - 8];
                    System.arraycopy(byArray3, 0, byArray2, 0, byArray2.length);
                    System.arraycopy(byArray3, byArray2.length, this.fBuffer, 0, 8);
                    this.fIndex2 = 8;
                }
            }
            return byArray2;
        }

        private byte[] removePads(byte[] byArray) throws BadPaddingException {
            int n = 0;
            if (byArray != null) {
                n += byArray.length;
            }
            byte[] byArray2 = new byte[this.fIndex2 + n];
            System.arraycopy(this.fBuffer, 0, byArray2, 0, this.fIndex2);
            if (byArray != null) {
                System.arraycopy(byArray, 0, byArray2, this.fIndex2, byArray.length);
            }
            this.fIndex2 = -1;
            if (byArray2.length == 0) {
                throw new BadPaddingException("No pads");
            }
            int n2 = byArray2[byArray2.length - 1] & 0xFF;
            if (n2 <= 0 || n2 > 8) {
                throw new BadPaddingException("Wrong pad: " + n2);
            }
            if (n2 > byArray2.length) {
                throw new BadPaddingException("Fewer pads");
            }
            byte[] byArray3 = null;
            if (n2 < byArray2.length) {
                byArray3 = new byte[byArray2.length - n2];
                System.arraycopy(byArray2, 0, byArray3, 0, byArray3.length);
            }
            return byArray3;
        }

        public String getURI() {
            return "http://www.w3.org/2001/04/xmlenc#tripledes-cbc";
        }

        public void init(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException, InvalidKeyException {
            this.fOpMode = n;
            this.fKey = key;
            switch (n) {
                case 1: {
                    if (key == null) {
                        throw new NullPointerException("Key not specified");
                    }
                    if (algorithmParameterSpec != null) {
                        this.fCipher.init(n, key, algorithmParameterSpec, TripleDESCBC.getRandom());
                    } else {
                        this.fCipher.init(n, key, TripleDESCBC.getRandom());
                    }
                    this.fFirstOutput = true;
                    this.fLength = 0;
                    break;
                }
                case 2: {
                    this.fIv = new byte[8];
                    this.fIndex = 0;
                    this.fInitialized = false;
                    this.fBuffer = new byte[8];
                    this.fIndex2 = 0;
                    break;
                }
                case 3: 
                case 4: {
                    throw new IllegalArgumentException("Unsupported operation mode: " + n);
                }
                default: {
                    throw new IllegalArgumentException("Unknown operation mode: " + n);
                }
            }
        }

        public byte[] update(byte[] byArray, int n, int n2) {
            byte[] byArray2 = null;
            switch (this.fOpMode) {
                case 1: {
                    if (byArray == null) {
                        throw new NullPointerException("Data not specified");
                    }
                    byArray2 = this.fCipher.update(byArray, n, n2);
                    if (this.fFirstOutput) {
                        byArray2 = this.addIv(byArray2);
                        this.fFirstOutput = false;
                    }
                    this.fLength += n2;
                    break;
                }
                case 2: {
                    if (byArray == null) {
                        throw new NullPointerException("Data not specified");
                    }
                    if (!this.fInitialized) {
                        byArray = this.removeIv(byArray, n, n2);
                        n = 0;
                        n2 = byArray.length;
                    }
                    if (!this.fInitialized) break;
                    byArray2 = this.fCipher.update(byArray, n, n2);
                    byArray2 = this.bufferData(byArray2);
                    break;
                }
                default: {
                    throw new IllegalStateException("EncryptionEngine not initialized");
                }
            }
            return byArray2;
        }

        public byte[] doFinal(byte[] byArray, int n, int n2) throws BadPaddingException, IllegalBlockSizeException {
            byte[] byArray2 = null;
            switch (this.fOpMode) {
                case 1: {
                    if (byArray != null) {
                        this.fLength += n2;
                    }
                    byArray = this.addPads(byArray, n, n2);
                    byArray2 = this.fCipher.doFinal(byArray);
                    if (this.fFirstOutput) {
                        byArray2 = this.addIv(byArray2);
                    }
                    this.fFirstOutput = true;
                    this.fLength = 0;
                    break;
                }
                case 2: {
                    if (byArray != null) {
                        if (!this.fInitialized) {
                            byArray = this.removeIv(byArray, n, n2);
                            n = 0;
                            n2 = byArray.length;
                        }
                        byArray2 = this.fCipher.doFinal(byArray, n, n2);
                    } else {
                        byArray2 = this.fCipher.doFinal();
                    }
                    byArray2 = this.removePads(byArray2);
                    this.fIndex = 0;
                    this.fInitialized = false;
                    this.fIndex2 = 0;
                    break;
                }
                default: {
                    throw new IllegalStateException("EncryptionEngine not initialized");
                }
            }
            return byArray2;
        }

        public byte[] wrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
            throw new UnsupportedOperationException("Unsupported method: EncryptionEngineImpl$TripleDESCBC.wrap(Key)");
        }

        public Key unwrap(byte[] byArray, String string, String string2) throws InvalidKeyException, NoSuchAlgorithmException {
            throw new UnsupportedOperationException("Unsupported method: EncryptionEngineImpl$TripleDESCBC.unwrap(byte[], String, String)");
        }
    }

    public static class HWC_KWTripleDES
    extends EncryptionEngineImpl {
        private static final String TRANS = "DESede/CBC/NoPadding";
        private static final byte[] IV = new byte[]{74, -35, -94, 44, 121, -24, 33, 5};
        private EngineFactory fEngineFactory;
        private int fOpMode;
        private Key fKey;
        private Cipher fCipher0;
        private Cipher fCipher1;

        public HWC_KWTripleDES(Provider provider, EngineFactory engineFactory) throws NoSuchAlgorithmException {
            this.fEngineFactory = engineFactory;
            try {
                if (provider != null) {
                    this.fCipher0 = Cipher.getInstance(TRANS, provider);
                    this.fCipher1 = Cipher.getInstance(TRANS, provider);
                } else {
                    this.fCipher0 = Cipher.getInstance(TRANS);
                    this.fCipher1 = Cipher.getInstance(TRANS);
                }
            }
            catch (NoSuchPaddingException noSuchPaddingException) {
                throw new RuntimeException(noSuchPaddingException);
            }
        }

        private byte[] addChecksum(byte[] byArray) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException {
            MessageDigest messageDigest = this.fEngineFactory.getMessageDigest("http://www.w3.org/2000/09/xmldsig#sha1", null);
            byte[] byArray2 = messageDigest.digest(byArray);
            this.fEngineFactory.releaseMessageDigest("http://www.w3.org/2000/09/xmldsig#sha1", messageDigest);
            byte[] byArray3 = new byte[byArray.length + 8];
            System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
            System.arraycopy(byArray2, 0, byArray3, byArray.length, 8);
            return byArray3;
        }

        private byte[] addIv(byte[] byArray) {
            byte[] byArray2 = this.fCipher0.getIV();
            byte[] byArray3 = new byte[byArray.length + 8];
            System.arraycopy(byArray2, 0, byArray3, 0, 8);
            System.arraycopy(byArray, 0, byArray3, 8, byArray.length);
            return byArray3;
        }

        private byte[] reverse(byte[] byArray) {
            byte[] byArray2 = new byte[byArray.length];
            for (int i = 0; i < byArray.length; ++i) {
                byArray2[byArray2.length - i - 1] = byArray[i];
            }
            return byArray2;
        }

        private byte[] removeIv(byte[] byArray) {
            byte[] byArray2 = new byte[8];
            byte[] byArray3 = new byte[byArray.length - 8];
            System.arraycopy(byArray, 0, byArray2, 0, 8);
            System.arraycopy(byArray, 8, byArray3, 0, byArray3.length);
            try {
                this.fCipher0.init(2, this.fKey, new IvParameterSpec(byArray2), HWC_KWTripleDES.getRandom());
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new RuntimeException(invalidAlgorithmParameterException);
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new RuntimeException(invalidKeyException);
            }
            return byArray3;
        }

        private byte[] removeChecksum(byte[] byArray) throws InvalidAlgorithmParameterException, InvalidKeyException, NoSuchAlgorithmException {
            byte[] byArray2 = new byte[byArray.length - 8];
            byte[] byArray3 = new byte[8];
            System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
            System.arraycopy(byArray, byArray2.length, byArray3, 0, 8);
            MessageDigest messageDigest = this.fEngineFactory.getMessageDigest("http://www.w3.org/2000/09/xmldsig#sha1", null);
            byte[] byArray4 = messageDigest.digest(byArray2);
            this.fEngineFactory.releaseMessageDigest("http://www.w3.org/2000/09/xmldsig#sha1", messageDigest);
            for (int i = 0; i < 8; ++i) {
                if (byArray3[i] == byArray4[i]) continue;
                throw new InvalidKeyException("Wrong checksum");
            }
            return byArray2;
        }

        public String getURI() {
            return "http://www.w3.org/2001/04/xmlenc#kw-tripledes";
        }

        public void init(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException, InvalidKeyException {
            this.fOpMode = n;
            this.fKey = key;
            switch (n) {
                case 1: 
                case 2: {
                    throw new IllegalArgumentException("Unsupported operation mode: " + n);
                }
                case 3: {
                    if (key != null) break;
                    throw new NullPointerException("Key not specified");
                }
                case 4: {
                    if (key == null) {
                        throw new NullPointerException("Key not specified");
                    }
                    this.fCipher1.init(2, key, new IvParameterSpec(IV), HWC_KWTripleDES.getRandom());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown operation mode: " + n);
                }
            }
        }

        public byte[] update(byte[] byArray, int n, int n2) {
            throw new UnsupportedOperationException("Unsupported method: EncryptionEngineImpl$KWTripleDES.update(byte[], int, int)");
        }

        public byte[] doFinal(byte[] byArray, int n, int n2) throws BadPaddingException, IllegalBlockSizeException {
            throw new UnsupportedOperationException("Unsupported method: EncryptionEngineImpl$KWTripleDES.doFinal(byte[], int, int)");
        }

        public byte[] wrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
            byte[] byArray = null;
            switch (this.fOpMode) {
                case 3: {
                    if (key == null) {
                        throw new NullPointerException("Data not specified");
                    }
                    byte[] byArray2 = key.getEncoded();
                    if (byArray2 == null || byArray2.length == 0) {
                        throw new InvalidKeyException("Encoded data not obtained or too short");
                    }
                    try {
                        try {
                            this.fCipher0.init(1, this.fKey, HWC_KWTripleDES.getRandom());
                        }
                        catch (InvalidKeyException invalidKeyException) {
                            throw new RuntimeException(invalidKeyException);
                        }
                        byArray2 = this.addChecksum(byArray2);
                        byArray2 = this.fCipher0.doFinal(byArray2);
                        byArray2 = this.addIv(byArray2);
                        byArray2 = this.reverse(byArray2);
                        this.fCipher1.init(1, this.fKey, new IvParameterSpec(IV), HWC_KWTripleDES.getRandom());
                        byArray = this.fCipher1.doFinal(byArray2);
                        break;
                    }
                    catch (BadPaddingException badPaddingException) {
                        throw new RuntimeException(badPaddingException);
                    }
                    catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                        throw new RuntimeException(invalidAlgorithmParameterException);
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        throw new RuntimeException(noSuchAlgorithmException);
                    }
                }
                default: {
                    throw new IllegalStateException("EncryptionEngine not initialized");
                }
            }
            return byArray;
        }

        public Key unwrap(byte[] byArray, String string, String string2) throws InvalidKeyException, NoSuchAlgorithmException {
            Key key = null;
            switch (this.fOpMode) {
                case 4: {
                    if (byArray == null) {
                        throw new NullPointerException("Data not specified");
                    }
                    KeyGenerationEngine keyGenerationEngine = this.fEngineFactory.getKeyGenerationEngine(string, string2);
                    if (keyGenerationEngine == null) {
                        throw new NullPointerException("KeyGenerationEngine not obtained: " + string + ", " + string2);
                    }
                    if (byArray.length != keyGenerationEngine.getKeySize() + 16) {
                        this.fEngineFactory.releaseKeyGenerationEngine(keyGenerationEngine);
                        throw new InvalidKeyException("Wrong length: " + byArray.length);
                    }
                    byte[] byArray2 = null;
                    try {
                        byArray2 = this.fCipher1.doFinal(byArray);
                        byArray2 = this.reverse(byArray2);
                        byArray2 = this.removeIv(byArray2);
                        byArray2 = this.fCipher0.doFinal(byArray2);
                        byArray2 = this.removeChecksum(byArray2);
                    }
                    catch (BadPaddingException badPaddingException) {
                        throw new RuntimeException(badPaddingException);
                    }
                    catch (IllegalBlockSizeException illegalBlockSizeException) {
                        throw new RuntimeException(illegalBlockSizeException);
                    }
                    catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                        throw new RuntimeException(invalidAlgorithmParameterException);
                    }
                    key = keyGenerationEngine.generateKey(byArray2);
                    this.fEngineFactory.releaseKeyGenerationEngine(keyGenerationEngine);
                    break;
                }
                default: {
                    throw new IllegalStateException("EncryptionEngine not initialized");
                }
            }
            return key;
        }
    }

    public static class HWC_KWAES256
    extends HWC_KWAES {
        private static final int KEY_LENGTH = 32;

        public HWC_KWAES256(Provider provider, EngineFactory engineFactory) throws NoSuchAlgorithmException {
            super(provider, engineFactory);
        }

        public String getURI() {
            return "http://www.w3.org/2001/04/xmlenc#kw-aes256";
        }

        public void init(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException, InvalidKeyException {
            if (key == null) {
                throw new NullPointerException("Key not specified");
            }
            byte[] byArray = key.getEncoded();
            if (byArray == null) {
                throw new InvalidKeyException("Encoded key not obtained");
            }
            if (byArray.length != 32) {
                throw new InvalidKeyException("Wrong length: " + byArray.length);
            }
            super.init(n, key, algorithmParameterSpec);
        }
    }

    public static class HWC_KWAES192
    extends HWC_KWAES {
        private static final int KEY_LENGTH = 24;

        public HWC_KWAES192(Provider provider, EngineFactory engineFactory) throws NoSuchAlgorithmException {
            super(provider, engineFactory);
        }

        public String getURI() {
            return "http://www.w3.org/2001/04/xmlenc#kw-aes192";
        }

        public void init(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException, InvalidKeyException {
            if (key == null) {
                throw new NullPointerException("Key not specified");
            }
            byte[] byArray = key.getEncoded();
            if (byArray == null) {
                throw new InvalidKeyException("Encoded key not obtained");
            }
            if (byArray.length != 24) {
                throw new InvalidKeyException("Wrong length: " + byArray.length);
            }
            super.init(n, key, algorithmParameterSpec);
        }
    }

    public static class HWC_KWAES128
    extends HWC_KWAES {
        private static final int KEY_LENGTH = 16;

        public HWC_KWAES128(Provider provider, EngineFactory engineFactory) throws NoSuchAlgorithmException {
            super(provider, engineFactory);
        }

        public String getURI() {
            return "http://www.w3.org/2001/04/xmlenc#kw-aes128";
        }

        public void init(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException, InvalidKeyException {
            if (key == null) {
                throw new NullPointerException("Key not specified");
            }
            byte[] byArray = key.getEncoded();
            if (byArray == null) {
                throw new InvalidKeyException("Encoded key not obtained");
            }
            if (byArray.length != 16) {
                throw new InvalidKeyException("Wrong length: " + byArray.length);
            }
            super.init(n, key, algorithmParameterSpec);
        }
    }

    public static abstract class HWC_KWAES
    extends EncryptionEngineImpl {
        private static final String TRANS = "AES/ECB/NoPadding";
        private static final int BLOCK_SIZE = 8;
        private static final byte[] PADS = new byte[]{-90, -90, -90, -90, -90, -90, -90, -90};
        private EngineFactory fEngineFactory;
        private int fOpMode;
        private Cipher fCipher;
        private Provider fProvider;
        private Key fKey;
        private boolean cipher_init = false;
        private boolean debug = false;

        protected HWC_KWAES(Provider provider, EngineFactory engineFactory) throws NoSuchAlgorithmException {
            this.fEngineFactory = engineFactory;
            this.fProvider = provider;
            try {
                if (provider != null) {
                    if (this.debug) {
                        System.out.println("HWC: provider name is :" + provider.getName());
                    }
                    this.fCipher = Cipher.getInstance(TRANS, provider);
                } else {
                    this.fCipher = Cipher.getInstance(TRANS);
                }
            }
            catch (NoSuchPaddingException noSuchPaddingException) {
                throw new NoSuchAlgorithmException(noSuchPaddingException.toString());
            }
        }

        private void encryptBlocks(byte[] byArray, int n) throws BadPaddingException, IllegalBlockSizeException {
            for (int i = 0; i <= 5; ++i) {
                for (int j = 1; j <= n; ++j) {
                    int n2 = j + i * n;
                    this.processBlock(byArray, j);
                    this.cipher_init = false;
                    this.xorBlock(byArray, n2);
                }
            }
        }

        private void decryptBlocks(byte[] byArray, int n) throws BadPaddingException, IllegalBlockSizeException {
            for (int i = 5; i >= 0; --i) {
                for (int j = n; j >= 1; --j) {
                    int n2 = j + i * n;
                    this.xorBlock(byArray, n2);
                    this.processBlock(byArray, j);
                    this.cipher_init = false;
                }
            }
        }

        private void processBlock(byte[] byArray, int n) throws BadPaddingException, IllegalBlockSizeException {
            byte[] byArray2 = new byte[16];
            System.arraycopy(byArray, 0, byArray2, 0, 8);
            System.arraycopy(byArray, 8 * n, byArray2, 8, 8);
            try {
                if (!this.cipher_init) {
                    switch (this.fOpMode) {
                        case 4: {
                            this.fCipher.init(2, this.fKey, HWC_KWAES.getRandom());
                            break;
                        }
                        case 3: {
                            this.fCipher.init(1, this.fKey, HWC_KWAES.getRandom());
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unknown operation mode: " + this.fOpMode);
                        }
                    }
                }
                byArray2 = this.fCipher.doFinal(byArray2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new RuntimeException(exception);
            }
            System.arraycopy(byArray2, 0, byArray, 0, 8);
            System.arraycopy(byArray2, 8, byArray, 8 * n, 8);
        }

        private void xorBlock(byte[] byArray, int n) {
            byte[] byArray2 = BigInteger.valueOf(n).toByteArray();
            for (int i = 0; i < 8; ++i) {
                int n2 = i - 8 + byArray2.length;
                int n3 = 0;
                if (n2 >= 0) {
                    n3 = byArray2[n2];
                }
                byArray[i] = (byte)(n3 ^= byArray[i]);
            }
        }

        private boolean arePadsChanged(byte[] byArray) {
            boolean bl = false;
            for (int i = 0; !bl && i < PADS.length; ++i) {
                if (byArray[i] == PADS[i]) continue;
                bl = true;
            }
            return bl;
        }

        public void init(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException, InvalidKeyException {
            this.fOpMode = n;
            this.fKey = key;
            switch (n) {
                case 1: 
                case 2: {
                    throw new IllegalArgumentException("Unsupported operation mode: " + n);
                }
                case 3: {
                    this.fCipher.init(1, key, HWC_KWAES.getRandom());
                    this.cipher_init = true;
                    break;
                }
                case 4: {
                    this.fCipher.init(2, key, HWC_KWAES.getRandom());
                    this.cipher_init = true;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown operation mode: " + n);
                }
            }
        }

        public byte[] update(byte[] byArray, int n, int n2) {
            throw new UnsupportedOperationException("Unsupported method: EncryptionEngineImpl$KWAES.update(byte[], int, int)");
        }

        public byte[] doFinal(byte[] byArray, int n, int n2) throws BadPaddingException, IllegalBlockSizeException {
            throw new UnsupportedOperationException("Unsupported method: EncryptionEngineImpl$KWAES.doFinal(byte[], int, int)");
        }

        public byte[] wrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
            byte[] byArray = null;
            switch (this.fOpMode) {
                case 3: {
                    if (key == null) {
                        throw new NullPointerException("Data not specified");
                    }
                    byte[] byArray2 = key.getEncoded();
                    if (byArray2 == null || byArray2.length == 0) {
                        throw new InvalidKeyException("Encoded data not obtained or too short");
                    }
                    if (byArray2.length % 8 > 0) {
                        throw new InvalidKeyException("Encoded data not multiple of 8 bytes");
                    }
                    byArray = new byte[PADS.length + byArray2.length];
                    System.arraycopy(PADS, 0, byArray, 0, PADS.length);
                    System.arraycopy(byArray2, 0, byArray, PADS.length, byArray2.length);
                    int n = byArray2.length / 8;
                    try {
                        if (n > 1) {
                            this.encryptBlocks(byArray, n);
                            break;
                        }
                        this.processBlock(byArray, 1);
                        break;
                    }
                    catch (BadPaddingException badPaddingException) {
                        throw new RuntimeException(badPaddingException);
                    }
                }
                default: {
                    throw new IllegalStateException("EncryptionEngine not initialized");
                }
            }
            return byArray;
        }

        public Key unwrap(byte[] byArray, String string, String string2) throws InvalidKeyException, NoSuchAlgorithmException {
            Key key = null;
            switch (this.fOpMode) {
                case 4: {
                    if (byArray == null) {
                        throw new NullPointerException("Data not specified");
                    }
                    if (byArray.length < 16) {
                        throw new InvalidKeyException("Data too short");
                    }
                    if (byArray.length % 8 > 0) {
                        throw new InvalidKeyException("Data not multiple of 8 bytes");
                    }
                    byte[] byArray2 = (byte[])byArray.clone();
                    int n = byArray2.length / 8 - 1;
                    try {
                        if (n > 1) {
                            this.decryptBlocks(byArray2, n);
                        } else {
                            this.processBlock(byArray2, 1);
                        }
                        if (this.arePadsChanged(byArray2)) {
                            throw new BadPaddingException("Wrong pads");
                        }
                    }
                    catch (BadPaddingException badPaddingException) {
                        throw new RuntimeException(badPaddingException);
                    }
                    catch (IllegalBlockSizeException illegalBlockSizeException) {
                        throw new RuntimeException(illegalBlockSizeException);
                    }
                    byte[] byArray3 = new byte[byArray2.length - 8];
                    System.arraycopy(byArray2, 8, byArray3, 0, byArray3.length);
                    KeyGenerationEngine keyGenerationEngine = this.fEngineFactory.getKeyGenerationEngine(string, string2);
                    if (keyGenerationEngine == null) {
                        throw new NullPointerException("KeyGenerationEngine not obtained: " + string + ", " + string2);
                    }
                    key = keyGenerationEngine.generateKey(byArray3);
                    this.fEngineFactory.releaseKeyGenerationEngine(keyGenerationEngine);
                    break;
                }
                default: {
                    throw new IllegalStateException("EncryptionEngine not initialized");
                }
            }
            return key;
        }
    }
}

