/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xss4j.enc;

import com.ibm.ws.wssecurity.xss4j.AlgorithmFactory;
import com.ibm.ws.wssecurity.xss4j.enc.PseudoIOException;
import com.ibm.wsspi.wssecurity.EncryptionEngine;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;

public class EncryptionInputStream
extends FilterInputStream {
    private EncryptionEngine fEncryptionEngine;
    private AlgorithmFactory fAlgorithmFactory;
    private byte[] fBuffer;
    private int fIndex;
    private boolean fDoneFinal;
    private byte[] fInputBuffer = new byte[2048];
    private static final int BUFFER_SIZE = 2048;

    public EncryptionInputStream(InputStream inputStream, EncryptionEngine encryptionEngine, AlgorithmFactory algorithmFactory) {
        super(inputStream);
        this.fEncryptionEngine = encryptionEngine;
        if (this.fEncryptionEngine == null) {
            throw new NullPointerException("Encryption engine not specified");
        }
        this.fAlgorithmFactory = algorithmFactory;
        if (this.fAlgorithmFactory == null) {
            throw new NullPointerException("AlgorithmFactory is null.");
        }
    }

    private byte[] getNextBytes() throws IOException {
        byte[] byArray = null;
        while (!this.fDoneFinal) {
            if (this.in == null) {
                throw new IOException("Input stream closed");
            }
            int n = this.in.read(this.fInputBuffer);
            byte[] byArray2 = null;
            if (n < 0) {
                try {
                    byArray2 = this.fEncryptionEngine.doFinal();
                }
                catch (BadPaddingException badPaddingException) {
                    throw new PseudoIOException(badPaddingException);
                }
                catch (IllegalBlockSizeException illegalBlockSizeException) {
                    throw new PseudoIOException(illegalBlockSizeException);
                }
                finally {
                    this.fAlgorithmFactory.releaseEncryptionEngine(this.fEncryptionEngine);
                }
                this.fDoneFinal = true;
            } else {
                byArray2 = this.fEncryptionEngine.update(this.fInputBuffer, 0, n);
            }
            if (byArray2 == null || byArray2.length <= 0) continue;
            byArray = byArray2;
            break;
        }
        return byArray;
    }

    private void pour() throws IOException {
        if (this.fBuffer == null || this.fIndex >= this.fBuffer.length) {
            this.fBuffer = this.getNextBytes();
            this.fIndex = 0;
        }
    }

    public int read() throws IOException {
        this.pour();
        int n = -1;
        if (this.fBuffer != null) {
            n = this.fBuffer[this.fIndex++] & 0xFF;
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n >= byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        this.pour();
        if (this.fBuffer == null) {
            return -1;
        }
        int n3 = this.fBuffer.length - this.fIndex;
        if (n2 < n3) {
            n3 = n2;
        }
        System.arraycopy(this.fBuffer, this.fIndex, byArray, n, n3);
        this.fIndex += n3;
        return n3;
    }

    public long skip(long l) throws IOException {
        long l2;
        int n;
        if (l <= 0L) {
            return 0L;
        }
        byte[] byArray = new byte[2048];
        for (l2 = l; l2 > 0L && (n = this.read(byArray, 0, (int)Math.min(2048L, l2))) >= 0; l2 -= (long)n) {
        }
        return l - l2;
    }

    public int available() throws IOException {
        return 0;
    }

    public boolean markSupported() {
        return false;
    }
}

