/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xss4j.enc;

import com.ibm.ws.wssecurity.xss4j.AlgorithmFactory;
import com.ibm.ws.wssecurity.xss4j.enc.PseudoIOException;
import com.ibm.wsspi.wssecurity.EncryptionEngine;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;

public class EncryptionOutputStream
extends FilterOutputStream {
    private EncryptionEngine fEncryptionEngine;
    private AlgorithmFactory fAlgorithmFactory;
    private boolean fDoneFinal;
    private byte[] fOutputBuffer = new byte[1];

    public EncryptionOutputStream(OutputStream outputStream, EncryptionEngine encryptionEngine, AlgorithmFactory algorithmFactory) {
        super(outputStream);
        this.fEncryptionEngine = encryptionEngine;
        if (this.fEncryptionEngine == null) {
            throw new NullPointerException("Encryption engine not specified");
        }
        this.fAlgorithmFactory = algorithmFactory;
        if (this.fAlgorithmFactory == null) {
            throw new NullPointerException("AlgorithmFactory is null.");
        }
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public void doFinal() throws IOException {
        this.doFinal(null);
    }

    public void doFinal(byte[] byArray) throws IOException {
        byte[] byArray2 = null;
        try {
            byArray2 = byArray != null ? this.fEncryptionEngine.doFinal(byArray) : this.fEncryptionEngine.doFinal();
        }
        catch (BadPaddingException badPaddingException) {
            throw new PseudoIOException(badPaddingException);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new PseudoIOException(illegalBlockSizeException);
        }
        finally {
            this.fAlgorithmFactory.releaseEncryptionEngine(this.fEncryptionEngine);
        }
        this.fDoneFinal = true;
        if (byArray2 != null && byArray2.length > 0) {
            this.writeBytes(byArray2);
        }
    }

    private void writeBytes(byte[] byArray) throws IOException {
        this.out.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return;
        }
        byte[] byArray2 = this.fEncryptionEngine.update(byArray, n, n2);
        if (byArray2 != null && byArray2.length > 0) {
            this.writeBytes(byArray2);
        }
    }

    public void write(int n) throws IOException {
        this.fOutputBuffer[0] = (byte)n;
        byte[] byArray = this.fEncryptionEngine.update(this.fOutputBuffer);
        if (byArray != null && byArray.length > 0) {
            this.writeBytes(byArray);
        }
    }

    public void close() throws IOException {
        if (!this.fDoneFinal) {
            this.doFinal();
        }
        super.close();
    }
}

