/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xss4j.enc;

import com.ibm.ws.wssecurity.xss4j.enc.EncryptionEngineImpl;
import com.ibm.wsspi.wssecurity.KeyGenerationEngine;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.SecretKeySpec;

public abstract class KeyGenerationEngineImpl
implements KeyGenerationEngine {

    public static class KWAES256
    extends AES256 {
        public KWAES256(Provider provider) throws NoSuchAlgorithmException {
            super(provider);
        }

        public String getURI() {
            return "http://www.w3.org/2001/04/xmlenc#kw-aes256";
        }
    }

    public static class AES256CBC
    extends AES256 {
        public AES256CBC(Provider provider) throws NoSuchAlgorithmException {
            super(provider);
        }

        public String getURI() {
            return "http://www.w3.org/2001/04/xmlenc#aes256-cbc";
        }
    }

    public static abstract class AES256
    extends AES {
        private static final int KEY_SIZE = 32;

        protected AES256(Provider provider) throws NoSuchAlgorithmException {
            super(32, provider);
        }

        public Key generateKey(byte[] byArray) throws InvalidKeyException {
            if (byArray == null) {
                throw new NullPointerException("Encoded key not specified");
            }
            if (byArray.length < 32) {
                throw new InvalidKeyException("Encoded key Too short");
            }
            if (byArray.length > 32) {
                byte[] byArray2 = new byte[32];
                System.arraycopy(byArray, 0, byArray2, 0, 32);
                byArray = byArray2;
            }
            return super.generateKey(byArray);
        }

        public int getKeySize() {
            return 32;
        }
    }

    public static class KWAES192
    extends AES192 {
        public KWAES192(Provider provider) throws NoSuchAlgorithmException {
            super(provider);
        }

        public String getURI() {
            return "http://www.w3.org/2001/04/xmlenc#kw-aes192";
        }
    }

    public static class AES192CBC
    extends AES192 {
        public AES192CBC(Provider provider) throws NoSuchAlgorithmException {
            super(provider);
        }

        public String getURI() {
            return "http://www.w3.org/2001/04/xmlenc#aes192-cbc";
        }
    }

    public static abstract class AES192
    extends AES {
        private static final int KEY_SIZE = 24;

        protected AES192(Provider provider) throws NoSuchAlgorithmException {
            super(24, provider);
        }

        public Key generateKey(byte[] byArray) throws InvalidKeyException {
            if (byArray == null) {
                throw new NullPointerException("Encoded key not specified");
            }
            if (byArray.length < 24) {
                throw new InvalidKeyException("Encoded key Too short");
            }
            if (byArray.length > 24) {
                byte[] byArray2 = new byte[24];
                System.arraycopy(byArray, 0, byArray2, 0, 24);
                byArray = byArray2;
            }
            return super.generateKey(byArray);
        }

        public int getKeySize() {
            return 24;
        }
    }

    public static class KWAES128
    extends AES128 {
        public KWAES128(Provider provider) throws NoSuchAlgorithmException {
            super(provider);
        }

        public String getURI() {
            return "http://www.w3.org/2001/04/xmlenc#kw-aes128";
        }
    }

    public static class AES128CBC
    extends AES128 {
        public AES128CBC(Provider provider) throws NoSuchAlgorithmException {
            super(provider);
        }

        public String getURI() {
            return "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
        }
    }

    public static abstract class AES128
    extends AES {
        private static final int KEY_SIZE = 16;

        protected AES128(Provider provider) throws NoSuchAlgorithmException {
            super(16, provider);
        }

        public Key generateKey(byte[] byArray) throws InvalidKeyException {
            if (byArray == null) {
                throw new NullPointerException("Encoded key not specified");
            }
            if (byArray.length < 16) {
                throw new InvalidKeyException("Encoded key too short");
            }
            if (byArray.length > 16) {
                byte[] byArray2 = new byte[16];
                System.arraycopy(byArray, 0, byArray2, 0, 16);
                byArray = byArray2;
            }
            return super.generateKey(byArray);
        }

        public int getKeySize() {
            return 16;
        }
    }

    public static abstract class AES
    extends KeyGenerationEngineImpl {
        private static final String ALGORITHM = "AES";
        private KeyGenerator fKeyGenerator;
        private SecretKeyFactory fKeyFactory;

        protected AES(int n, Provider provider) throws NoSuchAlgorithmException {
            if (provider != null) {
                this.fKeyGenerator = KeyGenerator.getInstance(ALGORITHM, provider);
                this.fKeyFactory = SecretKeyFactory.getInstance(ALGORITHM, provider);
            } else {
                this.fKeyGenerator = KeyGenerator.getInstance(ALGORITHM);
                this.fKeyFactory = SecretKeyFactory.getInstance(ALGORITHM);
            }
            this.fKeyGenerator.init(n * 8, EncryptionEngineImpl.getRandom());
        }

        public void init(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
            if (algorithmParameterSpec != null) {
                throw new InvalidAlgorithmParameterException("Support no parameter.");
            }
            this.fKeyGenerator.init(this.getKeySize() * 8, EncryptionEngineImpl.getRandom());
        }

        public Key generateKey() {
            return this.fKeyGenerator.generateKey();
        }

        public Key generateKey(byte[] byArray) throws InvalidKeyException {
            SecretKey secretKey = null;
            try {
                secretKey = this.fKeyFactory.generateSecret(new SecretKeySpec(byArray, ALGORITHM));
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
                throw new RuntimeException(invalidKeySpecException);
            }
            return secretKey;
        }
    }

    public static class KWTripleDES
    extends TripleDES {
        public KWTripleDES(Provider provider) throws NoSuchAlgorithmException {
            super(provider);
        }

        public String getURI() {
            return "http://www.w3.org/2001/04/xmlenc#kw-tripledes";
        }
    }

    public static class TripleDESCBC
    extends TripleDES {
        public TripleDESCBC(Provider provider) throws NoSuchAlgorithmException {
            super(provider);
        }

        public String getURI() {
            return "http://www.w3.org/2001/04/xmlenc#tripledes-cbc";
        }
    }

    public static abstract class TripleDES
    extends KeyGenerationEngineImpl {
        private static final String ALGORITHM = "DESede";
        private static final int KEY_SIZE = 24;
        private static final int KEY_SIZE_IN_BITS = 168;
        private KeyGenerator fKeyGenerator;
        private SecretKeyFactory fKeyFactory;

        protected TripleDES(Provider provider) throws NoSuchAlgorithmException {
            if (provider != null) {
                this.fKeyGenerator = KeyGenerator.getInstance(ALGORITHM, provider);
                this.fKeyFactory = SecretKeyFactory.getInstance(ALGORITHM, provider);
            } else {
                this.fKeyGenerator = KeyGenerator.getInstance(ALGORITHM);
                this.fKeyFactory = SecretKeyFactory.getInstance(ALGORITHM);
            }
            this.fKeyGenerator.init(168, EncryptionEngineImpl.getRandom());
        }

        public void init(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
            if (algorithmParameterSpec != null) {
                throw new InvalidAlgorithmParameterException("Support no parameter.");
            }
            this.fKeyGenerator.init(168, EncryptionEngineImpl.getRandom());
        }

        public Key generateKey() {
            return this.fKeyGenerator.generateKey();
        }

        public Key generateKey(byte[] byArray) throws InvalidKeyException {
            if (byArray == null) {
                throw new NullPointerException("Encoded key not specified");
            }
            if (byArray.length < 24) {
                throw new InvalidKeyException("Encoded key too short");
            }
            SecretKey secretKey = null;
            try {
                secretKey = this.fKeyFactory.generateSecret(new DESedeKeySpec(byArray));
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
                throw new RuntimeException(invalidKeySpecException);
            }
            return secretKey;
        }

        public int getKeySize() {
            return 24;
        }
    }

    public static class HWC_KWTripleDES
    extends HWC_TripleDES {
        public HWC_KWTripleDES(Provider provider) throws NoSuchAlgorithmException {
            super(provider);
        }

        public String getURI() {
            return "http://www.w3.org/2001/04/xmlenc#kw-tripledes";
        }
    }

    public static class HWC_TripleDESCBC
    extends HWC_TripleDES {
        public HWC_TripleDESCBC(Provider provider) throws NoSuchAlgorithmException {
            super(provider);
        }

        public String getURI() {
            return "http://www.w3.org/2001/04/xmlenc#tripledes-cbc";
        }
    }

    public static abstract class HWC_TripleDES
    extends KeyGenerationEngineImpl {
        private static final String ALGORITHM = "DESede";
        private static final int KEY_SIZE = 24;
        private static final int KEY_SIZE_IN_BITS = 168;
        private static final int HW_KEY_SIZE_IN_BITS = 192;
        private KeyGenerator fKeyGenerator;
        private SecretKeyFactory fKeyFactory;
        private String providerName = null;

        protected HWC_TripleDES(Provider provider) throws NoSuchAlgorithmException {
            if (provider != null) {
                this.fKeyGenerator = KeyGenerator.getInstance(ALGORITHM, provider);
                this.fKeyFactory = SecretKeyFactory.getInstance(ALGORITHM, provider);
                this.providerName = provider.getName();
            } else {
                this.fKeyGenerator = KeyGenerator.getInstance(ALGORITHM);
                this.fKeyFactory = SecretKeyFactory.getInstance(ALGORITHM);
            }
            this.fKeyGenerator.init(192, EncryptionEngineImpl.getRandom());
        }

        public void init(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
            if (algorithmParameterSpec != null) {
                throw new InvalidAlgorithmParameterException("Support no parameter.");
            }
            this.fKeyGenerator.init(192, EncryptionEngineImpl.getRandom());
        }

        public Key generateKey() {
            return this.fKeyGenerator.generateKey();
        }

        public Key generateKey(byte[] byArray) throws InvalidKeyException {
            if (byArray == null) {
                throw new NullPointerException("Encoded key not specified");
            }
            if (byArray.length < 24) {
                throw new InvalidKeyException("Encoded key too short");
            }
            SecretKey secretKey = null;
            try {
                secretKey = this.fKeyFactory.generateSecret(new SecretKeySpec(byArray, ALGORITHM));
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
                throw new RuntimeException(invalidKeySpecException);
            }
            return secretKey;
        }

        public int getKeySize() {
            return 24;
        }
    }
}

