/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xss4j.enc;

import com.ibm.ws.wssecurity.xss4j.enc.ResourceShower;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.w3c.dom.Element;

class ResourceInputStream
extends FilterInputStream {
    private ResourceShower fResourceShower;
    private Object fData;
    private Element fEncryptedType;
    private ByteArrayOutputStream fBuffer;

    ResourceInputStream(InputStream inputStream, ResourceShower resourceShower, Object object, Element element) {
        super(inputStream);
        this.fResourceShower = resourceShower;
        this.fData = object;
        this.fEncryptedType = element;
        this.fBuffer = new ByteArrayOutputStream();
    }

    InputStream getInputStream() {
        return this.in;
    }

    void showResource() {
        try {
            this.fBuffer.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        this.fResourceShower.showEncryptedResource(this.fBuffer.toByteArray(), this.fData, this.fEncryptedType);
    }

    public int read() throws IOException {
        int n = super.read();
        if (n < 0) {
            this.fBuffer.flush();
            this.showResource();
        } else {
            this.fBuffer.write(n);
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = super.read(byArray, n, n2);
        if (n3 < 0) {
            this.fBuffer.flush();
            this.showResource();
        } else {
            this.fBuffer.write(byArray, n, n3);
        }
        return n3;
    }

    public long skip(long l) throws IOException {
        byte[] byArray = new byte[(int)l];
        int n = this.read(byArray, 0, byArray.length);
        if (n < 0) {
            n = 0;
        }
        return n;
    }

    public void close() throws IOException {
        super.close();
        this.fBuffer.close();
    }

    public boolean markSupported() {
        return false;
    }
}

