/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xss4j.enc;

import com.ibm.ws.wssecurity.xss4j.domutil.BufferedWriter;
import com.ibm.ws.wssecurity.xss4j.enc.TransformerFactoryExtn;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;

class XMLWriter {
    private static final String ENTITIES1 = "<>\"'&";
    private static final String[] ENTITY_NAMES = new String[]{"lt", "gt", "quot", "apos", "amp"};
    private static final String[] ENTITY_REFS = new String[]{"&lt;", "&gt;", "&amp;"};
    private static final String ENTITIES2 = "<>&";
    private Writer fOut;
    private Transformer fTransformer;

    XMLWriter(OutputStream outputStream) throws IOException {
        this.fOut = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
    }

    void printText(String string) throws IOException {
        this.fOut.write(string);
    }

    void printText(char c) throws IOException {
        this.fOut.write(c);
    }

    void printText(DocumentFragment documentFragment) throws IOException {
        this.printText(documentFragment, true);
    }

    void printText(DocumentFragment documentFragment, boolean bl) throws IOException {
        Writer writer = this.fOut;
        if (!bl) {
            writer = new StringWriter();
        }
        this.printText(documentFragment, writer);
        if (!bl) {
            writer.flush();
            writer.close();
            String string = ((StringWriter)writer).toString();
            string = this.restoreEntities(string);
            this.fOut.write(string);
        }
    }

    private void printText(DocumentFragment documentFragment, Writer writer) throws IOException {
        if (this.fTransformer == null) {
            try {
                this.fTransformer = TransformerFactoryExtn.getTransformer();
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
                throw new RuntimeException(this.unwrapException(transformerConfigurationException).toString());
            }
        }
        DOMSource dOMSource = new DOMSource();
        StreamResult streamResult = new StreamResult(writer);
        for (Node node = documentFragment.getFirstChild(); node != null; node = node.getNextSibling()) {
            dOMSource.setNode(node);
            try {
                this.fTransformer.transform(dOMSource, streamResult);
                continue;
            }
            catch (TransformerException transformerException) {
                Throwable throwable = this.unwrapException(transformerException);
                if (throwable instanceof IOException) {
                    throw (IOException)throwable;
                }
                throw new RuntimeException(throwable.toString());
            }
        }
    }

    private Throwable unwrapException(TransformerException transformerException) {
        Throwable throwable = transformerException.getException();
        if (throwable == null) {
            throwable = transformerException;
        }
        return throwable;
    }

    private String restoreEntities(String string) {
        for (int i = 0; i < ENTITY_REFS.length; ++i) {
            string = this.restoreEntity(string, ENTITY_REFS[i], ENTITIES2.charAt(i));
        }
        return string;
    }

    private String restoreEntity(String string, String string2, char c) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        int n2 = string2.length();
        for (int i = 0; i < n; ++i) {
            int n3 = string.indexOf(string2, i);
            if (n3 >= 0) {
                stringBuffer.append(string.substring(i, n3));
                stringBuffer.append(c);
                i = n3 + n2;
                continue;
            }
            stringBuffer.append(string.substring(i));
            i = n;
        }
        return stringBuffer.toString();
    }

    void printDoctypeURL(String string) throws IOException {
        this.printText('\"');
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (string.charAt(i) == '\"' || string.charAt(i) < ' ' || string.charAt(i) > '\u007f') {
                this.printText('%');
                this.printText(Integer.toHexString(string.charAt(i)));
                continue;
            }
            this.printText(string.charAt(i));
        }
        this.printText('\"');
    }

    void printEscaped(String string) throws IOException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c;
            int n2 = string.charAt(i);
            if ((n2 & 0xFC00) == 55296 && i + 1 < n && ((c = string.charAt(i + 1)) & 0xFC00) == 56320) {
                n2 = 65536 + (n2 - 55296 << 10) + c - 56320;
                ++i;
            }
            this.printEscaped(n2);
        }
    }

    private void printEscaped(int n) throws IOException {
        if (n >= 63 && n <= 0x10FFFF && n != 247 || n >= 40 && n <= 59 || n == 32 || n == 33 || n == 35 || n == 36 || n == 37 || n == 61 || n == 10 || n == 13 || n == 9) {
            if (n < 65536) {
                this.printText((char)n);
            } else {
                this.printText((char)((n - 65536 >> 10) + 55296));
                this.printText((char)((n - 65536 & 0x3FF) + 56320));
            }
        } else {
            switch (n) {
                case 60: {
                    this.printText("&lt;");
                    break;
                }
                case 62: {
                    this.printText("&gt;");
                    break;
                }
                case 39: {
                    this.printText("&apos;");
                    break;
                }
                case 34: {
                    this.printText("&quot;");
                    break;
                }
                case 38: {
                    this.printText("&amp;");
                    break;
                }
                default: {
                    this.printText("&#x");
                    this.printText(Integer.toHexString(n));
                    this.printText(';');
                }
            }
        }
    }

    private String getEntityRef(int n) {
        int n2 = ENTITIES1.indexOf(n);
        String string = null;
        if (n2 >= 0) {
            string = ENTITY_NAMES[n2];
        }
        return string;
    }

    void flush() throws IOException {
        this.fOut.flush();
    }
}

