/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xss4j.enc.type;

import com.ibm.ws.wssecurity.xss4j.enc.StructureException;
import com.ibm.ws.wssecurity.xss4j.enc.type.CipherReference;
import com.ibm.ws.wssecurity.xss4j.enc.type.CipherValue;
import com.ibm.ws.wssecurity.xss4j.enc.type.Type;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CipherData
extends Type {
    private static final String NAMESPACE = "http://www.w3.org/2001/04/xmlenc#";
    private static final String NAME = "CipherData";
    private Type fCipherData;

    public CipherData() {
        this(null);
    }

    public CipherData(Element element) {
        super(element);
        if (element != null) {
            if (!CipherData.isOfType(element)) {
                throw new IllegalArgumentException("Not CipherData element");
            }
            this.init(element);
        }
    }

    public static boolean isOfType(Element element) {
        return element != null && NAMESPACE.equals(element.getNamespaceURI()) && NAME.equals(element.getLocalName());
    }

    private void init(Node node) {
        block4: for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            switch (node2.getNodeType()) {
                case 1: {
                    Element element = (Element)node2;
                    if (CipherValue.isOfType(element)) {
                        this.fCipherData = new CipherValue(element);
                        continue block4;
                    }
                    if (!CipherReference.isOfType(element)) continue block4;
                    this.fCipherData = new CipherReference(element);
                    continue block4;
                }
                case 5: {
                    this.init(node2);
                }
            }
        }
    }

    public void setCipherValue(CipherValue cipherValue) {
        this.fCipherData = cipherValue;
    }

    public void setCipherReference(CipherReference cipherReference) {
        this.fCipherData = cipherReference;
    }

    public Type getCipherData() {
        return this.fCipherData;
    }

    public String getNamespaceURI() {
        return NAMESPACE;
    }

    public Element createElement(Document document, boolean bl) throws StructureException {
        if (document == null) {
            throw new NullPointerException("Node factory not specified");
        }
        Element element = document.createElementNS(NAMESPACE, NAME);
        if (bl) {
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", NAMESPACE);
        }
        if (this.fCipherData == null) {
            throw new StructureException("Neither CipherValue nor CipherReference specified");
        }
        Element element2 = this.fCipherData.createElement(document, false);
        element.appendChild(element2);
        return element;
    }
}

