/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xss4j.enc.type;

import com.ibm.ws.wssecurity.xss4j.enc.StructureException;
import com.ibm.ws.wssecurity.xss4j.enc.type.Transforms;
import com.ibm.ws.wssecurity.xss4j.enc.type.Type;
import com.ibm.ws.wssecurity.xss4j.enc.util.Util;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CipherReference
extends Type {
    private static final String NAMESPACE = "http://www.w3.org/2001/04/xmlenc#";
    private static final String NAME = "CipherReference";
    private static final String ATTR_URI = "URI";
    private String fUri;
    private Transforms fTransforms;

    public CipherReference() {
        this(null);
    }

    public CipherReference(Element element) {
        super(element);
        if (element != null) {
            if (!CipherReference.isOfType(element)) {
                throw new IllegalArgumentException("Not CipherReference element");
            }
            if (element.hasAttribute(ATTR_URI)) {
                this.fUri = element.getAttribute(ATTR_URI);
            }
            this.init(element);
        }
    }

    public static boolean isOfType(Element element) {
        return element != null && NAMESPACE.equals(element.getNamespaceURI()) && NAME.equals(element.getLocalName());
    }

    private void init(Node node) {
        block4: for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            switch (node2.getNodeType()) {
                case 1: {
                    Element element = (Element)node2;
                    if (!Transforms.isOfType(element)) continue block4;
                    this.fTransforms = new Transforms(element);
                    continue block4;
                }
                case 5: {
                    this.init(node2);
                }
            }
        }
    }

    public void setURI(String string) {
        this.fUri = string;
    }

    public String getURI() {
        return this.fUri;
    }

    public void setTransforms(Transforms transforms) {
        this.fTransforms = transforms;
    }

    public Transforms getTransforms() {
        return this.fTransforms;
    }

    public String getNamespaceURI() {
        return NAMESPACE;
    }

    public Element createElement(Document document, boolean bl) throws StructureException {
        if (document == null) {
            throw new NullPointerException("Node factory not specified");
        }
        Element element = document.createElementNS(NAMESPACE, NAME);
        if (bl) {
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", NAMESPACE);
        }
        if (this.fUri == null) {
            throw new StructureException("URI not specified");
        }
        element.setAttribute(ATTR_URI, Util.normalize(this.fUri));
        if (this.fTransforms != null) {
            Element element2 = this.fTransforms.createElement(document, false);
            element.appendChild(element2);
        }
        return element;
    }
}

