/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xss4j.enc.type;

import com.ibm.ws.wssecurity.xss4j.enc.StructureException;
import com.ibm.ws.wssecurity.xss4j.enc.type.ElementsType;
import com.ibm.ws.wssecurity.xss4j.enc.util.Util;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DigestMethod
extends ElementsType {
    public static final String SHA1 = "http://www.w3.org/2000/09/xmldsig#sha1";
    public static final String SHA256 = "http://www.w3.org/2001/04/xmlenc#sha256";
    public static final String SHA512 = "http://www.w3.org/2001/04/xmlenc#sha512";
    public static final String RIPEMD160 = "http://www.w3.org/2001/04/xmlenc#ripemd160";
    private static final String NAMESPACE = "http://www.w3.org/2000/09/xmldsig#";
    private static final String NAME = "DigestMethod";
    private static final String ATTR_ALGORITHM = "Algorithm";
    private String fAlgorithm;

    public DigestMethod() {
        this(null);
    }

    public DigestMethod(Element element) {
        super(element);
        if (element != null) {
            if (!DigestMethod.isOfType(element)) {
                throw new IllegalArgumentException("Not DigestMethod element");
            }
            if (element.hasAttribute(ATTR_ALGORITHM)) {
                this.fAlgorithm = element.getAttribute(ATTR_ALGORITHM);
            }
            this.init(element);
        }
    }

    public static boolean isOfType(Element element) {
        return element != null && NAMESPACE.equals(element.getNamespaceURI()) && NAME.equals(element.getLocalName());
    }

    private void init(Node node) {
        block4: for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            switch (node2.getNodeType()) {
                case 1: {
                    Element element = (Element)node2;
                    if (!this.isParameter(element)) continue block4;
                    super.addElement(element);
                    continue block4;
                }
                case 5: {
                    this.init(node2);
                }
            }
        }
    }

    private boolean isParameter(Element element) {
        String string = element.getNamespaceURI();
        return string != null && !string.equals(NAMESPACE);
    }

    public void setAlgorithm(String string) {
        this.fAlgorithm = string;
    }

    public String getAlgorithm() {
        return this.fAlgorithm;
    }

    public void addParameter(Element element) {
        if (element != null) {
            if (!this.isParameter(element)) {
                throw new IllegalArgumentException("Wrong parameter");
            }
            super.addElement(element);
        }
    }

    public List getParameters() {
        return super.getElements();
    }

    public String getNamespaceURI() {
        return NAMESPACE;
    }

    public Element createElement(Document document, boolean bl) throws StructureException {
        if (document == null) {
            throw new NullPointerException("Node factory not specified");
        }
        Element element = document.createElementNS(NAMESPACE, NAME);
        if (bl) {
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", NAMESPACE);
        }
        if (this.fAlgorithm == null) {
            throw new StructureException("Algorithm not specified");
        }
        element.setAttribute(ATTR_ALGORITHM, Util.normalize(this.fAlgorithm));
        super.createElement(element, document, NAMESPACE);
        return element;
    }
}

