/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xss4j.enc.type;

import com.ibm.ws.wssecurity.xss4j.enc.StructureException;
import com.ibm.ws.wssecurity.xss4j.enc.type.CarriedKeyName;
import com.ibm.ws.wssecurity.xss4j.enc.type.EncryptedType;
import com.ibm.ws.wssecurity.xss4j.enc.type.ReferenceList;
import com.ibm.ws.wssecurity.xss4j.enc.util.Util;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EncryptedKey
extends EncryptedType {
    private static final String NAMESPACE = "http://www.w3.org/2001/04/xmlenc#";
    private static final String NAME = "EncryptedKey";
    private static final String ATTR_RECIPIENT = "Recipient";
    public static final String TYPE = "http://www.w3.org/2001/04/xmlenc#EncryptedKey";
    private String fRecipient;
    private ReferenceList fReferenceList;
    private CarriedKeyName fKeyName;

    public EncryptedKey() {
        this(null);
    }

    public EncryptedKey(Element element) {
        super(element);
        if (element != null) {
            if (!EncryptedKey.isOfType(element)) {
                throw new IllegalArgumentException("Not EncryptedKey element");
            }
            if (element.hasAttribute(ATTR_RECIPIENT)) {
                this.fRecipient = element.getAttribute(ATTR_RECIPIENT);
            }
            this.init(element);
        }
    }

    public static boolean isOfType(Element element) {
        return element != null && NAMESPACE.equals(element.getNamespaceURI()) && NAME.equals(element.getLocalName());
    }

    private void init(Node node) {
        block4: for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            switch (node2.getNodeType()) {
                case 1: {
                    Element element = (Element)node2;
                    if (ReferenceList.isOfType(element)) {
                        this.fReferenceList = new ReferenceList(element);
                        continue block4;
                    }
                    if (!CarriedKeyName.isOfType(element)) continue block4;
                    this.fKeyName = new CarriedKeyName(element);
                    continue block4;
                }
                case 5: {
                    this.init(node2);
                }
            }
        }
    }

    public void setRecipient(String string) {
        this.fRecipient = string;
    }

    public String getRecipient() {
        return this.fRecipient;
    }

    public void setReferenceList(ReferenceList referenceList) {
        this.fReferenceList = referenceList;
    }

    public ReferenceList getReferenceList() {
        return this.fReferenceList;
    }

    public void setCarriedKeyName(CarriedKeyName carriedKeyName) {
        this.fKeyName = carriedKeyName;
    }

    public CarriedKeyName getCarriedKeyName() {
        return this.fKeyName;
    }

    public String getNamespaceURI() {
        return NAMESPACE;
    }

    public Element createElement(Document document, boolean bl) throws StructureException {
        Element element;
        if (document == null) {
            throw new NullPointerException("Node factory not specified");
        }
        Element element2 = document.createElementNS(NAMESPACE, NAME);
        if (bl) {
            element2.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", NAMESPACE);
        }
        super.createElement(element2, document);
        if (this.fRecipient != null) {
            element2.setAttribute(ATTR_RECIPIENT, Util.normalize(this.fRecipient));
        }
        if (this.fReferenceList != null) {
            element = this.fReferenceList.createElement(document, false);
            element2.appendChild(element);
        }
        if (this.fKeyName != null) {
            element = this.fKeyName.createElement(document, false);
            element2.appendChild(element);
        }
        return element2;
    }
}

