/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xss4j.enc.type;

import com.ibm.ws.wssecurity.xss4j.enc.StructureException;
import com.ibm.ws.wssecurity.xss4j.enc.type.CipherData;
import com.ibm.ws.wssecurity.xss4j.enc.type.EncryptedData;
import com.ibm.ws.wssecurity.xss4j.enc.type.EncryptedKey;
import com.ibm.ws.wssecurity.xss4j.enc.type.EncryptionMethod;
import com.ibm.ws.wssecurity.xss4j.enc.type.EncryptionProperties;
import com.ibm.ws.wssecurity.xss4j.enc.type.KeyInfo;
import com.ibm.ws.wssecurity.xss4j.enc.type.Type;
import com.ibm.ws.wssecurity.xss4j.enc.util.Util;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class EncryptedType
extends Type {
    private static final String ATTR_ID = "Id";
    private static final String ATTR_TYPE = "Type";
    private static final String ATTR_MIME_TYPE = "MimeType";
    private static final String ATTR_ENCODING = "Encoding";
    private String fId;
    private String fType;
    private String fMimeType;
    private String fEncoding;
    private EncryptionMethod fEncryptionMethod;
    private KeyInfo fKeyInfo;
    private CipherData fCipherData;
    private EncryptionProperties fEncryptionProperties;

    public EncryptedType(Element element) {
        super(element);
        if (element != null) {
            if (element.hasAttribute(ATTR_ID)) {
                this.fId = element.getAttribute(ATTR_ID);
            }
            if (element.hasAttribute(ATTR_TYPE)) {
                this.fType = element.getAttribute(ATTR_TYPE);
            }
            if (element.hasAttribute(ATTR_MIME_TYPE)) {
                this.fMimeType = element.getAttribute(ATTR_MIME_TYPE);
            }
            if (element.hasAttribute(ATTR_ENCODING)) {
                this.fEncoding = element.getAttribute(ATTR_ENCODING);
            }
            this.init(element);
        }
    }

    public static EncryptedType getInstance(Element element) {
        if (element == null) {
            throw new NullPointerException("Element not specified");
        }
        EncryptedType encryptedType = null;
        if (EncryptedData.isOfType(element)) {
            encryptedType = new EncryptedData(element);
        } else if (EncryptedKey.isOfType(element)) {
            encryptedType = new EncryptedKey(element);
        } else {
            throw new IllegalArgumentException("Unknown element type: " + element.getTagName());
        }
        return encryptedType;
    }

    private void init(Node node) {
        block4: for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            switch (node2.getNodeType()) {
                case 1: {
                    Element element = (Element)node2;
                    if (EncryptionMethod.isOfType(element)) {
                        this.fEncryptionMethod = new EncryptionMethod(element);
                        continue block4;
                    }
                    if (KeyInfo.isOfType(element)) {
                        this.fKeyInfo = new KeyInfo(element);
                        continue block4;
                    }
                    if (CipherData.isOfType(element)) {
                        this.fCipherData = new CipherData(element);
                        continue block4;
                    }
                    if (!EncryptionProperties.isOfType(element)) continue block4;
                    this.fEncryptionProperties = new EncryptionProperties(element);
                    continue block4;
                }
                case 5: {
                    this.init(node2);
                }
            }
        }
    }

    public void setId(String string) {
        this.fId = string;
    }

    public String getId() {
        return this.fId;
    }

    public void setType(String string) {
        this.fType = string;
    }

    public String getType() {
        return this.fType;
    }

    public void setMimeType(String string) {
        this.fMimeType = string;
    }

    public String getMimeType() {
        return this.fMimeType;
    }

    public void setEncoding(String string) {
        this.fEncoding = string;
    }

    public String getEncoding() {
        return this.fEncoding;
    }

    public void setEncryptionMethod(EncryptionMethod encryptionMethod) {
        this.fEncryptionMethod = encryptionMethod;
    }

    public EncryptionMethod getEncryptionMethod() {
        return this.fEncryptionMethod;
    }

    public void setKeyInfo(KeyInfo keyInfo) {
        this.fKeyInfo = keyInfo;
    }

    public KeyInfo getKeyInfo() {
        return this.fKeyInfo;
    }

    public void setCipherData(CipherData cipherData) {
        this.fCipherData = cipherData;
    }

    public CipherData getCipherData() {
        return this.fCipherData;
    }

    public void setEncryptionProperties(EncryptionProperties encryptionProperties) {
        this.fEncryptionProperties = encryptionProperties;
    }

    public EncryptionProperties getEncryptionProperties() {
        return this.fEncryptionProperties;
    }

    void createElement(Element element, Document document) throws StructureException {
        Element element2;
        if (this.fId != null) {
            element.setAttribute(ATTR_ID, Util.normalize(this.fId));
        }
        if (this.fType != null) {
            element.setAttribute(ATTR_TYPE, Util.normalize(this.fType));
        }
        if (this.fMimeType != null) {
            element.setAttribute(ATTR_MIME_TYPE, Util.normalize(this.fMimeType));
        }
        if (this.fEncoding != null) {
            element.setAttribute(ATTR_ENCODING, Util.normalize(this.fEncoding));
        }
        if (this.fEncryptionMethod != null) {
            element2 = this.fEncryptionMethod.createElement(document, false);
            element.appendChild(element2);
        }
        if (this.fKeyInfo != null) {
            element2 = this.fKeyInfo.createElement(document, true);
            element.appendChild(element2);
        }
        if (this.fCipherData == null) {
            throw new StructureException("CipherData not specified");
        }
        element2 = this.fCipherData.createElement(document, false);
        element.appendChild(element2);
        if (this.fEncryptionProperties != null) {
            element2 = this.fEncryptionProperties.createElement(document, false);
            element.appendChild(element2);
        }
    }
}

