/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xss4j.enc.type;

import com.ibm.ws.wssecurity.xss4j.enc.StructureException;
import com.ibm.ws.wssecurity.xss4j.enc.type.ElementsType;
import com.ibm.ws.wssecurity.xss4j.enc.type.KeySize;
import com.ibm.ws.wssecurity.xss4j.enc.type.OAEPParams;
import com.ibm.ws.wssecurity.xss4j.enc.util.Util;
import com.ibm.wsspi.wssecurity.EngineFactory;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EncryptionMethod
extends ElementsType {
    public static final String TRIPLEDES_CBC = "http://www.w3.org/2001/04/xmlenc#tripledes-cbc";
    public static final String AES128_CBC = "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
    public static final String AES192_CBC = "http://www.w3.org/2001/04/xmlenc#aes192-cbc";
    public static final String AES256_CBC = "http://www.w3.org/2001/04/xmlenc#aes256-cbc";
    public static final String RSA_1_5 = "http://www.w3.org/2001/04/xmlenc#rsa-1_5";
    public static final String RSA_OAEP = "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p";
    public static final String KW_TRIPLEDES = "http://www.w3.org/2001/04/xmlenc#kw-tripledes";
    public static final String KW_AES128 = "http://www.w3.org/2001/04/xmlenc#kw-aes128";
    public static final String KW_AES192 = "http://www.w3.org/2001/04/xmlenc#kw-aes192";
    public static final String KW_AES256 = "http://www.w3.org/2001/04/xmlenc#kw-aes256";
    private static final String NAMESPACE = "http://www.w3.org/2001/04/xmlenc#";
    private static final String NAME = "EncryptionMethod";
    private static final String ATTR_ALGORITHM = "Algorithm";
    private String fAlgorithm;
    private KeySize fKeySize;
    private OAEPParams fOaepParams;
    private AlgorithmParameterSpec fSpec;
    private boolean fDoneSpecCreation;
    private EngineFactory fEngineFactory;

    public EncryptionMethod() {
        this(null);
    }

    public EncryptionMethod(Element element) {
        super(element);
        if (element != null) {
            if (!EncryptionMethod.isOfType(element)) {
                throw new IllegalArgumentException("Not EncryptionMethod element");
            }
            if (element.hasAttribute(ATTR_ALGORITHM)) {
                this.fAlgorithm = element.getAttribute(ATTR_ALGORITHM);
            }
            this.init(element);
        }
        this.fDoneSpecCreation = false;
    }

    public static boolean isOfType(Element element) {
        return element != null && NAMESPACE.equals(element.getNamespaceURI()) && NAME.equals(element.getLocalName());
    }

    private void init(Node node) {
        block4: for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            switch (node2.getNodeType()) {
                case 1: {
                    Element element = (Element)node2;
                    if (KeySize.isOfType(element)) {
                        this.fKeySize = new KeySize(element);
                        continue block4;
                    }
                    if (OAEPParams.isOfType(element)) {
                        this.fOaepParams = new OAEPParams(element);
                        continue block4;
                    }
                    if (!this.isParameter(element)) continue block4;
                    super.addElement(element);
                    continue block4;
                }
                case 5: {
                    this.init(node2);
                }
            }
        }
    }

    private boolean isParameter(Element element) {
        String string = element.getNamespaceURI();
        return string != null && !string.equals(NAMESPACE);
    }

    public void setAlgorithm(String string) {
        this.fAlgorithm = string;
    }

    public String getAlgorithm() {
        return this.fAlgorithm;
    }

    public AlgorithmParameterSpec getParameterSpec(EngineFactory engineFactory) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        if (this.fDoneSpecCreation) {
            return this.fSpec;
        }
        this.fEngineFactory = engineFactory;
        this.fSpec = engineFactory.unmarshalParameter(this.fAlgorithm, this.getBase());
        this.fDoneSpecCreation = true;
        return this.fSpec;
    }

    public void setParameterSpec(EngineFactory engineFactory, AlgorithmParameterSpec algorithmParameterSpec) {
        this.fEngineFactory = engineFactory;
        this.fSpec = algorithmParameterSpec;
        this.fDoneSpecCreation = true;
    }

    public String getNamespaceURI() {
        return NAMESPACE;
    }

    public Element createElement(Document document, boolean bl) throws StructureException {
        if (document == null) {
            throw new NullPointerException("Node factory not specified");
        }
        Element element = document.createElementNS(NAMESPACE, NAME);
        if (bl) {
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", NAMESPACE);
        }
        if (this.fAlgorithm == null) {
            throw new StructureException("Algorithm not specified");
        }
        element.setAttribute(ATTR_ALGORITHM, Util.normalize(this.fAlgorithm));
        if (this.fEngineFactory != null) {
            try {
                this.fEngineFactory.marshalParameter(this.fAlgorithm, this.fSpec, element);
            }
            catch (Exception exception) {
                throw new StructureException(exception.getMessage());
            }
        } else {
            Element element2;
            if (this.fKeySize != null) {
                element2 = this.fKeySize.createElement(document, false);
                element.appendChild(element2);
            }
            if (this.fOaepParams != null) {
                element2 = this.fOaepParams.createElement(document, false);
                element.appendChild(element2);
            }
            super.createElement(element, document, NAMESPACE);
        }
        return element;
    }
}

