/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xss4j.enc.type;

import com.ibm.ws.wssecurity.xss4j.enc.StructureException;
import com.ibm.ws.wssecurity.xss4j.enc.type.ElementsType;
import com.ibm.ws.wssecurity.xss4j.enc.util.Util;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class EncryptionProperty
extends ElementsType {
    private static final String NAMESPACE = "http://www.w3.org/2001/04/xmlenc#";
    private static final String NAME = "EncryptionProperty";
    private static final String ATTR_TARGET = "Target";
    private static final String ATTR_ID = "Id";
    private String fTarget;
    private String fId;
    private List fAttributes = new ArrayList();

    public EncryptionProperty() {
        this(null);
    }

    public EncryptionProperty(Element element) {
        super(element);
        if (element != null) {
            if (!EncryptionProperty.isOfType(element)) {
                throw new IllegalArgumentException("Not EncryptionProperty element");
            }
            NamedNodeMap namedNodeMap = element.getAttributes();
            int n = namedNodeMap.getLength();
            for (int i = 0; i < n; ++i) {
                Attr attr = (Attr)namedNodeMap.item(i);
                String string = attr.getName();
                if (string.equals(ATTR_TARGET)) {
                    this.fTarget = attr.getValue();
                    continue;
                }
                if (string.equals(ATTR_ID)) {
                    this.fId = attr.getValue();
                    continue;
                }
                if (!this.isAttribute(attr)) continue;
                this.fAttributes.add(attr);
            }
            this.init(element);
        }
    }

    public static boolean isOfType(Element element) {
        return element != null && NAMESPACE.equals(element.getNamespaceURI()) && NAME.equals(element.getLocalName());
    }

    private boolean isAttribute(Attr attr) {
        String string = attr.getNamespaceURI();
        return string != null && string.equals("http://www.w3.org/XML/1998/namespace");
    }

    private void init(Node node) {
        block4: for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            switch (node2.getNodeType()) {
                case 1: {
                    Element element = (Element)node2;
                    if (!this.isParameter(element)) continue block4;
                    super.addElement(element);
                    continue block4;
                }
                case 5: {
                    this.init(node2);
                }
            }
        }
    }

    private boolean isParameter(Element element) {
        String string = element.getNamespaceURI();
        return string != null && !string.equals(NAMESPACE);
    }

    public void setTarget(String string) {
        this.fTarget = string;
    }

    public String getTarget() {
        return this.fTarget;
    }

    public void setId(String string) {
        this.fId = string;
    }

    public String getId() {
        return this.fId;
    }

    public void addAttribute(Attr attr) {
        if (attr != null) {
            if (!this.isAttribute(attr)) {
                throw new IllegalArgumentException("Wrong attribute");
            }
            this.fAttributes.add(attr);
        }
    }

    public List getAttributes() {
        return this.fAttributes;
    }

    public void addParameter(Element element) {
        if (element != null) {
            if (!this.isParameter(element)) {
                throw new IllegalArgumentException("Wrong parameter");
            }
            super.addElement(element);
        }
    }

    public List getParameters() {
        return super.getElements();
    }

    public String getNamespaceURI() {
        return NAMESPACE;
    }

    public Element createElement(Document document, boolean bl) throws StructureException {
        if (document == null) {
            throw new NullPointerException("Node factory not specified");
        }
        Element element = document.createElementNS(NAMESPACE, NAME);
        if (bl) {
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", NAMESPACE);
        }
        if (this.fTarget != null) {
            element.setAttribute(ATTR_TARGET, Util.normalize(this.fTarget));
        }
        if (this.fId != null) {
            element.setAttribute(ATTR_ID, Util.normalize(this.fId));
        }
        Iterator iterator = this.fAttributes.iterator();
        while (iterator.hasNext()) {
            Attr attr = (Attr)document.importNode((Attr)iterator.next(), true);
            element.setAttributeNodeNS(attr);
        }
        if (this.fElements.isEmpty()) {
            throw new StructureException("Parameters not specified");
        }
        super.createElement(element, document, NAMESPACE);
        return element;
    }
}

