/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xss4j.enc.type;

import com.ibm.ws.wssecurity.xss4j.enc.StructureException;
import com.ibm.ws.wssecurity.xss4j.enc.type.ElementsType;
import com.ibm.ws.wssecurity.xss4j.enc.type.EncryptedKey;
import com.ibm.ws.wssecurity.xss4j.enc.type.KeyName;
import com.ibm.ws.wssecurity.xss4j.enc.type.RetrievalMethod;
import com.ibm.ws.wssecurity.xss4j.enc.util.Util;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class KeyInfo
extends ElementsType {
    private static final String NAMESPACE = "http://www.w3.org/2000/09/xmldsig#";
    private static final String NAME = "KeyInfo";
    private static final String ATTR_ID = "Id";
    private static final String ELEM_KEY_VALUE = "KeyValue";
    private static final String ELEM_X509_DATA = "X509Data";
    private static final String ELEM_PGP_DATA = "PGPData";
    private static final String ELEM_SPKI_DATA = "SPKIData";
    private static final String ELEM_MGMT_DATA = "MgmtData";
    private String fId;

    public KeyInfo() {
        this(null);
    }

    public KeyInfo(Element element) {
        super(element);
        if (element != null) {
            if (!KeyInfo.isOfType(element)) {
                throw new IllegalArgumentException("Not KeyInfo element");
            }
            if (element.hasAttribute(ATTR_ID)) {
                this.fId = element.getAttribute(ATTR_ID);
            }
            this.init(element);
        }
    }

    public static boolean isOfType(Element element) {
        return element != null && NAMESPACE.equals(element.getNamespaceURI()) && NAME.equals(element.getLocalName());
    }

    private void init(Node node) {
        block4: for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            switch (node2.getNodeType()) {
                case 1: {
                    Element element = (Element)node2;
                    Object object = null;
                    if (EncryptedKey.isOfType(element)) {
                        object = new EncryptedKey(element);
                    } else if (KeyName.isOfType(element)) {
                        object = new KeyName(element);
                    } else if (RetrievalMethod.isOfType(element)) {
                        object = new RetrievalMethod(element);
                    } else if (this.isKeyId(element)) {
                        object = element;
                    }
                    super.addElement(object);
                    continue block4;
                }
                case 5: {
                    this.init(node2);
                }
            }
        }
    }

    private boolean isKeyId(Element element) {
        String string = element.getNamespaceURI();
        String string2 = element.getLocalName();
        return string != null && (!string.equals(NAMESPACE) || string2 != null && (string2.equals(ELEM_KEY_VALUE) || string2.equals(ELEM_X509_DATA) || string2.equals(ELEM_PGP_DATA) || string2.equals(ELEM_SPKI_DATA) || string2.equals(ELEM_MGMT_DATA)));
    }

    public void setId(String string) {
        this.fId = string;
    }

    public String getId() {
        return this.fId;
    }

    public void addEncryptedKey(EncryptedKey encryptedKey) {
        super.addElement(encryptedKey);
    }

    public void addKeyName(KeyName keyName) {
        super.addElement(keyName);
    }

    public void addRetrievalMethod(RetrievalMethod retrievalMethod) {
        super.addElement(retrievalMethod);
    }

    public void addKeyId(Element element) {
        if (element != null) {
            if (!this.isKeyId(element)) {
                throw new IllegalArgumentException("Wrong key id");
            }
            super.addElement(element);
        }
    }

    public List getKeyIds() {
        return super.getElements();
    }

    public String getNamespaceURI() {
        return NAMESPACE;
    }

    public Element createElement(Document document, boolean bl) throws StructureException {
        if (document == null) {
            throw new NullPointerException("Node factory not specified");
        }
        Element element = document.createElementNS(NAMESPACE, NAME);
        if (bl) {
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", NAMESPACE);
        }
        if (this.fId != null) {
            element.setAttribute(ATTR_ID, Util.normalize(this.fId));
        }
        if (this.fElements.isEmpty()) {
            throw new StructureException("Key ids not specified");
        }
        super.createElement(element, document, NAMESPACE);
        return element;
    }
}

