/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xss4j.enc.type;

import com.ibm.ws.wssecurity.xss4j.enc.StructureException;
import com.ibm.ws.wssecurity.xss4j.enc.type.DsTransforms;
import com.ibm.ws.wssecurity.xss4j.enc.type.Type;
import com.ibm.ws.wssecurity.xss4j.enc.util.Util;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RetrievalMethod
extends Type {
    private static final String NAMESPACE = "http://www.w3.org/2000/09/xmldsig#";
    private static final String NAME = "RetrievalMethod";
    private static final String ATTR_URI = "URI";
    private static final String ATTR_TYPE = "Type";
    private String fUri;
    private String fType;
    private DsTransforms fTransforms;

    public RetrievalMethod() {
        this(null);
    }

    public RetrievalMethod(Element element) {
        super(element);
        if (element != null) {
            if (!RetrievalMethod.isOfType(element)) {
                throw new IllegalArgumentException("Not RetrievalMethod element");
            }
            if (element.hasAttribute(ATTR_URI)) {
                this.fUri = element.getAttribute(ATTR_URI);
            }
            if (element.hasAttribute(ATTR_TYPE)) {
                this.fType = element.getAttribute(ATTR_TYPE);
            }
            this.init(element);
        }
    }

    public static boolean isOfType(Element element) {
        return element != null && NAMESPACE.equals(element.getNamespaceURI()) && NAME.equals(element.getLocalName());
    }

    private void init(Node node) {
        block4: for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            switch (node2.getNodeType()) {
                case 1: {
                    Element element = (Element)node2;
                    if (!DsTransforms.isOfType(element)) continue block4;
                    this.fTransforms = new DsTransforms(element);
                    continue block4;
                }
                case 5: {
                    this.init(node2);
                }
            }
        }
    }

    public void setURI(String string) {
        this.fUri = string;
    }

    public String getURI() {
        return this.fUri;
    }

    public void setType(String string) {
        this.fType = string;
    }

    public String getType() {
        return this.fType;
    }

    public void setTransforms(DsTransforms dsTransforms) {
        this.fTransforms = dsTransforms;
    }

    public DsTransforms getTransforms() {
        return this.fTransforms;
    }

    public String getNamespaceURI() {
        return NAMESPACE;
    }

    public Element createElement(Document document, boolean bl) throws StructureException {
        if (document == null) {
            throw new NullPointerException("Node factory not specified");
        }
        Element element = document.createElementNS(NAMESPACE, NAME);
        if (bl) {
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", NAMESPACE);
        }
        if (this.fUri == null) {
            throw new StructureException("URI not specified");
        }
        element.setAttribute(ATTR_URI, Util.normalize(this.fUri));
        if (this.fType != null) {
            element.setAttribute(ATTR_TYPE, Util.normalize(this.fType));
        }
        if (this.fTransforms != null) {
            Element element2 = this.fTransforms.createElement(document, false);
            element.appendChild(element2);
        }
        return element;
    }
}

