/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xss4j.enc.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMUtil {
    private static final boolean DEBUG = false;
    public static final String XML_NS = "http://www.w3.org/XML/1998/namespace";
    public static final String XML_NS_PREFIX = "xml";
    public static final String XMLNS_NS = "http://www.w3.org/2000/xmlns/";
    public static final String XMLNS_NS_PREFIX = "xmlns";

    public static Map getNamespaceDeclAttrNodes(Node node) {
        HashMap<String, Attr> hashMap = null;
        if (node != null) {
            hashMap = new HashMap<String, Attr>();
            DOMUtil._getNamespaceDeclAttrNodes(node, node, hashMap);
            Document document = node.getOwnerDocument();
            if (node.getNodeType() == 9) {
                document = (Document)node;
            }
            Attr attr = document.createAttributeNS(XMLNS_NS, "xmlns:xml");
            attr.setValue(XML_NS);
            hashMap.put(attr.getName(), attr);
        }
        return hashMap;
    }

    private static void _getNamespaceDeclAttrNodes(Node node, Node node2, Map map) {
        if (DOMUtil.hasParentNode(node)) {
            DOMUtil._getNamespaceDeclAttrNodes(node.getParentNode(), node2, map);
        }
        if (node != node2 && node.getNodeType() == 1) {
            NamedNodeMap namedNodeMap = node.getAttributes();
            int n = namedNodeMap.getLength();
            for (int i = 0; i < n; ++i) {
                Attr attr = (Attr)namedNodeMap.item(i);
                String string = attr.getName();
                if (!string.equals(XMLNS_NS_PREFIX) && !string.startsWith("xmlns:")) continue;
                map.put(string, attr);
            }
        }
    }

    public static Node getRootNode(Node node) {
        Node node2 = null;
        if (node != null) {
            node2 = DOMUtil._getRootNode(node);
        }
        return node2;
    }

    private static Node _getRootNode(Node node) {
        Node node2 = node;
        if (DOMUtil.hasParentNode(node)) {
            node2 = DOMUtil._getRootNode(node.getParentNode());
        }
        return node2;
    }

    public static Element getFirstElement(NodeList nodeList) {
        return (Element)DOMUtil.getFirstNodeOfType(nodeList, (short)1);
    }

    public static Node getFirstNodeOfType(NodeList nodeList, short s) {
        Node node = null;
        if (nodeList != null) {
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node2 = nodeList.item(i);
                if (node2.getNodeType() != s) continue;
                node = node2;
                break;
            }
        }
        return node;
    }

    public static Element getFirstChildElement(Node node) {
        return (Element)DOMUtil.getFirstChildNodeOfType(node, (short)1);
    }

    public static Node getFirstChildNodeOfType(Node node, short s) {
        Node node2 = null;
        if (node != null && node.hasChildNodes()) {
            node2 = DOMUtil.getNextSiblingNodeOfType(node.getFirstChild(), s);
        }
        return node2;
    }

    public static Element getNextSiblingElement(Node node) {
        return (Element)DOMUtil.getNextSiblingNodeOfType(node, (short)1);
    }

    public static Node getNextSiblingNodeOfType(Node node, short s) {
        Node node2 = null;
        if (node != null) {
            while (node != null) {
                if (node.getNodeType() == s) {
                    node2 = node;
                    break;
                }
                node = node.getNextSibling();
            }
        }
        return node2;
    }

    public static Element getLastChildElement(Node node) {
        return (Element)DOMUtil.getLastChildNodeOfType(node, (short)1);
    }

    public static Node getLastChildNodeOfType(Node node, short s) {
        Node node2 = null;
        if (node != null && node.hasChildNodes()) {
            node2 = DOMUtil.getPreviousSiblingNodeOfType(node.getLastChild(), s);
        }
        return node2;
    }

    public static Node getPreviousSiblingElement(Node node) {
        return (Element)DOMUtil.getPreviousSiblingNodeOfType(node, (short)1);
    }

    public static Node getPreviousSiblingNodeOfType(Node node, short s) {
        Node node2 = null;
        if (node != null) {
            while (node != null) {
                if (node.getNodeType() == s) {
                    node2 = node;
                    break;
                }
                node = node.getPreviousSibling();
            }
        }
        return node2;
    }

    public static void moveChildNodes(Node node, Node node2) {
        if (node == null || node2 == null) {
            return;
        }
        Node node3 = node.getFirstChild();
        while (node3 != null) {
            Node node4 = node3.getNextSibling();
            node2.appendChild(node3);
            node3 = node4;
        }
    }

    public static void removeChildNodes(Node node) {
        if (node == null) {
            return;
        }
        while (node.hasChildNodes()) {
            Node node2 = node.getFirstChild();
            node.removeChild(node2);
        }
    }

    public static NodeList getChildNodes(Node node) {
        if (node == null) {
            return null;
        }
        NodeListImpl nodeListImpl = new NodeListImpl();
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            nodeListImpl.add(node2);
        }
        return nodeListImpl;
    }

    public static Node replaceNode(Node node, Node node2) {
        if (node != null && DOMUtil.hasParentNode(node) && node2 != null) {
            Node node3 = node.getParentNode();
            Node node4 = node.getNextSibling();
            node3.removeChild(node);
            node2 = node4 != null ? node3.insertBefore(node2, node4) : node3.appendChild(node2);
        }
        return node2;
    }

    public static NodeList replaceNode(Node node, NodeList nodeList) {
        if (node != null && DOMUtil.hasParentNode(node) && nodeList != null && nodeList.getLength() > 0) {
            NodeListImpl nodeListImpl = new NodeListImpl();
            Node node2 = node.getParentNode();
            Node node3 = nodeList.item(nodeList.getLength() - 1);
            Node node4 = node.getNextSibling();
            node2.removeChild(node);
            node3 = node4 != null ? node2.insertBefore(node3, node4) : node2.appendChild(node3);
            int n = nodeList.getLength() - 1;
            for (int i = 0; i < n; ++i) {
                Node node5 = node2.insertBefore(nodeList.item(i), node3);
                nodeListImpl.add(node5);
            }
            nodeListImpl.add(node3);
            return nodeListImpl;
        }
        return nodeList;
    }

    public static Node replaceNodes(NodeList nodeList, Node node) {
        if (nodeList != null && nodeList.getLength() > 0 && DOMUtil.hasParentNode(nodeList.item(0)) && node != null) {
            Node node2 = nodeList.item(0);
            Node node3 = node2.getParentNode();
            Node node4 = node2.getNextSibling();
            node3.removeChild(node2);
            node = node4 != null ? node3.insertBefore(node, node4) : node3.appendChild(node);
            int n = nodeList.getLength();
            for (int i = 1; i < n; ++i) {
                node3.removeChild(nodeList.item(i));
            }
            return node;
        }
        return node;
    }

    public static NodeList getElementsByTagNameNS(Node node, String string, String string2) {
        NodeListImpl nodeListImpl = null;
        if (node != null) {
            nodeListImpl = new NodeListImpl();
            DOMUtil.getElementsByTagName(node, string, string2, nodeListImpl, true);
        }
        return nodeListImpl;
    }

    public static NodeList getElementsByTagName(Node node, String string) {
        NodeListImpl nodeListImpl = null;
        if (node != null) {
            nodeListImpl = new NodeListImpl();
            DOMUtil.getElementsByTagName(node, null, string, nodeListImpl, false);
        }
        return nodeListImpl;
    }

    private static void getElementsByTagName(Node node, String string, String string2, NodeListImpl nodeListImpl, boolean bl) {
        Object object;
        if (node.getNodeType() == 1) {
            if (bl) {
                object = node.getNamespaceURI();
                if (string == null || string.equals("*") || string.equals(object)) {
                    String string3 = node.getLocalName();
                    if (string2 == null || string2.equals("*") || string2.equals(string3)) {
                        nodeListImpl.add(node);
                    }
                }
            } else {
                object = ((Element)node).getTagName();
                if (string2 == null || string2.equals("*") || string2.equals(object)) {
                    nodeListImpl.add(node);
                }
            }
        }
        for (object = node.getFirstChild(); object != null; object = object.getNextSibling()) {
            DOMUtil.getElementsByTagName((Node)object, string, string2, nodeListImpl, bl);
        }
    }

    public static NodeList getElementsByAttribute(Node node, String string, String string2) {
        NodeListImpl nodeListImpl = null;
        if (node != null) {
            nodeListImpl = new NodeListImpl();
            DOMUtil.getElementsByAttribute(node, string, string2, nodeListImpl);
        }
        return nodeListImpl;
    }

    private static void getElementsByAttribute(Node node, String string, String string2, NodeListImpl nodeListImpl) {
        Object object;
        if (node.getNodeType() == 1) {
            if (string == null || string.equals("*")) {
                object = node.getAttributes();
                int n = object.getLength();
                for (int i = 0; i < n; ++i) {
                    String string3 = ((Attr)object.item(i)).getValue();
                    if (string2 != null && !string2.equals("*") && !string2.equals(string3)) continue;
                    nodeListImpl.add(node);
                    break;
                }
            } else {
                object = (Element)node;
                if (string2 == null || string2.equals("*") || object.hasAttribute(string) && string2.equals(object.getAttribute(string))) {
                    nodeListImpl.add(node);
                }
            }
        }
        for (object = node.getFirstChild(); object != null; object = object.getNextSibling()) {
            DOMUtil.getElementsByAttribute((Node)object, string, string2, nodeListImpl);
        }
    }

    static void printNode(Node node, boolean bl) {
        if (node != null) {
            DOMUtil.printNode(node, "", bl);
        }
    }

    private static void printNode(Node node, String string, boolean bl) {
    }

    private static String getString(short s) {
        String string = null;
        switch (s) {
            case 2: {
                string = "ATTRIBUTE";
                break;
            }
            case 4: {
                string = "CDATA_SECTION";
                break;
            }
            case 8: {
                string = "COMMENT";
                break;
            }
            case 11: {
                string = "DOCUMENT_FRAGMENT";
                break;
            }
            case 9: {
                string = "DOCUMENT";
                break;
            }
            case 10: {
                string = "DOCUMENT_TYPE";
                break;
            }
            case 1: {
                string = "ELEMENT";
                break;
            }
            case 6: {
                string = "ENTITY";
                break;
            }
            case 5: {
                string = "ENTITY_REFERENCE";
                break;
            }
            case 12: {
                string = "NOTATION";
                break;
            }
            case 7: {
                string = "PROCESSING_INSTRUCTION";
                break;
            }
            case 3: {
                string = "TEXT";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown node type: " + s);
            }
        }
        return string;
    }

    private static String getQuotedString(String string) {
        if (string != null) {
            string = "\"" + string + "\"";
        }
        return string;
    }

    public static boolean isDescendantNode(Node node, Node node2) {
        boolean bl = false;
        if (node != null && node2 != null) {
            bl = DOMUtil._isDescendantNode(node, node2);
        }
        return bl;
    }

    private static boolean _isDescendantNode(Node node, Node node2) {
        boolean bl = false;
        if (node == node2) {
            bl = true;
        } else if (node.getNodeType() == 2) {
            if ((node = ((Attr)node).getOwnerElement()) != null) {
                bl = DOMUtil._isDescendantNode(node, node2);
            }
        } else if (DOMUtil.hasParentNode(node)) {
            bl = DOMUtil._isDescendantNode(node.getParentNode(), node2);
        }
        return bl;
    }

    public static boolean contains(NodeList nodeList, int n, Node node) {
        return DOMUtil.contains(nodeList, n, nodeList != null ? nodeList.getLength() : -1, node);
    }

    public static boolean contains(NodeList nodeList, int n, int n2, Node node) {
        return DOMUtil.getIndex(node, nodeList, n, n2) >= 0;
    }

    public static int getIndex(Node node, NodeList nodeList, int n) {
        return DOMUtil.getIndex(node, nodeList, n, nodeList != null ? nodeList.getLength() : -1);
    }

    public static int getIndex(Node node, NodeList nodeList, int n, int n2) {
        int n3 = -1;
        if (node != null && nodeList != null) {
            if (n < 0 || n >= nodeList.getLength()) {
                throw new IndexOutOfBoundsException(Integer.toString(n));
            }
            if (n2 <= n || n2 > nodeList.getLength()) {
                throw new IndexOutOfBoundsException(Integer.toString(n2));
            }
            for (int i = n; n3 < 0 && i < n2; ++i) {
                if (nodeList.item(i) != node) continue;
                n3 = i;
            }
        }
        return n3;
    }

    public static String getStringValue(NodeList nodeList, int n) {
        String string = null;
        if (nodeList != null) {
            if (n < 0 || n >= nodeList.getLength()) {
                throw new IndexOutOfBoundsException(Integer.toString(n));
            }
            Node node = nodeList.item(n);
            short s = node.getNodeType();
            switch (s) {
                case 1: 
                case 9: {
                    StringBuffer stringBuffer = new StringBuffer();
                    DOMUtil._getStringValue(node, nodeList, n + 1, stringBuffer);
                    string = stringBuffer.toString();
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 7: 
                case 8: {
                    string = DOMUtil.getString(node.getNodeValue());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown node type: " + s);
                }
            }
        }
        return string;
    }

    private static int _getStringValue(Node node, NodeList nodeList, int n, StringBuffer stringBuffer) {
        int n2 = n;
        block4: for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            switch (node2.getNodeType()) {
                case 1: 
                case 5: {
                    n2 = DOMUtil._getStringValue(node2, nodeList, n2, stringBuffer);
                    continue block4;
                }
                case 3: 
                case 4: {
                    int n3 = DOMUtil.getIndex(node2, nodeList, n2);
                    if (n3 < 0) continue block4;
                    stringBuffer.append(DOMUtil.getString(node2.getNodeValue()));
                    n2 = n3 + 1;
                }
            }
        }
        return n2;
    }

    private static String getString(String string) {
        if (string == null) {
            string = "";
        }
        return string;
    }

    public static DocumentFragment cloneChildNodes(Node node) {
        DocumentFragment documentFragment = null;
        if (node != null) {
            documentFragment = node.getOwnerDocument().createDocumentFragment();
            for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                documentFragment.appendChild(node2.cloneNode(true));
            }
        }
        return documentFragment;
    }

    public static boolean hasParentNode(Node node) {
        return node != null && DOMUtil.canHaveParentNode(node) && node.getParentNode() != null;
    }

    private static boolean canHaveParentNode(Node node) {
        boolean bl = true;
        switch (node.getNodeType()) {
            case 2: 
            case 6: 
            case 9: 
            case 11: 
            case 12: {
                bl = false;
            }
        }
        return bl;
    }

    public static class NodeListImpl
    implements NodeList {
        private List fList = new ArrayList();

        public NodeListImpl() {
            this(null);
        }

        public NodeListImpl(Node node) {
            if (node != null) {
                this.fList.add(node);
            }
        }

        public void add(Node node) {
            if (node != null) {
                this.fList.add(node);
            }
        }

        public Node item(int n) {
            return (Node)this.fList.get(n);
        }

        public int getLength() {
            return this.fList.size();
        }
    }
}

