/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xss4j.enc.util;

import com.ibm.ws.wssecurity.xss4j.enc.KeyInfoResolverBase;
import com.ibm.ws.wssecurity.xss4j.enc.KeyInfoResolvingException;
import com.ibm.ws.wssecurity.xss4j.enc.type.EncryptionMethod;
import com.ibm.ws.wssecurity.xss4j.enc.type.KeyName;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.Map;

public class KeyStoreKeyInfoResolver
extends KeyInfoResolverBase {
    private static final boolean DEBUG = false;
    private KeyStore fKeyStore;
    private Map fPasswords;

    public KeyStoreKeyInfoResolver(KeyStore keyStore) {
        this.fKeyStore = keyStore;
        this.fPasswords = new HashMap();
    }

    public void putAliasAndPassword(String string, char[] cArray) {
        this.fPasswords.put(string, cArray);
    }

    public char[] getPassword(String string) {
        return (char[])this.fPasswords.get(string);
    }

    protected String getAlias(String string) {
        return string;
    }

    protected Key resolveKeyName(KeyName keyName, EncryptionMethod encryptionMethod, Key key) throws KeyInfoResolvingException {
        String string;
        String string2;
        if (key == null) {
            key = super.resolveKeyName(keyName, encryptionMethod, key);
        }
        if (key == null && (string2 = keyName.getName()) != null && (string = this.getAlias(string2)) != null) {
            if (this.fKeyStore == null) {
                throw new KeyInfoResolvingException("Keystore not specified");
            }
            try {
                Object object;
                if (this.fInEncryptMode && (object = this.fKeyStore.getCertificate(string)) != null) {
                    key = ((Certificate)object).getPublicKey();
                }
                if (key == null && (object = (Object)this.getPassword(string)) != null) {
                    key = this.fKeyStore.getKey(string, (char[])object);
                }
            }
            catch (KeyStoreException keyStoreException) {
                throw new KeyInfoResolvingException(keyStoreException.getMessage());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return key;
    }
}

