/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xss4j.enc.util;

import com.ibm.ws.wssecurity.xss4j.enc.EncryptedKeyRetriever;
import com.ibm.ws.wssecurity.xss4j.enc.StructureException;
import com.ibm.ws.wssecurity.xss4j.enc.type.EncryptedKey;
import com.ibm.ws.wssecurity.xss4j.enc.type.KeyInfo;
import com.ibm.ws.wssecurity.xss4j.enc.type.ReferenceList;
import com.ibm.ws.wssecurity.xss4j.enc.type.ReferenceType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SameDocumentEncryptedKeyRetriever
implements EncryptedKeyRetriever {
    private Map fEncryptedKeyLists = new HashMap();

    public SameDocumentEncryptedKeyRetriever(Document document) throws StructureException {
        if (document == null) {
            throw new NullPointerException("Document not specified");
        }
        Element element = document.getDocumentElement();
        if (element != null) {
            this.addEncryptedKeys(element);
        }
    }

    private void addEncryptedKeys(Node node) throws StructureException {
        if (node.getNodeType() == 1 && EncryptedKey.isOfType((Element)node)) {
            this.addEncryptedKeys(new EncryptedKey((Element)node));
        } else {
            for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                this.addEncryptedKeys(node2);
            }
        }
    }

    private void addEncryptedKeys(EncryptedKey encryptedKey) throws StructureException {
        Object object;
        Object object2;
        ReferenceList referenceList = encryptedKey.getReferenceList();
        if (referenceList != null) {
            object2 = referenceList.getReferences().iterator();
            while (object2.hasNext()) {
                object = ((ReferenceType)object2.next()).getURI();
                if (object == null) {
                    throw new StructureException("URI not specified");
                }
                if (!((String)(object = ((String)object).trim())).startsWith("#") || ((String)object).length() < 2) continue;
                object = this.getId((String)object);
                this.retrieve((String)object).add(encryptedKey);
            }
        }
        if ((object2 = encryptedKey.getKeyInfo()) != null) {
            object = ((KeyInfo)object2).getKeyIds().iterator();
            while (object.hasNext()) {
                Object e2 = object.next();
                if (!(e2 instanceof EncryptedKey)) continue;
                this.addEncryptedKeys((EncryptedKey)e2);
            }
        }
    }

    private String getId(String string) {
        char c;
        String string2;
        String string3 = string.substring(1);
        if (string3.startsWith("xpointer(") && string3.endsWith(")") && (string2 = string3.substring(9, string3.length() - 1).trim()).startsWith("id(") && string2.endsWith(")") && (string2 = string2.substring(3, string3.length() - 1).trim()).length() > 2 && ((c = string2.charAt(0)) == '\"' || c == '\'') && c == string2.charAt(string2.length() - 1)) {
            string3 = string2.substring(1, string2.length() - 1);
        }
        return string3;
    }

    public List retrieve(String string) {
        List list = null;
        if (string != null) {
            if (!this.fEncryptedKeyLists.containsKey(string)) {
                this.fEncryptedKeyLists.put(string, new ArrayList());
            }
            list = (List)this.fEncryptedKeyLists.get(string);
        }
        return list;
    }
}

